/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.serialization.deserialization;

import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.metadata.internal.descriptors.SourceElement;
import kotlinx.metadata.internal.metadata.ProtoBuf;
import kotlinx.metadata.internal.metadata.builtins.BuiltInsBinaryVersion;
import kotlinx.metadata.internal.metadata.deserialization.BinaryVersion;
import kotlinx.metadata.internal.metadata.deserialization.NameResolver;
import kotlinx.metadata.internal.metadata.deserialization.NameResolverImpl;
import kotlinx.metadata.internal.name.ClassId;
import kotlinx.metadata.internal.serialization.deserialization.ClassData;
import kotlinx.metadata.internal.serialization.deserialization.ClassDataFinder;
import kotlinx.metadata.internal.serialization.deserialization.KotlinMetadataFinder;
import kotlinx.metadata.internal.serialization.deserialization.MetadataClassDataFinder;
import kotlinx.metadata.internal.serialization.deserialization.MetadataUtilKt;
import kotlinx.metadata.internal.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lkotlinx/metadata/internal/serialization/deserialization/MetadataClassDataFinder;", "Lkotlinx/metadata/internal/serialization/deserialization/ClassDataFinder;", "finder", "Lkotlinx/metadata/internal/serialization/deserialization/KotlinMetadataFinder;", "(Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;)V", "getFinder", "()Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;", "findClassData", "Lkotlinx/metadata/internal/serialization/deserialization/ClassData;", "classId", "Lkotlinx/metadata/internal/name/ClassId;", "deserialization.common"})
@SourceDebugExtension(value={"SMAP\nMetadataUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataUtil.kt\norg/jetbrains/kotlin/serialization/deserialization/MetadataClassDataFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n288#2,2:45\n*S KotlinDebug\n*F\n+ 1 MetadataUtil.kt\norg/jetbrains/kotlin/serialization/deserialization/MetadataClassDataFinder\n*L\n21#1:45,2\n*E\n"})
public final class MetadataClassDataFinder
implements ClassDataFinder {
    @NotNull
    private final KotlinMetadataFinder finder;

    public MetadataClassDataFinder(@NotNull KotlinMetadataFinder finder) {
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        this.finder = finder;
    }

    @NotNull
    public final KotlinMetadataFinder getFinder() {
        return this.finder;
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        ClassData classData;
        Object v2;
        BuiltInsBinaryVersion version;
        NameResolverImpl nameResolver2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            ClassId topLevelClassId2 = (ClassId)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)classId, (Function1)findClassData.topLevelClassId.1.INSTANCE));
            InputStream inputStream = this.finder.findMetadata(topLevelClassId2);
            if (inputStream == null) {
                return null;
            }
            InputStream stream = inputStream;
            Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion> triple = MetadataUtilKt.readProto(stream);
            ProtoBuf.PackageFragment message = (ProtoBuf.PackageFragment)triple.component1();
            nameResolver2 = (NameResolverImpl)triple.component2();
            version = (BuiltInsBinaryVersion)triple.component3();
            List<ProtoBuf.Class> list = message.getClass_List();
            Intrinsics.checkNotNullExpressionValue(list, (String)"message.class_List");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ProtoBuf.Class classProto = (ProtoBuf.Class)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)NameResolverUtilKt.getClassId(nameResolver2, classProto.getFqName()), (Object)classId)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        ProtoBuf.Class clazz2 = v2;
        if (clazz2 != null) {
            ProtoBuf.Class classProto = clazz2;
            boolean bl = false;
            NameResolver nameResolver3 = nameResolver2;
            BinaryVersion binaryVersion = version;
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
            classData = new ClassData(nameResolver3, classProto, binaryVersion, sourceElement);
        } else {
            classData = null;
        }
        return classData;
    }
}

