/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectTopLevelDeclarations;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectTopLevelDeclarationCollector;", "", "<init>", "()V", "expectTopLevelClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "expectTopLevelCallables", "Lorg/jetbrains/kotlin/name/CallableId;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "collect", "", "fragments", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "Companion", "ir.actualization"})
@SourceDebugExtension(value={"SMAP\nExpectActualCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ExpectTopLevelDeclarationCollector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,518:1\n382#2,7:519\n*S KotlinDebug\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ExpectTopLevelDeclarationCollector\n*L\n147#1:519,7\n*E\n"})
final class ExpectTopLevelDeclarationCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ClassId, IrClassSymbol> expectTopLevelClasses = new LinkedHashMap();
    @NotNull
    private final Map<CallableId, List<IrSymbol>> expectTopLevelCallables = new LinkedHashMap();

    public final void collect(@NotNull List<? extends IrModuleFragment> fragments) {
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        for (IrModuleFragment irModuleFragment : fragments) {
            for (IrFile file : irModuleFragment.getFiles()) {
                for (IrDeclaration declaration : file.getDeclarations()) {
                    if (!IrUtilsKt.isExpect(declaration) || !IrUtilsKt.isTopLevel(declaration)) continue;
                    IrDeclaration irDeclaration = declaration;
                    if (irDeclaration instanceof IrClass) {
                        this.expectTopLevelClasses.put(AdditionalIrUtilsKt.getClassIdOrFail((IrClass)declaration), ((IrClass)declaration).getSymbol());
                        continue;
                    }
                    if (irDeclaration instanceof IrProperty) {
                        ExpectTopLevelDeclarationCollector.collect$addCallable(this, declaration, AdditionalIrUtilsKt.getCallableId((IrProperty)declaration));
                        continue;
                    }
                    if (!(irDeclaration instanceof IrFunction)) continue;
                    ExpectTopLevelDeclarationCollector.collect$addCallable(this, declaration, AdditionalIrUtilsKt.getCallableId((IrFunction)declaration));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void collect$addCallable(ExpectTopLevelDeclarationCollector this$0, IrDeclaration declaration, CallableId callableId) {
        Object object;
        void $this$getOrPut$iv;
        Map<CallableId, List<IrSymbol>> map = this$0.expectTopLevelCallables;
        CallableId key$iv = callableId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        List list = (List)object;
        list.add(declaration.getSymbol());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectTopLevelDeclarationCollector$Companion;", "", "<init>", "()V", "collect", "Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectTopLevelDeclarations;", "fragments", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "ir.actualization"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExpectTopLevelDeclarations collect(@NotNull List<? extends IrModuleFragment> fragments) {
            Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
            ExpectTopLevelDeclarationCollector collector = new ExpectTopLevelDeclarationCollector();
            collector.collect(fragments);
            return new ExpectTopLevelDeclarations(collector.expectTopLevelClasses, collector.expectTopLevelCallables);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

