/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.util.DeclarationParentsVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/CheckDeclarationParentsVisitor;", "Lorg/jetbrains/kotlin/ir/util/DeclarationParentsVisitor;", "<init>", "()V", "errors", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/backend/common/CheckDeclarationParentsVisitor$Error;", "Lkotlin/collections/ArrayList;", "getErrors", "()Ljava/util/ArrayList;", "handleParent", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "actualParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "Error", "ir.backend.common"})
final class CheckDeclarationParentsVisitor
extends DeclarationParentsVisitor {
    @NotNull
    private final ArrayList<Error> errors = new ArrayList();

    @NotNull
    public final ArrayList<Error> getErrors() {
        return this.errors;
    }

    @Override
    protected void handleParent(@NotNull IrDeclaration declaration, @NotNull IrDeclarationParent actualParent) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)actualParent, (String)"actualParent");
        try {
            IrDeclarationParent assignedParent = declaration.getParent();
            if (!Intrinsics.areEqual((Object)assignedParent, (Object)actualParent)) {
                this.errors.add(new Error(declaration, assignedParent, actualParent));
            }
        }
        catch (Exception e) {
            this.errors.add(new Error(declaration, actualParent, null));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/CheckDeclarationParentsVisitor$Error;", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "expectedParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "actualParent", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getExpectedParent", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "getActualParent", "ir.backend.common"})
    public static final class Error {
        @NotNull
        private final IrDeclaration declaration;
        @NotNull
        private final IrDeclarationParent expectedParent;
        @Nullable
        private final IrDeclarationParent actualParent;

        public Error(@NotNull IrDeclaration declaration, @NotNull IrDeclarationParent expectedParent, @Nullable IrDeclarationParent actualParent) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)expectedParent, (String)"expectedParent");
            this.declaration = declaration;
            this.expectedParent = expectedParent;
            this.actualParent = actualParent;
        }

        @NotNull
        public final IrDeclaration getDeclaration() {
            return this.declaration;
        }

        @NotNull
        public final IrDeclarationParent getExpectedParent() {
            return this.expectedParent;
        }

        @Nullable
        public final IrDeclarationParent getActualParent() {
            return this.actualParent;
        }
    }
}

