/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationModeKt;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H&J\u001c\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H&J \u0010\u0014\u001a\u00020\u00032\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H&J\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0018\u001a\u00020\u0003*\u00020\u0019H\u0004J\f\u0010\u001a\u001a\u00020\u0003*\u00020\u0019H\u0002J\n\u0010\u001b\u001a\u00020\u0003*\u00020\u0019J\f\u0010\u001c\u001a\u00020\u0003*\u00020\u0019H\u0002J\f\u0010\u001d\u001a\u00020\u0003*\u00020\u0019H\u0004J\u0014\u0010\u001e\u001a\u00020\u0003*\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0004R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "", "mustCheckBody", "", "(Ljava/lang/String;IZ)V", "compileTimeTypeAliases", "", "", "getCompileTimeTypeAliases", "()Ljava/util/Set;", "getMustCheckBody", "()Z", "canEvaluateEnumValue", "enumEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "context", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "canEvaluateFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canEvaluateReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "mustCheckBodyOf", "isCompileTimeTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isContract", "isMarkedAsCompileTime", "isMarkedAsEvaluateIntrinsic", "isMarkedAsIntrinsicConstEvaluation", "isMarkedWith", "annotation", "Lorg/jetbrains/kotlin/name/FqName;", "FULL", "WITH_ANNOTATIONS", "ONLY_BUILTINS", "ONLY_INTRINSIC_CONST", "ir.interpreter"})
public abstract class EvaluationMode
extends Enum<EvaluationMode> {
    private final boolean mustCheckBody;
    @NotNull
    private final Set<String> compileTimeTypeAliases;
    public static final /* enum */ EvaluationMode FULL = new FULL("FULL", 0);
    public static final /* enum */ EvaluationMode WITH_ANNOTATIONS = new WITH_ANNOTATIONS("WITH_ANNOTATIONS", 1);
    public static final /* enum */ EvaluationMode ONLY_BUILTINS = new ONLY_BUILTINS("ONLY_BUILTINS", 2);
    public static final /* enum */ EvaluationMode ONLY_INTRINSIC_CONST = new ONLY_INTRINSIC_CONST("ONLY_INTRINSIC_CONST", 3);
    private static final /* synthetic */ EvaluationMode[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private EvaluationMode(boolean mustCheckBody) {
        this.mustCheckBody = mustCheckBody;
        Object[] objectArray = new String[]{"java.lang.StringBuilder", "java.lang.IllegalArgumentException", "java.util.NoSuchElementException"};
        this.compileTimeTypeAliases = SetsKt.setOf((Object[])objectArray);
    }

    protected final boolean getMustCheckBody() {
        return this.mustCheckBody;
    }

    public abstract boolean canEvaluateFunction(@NotNull IrFunction var1, @Nullable IrCall var2);

    public static /* synthetic */ boolean canEvaluateFunction$default(EvaluationMode evaluationMode, IrFunction irFunction, IrCall irCall, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: canEvaluateFunction");
        }
        if ((n & 2) != 0) {
            irCall = null;
        }
        return evaluationMode.canEvaluateFunction(irFunction, irCall);
    }

    public abstract boolean canEvaluateEnumValue(@NotNull IrGetEnumValue var1, @Nullable IrCall var2);

    public static /* synthetic */ boolean canEvaluateEnumValue$default(EvaluationMode evaluationMode, IrGetEnumValue irGetEnumValue, IrCall irCall, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: canEvaluateEnumValue");
        }
        if ((n & 2) != 0) {
            irCall = null;
        }
        return evaluationMode.canEvaluateEnumValue(irGetEnumValue, irCall);
    }

    public abstract boolean canEvaluateReference(@NotNull IrCallableReference<?> var1, @Nullable IrCall var2);

    public static /* synthetic */ boolean canEvaluateReference$default(EvaluationMode evaluationMode, IrCallableReference irCallableReference, IrCall irCall, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: canEvaluateReference");
        }
        if ((n & 2) != 0) {
            irCall = null;
        }
        return evaluationMode.canEvaluateReference(irCallableReference, irCall);
    }

    public final boolean mustCheckBodyOf(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (EvaluationModeKt.access$getProperty(function2) != null) {
            return true;
        }
        return (this.mustCheckBody || AdditionalIrUtilsKt.isLocal(function2)) && !this.isContract(function2) && !this.isMarkedAsEvaluateIntrinsic(function2);
    }

    @NotNull
    protected final Set<String> getCompileTimeTypeAliases() {
        return this.compileTimeTypeAliases;
    }

    public final boolean isMarkedAsCompileTime(@NotNull IrDeclaration $this$isMarkedAsCompileTime) {
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedAsCompileTime, (String)"<this>");
        return this.isMarkedWith($this$isMarkedAsCompileTime, UtilsKt.getCompileTimeAnnotation());
    }

    protected final boolean isMarkedAsIntrinsicConstEvaluation(@NotNull IrDeclaration $this$isMarkedAsIntrinsicConstEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedAsIntrinsicConstEvaluation, (String)"<this>");
        return this.isMarkedWith($this$isMarkedAsIntrinsicConstEvaluation, UtilsKt.getIntrinsicConstEvaluationAnnotation());
    }

    private final boolean isContract(IrDeclaration $this$isContract) {
        return this.isMarkedWith($this$isContract, UtilsKt.getContractsDslAnnotation());
    }

    private final boolean isMarkedAsEvaluateIntrinsic(IrDeclaration $this$isMarkedAsEvaluateIntrinsic) {
        return this.isMarkedWith($this$isMarkedAsEvaluateIntrinsic, UtilsKt.getEvaluateIntrinsicAnnotation());
    }

    protected final boolean isCompileTimeTypeAlias(@NotNull IrDeclaration $this$isCompileTimeTypeAlias) {
        Intrinsics.checkNotNullParameter((Object)$this$isCompileTimeTypeAlias, (String)"<this>");
        IrClass irClass = IrUtilsKt.getParentClassOrNull($this$isCompileTimeTypeAlias);
        return CollectionsKt.contains((Iterable)this.compileTimeTypeAliases, (Object)(irClass != null ? UtilsKt.getFqName(irClass) : null));
    }

    protected final boolean isMarkedWith(@NotNull IrDeclaration $this$isMarkedWith, @NotNull FqName annotation) {
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        if ($this$isMarkedWith instanceof IrClass && ((IrClass)$this$isMarkedWith).isCompanion()) {
            return false;
        }
        if (UtilsKt.hasAnnotation($this$isMarkedWith, annotation)) {
            return true;
        }
        IrDeclarationParent irDeclarationParent = $this$isMarkedWith.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        return irClass != null ? this.isMarkedWith(irClass, annotation) : false;
    }

    public static EvaluationMode[] values() {
        return (EvaluationMode[])$VALUES.clone();
    }

    public static EvaluationMode valueOf(String value) {
        return Enum.valueOf(EvaluationMode.class, value);
    }

    @NotNull
    public static EnumEntries<EvaluationMode> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ EvaluationMode(String $enum$name, int $enum$ordinal, boolean mustCheckBody, DefaultConstructorMarker $constructor_marker) {
        this(mustCheckBody);
    }

    static {
        $VALUES = evaluationModeArray = new EvaluationMode[]{EvaluationMode.FULL, EvaluationMode.WITH_ANNOTATIONS, EvaluationMode.ONLY_BUILTINS, EvaluationMode.ONLY_INTRINSIC_CONST};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001e\u0010\u000b\u001a\u00020\u00032\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$FULL;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "canEvaluateEnumValue", "", "enumEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "context", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "canEvaluateFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canEvaluateReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "ir.interpreter"})
    static final class FULL
    extends EvaluationMode {
        /*
         * WARNING - void declaration
         */
        FULL() {
            void var1_1;
        }

        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2, @Nullable IrCall context) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            return true;
        }

        @Override
        public boolean canEvaluateEnumValue(@NotNull IrGetEnumValue enumEntry, @Nullable IrCall context) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            return true;
        }

        @Override
        public boolean canEvaluateReference(@NotNull IrCallableReference<?> reference, @Nullable IrCall context) {
            Intrinsics.checkNotNullParameter(reference, (String)"reference");
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001e\u0010\u0011\u001a\u00020\t2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$ONLY_BUILTINS;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "allowedBuiltinExtensionFunctions", "", "", "allowedExtensionFunctions", "allowedMethodsOnPrimitives", "allowedMethodsOnStrings", "canEvaluateEnumValue", "", "enumEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "context", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "canEvaluateFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canEvaluateReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "ir.interpreter"})
    @SourceDebugExtension(value={"SMAP\nEvaluationMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvaluationMode.kt\norg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$ONLY_BUILTINS\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1549#2:151\n1620#2,3:152\n1#3:155\n*S KotlinDebug\n*F\n+ 1 EvaluationMode.kt\norg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$ONLY_BUILTINS\n*L\n70#1:151\n70#1:152,3\n*E\n"})
    static final class ONLY_BUILTINS
    extends EvaluationMode {
        @NotNull
        private final Set<String> allowedMethodsOnPrimitives;
        @NotNull
        private final Set<String> allowedMethodsOnStrings;
        @NotNull
        private final Set<String> allowedExtensionFunctions;
        @NotNull
        private final Set<String> allowedBuiltinExtensionFunctions;

        /*
         * WARNING - void declaration
         */
        ONLY_BUILTINS() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void var1_1;
            Object object = new String[]{"not", "unaryMinus", "unaryPlus", "inv", "toString", "toChar", "toByte", "toShort", "toInt", "toLong", "toFloat", "toDouble", "equals", "compareTo", "plus", "minus", "times", "div", "rem", "and", "or", "xor", "shl", "shr", "ushr", "less", "lessOrEqual", "greater", "greaterOrEqual"};
            this.allowedMethodsOnPrimitives = SetsKt.setOf((Object[])object);
            object = new String[]{"<get-length>", "plus", "get", "compareTo", "equals", "toString"};
            this.allowedMethodsOnStrings = SetsKt.setOf((Object[])object);
            object = new String[]{"kotlin.floorDiv", "kotlin.mod", "kotlin.NumbersKt.floorDiv", "kotlin.NumbersKt.mod", "kotlin.<get-code>"};
            this.allowedExtensionFunctions = SetsKt.setOf((Object[])object);
            object = new String[]{"less", "lessOrEqual", "greater", "greaterOrEqual", "EQEQ", "ieee754equals", "ANDAND", "OROR"};
            object = CollectionsKt.listOf((Object[])object);
            ONLY_BUILTINS oNLY_BUILTINS = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN().child(Name.identifier((String)it)).asString());
            }
            oNLY_BUILTINS.allowedBuiltinExtensionFunctions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2, @Nullable IrCall context) {
            boolean bl;
            IrClass parent2;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            IrProperty irProperty = EvaluationModeKt.access$getProperty(function2);
            if (irProperty != null) {
                if (irProperty.isConst()) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
            IrType returnType2 = function2.getReturnType();
            if (!(IrTypePredicatesKt.isPrimitiveType$default(returnType2, false, 1, null) || IrTypePredicatesKt.isString(returnType2) || IrTypePredicatesKt.isUnsignedType$default(returnType2, false, 1, null))) {
                return false;
            }
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable(function2);
            String fqName2 = fqName != null ? fqName.asString() : null;
            IrClass irClass = parent2 = IrUtilsKt.getParentClassOrNull(function2);
            IrSimpleType parentType = irClass != null ? IrUtilsKt.getDefaultType(irClass) : null;
            if (parentType == null) {
                if (CollectionsKt.contains((Iterable)this.allowedExtensionFunctions, (Object)fqName2)) return true;
                if (!CollectionsKt.contains((Iterable)this.allowedBuiltinExtensionFunctions, (Object)fqName2)) return false;
                return true;
            }
            if (IrTypePredicatesKt.isPrimitiveType$default(parentType, false, 1, null)) {
                bl = this.allowedMethodsOnPrimitives.contains(function2.getName().asString());
                return bl;
            } else if (IrTypePredicatesKt.isString(parentType)) {
                bl = this.allowedMethodsOnStrings.contains(function2.getName().asString());
                return bl;
            } else {
                if (IrTypePredicatesKt.isAny(parentType)) {
                    if (!Intrinsics.areEqual((Object)function2.getName().asString(), (Object)"toString")) return false;
                    IrCall irCall = context;
                    if ((irCall != null ? irCall.getDispatchReceiver() : null) instanceof IrGetObjectValue) return false;
                    return true;
                }
                if (IrUtilsKt.isObject(parent2)) {
                    IrClass irClass2 = IrUtilsKt.getParentClassOrNull(parent2);
                    IrAnnotationContainer irAnnotationContainer = irClass2;
                    if (irClass2 == null) return false;
                    IrSimpleType irSimpleType = IrUtilsKt.getDefaultType(irAnnotationContainer);
                    irAnnotationContainer = irSimpleType;
                    if (irSimpleType == null) return false;
                    IrAnnotationContainer irAnnotationContainer2 = irAnnotationContainer;
                    boolean bl3 = false;
                    if (IrTypePredicatesKt.isPrimitiveType$default((IrType)irAnnotationContainer2, false, 1, null)) return true;
                    if (!IrTypeUtilsKt.isUnsigned((IrType)irAnnotationContainer2)) return false;
                    return true;
                }
                if (IrTypePredicatesKt.isUnsignedType$default(parentType, false, 1, null) && function2 instanceof IrConstructor) {
                    return true;
                }
                if (CollectionsKt.contains((Iterable)this.allowedExtensionFunctions, (Object)fqName2)) return true;
                if (!CollectionsKt.contains((Iterable)this.allowedBuiltinExtensionFunctions, (Object)fqName2)) return false;
                return true;
            }
        }

        @Override
        public boolean canEvaluateEnumValue(@NotNull IrGetEnumValue enumEntry, @Nullable IrCall context) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            return false;
        }

        @Override
        public boolean canEvaluateReference(@NotNull IrCallableReference<?> reference, @Nullable IrCall context) {
            Intrinsics.checkNotNullParameter(reference, (String)"reference");
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001e\u0010\u000b\u001a\u00020\u00032\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u000e\u0010\u000e\u001a\u00020\u0003*\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u000f\u001a\u00020\u0003*\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$ONLY_INTRINSIC_CONST;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "canEvaluateEnumValue", "", "enumEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "context", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "canEvaluateFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canEvaluateReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "isCompileTimePropertyAccessor", "isIntrinsicConstEvaluationNameProperty", "ir.interpreter"})
    static final class ONLY_INTRINSIC_CONST
    extends EvaluationMode {
        /*
         * WARNING - void declaration
         */
        ONLY_INTRINSIC_CONST() {
            void var1_1;
        }

        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2, @Nullable IrCall context) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            return this.isCompileTimePropertyAccessor(function2) || this.isMarkedAsIntrinsicConstEvaluation(function2) || this.isIntrinsicConstEvaluationNameProperty(context);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isCompileTimePropertyAccessor(IrFunction $this$isCompileTimePropertyAccessor) {
            IrFunction irFunction = $this$isCompileTimePropertyAccessor;
            IrDeclarationBase irDeclarationBase = irFunction;
            if (irFunction == null) return false;
            if ((irDeclarationBase = EvaluationModeKt.access$getProperty((IrFunction)irDeclarationBase)) == null) {
                return false;
            }
            IrDeclarationBase property = irDeclarationBase;
            if (((IrProperty)property).isConst()) return true;
            IrDeclarationBase irDeclarationBase2 = (IrProperty)IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)((Object)property), false, null, 3, null);
            if (irDeclarationBase2 == null) {
                irDeclarationBase2 = property;
            }
            if (!this.isMarkedAsIntrinsicConstEvaluation(irDeclarationBase2)) return false;
            return true;
        }

        @Override
        public boolean canEvaluateEnumValue(@NotNull IrGetEnumValue enumEntry, @Nullable IrCall context) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            return this.isIntrinsicConstEvaluationNameProperty(context);
        }

        @Override
        public boolean canEvaluateReference(@NotNull IrCallableReference<?> reference, @Nullable IrCall context) {
            Intrinsics.checkNotNullParameter(reference, (String)"reference");
            return this.isIntrinsicConstEvaluationNameProperty(context);
        }

        private final boolean isIntrinsicConstEvaluationNameProperty(IrCall $this$isIntrinsicConstEvaluationNameProperty) {
            if ($this$isIntrinsicConstEvaluationNameProperty == null) {
                return false;
            }
            IrSimpleFunction owner = (IrSimpleFunction)$this$isIntrinsicConstEvaluationNameProperty.getSymbol().getOwner();
            IrProperty irProperty = EvaluationModeKt.access$getProperty(owner);
            if (irProperty == null) {
                return false;
            }
            IrProperty property = irProperty;
            return this.isCompileTimePropertyAccessor(owner) && Intrinsics.areEqual((Object)property.getName().asString(), (Object)"name");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001e\u0010\u000b\u001a\u00020\u00032\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u000e\u0010\u000e\u001a\u00020\u0003*\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$WITH_ANNOTATIONS;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "canEvaluateEnumValue", "", "enumEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "context", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "canEvaluateFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canEvaluateReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "isCompileTimePropertyAccessor", "ir.interpreter"})
    @SourceDebugExtension(value={"SMAP\nEvaluationMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvaluationMode.kt\norg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$WITH_ANNOTATIONS\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1747#2,3:151\n*S KotlinDebug\n*F\n+ 1 EvaluationMode.kt\norg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$WITH_ANNOTATIONS\n*L\n34#1:151,3\n*E\n"})
    static final class WITH_ANNOTATIONS
    extends EvaluationMode {
        /*
         * WARNING - void declaration
         */
        WITH_ANNOTATIONS() {
            void var1_1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2, @Nullable IrCall context) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            if (this.isCompileTimePropertyAccessor(function2)) {
                return true;
            }
            if (this.isMarkedAsCompileTime(function2)) return true;
            if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrBuiltIns.Companion.getBUILTIN_OPERATOR())) return true;
            if (function2 instanceof IrSimpleFunction && ((IrSimpleFunction)function2).isOperator()) {
                if (Intrinsics.areEqual((Object)function2.getName().asString(), (Object)"invoke")) return true;
            }
            if (function2 instanceof IrSimpleFunction && ((IrSimpleFunction)function2).isFakeOverride()) {
                boolean bl;
                Iterable $this$any$iv = ((IrSimpleFunction)function2).getOverriddenSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl2 = false;
                        if (!EvaluationMode.canEvaluateFunction$default(this, it.getOwner(), null, 2, null)) continue;
                        return true;
                    }
                    bl = false;
                }
                if (bl) return true;
            }
            if (!this.isCompileTimeTypeAlias(function2)) return false;
            return true;
        }

        private final boolean isCompileTimePropertyAccessor(IrFunction $this$isCompileTimePropertyAccessor) {
            IrGetValue backingFieldExpression;
            IrDeclarationBase irDeclarationBase = $this$isCompileTimePropertyAccessor;
            if (irDeclarationBase == null || (irDeclarationBase = EvaluationModeKt.access$getProperty((IrFunction)irDeclarationBase)) == null) {
                return false;
            }
            IrDeclarationBase property = irDeclarationBase;
            if (((IrProperty)property).isConst()) {
                return true;
            }
            if (this.isMarkedAsCompileTime(property) || this.isCompileTimeTypeAlias(property)) {
                return true;
            }
            IrField backingField2 = ((IrProperty)property).getBackingField();
            IrElementBase irElementBase = backingField2;
            IrExpression irExpression = irElementBase != null && (irElementBase = ((IrField)irElementBase).getInitializer()) != null ? ((IrExpressionBody)irElementBase).getExpression() : null;
            IrGetValue irGetValue = backingFieldExpression = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
            return Intrinsics.areEqual((Object)(irGetValue != null ? irGetValue.getOrigin() : null), (Object)IrStatementOrigin.INITIALIZE_PROPERTY_FROM_PARAMETER.INSTANCE);
        }

        @Override
        public boolean canEvaluateEnumValue(@NotNull IrGetEnumValue enumEntry, @Nullable IrCall context) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            return true;
        }

        @Override
        public boolean canEvaluateReference(@NotNull IrCallableReference<?> reference, @Nullable IrCall context) {
            Intrinsics.checkNotNullParameter(reference, (String)"reference");
            return true;
        }
    }
}

