/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.IrFileSerializer;
import org.jetbrains.kotlin.backend.common.serialization.proto.IdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrType;
import org.jetbrains.kotlin.backend.jvm.serialization.JvmIrSerializerSessionKt;
import org.jetbrains.kotlin.backend.jvm.serialization.proto.JvmIr;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001dJ\n\u0010\u001e\u001a\u00020\u001f*\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIrSerializerSession;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "messageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "declarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "expectDescriptorToSymbol", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "mode", "Lorg/jetbrains/kotlin/config/JvmSerializeIrMode;", "fileClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "skipExpects", "", "(Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;Ljava/util/Map;Lorg/jetbrains/kotlin/config/JvmSerializeIrMode;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Z)V", "serializeAuxTables", "", "proto", "Lorg/jetbrains/kotlin/backend/jvm/serialization/proto/JvmIr$ClassOrFile$Builder;", "serializeJvmIrFile", "Lorg/jetbrains/kotlin/backend/jvm/serialization/proto/JvmIr$ClassOrFile;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "serializeTopLevelClass", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "toProto", "Lorg/jetbrains/kotlin/backend/jvm/serialization/proto/JvmIr$XStatementOrExpression;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer$XStatementOrExpression;", "ir.serialization.jvm"})
@SourceDebugExtension(value={"SMAP\nJvmIrSerializerSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmIrSerializerSession.kt\norg/jetbrains/kotlin/backend/jvm/serialization/JvmIrSerializerSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1855#2,2:131\n1855#2,2:133\n1855#2,2:135\n1855#2,2:137\n1855#2,2:139\n*S KotlinDebug\n*F\n+ 1 JvmIrSerializerSession.kt\norg/jetbrains/kotlin/backend/jvm/serialization/JvmIrSerializerSession\n*L\n76#1:131,2\n77#1:133,2\n78#1:135,2\n79#1:137,2\n80#1:139,2\n*E\n"})
public final class JvmIrSerializerSession
extends IrFileSerializer {
    @NotNull
    private final DeclarationTable declarationTable;
    @NotNull
    private final JvmSerializeIrMode mode;
    @NotNull
    private final FqName fileClassFqName;

    public JvmIrSerializerSession(@NotNull IrMessageLogger messageLogger, @NotNull DeclarationTable declarationTable, @NotNull Map<DeclarationDescriptor, IrSymbol> expectDescriptorToSymbol, @NotNull JvmSerializeIrMode mode, @NotNull FqName fileClassFqName, @NotNull LanguageVersionSettings languageVersionSettings, boolean skipExpects) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)messageLogger, (String)"messageLogger");
        Intrinsics.checkNotNullParameter((Object)declarationTable, (String)"declarationTable");
        Intrinsics.checkNotNullParameter(expectDescriptorToSymbol, (String)"expectDescriptorToSymbol");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)fileClassFqName, (String)"fileClassFqName");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        super(messageLogger, declarationTable, expectDescriptorToSymbol, CompatibilityMode.Companion.getCURRENT(), languageVersionSettings, mode == JvmSerializeIrMode.INLINE, skipExpects, false, CollectionsKt.emptyList());
        this.declarationTable = declarationTable;
        this.mode = mode;
        this.fileClassFqName = fileClassFqName;
        boolean bl2 = bl = this.mode != JvmSerializeIrMode.NONE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ JvmIrSerializerSession(IrMessageLogger irMessageLogger, DeclarationTable declarationTable, Map map, JvmSerializeIrMode jvmSerializeIrMode, FqName fqName, LanguageVersionSettings languageVersionSettings, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            bl = false;
        }
        this(irMessageLogger, declarationTable, map, jvmSerializeIrMode, fqName, languageVersionSettings, bl);
    }

    @Nullable
    public final JvmIr.ClassOrFile serializeJvmIrFile(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Ref.BooleanRef anySaved = new Ref.BooleanRef();
        JvmIr.ClassOrFile.Builder proto = JvmIr.ClassOrFile.newBuilder();
        this.declarationTable.inFile(irFile, (Function0<Unit>)((Function0)new Function0<Unit>(irFile, this, proto, anySaved){
            final /* synthetic */ IrFile $irFile;
            final /* synthetic */ JvmIrSerializerSession this$0;
            final /* synthetic */ JvmIr.ClassOrFile.Builder $proto;
            final /* synthetic */ Ref.BooleanRef $anySaved;
            {
                this.$irFile = $irFile;
                this.this$0 = $receiver;
                this.$proto = $proto;
                this.$anySaved = $anySaved;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.$irFile.getDeclarations();
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv$iv;
                    boolean bl = false;
                    if (!(!(it instanceof IrClass))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                JvmIrSerializerSession jvmIrSerializerSession = this.this$0;
                object = this.$proto;
                Ref.BooleanRef booleanRef = this.$anySaved;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrDeclaration topDeclaration = (IrDeclaration)element$iv;
                    boolean bl = false;
                    JvmIrSerializerSessionKt.access$forEveryDeclarationToSerialize(topDeclaration, JvmIrSerializerSession.access$getMode$p(jvmIrSerializerSession), (Function1)new Function1<IrDeclaration, Unit>((JvmIr.ClassOrFile.Builder)object, jvmIrSerializerSession, booleanRef){
                        final /* synthetic */ JvmIr.ClassOrFile.Builder $proto;
                        final /* synthetic */ JvmIrSerializerSession this$0;
                        final /* synthetic */ Ref.BooleanRef $anySaved;
                        {
                            this.$proto = $proto;
                            this.this$0 = $receiver;
                            this.$anySaved = $anySaved;
                            super(1);
                        }

                        public final void invoke(@NotNull IrDeclaration declaration) {
                            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                            this.$proto.addDeclaration(this.this$0.serializeDeclaration(declaration));
                            this.$anySaved.element = true;
                        }
                    });
                }
            }
        }));
        if (!anySaved.element) {
            return null;
        }
        Intrinsics.checkNotNull((Object)proto);
        this.serializeAuxTables(proto);
        proto.setFileFacadeFqName(this.fileClassFqName.asString());
        return proto.build();
    }

    @Nullable
    public final JvmIr.ClassOrFile serializeTopLevelClass(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        JvmIr.ClassOrFile.Builder proto = JvmIr.ClassOrFile.newBuilder();
        IrDeclarationParent irDeclarationParent = irClass.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
        this.declarationTable.inFile((IrFile)irDeclarationParent, (Function0<Unit>)((Function0)new Function0<Unit>(irClass, this, proto){
            final /* synthetic */ IrClass $irClass;
            final /* synthetic */ JvmIrSerializerSession this$0;
            final /* synthetic */ JvmIr.ClassOrFile.Builder $proto;
            {
                this.$irClass = $irClass;
                this.this$0 = $receiver;
                this.$proto = $proto;
                super(0);
            }

            public final void invoke() {
                JvmIrSerializerSessionKt.access$forEveryDeclarationToSerialize(this.$irClass, JvmIrSerializerSession.access$getMode$p(this.this$0), (Function1)new Function1<IrDeclaration, Unit>(this.$proto, this.this$0){
                    final /* synthetic */ JvmIr.ClassOrFile.Builder $proto;
                    final /* synthetic */ JvmIrSerializerSession this$0;
                    {
                        this.$proto = $proto;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull IrDeclaration declaration) {
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        this.$proto.addDeclaration(this.this$0.serializeDeclaration(declaration));
                    }
                });
            }
        }));
        Intrinsics.checkNotNull((Object)proto);
        this.serializeAuxTables(proto);
        proto.setFileFacadeFqName(this.fileClassFqName.asString());
        return proto.build();
    }

    private final void serializeAuxTables(JvmIr.ClassOrFile.Builder proto) {
        Object p0;
        Iterable $this$forEach$iv = this.getProtoTypeArray();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (IrType)element$iv;
            boolean bl = false;
            proto.addType((IrType)p0);
        }
        $this$forEach$iv = this.getProtoIdSignatureArray();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (IdSignature)element$iv;
            boolean bl = false;
            proto.addSignature((IdSignature)p0);
        }
        $this$forEach$iv = this.getProtoStringArray();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (String)element$iv;
            boolean bl = false;
            proto.addString((String)p0);
        }
        $this$forEach$iv = this.getProtoBodyArray();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFileSerializer.XStatementOrExpression it = (IrFileSerializer.XStatementOrExpression)element$iv;
            boolean bl = false;
            proto.addBody(this.toProto(it));
        }
        $this$forEach$iv = this.getProtoDebugInfoArray();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (String)element$iv;
            boolean bl = false;
            proto.addDebugInfo((String)p0);
        }
    }

    @NotNull
    public final JvmIr.XStatementOrExpression toProto(@NotNull IrFileSerializer.XStatementOrExpression $this$toProto) {
        JvmIr.XStatementOrExpression xStatementOrExpression;
        Intrinsics.checkNotNullParameter((Object)$this$toProto, (String)"<this>");
        IrFileSerializer.XStatementOrExpression xStatementOrExpression2 = $this$toProto;
        if (xStatementOrExpression2 instanceof IrFileSerializer.XStatementOrExpression.XStatement) {
            JvmIr.XStatementOrExpression xStatementOrExpression3 = JvmIr.XStatementOrExpression.newBuilder().setStatement($this$toProto.toProtoStatement()).build();
            xStatementOrExpression = xStatementOrExpression3;
            Intrinsics.checkNotNullExpressionValue((Object)xStatementOrExpression3, (String)"build(...)");
        } else if (xStatementOrExpression2 instanceof IrFileSerializer.XStatementOrExpression.XExpression) {
            JvmIr.XStatementOrExpression xStatementOrExpression4 = JvmIr.XStatementOrExpression.newBuilder().setExpression($this$toProto.toProtoExpression()).build();
            xStatementOrExpression = xStatementOrExpression4;
            Intrinsics.checkNotNullExpressionValue((Object)xStatementOrExpression4, (String)"build(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return xStatementOrExpression;
    }

    public static final /* synthetic */ JvmSerializeIrMode access$getMode$p(JvmIrSerializerSession $this) {
        return $this.mode;
    }
}

