/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.DataClassArrayToString;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/DataClassArrayToString;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "arrayToString", "", "array", "", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getListOfAcceptableFunctions", "", "ir.interpreter"})
public final class DataClassArrayToString
extends IntrinsicBase {
    @NotNull
    public static final DataClassArrayToString INSTANCE = new DataClassArrayToString();

    private DataClassArrayToString() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        return CollectionsKt.listOf((Object)"kotlin.internal.ir.dataClassArrayMemberToString");
    }

    private final String arrayToString(Object array) {
        String string;
        Object object = array;
        if (object == null) {
            string = "null";
        } else if (object instanceof Object[]) {
            String string2 = Arrays.toString((Object[])array);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(array)");
        } else if (object instanceof byte[]) {
            String string3 = Arrays.toString((byte[])array);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(array)");
        } else if (object instanceof short[]) {
            String string4 = Arrays.toString((short[])array);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(array)");
        } else if (object instanceof int[]) {
            String string5 = Arrays.toString((int[])array);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(array)");
        } else if (object instanceof long[]) {
            String string6 = Arrays.toString((long[])array);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(array)");
        } else if (object instanceof char[]) {
            String string7 = Arrays.toString((char[])array);
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(array)");
        } else if (object instanceof boolean[]) {
            String string8 = Arrays.toString((boolean[])array);
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(array)");
        } else if (object instanceof float[]) {
            String string9 = Arrays.toString((float[])array);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toString(array)");
        } else if (object instanceof double[]) {
            String string10 = Arrays.toString((double[])array);
            string = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toString(array)");
        } else {
            ExceptionUtilsKt.stop((Function0<? extends Object>)((Function0)arrayToString.1.INSTANCE));
            throw null;
        }
        return string;
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        State state = environment.getCallStack$ir_interpreter().loadState(((IrValueParameter)CollectionsKt.single(irFunction.getValueParameters())).getSymbol());
        Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
        Primitive array = (Primitive)state;
        environment.getCallStack$ir_interpreter().pushState(environment.convertToState$ir_interpreter(this.arrayToString(array.getValue()), irFunction.getReturnType()));
    }
}

