/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.IrDeclarationDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrInterningService;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFileFromBytes;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.proto.Actual;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020%J\u0006\u0010.\u001a\u00020,J\u0006\u0010/\u001a\u00020,R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001e\u0010#\u001a\u0012\u0012\u0004\u0012\u00020%0$j\b\u0012\u0004\u0012\u00020%`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState;", "", "linker", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "fileIndex", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "fileReader", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes;", "fileProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;", "deserializeBodies", "", "allowErrorNodes", "deserializeInlineFunctions", "moduleDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;ILorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes;Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;ZZZLorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;)V", "declarationDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;", "getDeclarationDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;", "getFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "fileDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "getFileDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "getFileIndex", "()I", "getFileReader", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes;", "getLinker", "()Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "reachableTopLevels", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lkotlin/collections/LinkedHashSet;", "symbolDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "getSymbolDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "addIdSignature", "", "key", "deserializeAllFileReachableTopLevel", "enqueueAllDeclarations", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrFileDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrFileDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1855#2,2:201\n*S KotlinDebug\n*F\n+ 1 IrFileDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState\n*L\n106#1:201,2\n*E\n"})
public final class FileDeserializationState {
    @NotNull
    private final KotlinIrLinker linker;
    private final int fileIndex;
    @NotNull
    private final org.jetbrains.kotlin.ir.declarations.IrFile file;
    @NotNull
    private final IrLibraryFileFromBytes fileReader;
    @NotNull
    private final IrSymbolDeserializer symbolDeserializer;
    @NotNull
    private final IrDeclarationDeserializer declarationDeserializer;
    @NotNull
    private final IrFileDeserializer fileDeserializer;
    @NotNull
    private final LinkedHashSet<IdSignature> reachableTopLevels;

    public FileDeserializationState(@NotNull KotlinIrLinker linker, int fileIndex, @NotNull org.jetbrains.kotlin.ir.declarations.IrFile file, @NotNull IrLibraryFileFromBytes fileReader, @NotNull IrFile fileProto, boolean deserializeBodies, boolean allowErrorNodes, boolean deserializeInlineFunctions, @NotNull IrModuleDeserializer moduleDeserializer) {
        Intrinsics.checkNotNullParameter((Object)linker, (String)"linker");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileReader, (String)"fileReader");
        Intrinsics.checkNotNullParameter((Object)fileProto, (String)"fileProto");
        Intrinsics.checkNotNullParameter((Object)moduleDeserializer, (String)"moduleDeserializer");
        this.linker = linker;
        this.fileIndex = fileIndex;
        this.file = file;
        this.fileReader = fileReader;
        SymbolTable symbolTable = this.linker.getSymbolTable();
        IrLibraryFileFromBytes irLibraryFileFromBytes = this.fileReader;
        IrFileSymbol irFileSymbol = this.file.getSymbol();
        List<Actual> list = fileProto.getActualList();
        KFunction kFunction = (KFunction)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(@NotNull IdSignature p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((FileDeserializationState)this.receiver).addIdSignature(p0);
            }

            @NotNull
            public final String getSignature() {
                return "addIdSignature(Lorg/jetbrains/kotlin/ir/util/IdSignature;)V";
            }

            @NotNull
            public final String getName() {
                return "addIdSignature";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(FileDeserializationState.class);
            }
        };
        KFunction kFunction2 = (KFunction)new Function2<IdSignature, IrSymbol, IrSymbol>((Object)this.linker){

            @NotNull
            public final IrSymbol invoke(@NotNull IdSignature p0, @NotNull IrSymbol p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((KotlinIrLinker)this.receiver).handleExpectActualMapping(p0, p1);
            }

            @NotNull
            public final String getSignature() {
                return "handleExpectActualMapping(Lorg/jetbrains/kotlin/ir/util/IdSignature;Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }

            @NotNull
            public final String getName() {
                return "handleExpectActualMapping";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinIrLinker.class);
            }
        };
        Function3<IrSymbolDeserializer, IrSymbol, IdSignature, IrSymbol> function3 = this.linker.getSymbolProcessor();
        IrInterningService irInterningService = this.linker.getInternationService();
        ReferenceSymbolTable referenceSymbolTable = symbolTable;
        IrLibraryFile irLibraryFile = irLibraryFileFromBytes;
        Intrinsics.checkNotNullExpressionValue(list, (String)"actualList");
        this.symbolDeserializer = new IrSymbolDeserializer(referenceSymbolTable, irLibraryFile, irFileSymbol, list, (Function1)kFunction, (Function2)kFunction2, irInterningService, function3, null, (Function2)new Function2<IdSignature, BinarySymbolData.SymbolKind, IrSymbol>(this, moduleDeserializer){
            final /* synthetic */ FileDeserializationState this$0;
            final /* synthetic */ IrModuleDeserializer $moduleDeserializer;
            {
                this.this$0 = $receiver;
                this.$moduleDeserializer = $moduleDeserializer;
                super(2);
            }

            @NotNull
            public final IrSymbol invoke(@NotNull IdSignature idSignature, @NotNull BinarySymbolData.SymbolKind symbolKind) {
                Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
                Intrinsics.checkNotNullParameter((Object)((Object)symbolKind), (String)"symbolKind");
                return this.this$0.getLinker().deserializeOrReturnUnboundIrSymbolIfPartialLinkageEnabled(idSignature, symbolKind, this.$moduleDeserializer);
            }
        }, 256, null);
        this.declarationDeserializer = new IrDeclarationDeserializer(this.linker.getBuiltIns(), this.linker.getSymbolTable(), this.linker.getSymbolTable().getIrFactory(), this.fileReader, this.file, allowErrorNodes, deserializeInlineFunctions, deserializeBodies, this.symbolDeserializer, this.linker.getFakeOverrideBuilder().getPlatformSpecificClassFilter(), this.linker.getFakeOverrideBuilder(), moduleDeserializer.getCompatibilityMode(), this.linker.getPartialLinkageSupport().isEnabled(), this.linker.getInternationService());
        this.fileDeserializer = new IrFileDeserializer(this.file, this.fileReader, fileProto, this.symbolDeserializer, this.declarationDeserializer);
        this.reachableTopLevels = new LinkedHashSet();
        List<Long> list2 = fileProto.getExplicitlyExportedToCompilerList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"fileProto.explicitlyExportedToCompilerList");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Long it = (Long)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            long symbolData = this.symbolDeserializer.parseSymbolData-9x8F8T0(it);
            IdSignature sig = this.symbolDeserializer.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(symbolData));
            boolean bl3 = bl = !sig.isPackageSignature();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.addIdSignature(sig.topLevelSignature());
        }
    }

    @NotNull
    public final KotlinIrLinker getLinker() {
        return this.linker;
    }

    public final int getFileIndex() {
        return this.fileIndex;
    }

    @NotNull
    public final org.jetbrains.kotlin.ir.declarations.IrFile getFile() {
        return this.file;
    }

    @NotNull
    public final IrLibraryFileFromBytes getFileReader() {
        return this.fileReader;
    }

    @NotNull
    public final IrSymbolDeserializer getSymbolDeserializer() {
        return this.symbolDeserializer;
    }

    @NotNull
    public final IrDeclarationDeserializer getDeclarationDeserializer() {
        return this.declarationDeserializer;
    }

    @NotNull
    public final IrFileDeserializer getFileDeserializer() {
        return this.fileDeserializer;
    }

    public final void addIdSignature(@NotNull IdSignature key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.reachableTopLevels.add(key);
    }

    public final void enqueueAllDeclarations() {
        this.reachableTopLevels.addAll((Collection<IdSignature>)this.fileDeserializer.getReversedSignatureIndex().keySet());
    }

    public final void deserializeAllFileReachableTopLevel() {
        while (!((Collection)this.reachableTopLevels).isEmpty()) {
            IdSignature reachableKey = (IdSignature)CollectionsKt.first((Iterable)this.reachableTopLevels);
            IrSymbol existedSymbol = this.symbolDeserializer.getDeserializedSymbols().get(reachableKey);
            if (existedSymbol == null || !existedSymbol.isBound()) {
                this.fileDeserializer.deserializeDeclaration(reachableKey);
            }
            this.reachableTopLevels.remove(reachableKey);
        }
    }
}

