/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.linkage.partial;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.linkage.partial.PartialLinkageLogLevel;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageLogger;", "", "irLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "logLevel", "Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageLogLevel;", "(Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageLogLevel;)V", "irLoggerSeverity", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger$Severity;", "log", "", "message", "", "location", "Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageLogger$Location;", "Location", "ir.tree"})
public final class PartialLinkageLogger {
    @NotNull
    private final IrMessageLogger irLogger;
    @NotNull
    private final IrMessageLogger.Severity irLoggerSeverity;

    public PartialLinkageLogger(@NotNull IrMessageLogger irLogger, @NotNull PartialLinkageLogLevel logLevel) {
        IrMessageLogger.Severity severity;
        Intrinsics.checkNotNullParameter((Object)irLogger, (String)"irLogger");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        this.irLogger = irLogger;
        switch (WhenMappings.$EnumSwitchMapping$0[logLevel.ordinal()]) {
            case 1: {
                severity = IrMessageLogger.Severity.INFO;
                break;
            }
            case 2: {
                severity = IrMessageLogger.Severity.WARNING;
                break;
            }
            case 3: {
                severity = IrMessageLogger.Severity.ERROR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.irLoggerSeverity = severity;
    }

    public final void log(@NotNull String message, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        String string = location.render().append(": ").append(message).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"location.render().append\u2026ppend(message).toString()");
        this.irLogger.report(this.irLoggerSeverity, string, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageLogger$Location;", "", "moduleName", "", "filePath", "lineNumber", "", "columnNumber", "(Ljava/lang/String;Ljava/lang/String;II)V", "getColumnNumber", "()I", "getFilePath", "()Ljava/lang/String;", "getLineNumber", "getModuleName", "render", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toString", "ir.tree"})
    public static final class Location {
        @NotNull
        private final String moduleName;
        @NotNull
        private final String filePath;
        private final int lineNumber;
        private final int columnNumber;

        public Location(@NotNull String moduleName, @NotNull String filePath, int lineNumber, int columnNumber) {
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.moduleName = moduleName;
            this.filePath = filePath;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public final int getColumnNumber() {
            return this.columnNumber;
        }

        @NotNull
        public final StringBuilder render() {
            StringBuilder stringBuilder;
            StringBuilder $this$render_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$render_u24lambda_u240.append(this.moduleName);
            if (((CharSequence)this.filePath).length() > 0) {
                $this$render_u24lambda_u240.append(" @ ").append(this.filePath);
                if (this.lineNumber != -1 && this.columnNumber != -1) {
                    $this$render_u24lambda_u240.append(':').append(this.lineNumber).append(':').append(this.columnNumber);
                }
            }
            return stringBuilder;
        }

        @NotNull
        public String toString() {
            String string = this.render().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render().toString()");
            return string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PartialLinkageLogLevel.values().length];
            try {
                nArray[PartialLinkageLogLevel.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PartialLinkageLogLevel.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PartialLinkageLogLevel.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

