/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.InstructionKt;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.builtins.IrBuiltInsMapGeneratedKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterAssertionError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterException;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicEvaluator;
import org.jetbrains.kotlin.ir.interpreter.proxy.ProxyKt;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u001e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J,\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J\u001e\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J\u001e\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010-\u001a\u000200H\u0016J,\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u0017\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\n\u00104\u001a\u0006\u0012\u0002\b\u000305H\u0016J\u0016\u00106\u001a\u00020\u001e*\u0004\u0018\u0001022\u0006\u00107\u001a\u00020\u001eH\u0002J$\u00108\u001a\u00020\u0016*\u0004\u0018\u0001092\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u000e\u0010:\u001a\u0004\u0018\u00010;*\u00020\u0018H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor;", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;)V", "bodyMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getEnvironment", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getInterpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "calculateBuiltIns", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "args", "", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "calculateRangeTo", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "handleIntrinsicMethods", "", "interceptCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "defaultAction", "Lkotlin/Function0;", "interceptConstructor", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "interceptEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "interceptGetObjectValue", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "interceptJavaStaticField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "interceptProxy", "", "valueArguments", "expectedResultClass", "Ljava/lang/Class;", "getType", "defaultType", "invokeMethod", "Ljava/lang/invoke/MethodHandle;", "trySubstituteFunctionBody", "Lorg/jetbrains/kotlin/ir/IrElement;", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nCallInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallInterceptor.kt\norg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor\n+ 2 ExceptionUtils.kt\norg/jetbrains/kotlin/ir/interpreter/exceptions/ExceptionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,226:1\n20#2,2:227\n20#2,2:254\n24#2,8:256\n24#2,8:270\n618#3,12:229\n1855#3,2:264\n1549#3:266\n1620#3,3:267\n1549#3:278\n1620#3,3:279\n1549#3:282\n1620#3,3:283\n1864#3,3:286\n1#4:241\n346#5,12:242\n*S KotlinDebug\n*F\n+ 1 CallInterceptor.kt\norg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor\n*L\n88#1:227,2\n133#1:254,2\n135#1:256,8\n165#1:270,8\n93#1:229,12\n143#1:264,2\n154#1:266\n154#1:267,3\n193#1:278\n193#1:279,3\n195#1:282\n195#1:283,3\n196#1:286,3\n117#1:242,12\n*E\n"})
public final class DefaultCallInterceptor
implements CallInterceptor {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrInterpreterEnvironment environment;
    @NotNull
    private final CallStack callStack;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Map<IdSignature, IrBody> bodyMap;

    public DefaultCallInterceptor(@NotNull IrInterpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        this.interpreter = interpreter;
        this.environment = this.getInterpreter().getEnvironment$ir_interpreter();
        this.callStack = this.getEnvironment().getCallStack$ir_interpreter();
        this.irBuiltIns = this.getEnvironment().getIrBuiltIns();
        this.bodyMap = this.getInterpreter().getBodyMap$ir_interpreter();
    }

    @Override
    @NotNull
    public IrInterpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    @NotNull
    public IrInterpreterEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @Override
    @Nullable
    public Object interceptProxy(@NotNull IrFunction irFunction, @NotNull List<? extends State> valueArguments, @NotNull Class<?> expectedResultClass) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter(valueArguments, (String)"valueArguments");
        Intrinsics.checkNotNullParameter(expectedResultClass, (String)"expectedResultClass");
        IrCall irCall = IrTreeBuildUtilsKt.createCall$default(irFunction, null, 1, null);
        return ProxyKt.wrap(this.getInterpreter().withNewCallStack$ir_interpreter(irCall, (Function1<? super IrInterpreter, ? extends Object>)((Function1)new Function1<IrInterpreter, Unit>(irCall, valueArguments){
            final /* synthetic */ IrCall $irCall;
            final /* synthetic */ List<State> $valueArguments;
            {
                this.$irCall = $irCall;
                this.$valueArguments = $valueArguments;
                super(1);
            }

            public final void invoke(@NotNull IrInterpreter $this$withNewCallStack) {
                Intrinsics.checkNotNullParameter((Object)$this$withNewCallStack, (String)"$this$withNewCallStack");
                InstructionKt.pushSimpleInstruction($this$withNewCallStack.getEnvironment$ir_interpreter().getCallStack$ir_interpreter(), this.$irCall);
                Iterable $this$forEach$iv = this.$valueArguments;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    State it = (State)element$iv;
                    boolean bl = false;
                    $this$withNewCallStack.getEnvironment$ir_interpreter().getCallStack$ir_interpreter().pushState(it);
                }
            }
        })), (CallInterceptor)this, false, expectedResultClass);
    }

    @Override
    public void interceptCall(@NotNull IrCall call, @NotNull IrFunction irFunction, @NotNull List<? extends State> args, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        boolean isInlineOnly = IrUtilsKt.hasAnnotation((IrAnnotationContainer)irFunction, new FqName("kotlin.internal.InlineOnly"));
        boolean isSyntheticDefault = Intrinsics.areEqual((Object)irFunction.getOrigin(), (Object)IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE);
        State receiver = irFunction.getDispatchReceiverParameter() != null ? args.get(0) : null;
        if (receiver instanceof Wrapper && !isInlineOnly && !isSyntheticDefault) {
            this.invokeMethod(((Wrapper)receiver).getMethod(irFunction), irFunction, args);
        } else if (Wrapper.Companion.mustBeHandledWithWrapper(irFunction)) {
            this.invokeMethod(Wrapper.Companion.getStaticMethod(irFunction), irFunction, args);
        } else {
            if (this.handleIntrinsicMethods(irFunction)) {
                return;
            }
            if (StateKt.mustBeHandledAsReflection(receiver, call)) {
                this.invokeMethod(Wrapper.Companion.getReflectionMethod(irFunction), irFunction, args);
            } else if (receiver instanceof Primitive) {
                this.calculateBuiltIns(irFunction, args);
            } else if (irFunction.getBody() == null && UtilsKt.isAccessorOfPropertyWithBackingField(irFunction)) {
                InstructionKt.pushCompoundInstruction(this.callStack, IrTreeBuildUtilsKt.createGetField(irFunction));
            } else if (irFunction.getBody() == null) {
                IrElement irElement = this.trySubstituteFunctionBody(irFunction);
                if (irElement == null) {
                    this.calculateBuiltIns(irFunction, args);
                    irElement = Unit.INSTANCE;
                }
            } else {
                defaultAction.invoke();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void interceptConstructor(@NotNull IrFunctionAccessExpression constructorCall, @NotNull List<? extends State> args, @NotNull Function0<Unit> defaultAction) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        Intrinsics.checkNotNullParameter((Object)constructorCall, (String)"constructorCall");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
                        receiver = this.callStack.loadState(UtilsKt.getThisReceiver(constructorCall));
                        irConstructor = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
                        irClass = IrUtilsKt.getParentAsClass(irConstructor);
                        if (!Wrapper.Companion.mustBeHandledWithWrapper(irClass)) break block10;
                        this.invokeMethod(Wrapper.Companion.getConstructorMethod(irConstructor), irConstructor, args);
                        if (UtilsKt.isSubclassOfThrowable(irClass)) {
                            Intrinsics.checkNotNull((Object)receiver, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.ExceptionState");
                            v0 = (ExceptionState)receiver;
                            v1 = this.callStack.popState();
                            Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Wrapper");
                            v0.copyFieldsFrom((Wrapper)v1);
                        } else if (constructorCall instanceof IrConstructorCall) {
                            this.callStack.rewriteState(UtilsKt.getThisReceiver(constructorCall), this.callStack.popState());
                        } else {
                            Intrinsics.checkNotNull((Object)receiver, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
                            v2 = (Complex)receiver;
                            v3 = this.callStack.popState();
                            Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Wrapper");
                            v2.setSuperWrapperClass((Wrapper)v3);
                        }
                        break block11;
                    }
                    if (!IrTypePredicatesKt.isArray(IrUtilsKt.getDefaultType(irClass)) && !UtilsKt.isPrimitiveArray(IrUtilsKt.getDefaultType(irClass))) break block12;
                    value$iv = this.handleIntrinsicMethods(irConstructor);
                    $i$f$verify = false;
                    if (!value$iv) {
                        $i$a$-verify-DefaultCallInterceptor$interceptConstructor$1 = false;
                        var17_14 = ("Unsupported intrinsic constructor: " + RenderIrElementKt.render(irConstructor)).toString();
                        throw new InterpreterAssertionError(var17_14);
                    }
                    break block11;
                }
                if (!IrTypePredicatesKt.isUnsignedType$default(IrUtilsKt.getDefaultType(irClass), false, 1, null)) break block13;
                $this$single$iv = irClass.getDeclarations();
                $i$f$single = false;
                single$iv = null;
                found$iv = false;
                for (T element$iv : $this$single$iv) {
                    it = (IrDeclaration)element$iv;
                    $i$a$-single-DefaultCallInterceptor$interceptConstructor$propertySymbol$1 = false;
                    if (!(it instanceof IrProperty)) ** GOTO lbl-1000
                    v4 /* !! */  = ((IrProperty)it).getGetter();
                    v5 = v4 /* !! */  != null && (v4 /* !! */  = v4 /* !! */ .getReturnType()) != null ? IrTypePredicatesKt.isPrimitiveType$default((IrType)v4 /* !! */ , false, 1, null) : false;
                    if (v5) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    if (!v6) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                propertySymbol = ((IrDeclaration)single$iv).getSymbol();
                $i$f$single = var8_10 = receiver;
                var16_22 = this.callStack;
                $i$a$-apply-DefaultCallInterceptor$interceptConstructor$2 = false;
                $this$interceptConstructor_u24lambda_u242.setField(propertySymbol, (State)CollectionsKt.single(args));
                var16_22.pushState(var8_10);
                break block11;
            }
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptGetObjectValue(@NotNull IrGetObjectValue expression, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        IrClass objectClass = (IrClass)expression.getSymbol().getOwner();
        if (Wrapper.Companion.mustBeHandledWithWrapper(objectClass)) {
            Wrapper result2 = Wrapper.Companion.getCompanionObject(objectClass, this.getEnvironment());
            this.getEnvironment().getMapOfObjects$ir_interpreter().put(expression.getSymbol(), result2);
            this.callStack.pushState(result2);
        } else {
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptEnumEntry(@NotNull IrEnumEntry enumEntry, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        IrClass enumClass = IrUtilsKt.getParentAsClass((IrDeclaration)enumEntry.getSymbol().getOwner());
        if (Wrapper.Companion.mustBeHandledWithWrapper(enumClass)) {
            State enumEntryName = this.getEnvironment().convertToState$ir_interpreter(enumEntry.getName().asString(), this.getEnvironment().getIrBuiltIns().getStringType());
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(enumClass);
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"valueOf")) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction valueOfFun = single$iv;
            this.invokeMethod(Wrapper.Companion.getEnumEntry(enumClass), valueOfFun, CollectionsKt.listOf((Object)enumEntryName));
            Map<IrSymbol, Complex> map = this.getEnvironment().getMapOfEnums$ir_interpreter();
            IrEnumEntrySymbol irEnumEntrySymbol = enumEntry.getSymbol();
            State state = this.callStack.popState();
            Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
            Complex complex = (Complex)state;
            map.put(irEnumEntrySymbol, complex);
        } else {
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptJavaStaticField(@NotNull IrGetField expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrField field2 = (IrField)expression.getSymbol().getOwner();
        ExceptionUtilsKt.verify(Intrinsics.areEqual((Object)field2.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) && field2.isStatic());
        IrExpressionBody irExpressionBody = field2.getInitializer();
        ExceptionUtilsKt.verify(!((irExpressionBody != null ? irExpressionBody.getExpression() : null) instanceof IrConst));
        this.callStack.pushState(this.getEnvironment().convertToState$ir_interpreter(Wrapper.Companion.getStaticGetter(field2).invokeWithArguments(new Object[0]), field2.getType()));
    }

    private final void invokeMethod(MethodHandle $this$invokeMethod, IrFunction irFunction, List<? extends State> args) {
        if ($this$invokeMethod == null) {
            boolean value$iv = this.handleIntrinsicMethods(irFunction);
            boolean $i$f$verify = false;
            if (!value$iv) {
                boolean bl = false;
                String string = ("Unsupported intrinsic function: " + RenderIrElementKt.render(irFunction)).toString();
                throw new InterpreterAssertionError(string);
            }
            return;
        }
        CallInterceptor callInterceptor = this;
        MethodType methodType = $this$invokeMethod.type();
        Intrinsics.checkNotNullExpressionValue((Object)methodType, (String)"this.type()");
        List<Object> argsForMethodInvocation = UtilsKt.getArgsForMethodInvocation(irFunction, callInterceptor, methodType, args);
        IrInterpreterEnvironment environment$iv = this.getEnvironment();
        boolean $i$f$withExceptionHandler = false;
        try {
            boolean bl = false;
            Object result2 = $this$invokeMethod.invokeWithArguments(argsForMethodInvocation);
            this.callStack.pushState(this.getEnvironment().convertToState$ir_interpreter(result2, this.getType(result2, irFunction.getReturnType())));
        }
        catch (InterpreterException e$iv) {
            throw e$iv;
        }
        catch (Throwable e$iv) {
            ExceptionUtilsKt.handleUserException(e$iv, environment$iv);
        }
    }

    private final boolean handleIntrinsicMethods(IrFunction irFunction) {
        List<Instruction> list = IntrinsicEvaluator.INSTANCE.unwindInstructions(irFunction, this.getEnvironment());
        if (list == null) {
            return false;
        }
        List<Instruction> instructions = list;
        Iterable $this$forEach$iv = instructions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Instruction it = (Instruction)element$iv;
            boolean bl = false;
            this.callStack.pushInstruction(it);
        }
        return true;
    }

    private final void calculateBuiltIns(IrFunction irFunction, List<? extends State> args) {
        IrType it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        IrSimpleFunction irSimpleFunction = irFunction instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction : null;
        IrPropertySymbol property = irSimpleFunction != null ? irSimpleFunction.getCorrespondingPropertySymbol() : null;
        String string = property == null ? irFunction.getName().asString() : ((IrProperty)property.getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (val property = (ir\u2026name.asString()\n        }");
        String methodName = string;
        IrAnnotationContainer irAnnotationContainer = irFunction.getDispatchReceiverParameter();
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            IrValueParameter irValueParameter = irFunction.getExtensionReceiverParameter();
            irAnnotationContainer = irValueParameter != null ? irValueParameter.getType() : null;
        }
        IrAnnotationContainer receiverType = irAnnotationContainer;
        Iterable iterable = irFunction.getValueParameters();
        Collection collection = CollectionsKt.listOfNotNull((Object)receiverType);
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getType());
        }
        $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getEnvironment().getConfiguration().getTreatFloatInSpecialWay() && IrTypePredicatesKt.isFloat(IrTypesKt.makeNotNull(it)) ? (IrTypeUtilsKt.isNullable(it) ? IrTypesKt.makeNullable(this.getIrBuiltIns().getDoubleType()) : this.getIrBuiltIns().getDoubleType()) : it);
        }
        List argsType = (List)destination$iv$iv;
        List argsValues = ProxyKt.wrap$default(args, (CallInterceptor)this, irFunction, null, 4, null);
        IrInterpreterEnvironment environment$iv = this.getEnvironment();
        boolean $i$f$withExceptionHandler = false;
        try {
            Object object;
            boolean bl = false;
            switch (argsType.size()) {
                case 1: {
                    if (Intrinsics.areEqual((Object)methodName, (Object)"toString") && this.getEnvironment().getConfiguration().getTreatFloatInSpecialWay() && (argsValues.get(0) instanceof Double || argsValues.get(0) instanceof Float)) {
                        object = UtilsKt.specialToStringForJs(argsValues.get(0));
                        break;
                    }
                    object = IrBuiltInsMapGeneratedKt.interpretUnaryFunction(methodName, UtilsKt.getOnlyName((IrType)argsType.get(0)), argsValues.get(0));
                    break;
                }
                case 2: {
                    if (Intrinsics.areEqual((Object)methodName, (Object)"rangeTo")) {
                        this.calculateRangeTo(irFunction.getReturnType(), args);
                        return;
                    }
                    object = IrBuiltInsMapGeneratedKt.interpretBinaryFunction(methodName, UtilsKt.getOnlyName((IrType)argsType.get(0)), UtilsKt.getOnlyName((IrType)argsType.get(1)), argsValues.get(0), argsValues.get(1));
                    break;
                }
                case 3: {
                    object = IrBuiltInsMapGeneratedKt.interpretTernaryFunction(methodName, UtilsKt.getOnlyName((IrType)argsType.get(0)), UtilsKt.getOnlyName((IrType)argsType.get(1)), UtilsKt.getOnlyName((IrType)argsType.get(2)), argsValues.get(0), argsValues.get(1), argsValues.get(2));
                    break;
                }
                default: {
                    throw new InterpreterError("Unsupported number of arguments for invocation as builtin function: " + methodName);
                }
            }
            Object result2 = object;
            this.callStack.pushState(this.getEnvironment().convertToState$ir_interpreter(result2, this.getType(result2, irFunction.getReturnType())));
        }
        catch (InterpreterException e$iv) {
            throw e$iv;
        }
        catch (Throwable e$iv) {
            ExceptionUtilsKt.handleUserException(e$iv, environment$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateRangeTo(IrType type2, List<? extends State> args) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(type2);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        IrConstructor constructor = (IrConstructor)SequencesKt.first(IrUtilsKt.getConstructors((IrClass)irClassSymbol.getOwner()));
        IrConstructorCall constructorCall = IrTreeBuildUtilsKt.createConstructorCall$default(constructor, null, 1, null);
        Iterable $this$map$iv = constructor.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        List constructorValueParameters = (List)destination$iv$iv;
        Iterable $this$map$iv2 = args;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            State bl = (State)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
            collection.add((Primitive)it);
        }
        List primitiveValueParameters = (List)destination$iv$iv2;
        Iterable $this$forEachIndexed$iv = primitiveValueParameters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void primitive;
            int n;
            Object item$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (Primitive)item$iv;
            int index = n;
            boolean bl = false;
            constructorCall.putValueArgument(index, IrTreeBuildUtilsKt.toIrConst$default(primitive.getValue(), ((IrValueParameter)((IrValueParameterSymbol)constructorValueParameters.get(index)).getOwner()).getType(), 0, 0, 6, null));
        }
        InstructionKt.pushCompoundInstruction(this.callStack, constructorCall);
    }

    private final IrType getType(Object $this$getType, IrType defaultType) {
        Object object = $this$getType;
        return object instanceof Boolean ? this.getIrBuiltIns().getBooleanType() : (object instanceof Character ? this.getIrBuiltIns().getCharType() : (object instanceof Byte ? this.getIrBuiltIns().getByteType() : (object instanceof Short ? this.getIrBuiltIns().getShortType() : (object instanceof Integer ? this.getIrBuiltIns().getIntType() : (object instanceof Long ? this.getIrBuiltIns().getLongType() : (object instanceof String ? this.getIrBuiltIns().getStringType() : (object instanceof Float ? this.getIrBuiltIns().getFloatType() : (object instanceof Double ? this.getIrBuiltIns().getDoubleType() : (object == null ? this.getIrBuiltIns().getNothingNType() : defaultType)))))))));
    }

    private final IrElement trySubstituteFunctionBody(IrFunction $this$trySubstituteFunctionBody) {
        IdSignature idSignature = $this$trySubstituteFunctionBody.getSymbol().getSignature();
        if (idSignature == null) {
            return null;
        }
        IdSignature signature = idSignature;
        IrBody irBody = this.bodyMap.get(signature);
        if (irBody == null) {
            return null;
        }
        $this$trySubstituteFunctionBody.setBody(irBody);
        InstructionKt.pushCompoundInstruction(this.callStack, $this$trySubstituteFunctionBody);
        return $this$trySubstituteFunctionBody.getBody();
    }
}

