/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.checker.IrCompileTimeChecker;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012 \b\u0002\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000b\u0012 \b\u0002\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020$H\u0016J\"\u0010%\u001a\u00020\u0011*\u00020\u001a2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010'\u001a\u00020(H\u0002J\u0014\u0010)\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0002J\u0014\u0010,\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010-\u001a\u00020\u0011H\u0002J\u0014\u0010.\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010/\u001a\u00020\u001aH\u0002J\u0014\u00100\u001a\u00020\u001a*\u00020\u001a2\u0006\u00101\u001a\u00020+H\u0002J\f\u00102\u001a\u000203*\u000203H\u0002J\u0014\u00104\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010/\u001a\u00020\u001aH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/IrConstTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "mode", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "evaluatedConstTracker", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "onWarning", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/expressions/IrErrorExpression;", "", "onError", "suppressExceptions", "", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function3;Z)V", "transformAnnotation", "annotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "transformAnnotations", "annotationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "canBeInterpreted", "containingDeclaration", "configuration", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;", "convertToConstIfPossible", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "interpret", "failAsError", "reportIfError", "original", "transformSingleArg", "expectedType", "transformVarArg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "warningIfError", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrConstTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConstTransformer.kt\norg/jetbrains/kotlin/ir/interpreter/checker/IrConstTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1855#2,2:211\n1855#2,2:213\n1855#2,2:215\n*S KotlinDebug\n*F\n+ 1 IrConstTransformer.kt\norg/jetbrains/kotlin/ir/interpreter/checker/IrConstTransformer\n*L\n152#1:211,2\n165#1:213,2\n185#1:215,2\n*E\n"})
public final class IrConstTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final EvaluationMode mode;
    @Nullable
    private final EvaluatedConstTracker evaluatedConstTracker;
    @NotNull
    private final Function3<IrFile, IrElement, IrErrorExpression, Unit> onWarning;
    @NotNull
    private final Function3<IrFile, IrElement, IrErrorExpression, Unit> onError;
    private final boolean suppressExceptions;

    public IrConstTransformer(@NotNull IrInterpreter interpreter, @NotNull IrFile irFile, @NotNull EvaluationMode mode, @Nullable EvaluatedConstTracker evaluatedConstTracker, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onWarning, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onError, boolean suppressExceptions) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter(onWarning, (String)"onWarning");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.interpreter = interpreter;
        this.irFile = irFile;
        this.mode = mode;
        this.evaluatedConstTracker = evaluatedConstTracker;
        this.onWarning = onWarning;
        this.onError = onError;
        this.suppressExceptions = suppressExceptions;
    }

    public /* synthetic */ IrConstTransformer(IrInterpreter irInterpreter, IrFile irFile, EvaluationMode evaluationMode, EvaluatedConstTracker evaluatedConstTracker, Function3 function3, Function3 function32, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            evaluatedConstTracker = null;
        }
        if ((n & 0x10) != 0) {
            function3 = 1.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            function32 = 2.INSTANCE;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        this(irInterpreter, irFile, evaluationMode, evaluatedConstTracker, (Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit>)function3, (Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit>)function32, bl);
    }

    private final IrExpression warningIfError(IrExpression $this$warningIfError, IrExpression original) {
        if ($this$warningIfError instanceof IrErrorExpression) {
            this.onWarning.invoke((Object)this.irFile, (Object)original, (Object)$this$warningIfError);
            return original;
        }
        return $this$warningIfError;
    }

    private final IrExpression reportIfError(IrExpression $this$reportIfError, IrExpression original) {
        if ($this$reportIfError instanceof IrErrorExpression) {
            this.onError.invoke((Object)this.irFile, (Object)original, (Object)$this$reportIfError);
            return WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()] == 1 ? (IrExpression)IrConstImpl.Companion.constNull($this$reportIfError.getStartOffset(), $this$reportIfError.getEndOffset(), $this$reportIfError.getType()) : original;
        }
        return $this$reportIfError;
    }

    private final boolean canBeInterpreted(IrExpression $this$canBeInterpreted, IrElement containingDeclaration, IrInterpreterConfiguration configuration) {
        boolean bl;
        try {
            bl = (Boolean)$this$canBeInterpreted.accept(new IrCompileTimeChecker(containingDeclaration, this.mode, configuration), null);
        }
        catch (Throwable e) {
            if (this.suppressExceptions) {
                return false;
            }
            throw new AssertionError("Error occurred while optimizing an expression:\n" + DumpIrTreeKt.dump$default($this$canBeInterpreted, false, false, 3, null), e);
        }
        return bl;
    }

    static /* synthetic */ boolean canBeInterpreted$default(IrConstTransformer irConstTransformer, IrExpression irExpression, IrElement irElement, IrInterpreterConfiguration irInterpreterConfiguration, int n, Object object) {
        if ((n & 1) != 0) {
            irElement = null;
        }
        if ((n & 2) != 0) {
            irInterpreterConfiguration = irConstTransformer.interpreter.getEnvironment$ir_interpreter().getConfiguration();
        }
        return irConstTransformer.canBeInterpreted(irExpression, irElement, irInterpreterConfiguration);
    }

    private final IrExpression interpret(IrExpression $this$interpret, boolean failAsError) {
        IrExpression result2;
        block5: {
            ConstantValue<?> constantValue;
            IrExpression irExpression;
            try {
                irExpression = this.interpreter.interpret($this$interpret, this.irFile);
            }
            catch (Throwable e) {
                if (this.suppressExceptions) {
                    return $this$interpret;
                }
                throw new AssertionError("Error occurred while optimizing an expression:\n" + DumpIrTreeKt.dump$default($this$interpret, false, false, 3, null), e);
            }
            result2 = irExpression;
            EvaluatedConstTracker evaluatedConstTracker = this.evaluatedConstTracker;
            if (evaluatedConstTracker == null) break block5;
            int n = result2.getStartOffset();
            int n2 = result2.getEndOffset();
            String string = this.irFile.getFqName().child(Name.identifier((String)IrDeclarationsKt.getName(this.irFile))).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"irFile.fqName.child(Name\u2026(irFile.name)).asString()");
            if (result2 instanceof IrErrorExpression) {
                constantValue = (ConstantValue<?>)ErrorValue.Companion.create(((IrErrorExpression)result2).getDescription());
            } else {
                Intrinsics.checkNotNull((Object)result2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
                constantValue = IrTreeBuildUtilsKt.toConstantValue((IrConst)result2);
            }
            evaluatedConstTracker.save(n, n2, string, constantValue);
        }
        return failAsError ? this.reportIfError(result2, $this$interpret) : this.warningIfError(result2, $this$interpret);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (IrConstTransformer.canBeInterpreted$default(this, expression, null, null, 3, null)) {
            return this.interpret(expression, false);
        }
        return super.visitCall(expression);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration) {
        boolean isConst;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.transformAnnotations(declaration);
        IrExpressionBody initializer2 = declaration.getInitializer();
        IrElementBase irElementBase = initializer2;
        if (irElementBase == null || (irElementBase = irElementBase.getExpression()) == null) {
            return declaration;
        }
        IrElementBase expression = irElementBase;
        Object object = declaration.getCorrespondingPropertySymbol();
        boolean bl = object != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isConst() : (isConst = false);
        if (!isConst) {
            return super.visitField(declaration);
        }
        if (this.canBeInterpreted((IrExpression)expression, declaration, IrInterpreterConfiguration.copy$default(this.interpreter.getEnvironment$ir_interpreter().getConfiguration(), 0, 0, false, false, false, false, 31, null))) {
            initializer2.setExpression(this.interpret((IrExpression)expression, true));
        }
        return super.visitField(declaration);
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression) {
        IrConst foldedConst;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        List folded = new ArrayList();
        List buildersList = new ArrayList();
        for (IrExpression irExpression : expression.getArguments()) {
            IrExpression last = (IrExpression)CollectionsKt.lastOrNull((List)folded);
            if (!IrConstTransformer.canBeInterpreted$default(this, IrConstTransformer.visitStringConcatenation$wrapInStringConcat(irExpression, expression), null, null, 3, null)) {
                ((Collection)folded).add(irExpression);
                buildersList.add(new StringBuilder());
                continue;
            }
            if (last == null || !IrConstTransformer.canBeInterpreted$default(this, IrConstTransformer.visitStringConcatenation$wrapInStringConcat(last, expression), null, null, 3, null)) {
                IrExpression result2 = IrConstTransformer.visitStringConcatenation$wrapInToStringConcatAndInterpret(irExpression, this, expression);
                ((Collection)folded).add(result2);
                Object object = result2 instanceof IrConst ? (IrConst)result2 : null;
                if (object == null || (object = ((IrConst)object).getValue()) == null || (object = object.toString()) == null) {
                    object = "";
                }
                buildersList.add(new StringBuilder((String)object));
                continue;
            }
            IrExpression nextAsConst = IrConstTransformer.visitStringConcatenation$wrapInToStringConcatAndInterpret(irExpression, this, expression);
            if (!(nextAsConst instanceof IrConst)) {
                ((Collection)folded).add(irExpression);
                buildersList.add(new StringBuilder());
                continue;
            }
            folded.set(folded.size() - 1, IrConstImpl.Companion.string(Math.min(last.getStartOffset(), irExpression.getStartOffset()), Math.max(last.getEndOffset(), irExpression.getEndOffset()), expression.getType(), ""));
            ((StringBuilder)CollectionsKt.last((List)buildersList)).append(String.valueOf(((IrConst)nextAsConst).getValue()));
        }
        Object object = CollectionsKt.singleOrNull((List)folded);
        IrConst irConst = foldedConst = object instanceof IrConst ? (IrConst)object : null;
        if (foldedConst != null) {
            int n = expression.getStartOffset();
            int n2 = expression.getEndOffset();
            IrType irType = expression.getType();
            String string = ((StringBuilder)CollectionsKt.single((List)buildersList)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildersList.single().toString()");
            return IrConstImpl.Companion.string(n, n2, irType, string);
        }
        Iterable iterable = CollectionsKt.zip((Iterable)folded, (Iterable)buildersList);
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Object object2 = it.getFirst();
            IrConst irConst2 = object2 instanceof IrConst ? (IrConst)object2 : null;
            if (irConst2 == null) continue;
            String string = ((StringBuilder)it.getSecond()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.second.toString()");
            irConst2.setValue(string);
        }
        return new IrStringConcatenationImpl(expression.getStartOffset(), expression.getEndOffset(), expression.getType(), folded);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.transformAnnotations(declaration);
        return super.visitDeclaration(declaration);
    }

    private final void transformAnnotations(IrAnnotationContainer annotationContainer) {
        Iterable $this$forEach$iv = annotationContainer.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructorCall annotation = (IrConstructorCall)element$iv;
            boolean bl = false;
            this.transformAnnotation(annotation);
        }
    }

    private final void transformAnnotation(IrConstructorCall annotation) {
        int n = annotation.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            IrExpression arg;
            if (annotation.getValueArgument(i) == null) continue;
            if (arg instanceof IrVararg) {
                annotation.putValueArgument(i, this.transformVarArg((IrVararg)arg));
                continue;
            }
            annotation.putValueArgument(i, this.transformSingleArg(arg, ((IrConstructor)annotation.getSymbol().getOwner()).getValueParameters().get(i).getType()));
        }
    }

    private final IrVararg transformVarArg(IrVararg $this$transformVarArg) {
        if ($this$transformVarArg.getElements().isEmpty()) {
            return $this$transformVarArg;
        }
        IrVarargImpl newIrVararg = new IrVarargImpl($this$transformVarArg.getStartOffset(), $this$transformVarArg.getEndOffset(), $this$transformVarArg.getType(), $this$transformVarArg.getVarargElementType());
        for (IrVarargElement element : $this$transformVarArg.getElements()) {
            IrVarargElement arg;
            IrElementBase irElementBase = element instanceof IrSpreadElement ? (IrSpreadElement)element : null;
            IrVarargElement irVarargElement = irElementBase != null && (irElementBase = irElementBase.getExpression()) != null ? (IrVarargElement)((Object)irElementBase) : (arg = element);
            if (arg instanceof IrVararg) {
                Iterable $this$forEach$iv = this.transformVarArg((IrVararg)arg).getElements();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl = false;
                    IrExpressionsKt.addElement(newIrVararg, it);
                }
                continue;
            }
            if (arg instanceof IrExpression) {
                IrExpressionsKt.addElement(newIrVararg, this.transformSingleArg((IrExpression)arg, $this$transformVarArg.getVarargElementType()));
                continue;
            }
            IrExpressionsKt.addElement(newIrVararg, arg);
        }
        return newIrVararg;
    }

    private final IrExpression transformSingleArg(IrExpression $this$transformSingleArg, IrType expectedType) {
        if (IrConstTransformer.canBeInterpreted$default(this, $this$transformSingleArg, null, IrInterpreterConfiguration.copy$default(this.interpreter.getEnvironment$ir_interpreter().getConfiguration(), 0, 0, false, false, false, false, 31, null), 1, null)) {
            return this.convertToConstIfPossible(this.interpret($this$transformSingleArg, true), expectedType);
        }
        if ($this$transformSingleArg instanceof IrConstructorCall) {
            this.transformAnnotation((IrConstructorCall)$this$transformSingleArg);
        }
        return $this$transformSingleArg;
    }

    private final IrExpression convertToConstIfPossible(IrExpression $this$convertToConstIfPossible, IrType type2) {
        IrExpression irExpression;
        if (!($this$convertToConstIfPossible instanceof IrConst) || type2 instanceof IrErrorType) {
            irExpression = $this$convertToConstIfPossible;
        } else if (IrTypePredicatesKt.isArray(type2)) {
            Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.single(((IrSimpleType)type2).getArguments()));
            Intrinsics.checkNotNull((Object)irType);
            irExpression = this.convertToConstIfPossible($this$convertToConstIfPossible, irType);
        } else {
            irExpression = UtilsKt.isPrimitiveArray(type2) ? this.convertToConstIfPossible($this$convertToConstIfPossible, $this$convertToConstIfPossible.getType()) : (IrExpression)IrTreeBuildUtilsKt.toIrConst(((IrConst)$this$convertToConstIfPossible).getValue(), type2, $this$convertToConstIfPossible.getStartOffset(), $this$convertToConstIfPossible.getEndOffset());
        }
        return irExpression;
    }

    private static final IrExpression visitStringConcatenation$wrapInStringConcat(IrExpression $this$visitStringConcatenation_u24wrapInStringConcat, IrStringConcatenation $expression) {
        return new IrStringConcatenationImpl($this$visitStringConcatenation_u24wrapInStringConcat.getStartOffset(), $this$visitStringConcatenation_u24wrapInStringConcat.getEndOffset(), $expression.getType(), CollectionsKt.listOf((Object)$this$visitStringConcatenation_u24wrapInStringConcat));
    }

    private static final IrExpression visitStringConcatenation$wrapInToStringConcatAndInterpret(IrExpression $this$visitStringConcatenation_u24wrapInToStringConcatAndInterpret, IrConstTransformer this$0, IrStringConcatenation $expression) {
        return this$0.interpret(IrConstTransformer.visitStringConcatenation$wrapInStringConcat($this$visitStringConcatenation_u24wrapInToStringConcatAndInterpret, $expression), false);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EvaluationMode.values().length];
            try {
                nArray[EvaluationMode.ONLY_INTRINSIC_CONST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

