/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.unlinked;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.unlinked.ImplementedFakeOverrideCopier;
import org.jetbrains.kotlin.backend.common.serialization.unlinked.UnlinkedDeclarationsProcessor;
import org.jetbrains.kotlin.backend.common.serialization.unlinked.UnlinkedDeclarationsSupport;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrAnonymousInitializerSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapperPreservingSignatures;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 )2\u00020\u0001:\u0003)*+B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0006H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0019H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u001aH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0017*\u00020\u001bH\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u001dH\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010!\u001a\u00020\r*\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0002J \u0010%\u001a\u00020&*\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UnlinkedDeclarationsProcessor;", "", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unlinkedClassifiers", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "unlinkedMarkerTypeHandler", "Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UnlinkedDeclarationsSupport$UnlinkedMarkerTypeHandler;", "messageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Ljava/util/Set;Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UnlinkedDeclarationsSupport$UnlinkedMarkerTypeHandler;Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;)V", "addLinkageErrorIntoUnlinkedClasses", "", "reportWarning", "message", "", "location", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger$Location;", "signatureTransformer", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "usageTransformer", "isUnlinked", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isUnlinkedMarkerType", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "offset", "", "reportUnlinkedSymbolsWarning", "kind", "fqn", "Lorg/jetbrains/kotlin/name/FqName;", "throwLinkageError", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/IrElement;", "unlinkedSymbol", "Companion", "SignatureTransformer", "UsageTransformer", "ir.serialization.common"})
public final class UnlinkedDeclarationsProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final Set<IrClassifierSymbol> unlinkedClassifiers;
    @NotNull
    private final UnlinkedDeclarationsSupport.UnlinkedMarkerTypeHandler unlinkedMarkerTypeHandler;
    @NotNull
    private final IrMessageLogger messageLogger;
    @NotNull
    private static final Companion.errorOrigin.1 errorOrigin = new IrStatementOriginImpl(){};

    public UnlinkedDeclarationsProcessor(@NotNull IrBuiltIns builtIns, @NotNull Set<? extends IrClassifierSymbol> unlinkedClassifiers, @NotNull UnlinkedDeclarationsSupport.UnlinkedMarkerTypeHandler unlinkedMarkerTypeHandler, @NotNull IrMessageLogger messageLogger) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter(unlinkedClassifiers, (String)"unlinkedClassifiers");
        Intrinsics.checkNotNullParameter((Object)unlinkedMarkerTypeHandler, (String)"unlinkedMarkerTypeHandler");
        Intrinsics.checkNotNullParameter((Object)messageLogger, (String)"messageLogger");
        this.builtIns = builtIns;
        this.unlinkedClassifiers = unlinkedClassifiers;
        this.unlinkedMarkerTypeHandler = unlinkedMarkerTypeHandler;
        this.messageLogger = messageLogger;
    }

    /*
     * WARNING - void declaration
     */
    public final void addLinkageErrorIntoUnlinkedClasses() {
        for (IrClassifierSymbol u : this.unlinkedClassifiers) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            IrAnonymousInitializer irAnonymousInitializer;
            Object v0;
            IrDeclaration it;
            IrClass klass;
            block4: {
                if (!(u instanceof IrClassSymbol)) continue;
                klass = (IrClass)((IrClassSymbol)u).getOwner();
                Iterable $this$firstOrNull$iv = klass.getDeclarations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (IrDeclaration)element$iv;
                    boolean bl = false;
                    if (!(it instanceof IrAnonymousInitializer)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            if ((irAnonymousInitializer = (IrAnonymousInitializer)v0) == null) {
                Object element$iv;
                UnlinkedDeclarationsProcessor $this$addLinkageErrorIntoUnlinkedClasses_u24lambda_u242 = this;
                boolean bl = false;
                element$iv = IrFactory.DefaultImpls.createAnonymousInitializer$default($this$addLinkageErrorIntoUnlinkedClasses_u24lambda_u242.builtIns.getIrFactory(), klass.getStartOffset(), klass.getEndOffset(), IrDeclarationOrigin.DEFINED.INSTANCE, new IrAnonymousInitializerSymbolImpl(null, 1, null), false, 16, null);
                it = element$iv;
                boolean bl2 = false;
                ((IrAnonymousInitializer)it).setBody($this$addLinkageErrorIntoUnlinkedClasses_u24lambda_u242.builtIns.getIrFactory().createBlockBody(klass.getStartOffset(), klass.getEndOffset()));
                it.setParent(klass);
                klass.getDeclarations().add(it);
                irAnonymousInitializer = element$iv;
            }
            IrAnonymousInitializer anonInitializer = irAnonymousInitializer;
            anonInitializer.getBody().getStatements().clear();
            this.reportUnlinkedSymbolsWarning(klass, "Class", AdditionalIrUtilsKt.getFqNameForIrSerialization(klass));
            anonInitializer.getBody().getStatements().add(UnlinkedDeclarationsProcessor.throwLinkageError$default(this, klass, klass.getSymbol(), null, 2, null));
            Iterable iterable = klass.getSuperTypes();
            IrClass irClass = klass;
            boolean $i$f$filter = false;
            void $this$addLinkageErrorIntoUnlinkedClasses_u24lambda_u242 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrType it2 = (IrType)element$iv$iv;
                boolean bl = false;
                if (!(!this.isUnlinked(it2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            irClass.setSuperTypes((List)destination$iv$iv);
        }
    }

    private final IrMessageLogger.Location location(IrDeclaration $this$location) {
        IrFile irFile = IrUtilsKt.getFileOrNull($this$location);
        return irFile != null ? this.location(irFile, $this$location.getStartOffset()) : null;
    }

    private final IrMessageLogger.Location location(IrFile $this$location, int offset) {
        Name module = $this$location.getModule().getName();
        IrFileEntry fileEntry = $this$location.getFileEntry();
        String fileName = fileEntry.getName();
        int lineNumber = fileEntry.getLineNumber(offset) + 1;
        int columnNumber = fileEntry.getColumnNumber(offset) + 1;
        return new IrMessageLogger.Location(module + " @ " + fileName, lineNumber, columnNumber);
    }

    private final void reportUnlinkedSymbolsWarning(IrDeclaration $this$reportUnlinkedSymbolsWarning, String kind, FqName fqn) {
        this.reportWarning(kind + " declaration " + fqn.asString() + " contains unlinked symbols", this.location($this$reportUnlinkedSymbolsWarning));
    }

    private final void reportWarning(String message, IrMessageLogger.Location location) {
        this.messageLogger.report(IrMessageLogger.Severity.WARNING, message, location);
    }

    @NotNull
    public final IrElementTransformerVoid signatureTransformer() {
        return new SignatureTransformer();
    }

    private final boolean isUnlinked(IrSymbol $this$isUnlinked) {
        if (!$this$isUnlinked.isBound()) {
            return true;
        }
        IrSymbol irSymbol = $this$isUnlinked;
        if (irSymbol instanceof IrClassifierSymbol) {
            this.isUnlinked((IrClassifierSymbol)$this$isUnlinked);
        } else if (irSymbol instanceof IrPropertySymbol) {
            IrField irField;
            IrDeclarationBase it;
            IrSimpleFunction irSimpleFunction = ((IrProperty)((IrPropertySymbol)$this$isUnlinked).getOwner()).getGetter();
            if (irSimpleFunction != null) {
                it = irSimpleFunction;
                boolean bl = false;
                if (this.isUnlinked(((IrSimpleFunction)it).getSymbol())) {
                    return true;
                }
            }
            IrSimpleFunction irSimpleFunction2 = ((IrProperty)((IrPropertySymbol)$this$isUnlinked).getOwner()).getSetter();
            if (irSimpleFunction2 != null) {
                it = irSimpleFunction2;
                boolean bl = false;
                if (this.isUnlinked(((IrSimpleFunction)it).getSymbol())) {
                    return true;
                }
            }
            if ((irField = ((IrProperty)((IrPropertySymbol)$this$isUnlinked).getOwner()).getBackingField()) != null) {
                it = irField;
                boolean bl = false;
                return this.isUnlinked(((IrField)it).getSymbol());
            }
        } else if (irSymbol instanceof IrFunctionSymbol) {
            return this.isUnlinked((IrFunctionSymbol)$this$isUnlinked);
        }
        return false;
    }

    private final boolean isUnlinked(IrClassifierSymbol $this$isUnlinked) {
        return !$this$isUnlinked.isBound() || this.unlinkedClassifiers.contains($this$isUnlinked);
    }

    private final boolean isUnlinked(IrType $this$isUnlinked) {
        boolean bl;
        block5: {
            IrSimpleType irSimpleType = $this$isUnlinked instanceof IrSimpleType ? (IrSimpleType)$this$isUnlinked : null;
            if (irSimpleType == null) {
                return false;
            }
            IrSimpleType simpleType = irSimpleType;
            if (this.isUnlinked(simpleType.getClassifier())) {
                return true;
            }
            Iterable $this$any$iv = simpleType.getArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrTypeProjection && this.isUnlinked(((IrTypeProjection)it).getType()))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isUnlinked(IrFieldSymbol $this$isUnlinked) {
        return this.isUnlinkedMarkerType(((IrField)$this$isUnlinked.getOwner()).getType());
    }

    private final boolean isUnlinked(IrFunctionSymbol $this$isUnlinked) {
        boolean bl;
        block15: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            IrFunction function;
            block13: {
                function = $this$isUnlinked.getOwner();
                if (this.isUnlinkedMarkerType(function.getReturnType())) {
                    return true;
                }
                IrAnnotationContainer irAnnotationContainer = function.getDispatchReceiverParameter();
                boolean bl3 = irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? this.isUnlinkedMarkerType((IrType)irAnnotationContainer) : false;
                if (bl3) {
                    return true;
                }
                IrAnnotationContainer irAnnotationContainer2 = function.getExtensionReceiverParameter();
                boolean bl4 = irAnnotationContainer2 != null && (irAnnotationContainer2 = irAnnotationContainer2.getType()) != null ? this.isUnlinkedMarkerType((IrType)irAnnotationContainer2) : false;
                if (bl4) {
                    return true;
                }
                $this$any$iv = function.getValueParameters();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl5 = false;
                        if (!this.isUnlinkedMarkerType(it.getType())) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return true;
            }
            $this$any$iv = function.getTypeParameters();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl6;
                    block14: {
                        IrTypeParameter tp = (IrTypeParameter)element$iv;
                        boolean bl7 = false;
                        Iterable $this$any$iv2 = tp.getSuperTypes();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl6 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                IrType st = (IrType)element$iv2;
                                boolean bl8 = false;
                                if (!this.isUnlinkedMarkerType(st)) continue;
                                bl6 = true;
                                break block14;
                            }
                            bl6 = false;
                        }
                    }
                    if (!bl6) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isUnlinkedMarkerType(IrType $this$isUnlinkedMarkerType) {
        UnlinkedDeclarationsSupport.UnlinkedMarkerTypeHandler $this$isUnlinkedMarkerType_u24lambda_u2411 = this.unlinkedMarkerTypeHandler;
        boolean bl = false;
        return $this$isUnlinkedMarkerType_u24lambda_u2411.isUnlinkedMarkerType($this$isUnlinkedMarkerType);
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall throwLinkageError(IrElement $this$throwLinkageError, IrSymbol unlinkedSymbol, String message) {
        String string;
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append(message);
        Object object = unlinkedSymbol;
        if (object != null && (object = object.getSignature()) != null && (object = ((IdSignature)object).render()) != null) {
            void it;
            Object object2 = object;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            string2 = ' ' + (String)it;
            stringBuilder = stringBuilder2;
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        String messageLiteral = stringBuilder.append(string).toString();
        IrCallImpl irCall = new IrCallImpl($this$throwLinkageError.getStartOffset(), $this$throwLinkageError.getEndOffset(), this.builtIns.getNothingType(), this.builtIns.getLinkageErrorSymbol(), 0, 1, errorOrigin, null, 128, null);
        irCall.putValueArgument(0, IrConstImpl.Companion.string($this$throwLinkageError.getStartOffset(), $this$throwLinkageError.getEndOffset(), this.builtIns.getStringType(), messageLiteral));
        return irCall;
    }

    static /* synthetic */ IrCall throwLinkageError$default(UnlinkedDeclarationsProcessor unlinkedDeclarationsProcessor, IrElement irElement, IrSymbol irSymbol, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "Unlinked IR symbol";
        }
        return unlinkedDeclarationsProcessor.throwLinkageError(irElement, irSymbol, string);
    }

    @NotNull
    public final IrElementTransformerVoid usageTransformer() {
        return new UsageTransformer();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UnlinkedDeclarationsProcessor$Companion;", "", "()V", "errorOrigin", "org/jetbrains/kotlin/backend/common/serialization/unlinked/UnlinkedDeclarationsProcessor$Companion$errorOrigin$1", "Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UnlinkedDeclarationsProcessor$Companion$errorOrigin$1;", "ir.serialization.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\tH\u0002J\u001b\u0010\u0014\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u0016*\u0002H\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0018\u001a\u00020\t*\u00020\t2\u0006\u0010\u0019\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UnlinkedDeclarationsProcessor$SignatureTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UnlinkedDeclarationsProcessor;)V", "implementedFakeOverrideProperties", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lkotlin/collections/HashSet;", "isAccessorOfImplementedFakeOverrideProperty", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "visitField", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitFunction", "visitProperty", "fixUnlinkedTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "replaceIfUnimplementedFakeOverride", "T", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "transformBodyIfNecessary", "isImplementedFakeOverride", "removedUnlinkedTypes", "ir.serialization.common"})
    private final class SignatureTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final HashSet<IrProperty> implementedFakeOverrideProperties = new HashSet();

        private final boolean isAccessorOfImplementedFakeOverrideProperty(IrFunction $this$isAccessorOfImplementedFakeOverrideProperty) {
            Object object = $this$isAccessorOfImplementedFakeOverrideProperty instanceof IrSimpleFunction ? (IrSimpleFunction)$this$isAccessorOfImplementedFakeOverrideProperty : null;
            return CollectionsKt.contains((Iterable)this.implementedFakeOverrideProperties, object != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null ? (IrProperty)object.getOwner() : null);
        }

        @Override
        @NotNull
        public IrStatement visitProperty(@NotNull IrProperty declaration) {
            boolean isImplementedFakeOverride;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrProperty newProperty = (IrProperty)this.replaceIfUnimplementedFakeOverride((IrDeclaration)declaration);
            boolean bl = isImplementedFakeOverride = !Intrinsics.areEqual((Object)newProperty, (Object)declaration);
            if (isImplementedFakeOverride) {
                ((Collection)this.implementedFakeOverrideProperties).add(newProperty);
            }
            this.transformChildrenVoid(newProperty);
            if (isImplementedFakeOverride) {
                ((Collection)this.implementedFakeOverrideProperties).remove(newProperty);
            }
            return newProperty;
        }

        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrFunction newFunction = (IrFunction)this.replaceIfUnimplementedFakeOverride((IrDeclaration)declaration);
            Set<IrType> removedUnlinkedTypes = this.fixUnlinkedTypes(newFunction);
            boolean isImplementedFakeOverride = !Intrinsics.areEqual((Object)newFunction, (Object)declaration) || this.isAccessorOfImplementedFakeOverrideProperty(declaration);
            return this.transformBodyIfNecessary(newFunction, isImplementedFakeOverride, removedUnlinkedTypes);
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (UnlinkedDeclarationsProcessor.this.isUnlinked(declaration.getType())) {
                Object object = declaration.getCorrespondingPropertySymbol();
                if (object == null || (object = (IrProperty)object.getOwner()) == null || (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) == null) {
                    object = AdditionalIrUtilsKt.getFqNameForIrSerialization(declaration);
                }
                Object fqn = object;
                String kind = declaration.getCorrespondingPropertySymbol() != null ? "Property" : "Field";
                UnlinkedDeclarationsProcessor.this.reportUnlinkedSymbolsWarning(declaration, kind, (FqName)fqn);
                declaration.setType(UnlinkedDeclarationsProcessor.this.unlinkedMarkerTypeHandler.getUnlinkedMarkerType());
                declaration.setInitializer(null);
            } else {
                this.transformChildrenVoid(declaration);
            }
            return declaration;
        }

        /*
         * WARNING - void declaration
         */
        private final <T extends IrDeclaration> T replaceIfUnimplementedFakeOverride(T $this$replaceIfUnimplementedFakeOverride) {
            void typeRemapper$iv;
            void symbolRemapper$iv;
            void $this$deepCopyWithSymbols$iv$iv;
            if (!($this$replaceIfUnimplementedFakeOverride instanceof IrOverridableDeclaration) || !((IrOverridableDeclaration)$this$replaceIfUnimplementedFakeOverride).isFakeOverride() || ((IrOverridableDeclaration)$this$replaceIfUnimplementedFakeOverride).getModality() != Modality.ABSTRACT) {
                return $this$replaceIfUnimplementedFakeOverride;
            }
            IrClass clazz = IrUtilsKt.getParentAsClass($this$replaceIfUnimplementedFakeOverride);
            if (clazz.getModality() == Modality.ABSTRACT || clazz.getModality() == Modality.SEALED) {
                return $this$replaceIfUnimplementedFakeOverride;
            }
            IrOverridableDeclaration $this$deepCopyWithImplementedFakeOverrides$iv = (IrOverridableDeclaration)$this$replaceIfUnimplementedFakeOverride;
            boolean $i$f$deepCopyWithImplementedFakeOverrides = false;
            IrClass clazz$iv = IrUtilsKt.getParentAsClass($this$deepCopyWithImplementedFakeOverrides$iv);
            IrElement irElement = $this$deepCopyWithImplementedFakeOverrides$iv;
            DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapperPreservingSignatures();
            boolean $i$f$deepCopyWithSymbols = false;
            IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
            DeepCopyTypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
            TypeRemapper typeRemapper = typeRemapper$iv$iv;
            SymbolRemapper symbolRemapper = symbolRemapper$iv$iv;
            void var12_12 = $this$deepCopyWithSymbols$iv$iv;
            boolean bl = false;
            IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var12_12.transform(new ImplementedFakeOverrideCopier(clazz$iv, (SymbolRemapper)symbolRemapper$iv, (TypeRemapper)typeRemapper$iv), null), clazz$iv);
            if (irElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            }
            return (T)((IrOverridableDeclaration)((IrDeclaration)irElement2));
        }

        private final Set<IrType> fixUnlinkedTypes(IrFunction $this$fixUnlinkedTypes) {
            IrDeclarationBase it;
            Set set;
            UnlinkedDeclarationsProcessor unlinkedDeclarationsProcessor = UnlinkedDeclarationsProcessor.this;
            Set $this$fixUnlinkedTypes_u24lambda_u244 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            IrValueParameter irValueParameter = $this$fixUnlinkedTypes.getDispatchReceiverParameter();
            if (irValueParameter != null) {
                SignatureTransformer.fixUnlinkedTypes$lambda$4$fixType(irValueParameter, unlinkedDeclarationsProcessor, $this$fixUnlinkedTypes_u24lambda_u244);
            }
            IrValueParameter irValueParameter2 = $this$fixUnlinkedTypes.getExtensionReceiverParameter();
            if (irValueParameter2 != null) {
                SignatureTransformer.fixUnlinkedTypes$lambda$4$fixType(irValueParameter2, unlinkedDeclarationsProcessor, $this$fixUnlinkedTypes_u24lambda_u244);
            }
            Iterable $this$forEach$iv = $this$fixUnlinkedTypes.getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrValueParameter)element$iv;
                boolean bl2 = false;
                SignatureTransformer.fixUnlinkedTypes$lambda$4$fixType((IrValueParameter)it, unlinkedDeclarationsProcessor, $this$fixUnlinkedTypes_u24lambda_u244);
            }
            if (unlinkedDeclarationsProcessor.isUnlinked($this$fixUnlinkedTypes.getReturnType())) {
                ((Collection)$this$fixUnlinkedTypes_u24lambda_u244).add($this$fixUnlinkedTypes.getReturnType());
                $this$fixUnlinkedTypes.setReturnType(unlinkedDeclarationsProcessor.unlinkedMarkerTypeHandler.getUnlinkedMarkerType());
            }
            $this$forEach$iv = $this$fixUnlinkedTypes.getTypeParameters();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrType unlinkedSuperType;
                Object v2;
                block6: {
                    it = (IrTypeParameter)element$iv;
                    boolean bl3 = false;
                    Iterable $this$firstOrNull$iv = ((IrTypeParameter)it).getSuperTypes();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        IrType s = (IrType)element$iv2;
                        boolean bl4 = false;
                        if (!unlinkedDeclarationsProcessor.isUnlinked(s)) continue;
                        v2 = element$iv2;
                        break block6;
                    }
                    v2 = null;
                }
                if ((unlinkedSuperType = (IrType)v2) == null) continue;
                ((Collection)$this$fixUnlinkedTypes_u24lambda_u244).add(unlinkedSuperType);
                ((IrTypeParameter)it).setSuperTypes(CollectionsKt.listOf((Object)unlinkedDeclarationsProcessor.unlinkedMarkerTypeHandler.getUnlinkedMarkerType()));
            }
            return SetsKt.build((Set)set);
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction transformBodyIfNecessary(IrFunction $this$transformBodyIfNecessary, boolean isImplementedFakeOverride, Set<? extends IrType> removedUnlinkedTypes) {
            block6: {
                void $this$forEach$iv;
                String string;
                String string2;
                Unit unit;
                StringBuilder $this$transformBodyIfNecessary_u24lambda_u245;
                Object[] objectArray;
                int n;
                Object object;
                Object object2;
                block5: {
                    if (isImplementedFakeOverride || !removedUnlinkedTypes.isEmpty()) break block5;
                    this.transformChildrenVoid($this$transformBodyIfNecessary);
                    break block6;
                }
                String functionKind = $this$transformBodyIfNecessary instanceof IrSimpleFunction && ((IrSimpleFunction)$this$transformBodyIfNecessary).getCorrespondingPropertySymbol() != null ? "property accessor" : ($this$transformBodyIfNecessary instanceof IrConstructor ? "constructor" : "function");
                Object[] objectArray2 = object2 = new String[2];
                int n2 = 0;
                if (isImplementedFakeOverride) {
                    object = new StringBuilder();
                    StringBuilder stringBuilder = object;
                    n = n2;
                    objectArray = objectArray2;
                    boolean bl = false;
                    $this$transformBodyIfNecessary_u24lambda_u245.append("Abstract ").append(functionKind).append(" ");
                    $this$transformBodyIfNecessary_u24lambda_u245.append(AdditionalIrUtilsKt.getFqNameForIrSerialization($this$transformBodyIfNecessary).asString());
                    $this$transformBodyIfNecessary_u24lambda_u245.append(" is not implemented in non-abstract class ");
                    $this$transformBodyIfNecessary_u24lambda_u245.append(AdditionalIrUtilsKt.getFqNameForIrSerialization($this$transformBodyIfNecessary.getParent()).asString());
                    unit = Unit.INSTANCE;
                    objectArray2 = objectArray;
                    n2 = n;
                    String string3 = ((StringBuilder)object).toString();
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
                } else {
                    string2 = null;
                }
                objectArray2[n2] = string2;
                Object[] objectArray3 = object2;
                int n3 = 1;
                if (!((Collection)removedUnlinkedTypes).isEmpty()) {
                    void $this$transformBodyIfNecessary_u24lambda_u246;
                    object = new StringBuilder();
                    $this$transformBodyIfNecessary_u24lambda_u245 = object;
                    n = n3;
                    objectArray = objectArray3;
                    boolean bl = false;
                    $this$transformBodyIfNecessary_u24lambda_u246.append("The signature of ").append(functionKind).append(" ");
                    $this$transformBodyIfNecessary_u24lambda_u246.append(AdditionalIrUtilsKt.getFqNameForIrSerialization($this$transformBodyIfNecessary).asString());
                    $this$transformBodyIfNecessary_u24lambda_u246.append(" contains unlinked symbols: ");
                    CollectionsKt.joinTo$default((Iterable)removedUnlinkedTypes, (Appendable)((Appendable)$this$transformBodyIfNecessary_u24lambda_u246), null, null, null, (int)0, null, (Function1)transformBodyIfNecessary.errorMessages.2.1.INSTANCE, (int)62, null);
                    unit = Unit.INSTANCE;
                    objectArray3 = objectArray;
                    n3 = n;
                    String string4 = ((StringBuilder)object).toString();
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
                } else {
                    string = null;
                }
                objectArray3[n3] = string;
                List errorMessages2 = CollectionsKt.listOfNotNull((Object[])object2);
                object2 = errorMessages2;
                object = UnlinkedDeclarationsProcessor.this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    ((UnlinkedDeclarationsProcessor)object).reportWarning(it, ((UnlinkedDeclarationsProcessor)object).location($this$transformBodyIfNecessary));
                }
                IrBody irBody = $this$transformBodyIfNecessary.getBody();
                if (irBody == null) break block6;
                object = irBody;
                UnlinkedDeclarationsProcessor unlinkedDeclarationsProcessor = UnlinkedDeclarationsProcessor.this;
                Object body2 = object;
                boolean bl = false;
                IrBlockBody bb = (IrBlockBody)body2;
                bb.getStatements().clear();
                bb.getStatements().add(unlinkedDeclarationsProcessor.throwLinkageError($this$transformBodyIfNecessary, null, CollectionsKt.joinToString$default((Iterable)errorMessages2, (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null)));
            }
            return $this$transformBodyIfNecessary;
        }

        private static final void fixUnlinkedTypes$lambda$4$fixType(IrValueParameter $this$fixUnlinkedTypes_u24lambda_u244_u24fixType, UnlinkedDeclarationsProcessor this$0, Set<IrType> $this_buildSet) {
            block2: {
                if (this$0.isUnlinked($this$fixUnlinkedTypes_u24lambda_u244_u24fixType.getType())) {
                    ((Collection)$this_buildSet).add($this$fixUnlinkedTypes_u24lambda_u244_u24fixType.getType());
                    $this$fixUnlinkedTypes_u24lambda_u244_u24fixType.setType(this$0.unlinkedMarkerTypeHandler.getUnlinkedMarkerType());
                    $this$fixUnlinkedTypes_u24lambda_u244_u24fixType.setDefaultValue(null);
                }
                IrType irType = $this$fixUnlinkedTypes_u24lambda_u244_u24fixType.getVarargElementType();
                if (irType == null) break block2;
                IrType it = irType;
                boolean bl = false;
                if (this$0.isUnlinked(it)) {
                    ((Collection)$this_buildSet).add(it);
                    $this$fixUnlinkedTypes_u24lambda_u244_u24fixType.setVarargElementType(this$0.unlinkedMarkerTypeHandler.getUnlinkedMarkerType());
                }
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\u0014\u0010\u0011\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UnlinkedDeclarationsProcessor$UsageTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UnlinkedDeclarationsProcessor;)V", "currentFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitClassReference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "visitExpression", "visitFieldAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "visitFile", "visitMemberAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "ir.serialization.common"})
    private final class UsageTransformer
    extends IrElementTransformerVoid {
        @Nullable
        private IrFile currentFile;

        @Override
        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration) {
            IrFile irFile;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            this.currentFile = declaration;
            IrFile it = irFile = super.visitFile(declaration);
            boolean bl = false;
            this.currentFile = null;
            return irFile;
        }

        @Override
        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression) {
            IrFile irFile;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.transformChildrenVoid(expression);
            IrClassifierSymbol checkType = expression.getTypeOperandClassifier();
            if (!UnlinkedDeclarationsProcessor.this.isUnlinked(checkType)) {
                return expression;
            }
            StringBuilder stringBuilder = new StringBuilder().append("TypeOperator contains unlinked symbol ");
            Object object = checkType.getSignature();
            if (object == null || (object = ((IdSignature)object).render()) == null) {
                object = "";
            }
            UnlinkedDeclarationsProcessor.this.reportWarning(stringBuilder.append((String)object).toString(), (irFile = this.currentFile) != null ? UnlinkedDeclarationsProcessor.this.location(irFile, expression.getStartOffset()) : null);
            IrCompositeImpl composite = new IrCompositeImpl(expression.getStartOffset(), expression.getEndOffset(), UnlinkedDeclarationsProcessor.this.builtIns.getNothingType(), null, 8, null);
            composite.getStatements().add(expression.getArgument());
            composite.getStatements().add(UnlinkedDeclarationsProcessor.throwLinkageError$default(UnlinkedDeclarationsProcessor.this, expression, expression.getTypeOperandClassifier(), null, 2, null));
            return composite;
        }

        @Override
        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (UnlinkedDeclarationsProcessor.this.isUnlinked(expression.getType()) || UnlinkedDeclarationsProcessor.this.isUnlinkedMarkerType(expression.getType())) {
                IrFile irFile = this.currentFile;
                UnlinkedDeclarationsProcessor.this.reportWarning("Expression type contains unlinked symbol", irFile != null ? UnlinkedDeclarationsProcessor.this.location(irFile, expression.getStartOffset()) : null);
                return UnlinkedDeclarationsProcessor.this.throwLinkageError(expression, null, "Unlinked type of IR expression");
            }
            return super.visitExpression(expression);
        }

        @Override
        @NotNull
        public IrExpression visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression) {
            IrExpression it;
            IrFile irFile;
            Intrinsics.checkNotNullParameter(expression, (String)"expression");
            this.transformChildrenVoid(expression);
            Object symbol2 = expression.getSymbol();
            if (!UnlinkedDeclarationsProcessor.this.isUnlinked(symbol2) && !UnlinkedDeclarationsProcessor.this.isUnlinked(expression.getType())) {
                return expression;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Accessing declaration contains unlinked symbol ");
            Object object = symbol2.getSignature();
            if (object == null || (object = ((IdSignature)object).render()) == null) {
                object = "";
            }
            UnlinkedDeclarationsProcessor.this.reportWarning(stringBuilder.append((String)object).toString(), (irFile = this.currentFile) != null ? UnlinkedDeclarationsProcessor.this.location(irFile, expression.getStartOffset()) : null);
            IrCompositeImpl composite = new IrCompositeImpl(expression.getStartOffset(), expression.getEndOffset(), UnlinkedDeclarationsProcessor.this.builtIns.getNothingType(), expression.getOrigin());
            IrExpression irExpression = expression.getDispatchReceiver();
            if (irExpression != null) {
                it = irExpression;
                boolean bl = false;
                composite.getStatements().add(it);
            }
            IrExpression irExpression2 = expression.getExtensionReceiver();
            if (irExpression2 != null) {
                it = irExpression2;
                boolean bl = false;
                composite.getStatements().add(it);
            }
            int n = expression.getValueArgumentsCount();
            for (int i = 0; i < n; ++i) {
                IrExpression it2;
                IrExpression arg = expression.getValueArgument(i);
                if (arg == null) continue;
                boolean bl = false;
                composite.getStatements().add(it2);
            }
            composite.getStatements().add(!symbol2.isBound() ? UnlinkedDeclarationsProcessor.throwLinkageError$default(UnlinkedDeclarationsProcessor.this, expression, symbol2, null, 2, null) : UnlinkedDeclarationsProcessor.this.throwLinkageError(expression, symbol2, "Unlinked type in signature of IR symbol"));
            return composite;
        }

        @Override
        @NotNull
        public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.transformChildrenVoid(expression);
            IrFieldSymbol symbol2 = expression.getSymbol();
            if (!UnlinkedDeclarationsProcessor.this.isUnlinked(symbol2)) {
                return expression;
            }
            IdSignature idSignature = symbol2.getSignature();
            IrFile irFile = this.currentFile;
            UnlinkedDeclarationsProcessor.this.reportWarning("Accessing field contains unlinked symbol " + (idSignature != null ? idSignature.render() : null), irFile != null ? UnlinkedDeclarationsProcessor.this.location(irFile, expression.getStartOffset()) : null);
            IrCompositeImpl composite = new IrCompositeImpl(expression.getStartOffset(), expression.getEndOffset(), UnlinkedDeclarationsProcessor.this.builtIns.getNothingType(), expression.getOrigin());
            IrExpression irExpression = expression.getReceiver();
            if (irExpression != null) {
                IrExpression it = irExpression;
                boolean bl = false;
                composite.getStatements().add(it);
            }
            if (expression instanceof IrSetField) {
                composite.getStatements().add(((IrSetField)expression).getValue());
            }
            composite.getStatements().add(!symbol2.isBound() ? UnlinkedDeclarationsProcessor.throwLinkageError$default(UnlinkedDeclarationsProcessor.this, expression, symbol2, null, 2, null) : UnlinkedDeclarationsProcessor.this.throwLinkageError(expression, symbol2, "Field type is unlinked in IR symbol"));
            return composite;
        }

        @Override
        @NotNull
        public IrExpression visitClassReference(@NotNull IrClassReference expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (UnlinkedDeclarationsProcessor.this.isUnlinked(expression.getSymbol())) {
                IdSignature idSignature = expression.getSymbol().getSignature();
                IrFile irFile = this.currentFile;
                UnlinkedDeclarationsProcessor.this.reportWarning("Accessing class contains unlinked symbol " + (idSignature != null ? idSignature.render() : null), irFile != null ? UnlinkedDeclarationsProcessor.this.location(irFile, expression.getStartOffset()) : null);
                return UnlinkedDeclarationsProcessor.throwLinkageError$default(UnlinkedDeclarationsProcessor.this, expression, expression.getSymbol(), null, 2, null);
            }
            return expression;
        }

        @Override
        @NotNull
        public IrStatement visitClass(@NotNull IrClass declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            this.transformChildrenVoid(declaration);
            for (IrDeclaration member : declaration.getDeclarations()) {
                IrDeclaration irDeclaration = member;
                if (irDeclaration instanceof IrSimpleFunction) {
                    UsageTransformer.visitClass$filterOverriddens((IrOverridableDeclaration)member);
                    continue;
                }
                if (!(irDeclaration instanceof IrProperty)) continue;
                UsageTransformer.visitClass$filterOverriddens((IrOverridableDeclaration)member);
                IrSimpleFunction irSimpleFunction = ((IrProperty)member).getGetter();
                if (irSimpleFunction != null) {
                    UsageTransformer.visitClass$filterOverriddens(irSimpleFunction);
                }
                IrSimpleFunction irSimpleFunction2 = ((IrProperty)member).getSetter();
                if (irSimpleFunction2 == null) continue;
                UsageTransformer.visitClass$filterOverriddens(irSimpleFunction2);
            }
            return declaration;
        }

        /*
         * WARNING - void declaration
         */
        private static final <S extends IrSymbol> void visitClass$filterOverriddens(IrOverridableDeclaration<S> $this$visitClass_u24filterOverriddens) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = $this$visitClass_u24filterOverriddens.getOverriddenSymbols();
            IrOverridableDeclaration<S> irOverridableDeclaration = $this$visitClass_u24filterOverriddens;
            boolean $i$f$filter = false;
            void var3_4 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrSymbol it = (IrSymbol)element$iv$iv;
                boolean bl = false;
                if (!it.isBound()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            irOverridableDeclaration.setOverriddenSymbols((List)destination$iv$iv);
        }
    }
}

