/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideBuilder;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideClassFilter;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.IrBodyDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinaryCoordinates;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinaryNameAndType;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinaryTypeProjection;
import org.jetbrains.kotlin.backend.common.serialization.encodings.ClassFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.FieldFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.FunctionFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.LocalVariableFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.PropertyFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.TypeAliasFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.TypeParameterFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.ValueParameterFlags;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.IrDisallowedErrorNode;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.IrSymbolTypeMismatchException;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrAnonymousInit;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrClass;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrConstructor;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrConstructorCall;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDeclaration;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDeclarationBase;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDefinitelyNotNullType;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDynamicType;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrEnumEntry;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrErrorDeclaration;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrErrorType;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrExpression;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrField;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFunction;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFunctionBase;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrInlineClassRepresentation;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrMultiFieldValueClassRepresentation;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrProperty;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrSimpleType;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrSimpleTypeLegacy;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrSimpleTypeNullability;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrStatement;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrType;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrTypeAbbreviation;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrTypeAlias;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrTypeParameter;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrValueParameter;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrVariable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.MultiFieldValueClassRepresentation;
import org.jetbrains.kotlin.descriptors.ValueClassRepresentation;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.symbols.IrAnonymousInitializerSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrPublicSymbolBase;
import org.jetbrains.kotlin.ir.symbols.impl.IrTypeParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrDynamicTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrErrorTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.ir.types.impl.IrTypeAbbreviationImpl;
import org.jetbrains.kotlin.ir.types.impl.IrUninitializedType;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00f2\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00b7\u00012\u00020\u0001:\u0002\u00b7\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-H\u0002J!\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020/H\u0000\u00a2\u0006\u0002\b3J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\b\b\u0002\u00108\u001a\u00020\rJ\u0010\u00109\u001a\u00020+2\u0006\u00106\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u00106\u001a\u00020=H\u0002J\u001a\u0010>\u001a\u00020?2\u0006\u00106\u001a\u00020@2\b\b\u0002\u00108\u001a\u00020\rH\u0002J\u0010\u0010A\u001a\u00020B2\u0006\u00106\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020$J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u00106\u001a\u00020HH\u0002J\u001a\u0010I\u001a\u00020J2\u0006\u00106\u001a\u00020K2\b\b\u0002\u00108\u001a\u00020\rH\u0002J\u001a\u0010L\u001a\u00020-2\u0006\u00106\u001a\u00020M2\b\b\u0002\u00108\u001a\u00020\rH\u0002J\u001a\u0010N\u001a\u00020O2\u0006\u00106\u001a\u00020P2\b\b\u0002\u00108\u001a\u00020\rH\u0002J\u0010\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020$H\u0002J\u001a\u0010T\u001a\u00020U2\u0006\u00106\u001a\u00020V2\b\b\u0002\u00108\u001a\u00020\rH\u0002J\"\u0010W\u001a\u00020X2\u0006\u00106\u001a\u00020Y2\u0006\u0010Z\u001a\u00020\r2\b\b\u0002\u00108\u001a\u00020\rH\u0002J\u001f\u0010[\u001a\u00020\\2\u0006\u00106\u001a\u00020]2\b\b\u0002\u00108\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b^J\u001a\u0010_\u001a\u00020`2\u0006\u00106\u001a\u00020a2\b\b\u0002\u00108\u001a\u00020\rH\u0002J\u001a\u0010b\u001a\u00020c2\u0006\u00106\u001a\u00020d2\b\b\u0002\u00108\u001a\u00020\rH\u0002J\u0015\u0010e\u001a\u00020 2\u0006\u0010f\u001a\u00020gH\u0000\u00a2\u0006\u0002\bhJ\u0015\u0010i\u001a\u00020 2\u0006\u0010f\u001a\u00020gH\u0000\u00a2\u0006\u0002\bjJ\u000e\u0010k\u001a\u00020%2\u0006\u0010F\u001a\u00020$J\u001a\u0010l\u001a\u00020m2\u0006\u00106\u001a\u00020n2\b\b\u0002\u00108\u001a\u00020\rH\u0002J\u0010\u0010o\u001a\u00020p2\u0006\u00106\u001a\u00020gH\u0002J\u0010\u0010q\u001a\u00020%2\u0006\u00106\u001a\u00020rH\u0002J*\u0010s\u001a\u00020t2\u0006\u00106\u001a\u00020u2\u0006\u0010F\u001a\u00020$2\u0006\u0010v\u001a\u00020\r2\b\b\u0002\u00108\u001a\u00020\rH\u0002J\"\u0010w\u001a\u00020x2\u0006\u00106\u001a\u00020y2\u0006\u0010F\u001a\u00020$2\b\b\u0002\u00108\u001a\u00020\rH\u0002J\u0018\u0010z\u001a\u00020{2\u0006\u00106\u001a\u00020|2\b\b\u0002\u00108\u001a\u00020\rJ\u0010\u0010}\u001a\u00020+2\u0006\u00106\u001a\u00020~H\u0002J\u0018\u0010\u007f\u001a\t\u0012\u0004\u0012\u00020+0\u0080\u00012\u0007\u00106\u001a\u00030\u0081\u0001H\u0002J\u0012\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0006\u0010F\u001a\u00020$H\u0002J\u0011\u0010\u0084\u0001\u001a\u0004\u0018\u00010%2\u0006\u0010F\u001a\u00020$J\u0012\u0010\u0085\u0001\u001a\u00020+2\u0007\u00106\u001a\u00030\u0086\u0001H\u0002J\u0013\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0007\u00106\u001a\u00030\u0089\u0001H\u0002J\u0012\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\u0006\u0010F\u001a\u00020$J\u0013\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0007\u00106\u001a\u00030\u008e\u0001H\u0002J&\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u00020t0/2\r\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020u0/2\u0006\u0010v\u001a\u00020\rH\u0002J\u001e\u0010\u0091\u0001\u001a\b\u0012\u0004\u0012\u00020x0/2\r\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020y0/H\u0002J\u0013\u0010\u0092\u0001\u001a\u00030\u0093\u00012\u0007\u0010\u0094\u0001\u001a\u00020 H\u0002J\u0019\u0010\u0095\u0001\u001a\u00020\r2\u0006\u00106\u001a\u0002072\u0006\u0010\n\u001a\u00020-H\u0002J\u0012\u0010\u0096\u0001\u001a\u00030\u0097\u00012\u0006\u0010F\u001a\u00020$H\u0002J\u0012\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0006\u0010F\u001a\u00020$H\u0002J\u0011\u0010\u009a\u0001\u001a\u00020r2\u0006\u0010F\u001a\u00020$H\u0002J\u0013\u0010\u009b\u0001\u001a\u00030\u0093\u00012\u0007\u0010\u0094\u0001\u001a\u00020 H\u0002Jk\u0010\u009c\u0001\u001a\u0003H\u009d\u0001\"\u000e\b\u0000\u0010\u009d\u0001*\u000205*\u00030\u009e\u00012\u0007\u00106\u001a\u00030\u009f\u00012\b\b\u0002\u00108\u001a\u00020\r25\u0010\u00a0\u0001\u001a0\u0012\u0004\u0012\u00020 \u0012\u0005\u0012\u00030\u00a2\u0001\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$\u0012\u0005\u0012\u00030\u00a3\u0001\u0012\u0004\u0012\u00020g\u0012\u0005\u0012\u0003H\u009d\u00010\u00a1\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u00a4\u0001Jh\u0010\u00a5\u0001\u001a\u0003H\u009d\u0001\"\n\b\u0000\u0010\u009d\u0001*\u00030\u00a6\u00012\u0007\u00106\u001a\u00030\u00a7\u00012\b\b\u0002\u00108\u001a\u00020\r26\u0010\u00a0\u0001\u001a1\u0012\u0005\u0012\u00030\u00a8\u0001\u0012\u0005\u0012\u00030\u00a2\u0001\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$\u0012\u0005\u0012\u00030\u00a3\u0001\u0012\u0004\u0012\u00020g\u0012\u0005\u0012\u0003H\u009d\u00010\u00a1\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u00a9\u0001J%\u0010\u00aa\u0001\u001a\u00030\u0093\u00012\u0007\u0010\u00ab\u0001\u001a\u00020\r2\u000f\u0010\u00ac\u0001\u001a\n\u0012\u0005\u0012\u00030\u0093\u00010\u00ad\u0001H\u0082\bJ\r\u0010\u00ae\u0001\u001a\u00020\r*\u00020%H\u0002J?\u0010\u00af\u0001\u001a\u0003H\u009d\u0001\"\t\b\u0000\u0010\u009d\u0001*\u00020\u000b*\u0003H\u009d\u00012\u001c\u0010\u00a0\u0001\u001a\u0017\u0012\u0005\u0012\u0003H\u009d\u0001\u0012\u0005\u0012\u00030\u0093\u00010\u00b0\u0001\u00a2\u0006\u0003\b\u00b1\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u00b2\u0001J?\u0010\u00b3\u0001\u001a\u00030\u0093\u0001\"\n\b\u0000\u0010\u009d\u0001*\u00030\u00a6\u0001*\u0003H\u009d\u00012\u001c\u0010\u00a0\u0001\u001a\u0017\u0012\u0005\u0012\u0003H\u009d\u0001\u0012\u0005\u0012\u00030\u0093\u00010\u00b0\u0001\u00a2\u0006\u0003\b\u00b1\u0001H\u0002\u00a2\u0006\u0003\u0010\u00b4\u0001J3\u0010\u00b5\u0001\u001a\u00030\u0093\u0001*\u00020X2\u0006\u0010Z\u001a\u00020\r2\u001b\u0010\u00b6\u0001\u001a\u0016\u0012\u0004\u0012\u00020X\u0012\u0005\u0012\u00030\u0093\u00010\u00b0\u0001\u00a2\u0006\u0003\b\u00b1\u0001H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b8\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;", "", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "libraryFile", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "allowErrorNodes", "", "deserializeInlineFunctions", "deserializeBodies", "symbolDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "platformFakeOverrideClassFilter", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "compatibilityMode", "Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/declarations/IrFactory;Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;ZZZLorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;)V", "getAllowErrorNodes", "()Z", "bodyDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrBodyDeserializer;", "currentParent", "delegatedSymbolMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "irTypeCache", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isEffectivelyExternal", "getSymbolDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "computeMissingInlineClassRepresentationForCompatibility", "Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "deserializeAnnotations", "", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "annotations", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrConstructorCall;", "deserializeAnnotations$ir_serialization_common", "deserializeDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "proto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDeclaration;", "setParent", "deserializeDefinitelyNotNullType", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDefinitelyNotNullType;", "deserializeDynamicType", "Lorg/jetbrains/kotlin/ir/types/IrDynamicType;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDynamicType;", "deserializeErrorDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrErrorDeclaration;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrErrorDeclaration;", "deserializeErrorType", "Lorg/jetbrains/kotlin/ir/types/IrErrorType;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrErrorType;", "deserializeExpressionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "index", "deserializeInlineClassRepresentation", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrInlineClassRepresentation;", "deserializeIrAnonymousInit", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrAnonymousInit;", "deserializeIrClass", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrClass;", "deserializeIrConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrConstructor;", "deserializeIrDeclarationOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "protoName", "deserializeIrEnumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrEnumEntry;", "deserializeIrField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrField;", "isConst", "deserializeIrFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFunction;", "deserializeIrFunction$ir_serialization_common", "deserializeIrLocalDelegatedProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrLocalDelegatedProperty;", "deserializeIrProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrProperty;", "deserializeIrSymbol", "code", "", "deserializeIrSymbol$ir_serialization_common", "deserializeIrSymbolAndRemap", "deserializeIrSymbolAndRemap$ir_serialization_common", "deserializeIrType", "deserializeIrTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrTypeAlias;", "deserializeIrTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "deserializeIrTypeData", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrType;", "deserializeIrTypeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrTypeParameter;", "isGlobal", "deserializeIrValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrValueParameter;", "deserializeIrVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrVariable;", "deserializeLegacySimpleType", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrSimpleTypeLegacy;", "deserializeMultiFieldValueClassRepresentation", "Lorg/jetbrains/kotlin/descriptors/MultiFieldValueClassRepresentation;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrMultiFieldValueClassRepresentation;", "deserializeName", "Lorg/jetbrains/kotlin/name/Name;", "deserializeNullableIrType", "deserializeSimpleType", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrSimpleType;", "deserializeSimpleTypeNullability", "Lorg/jetbrains/kotlin/ir/types/SimpleTypeNullability;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrSimpleTypeNullability;", "deserializeStatementBody", "Lorg/jetbrains/kotlin/ir/IrElement;", "deserializeTypeAbbreviation", "Lorg/jetbrains/kotlin/ir/types/IrTypeAbbreviation;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrTypeAbbreviation;", "deserializeTypeParameters", "protos", "deserializeValueParameters", "eraseDelegatedSymbol", "", "symbol", "isSkippableFakeOverride", "loadExpressionBodyProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrExpression;", "loadStatementBodyProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrStatement;", "loadTypeProto", "recordDelegatedSymbol", "withDeserializedIrDeclarationBase", "T", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDeclarationBase;", "block", "Lkotlin/Function6;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "(Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDeclarationBase;ZLkotlin/jvm/functions/Function6;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "withDeserializedIrFunctionBase", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFunctionBase;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "(Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFunctionBase;ZLkotlin/jvm/functions/Function6;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "withExternalValue", "value", "fn", "Lkotlin/Function0;", "checkObjectLeak", "usingParent", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "withBodyGuard", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lkotlin/jvm/functions/Function1;)V", "withInitializerGuard", "f", "Companion", "ir.serialization.common"})
public final class IrDeclarationDeserializer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final IrFactory irFactory;
    @NotNull
    private final IrLibraryFile libraryFile;
    private final boolean allowErrorNodes;
    private final boolean deserializeInlineFunctions;
    private boolean deserializeBodies;
    @NotNull
    private final IrSymbolDeserializer symbolDeserializer;
    @NotNull
    private final FakeOverrideClassFilter platformFakeOverrideClassFilter;
    @NotNull
    private final FakeOverrideBuilder fakeOverrideBuilder;
    @NotNull
    private final CompatibilityMode compatibilityMode;
    @NotNull
    private final IrBodyDeserializer bodyDeserializer;
    @NotNull
    private final Map<Integer, org.jetbrains.kotlin.ir.types.IrType> irTypeCache;
    @NotNull
    private IrDeclarationParent currentParent;
    @NotNull
    private final Map<IrSymbol, IrSymbol> delegatedSymbolMap;
    private boolean isEffectivelyExternal;
    @NotNull
    private static final List<KClass<?>> allKnownDeclarationOrigins;
    @NotNull
    private static final Map<String, IrDeclarationOriginImpl> declarationOriginIndex;

    public IrDeclarationDeserializer(@NotNull IrBuiltIns builtIns, @NotNull SymbolTable symbolTable, @NotNull IrFactory irFactory, @NotNull IrLibraryFile libraryFile, @NotNull IrDeclarationParent parent2, boolean allowErrorNodes, boolean deserializeInlineFunctions, boolean deserializeBodies, @NotNull IrSymbolDeserializer symbolDeserializer2, @NotNull FakeOverrideClassFilter platformFakeOverrideClassFilter, @NotNull FakeOverrideBuilder fakeOverrideBuilder, @NotNull CompatibilityMode compatibilityMode) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)symbolDeserializer2, (String)"symbolDeserializer");
        Intrinsics.checkNotNullParameter((Object)platformFakeOverrideClassFilter, (String)"platformFakeOverrideClassFilter");
        Intrinsics.checkNotNullParameter((Object)fakeOverrideBuilder, (String)"fakeOverrideBuilder");
        Intrinsics.checkNotNullParameter((Object)compatibilityMode, (String)"compatibilityMode");
        this.symbolTable = symbolTable;
        this.irFactory = irFactory;
        this.libraryFile = libraryFile;
        this.allowErrorNodes = allowErrorNodes;
        this.deserializeInlineFunctions = deserializeInlineFunctions;
        this.deserializeBodies = deserializeBodies;
        this.symbolDeserializer = symbolDeserializer2;
        this.platformFakeOverrideClassFilter = platformFakeOverrideClassFilter;
        this.fakeOverrideBuilder = fakeOverrideBuilder;
        this.compatibilityMode = compatibilityMode;
        this.bodyDeserializer = new IrBodyDeserializer(builtIns, this.allowErrorNodes, this.irFactory, this.libraryFile, this);
        this.irTypeCache = new LinkedHashMap();
        this.currentParent = parent2;
        this.delegatedSymbolMap = new LinkedHashMap();
    }

    @NotNull
    public final IrFactory getIrFactory() {
        return this.irFactory;
    }

    public final boolean getAllowErrorNodes() {
        return this.allowErrorNodes;
    }

    @NotNull
    public final IrSymbolDeserializer getSymbolDeserializer() {
        return this.symbolDeserializer;
    }

    private final Name deserializeName(int index) {
        String name = this.libraryFile.string(index);
        Name name2 = Name.guessByFirstCharacter((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"guessByFirstCharacter(name)");
        return name2;
    }

    private final IrType loadTypeProto(int index) {
        return this.libraryFile.type(index);
    }

    @Nullable
    public final org.jetbrains.kotlin.ir.types.IrType deserializeNullableIrType(int index) {
        return index == -1 ? null : this.deserializeIrType(index);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final org.jetbrains.kotlin.ir.types.IrType deserializeIrType(int index) {
        Object object;
        void $this$getOrPut$iv;
        Map<Integer, org.jetbrains.kotlin.ir.types.IrType> map = this.irTypeCache;
        Integer key$iv = index;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            IrType typeData = this.loadTypeProto(index);
            org.jetbrains.kotlin.ir.types.IrType answer$iv = this.deserializeIrTypeData(typeData);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (org.jetbrains.kotlin.ir.types.IrType)object;
    }

    private final IrTypeArgument deserializeIrTypeArgument(long proto) {
        long encoding = BinaryTypeProjection.Companion.decode-2ztXSlc(proto);
        if (BinaryTypeProjection.isStarProjection-impl(encoding)) {
            return IrStarProjectionImpl.INSTANCE;
        }
        return IrSimpleTypeImplKt.makeTypeProjection(this.deserializeIrType(BinaryTypeProjection.getTypeIndex-impl(encoding)), BinaryTypeProjection.getVariance-impl(encoding));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<org.jetbrains.kotlin.ir.expressions.IrConstructorCall> deserializeAnnotations$ir_serialization_common(@NotNull List<IrConstructorCall> annotations2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(annotations2, (String)"annotations");
        Iterable $this$map$iv = annotations2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrConstructorCall irConstructorCall = (IrConstructorCall)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.bodyDeserializer.deserializeAnnotation((IrConstructorCall)it));
        }
        return (List)destination$iv$iv;
    }

    private final SimpleTypeNullability deserializeSimpleTypeNullability(IrSimpleTypeNullability proto) {
        SimpleTypeNullability simpleTypeNullability;
        switch (WhenMappings.$EnumSwitchMapping$0[proto.ordinal()]) {
            case 1: {
                simpleTypeNullability = SimpleTypeNullability.MARKED_NULLABLE;
                break;
            }
            case 2: {
                simpleTypeNullability = SimpleTypeNullability.NOT_SPECIFIED;
                break;
            }
            case 3: {
                simpleTypeNullability = SimpleTypeNullability.DEFINITELY_NOT_NULL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return simpleTypeNullability;
    }

    /*
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.types.IrSimpleType deserializeSimpleType(IrSimpleType proto) {
        org.jetbrains.kotlin.ir.types.IrTypeAbbreviation irTypeAbbreviation;
        void $this$mapTo$iv$iv;
        IrSymbol symbol$iv = this.deserializeIrSymbolAndRemap$ir_serialization_common(proto.getClassifier());
        boolean $i$f$checkSymbolType = false;
        if (!(symbol$iv instanceof IrClassifierSymbol)) {
            throw new IrSymbolTypeMismatchException(IrClassifierSymbol.class, symbol$iv);
        }
        IrClassifierSymbol symbol2 = (IrClassifierSymbol)symbol$iv;
        List<Long> list = proto.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"proto.argumentList");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.deserializeIrTypeArgument(it.longValue()));
        }
        List arguments2 = (List)destination$iv$iv;
        List<IrConstructorCall> list2 = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
        List<org.jetbrains.kotlin.ir.expressions.IrConstructorCall> annotations2 = this.deserializeAnnotations$ir_serialization_common(list2);
        IrSimpleTypeNullability irSimpleTypeNullability = proto.getNullability();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)irSimpleTypeNullability), (String)"proto.nullability");
        SimpleTypeNullability simpleTypeNullability = this.deserializeSimpleTypeNullability(irSimpleTypeNullability);
        if (proto.hasAbbreviation()) {
            IrTypeAbbreviation irTypeAbbreviation2 = proto.getAbbreviation();
            Intrinsics.checkNotNullExpressionValue((Object)irTypeAbbreviation2, (String)"proto.abbreviation");
            irTypeAbbreviation = this.deserializeTypeAbbreviation(irTypeAbbreviation2);
        } else {
            irTypeAbbreviation = null;
        }
        return new IrSimpleTypeImpl(null, symbol2, simpleTypeNullability, arguments2, annotations2, irTypeAbbreviation);
    }

    /*
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.types.IrSimpleType deserializeLegacySimpleType(IrSimpleTypeLegacy proto) {
        org.jetbrains.kotlin.ir.types.IrTypeAbbreviation irTypeAbbreviation;
        void $this$mapTo$iv$iv;
        IrSymbol symbol$iv = this.deserializeIrSymbolAndRemap$ir_serialization_common(proto.getClassifier());
        boolean $i$f$checkSymbolType = false;
        if (!(symbol$iv instanceof IrClassifierSymbol)) {
            throw new IrSymbolTypeMismatchException(IrClassifierSymbol.class, symbol$iv);
        }
        IrClassifierSymbol symbol2 = (IrClassifierSymbol)symbol$iv;
        List<Long> list = proto.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"proto.argumentList");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.deserializeIrTypeArgument(it.longValue()));
        }
        List arguments2 = (List)destination$iv$iv;
        List<IrConstructorCall> list2 = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
        List<org.jetbrains.kotlin.ir.expressions.IrConstructorCall> annotations2 = this.deserializeAnnotations$ir_serialization_common(list2);
        SimpleTypeNullability simpleTypeNullability = SimpleTypeNullability.Companion.fromHasQuestionMark(proto.getHasQuestionMark());
        if (proto.hasAbbreviation()) {
            IrTypeAbbreviation irTypeAbbreviation2 = proto.getAbbreviation();
            Intrinsics.checkNotNullExpressionValue((Object)irTypeAbbreviation2, (String)"proto.abbreviation");
            irTypeAbbreviation = this.deserializeTypeAbbreviation(irTypeAbbreviation2);
        } else {
            irTypeAbbreviation = null;
        }
        return new IrSimpleTypeImpl(null, symbol2, simpleTypeNullability, arguments2, annotations2, irTypeAbbreviation);
    }

    /*
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.types.IrTypeAbbreviation deserializeTypeAbbreviation(IrTypeAbbreviation proto) {
        Collection<IrTypeArgument> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object symbol$iv = this.deserializeIrSymbolAndRemap$ir_serialization_common(proto.getTypeAlias());
        boolean $i$f$checkSymbolType = false;
        if (!(symbol$iv instanceof IrTypeAliasSymbol)) {
            throw new IrSymbolTypeMismatchException(IrTypeAliasSymbol.class, (IrSymbol)symbol$iv);
        }
        IrTypeAliasSymbol irTypeAliasSymbol = (IrTypeAliasSymbol)symbol$iv;
        boolean bl = proto.getHasQuestionMark();
        List<Long> list = proto.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"proto.argumentList");
        symbol$iv = list;
        boolean bl2 = bl;
        IrTypeAliasSymbol irTypeAliasSymbol2 = irTypeAliasSymbol;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Long l = (Long)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.deserializeIrTypeArgument(it.longValue()));
        }
        collection = (List)destination$iv$iv;
        List<IrConstructorCall> list2 = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
        List<org.jetbrains.kotlin.ir.expressions.IrConstructorCall> list3 = this.deserializeAnnotations$ir_serialization_common(list2);
        List list4 = collection;
        boolean bl4 = bl2;
        IrTypeAliasSymbol irTypeAliasSymbol3 = irTypeAliasSymbol2;
        return new IrTypeAbbreviationImpl(irTypeAliasSymbol3, bl4, list4, list3);
    }

    private final org.jetbrains.kotlin.ir.types.IrDynamicType deserializeDynamicType(IrDynamicType proto) {
        List<IrConstructorCall> list = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
        List<org.jetbrains.kotlin.ir.expressions.IrConstructorCall> annotations2 = this.deserializeAnnotations$ir_serialization_common(list);
        return new IrDynamicTypeImpl(null, annotations2, Variance.INVARIANT);
    }

    private final org.jetbrains.kotlin.ir.types.IrErrorType deserializeErrorType(IrErrorType proto) {
        boolean errorNodesAllowed$iv = this.allowErrorNodes;
        boolean $i$f$checkErrorNodesAllowed = false;
        if (!errorNodesAllowed$iv) {
            throw new IrDisallowedErrorNode(org.jetbrains.kotlin.ir.types.IrErrorType.class);
        }
        List<IrConstructorCall> list = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
        List<org.jetbrains.kotlin.ir.expressions.IrConstructorCall> annotations2 = this.deserializeAnnotations$ir_serialization_common(list);
        return new IrErrorTypeImpl(null, annotations2, Variance.INVARIANT, false, 8, null);
    }

    private final org.jetbrains.kotlin.ir.types.IrSimpleType deserializeDefinitelyNotNullType(IrDefinitelyNotNullType proto) {
        boolean bl;
        boolean bl2 = bl = proto.getTypesCount() == 1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Only DefinitelyNotNull type is now supported";
            throw new AssertionError((Object)string);
        }
        Integer n = proto.getTypesList().get(0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"proto.typesList[0]");
        org.jetbrains.kotlin.ir.types.IrType irType = IrTypesKt.makeNotNull(this.deserializeIrType(((Number)n).intValue()));
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        return (org.jetbrains.kotlin.ir.types.IrSimpleType)irType;
    }

    private final org.jetbrains.kotlin.ir.types.IrType deserializeIrTypeData(IrType proto) {
        org.jetbrains.kotlin.ir.types.IrType irType;
        IrType.KindCase kindCase = proto.getKindCase();
        switch (kindCase == null ? -1 : WhenMappings.$EnumSwitchMapping$1[kindCase.ordinal()]) {
            case 1: {
                IrDefinitelyNotNullType irDefinitelyNotNullType = proto.getDnn();
                Intrinsics.checkNotNullExpressionValue((Object)irDefinitelyNotNullType, (String)"proto.dnn");
                irType = this.deserializeDefinitelyNotNullType(irDefinitelyNotNullType);
                break;
            }
            case 2: {
                IrSimpleType irSimpleType = proto.getSimple();
                Intrinsics.checkNotNullExpressionValue((Object)irSimpleType, (String)"proto.simple");
                irType = this.deserializeSimpleType(irSimpleType);
                break;
            }
            case 3: {
                IrSimpleTypeLegacy irSimpleTypeLegacy = proto.getLegacySimple();
                Intrinsics.checkNotNullExpressionValue((Object)irSimpleTypeLegacy, (String)"proto.legacySimple");
                irType = this.deserializeLegacySimpleType(irSimpleTypeLegacy);
                break;
            }
            case 4: {
                IrDynamicType irDynamicType = proto.getDynamic();
                Intrinsics.checkNotNullExpressionValue((Object)irDynamicType, (String)"proto.dynamic");
                irType = this.deserializeDynamicType(irDynamicType);
                break;
            }
            case 5: {
                IrErrorType irErrorType = proto.getError();
                Intrinsics.checkNotNullExpressionValue((Object)irErrorType, (String)"proto.error");
                irType = this.deserializeErrorType(irErrorType);
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected IrType kind: " + (Object)((Object)proto.getKindCase())).toString());
            }
        }
        return irType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends IrDeclarationParent> T usingParent(T $this$usingParent, Function1<? super T, Unit> block) {
        T t;
        boolean $i$f$usingParent = false;
        T $this$usingParent_u24lambda_u246 = t = $this$usingParent;
        boolean bl = false;
        IrDeclarationParent oldParent = this.currentParent;
        this.currentParent = $this$usingParent_u24lambda_u246;
        try {
            block.invoke($this$usingParent_u24lambda_u246);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.currentParent = oldParent;
            InlineMarker.finallyEnd((int)1);
        }
        return t;
    }

    @NotNull
    public final IrSymbol deserializeIrSymbol$ir_serialization_common(long code) {
        return this.symbolDeserializer.deserializeIrSymbol(code);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrSymbol deserializeIrSymbolAndRemap$ir_serialization_common(long code) {
        IrSymbol it = this.symbolDeserializer.deserializeIrSymbol(code);
        boolean bl = false;
        IrSymbol irSymbol = this.delegatedSymbolMap.get(it);
        if (irSymbol == null) {
            void var3_2;
            irSymbol = var3_2;
        }
        return irSymbol;
    }

    private final void recordDelegatedSymbol(IrSymbol symbol2) {
        if (symbol2 instanceof IrDelegatingSymbol) {
            this.delegatedSymbolMap.put(symbol2, (IrSymbol)((IrDelegatingSymbol)symbol2).getDelegate());
        }
    }

    private final void eraseDelegatedSymbol(IrSymbol symbol2) {
        if (symbol2 instanceof IrDelegatingSymbol) {
            this.delegatedSymbolMap.remove(symbol2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withExternalValue(boolean value, Function0<Unit> fn) {
        boolean $i$f$withExternalValue = false;
        boolean oldExternalValue = this.isEffectivelyExternal;
        this.isEffectivelyExternal = value;
        try {
            fn.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.isEffectivelyExternal = oldExternalValue;
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends org.jetbrains.kotlin.ir.declarations.IrDeclaration & IrSymbolOwner> T withDeserializedIrDeclarationBase(IrDeclarationBase proto, boolean setParent, Function6<? super IrSymbol, ? super IdSignature, ? super Integer, ? super Integer, ? super IrDeclarationOrigin, ? super Long, ? extends T> block) {
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto.getSymbol());
        IrSymbol s = (IrSymbol)pair.component1();
        IdSignature uid = (IdSignature)pair.component2();
        long coordinates = BinaryCoordinates.Companion.decode-ViYoqTc(proto.getCoordinates());
        try {
            this.recordDelegatedSymbol(s);
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result2 = (org.jetbrains.kotlin.ir.declarations.IrDeclaration)block.invoke((Object)s, (Object)uid, (Object)BinaryCoordinates.getStartOffset-impl(coordinates), (Object)BinaryCoordinates.getEndOffset-impl(coordinates), (Object)this.deserializeIrDeclarationOrigin(proto.getOriginName()), (Object)proto.getFlags());
            List<IrConstructorCall> list = proto.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result2.setAnnotations(this.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result2.setParent(this.currentParent);
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration = result2;
            return (T)irDeclaration;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.eraseDelegatedSymbol(s);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrDeclaration withDeserializedIrDeclarationBase$default(IrDeclarationDeserializer $this, IrDeclarationBase proto, boolean setParent, Function6 block, int n, Object pair) {
        if ((n & 2) != 0) {
            setParent = true;
        }
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        pair = $this.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto.getSymbol());
        IrSymbol s = (IrSymbol)pair.component1();
        IdSignature uid = (IdSignature)pair.component2();
        long coordinates = BinaryCoordinates.Companion.decode-ViYoqTc(proto.getCoordinates());
        try {
            $this.recordDelegatedSymbol(s);
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result2 = (org.jetbrains.kotlin.ir.declarations.IrDeclaration)block.invoke((Object)s, (Object)uid, (Object)BinaryCoordinates.getStartOffset-impl(coordinates), (Object)BinaryCoordinates.getEndOffset-impl(coordinates), (Object)$this.deserializeIrDeclarationOrigin(proto.getOriginName()), (Object)proto.getFlags());
            List<IrConstructorCall> list = proto.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result2.setAnnotations($this.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result2.setParent($this.currentParent);
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration = result2;
            return irDeclaration;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this.eraseDelegatedSymbol(s);
            InlineMarker.finallyEnd((int)1);
        }
    }

    private final org.jetbrains.kotlin.ir.declarations.IrTypeParameter deserializeIrTypeParameter(IrTypeParameter proto, int index, boolean isGlobal, boolean setParent) {
        org.jetbrains.kotlin.ir.declarations.IrTypeParameter irTypeParameter;
        Name name = this.deserializeName(proto.getName());
        long coordinates = BinaryCoordinates.Companion.decode-ViYoqTc(proto.getBase().getCoordinates());
        long flags = TypeParameterFlags.Companion.decode-dTrNHuw(proto.getBase().getFlags());
        Function1 factory2 = (Function1)new Function1<IrTypeParameterSymbol, org.jetbrains.kotlin.ir.declarations.IrTypeParameter>(this, coordinates, proto, name, index, flags){
            final /* synthetic */ IrDeclarationDeserializer this$0;
            final /* synthetic */ long $coordinates;
            final /* synthetic */ IrTypeParameter $proto;
            final /* synthetic */ Name $name;
            final /* synthetic */ int $index;
            final /* synthetic */ long $flags;
            {
                this.this$0 = $receiver;
                this.$coordinates = $coordinates;
                this.$proto = $proto;
                this.$name = $name;
                this.$index = $index;
                this.$flags = $flags;
                super(1);
            }

            @NotNull
            public final org.jetbrains.kotlin.ir.declarations.IrTypeParameter invoke(@NotNull IrTypeParameterSymbol symbol2) {
                Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                return this.this$0.getIrFactory().createTypeParameter(BinaryCoordinates.getStartOffset-impl(this.$coordinates), BinaryCoordinates.getEndOffset-impl(this.$coordinates), IrDeclarationDeserializer.access$deserializeIrDeclarationOrigin(this.this$0, this.$proto.getBase().getOriginName()), symbol2, this.$name, this.$index, TypeParameterFlags.isReified-impl(this.$flags), TypeParameterFlags.getVariance-impl(this.$flags));
            }
        };
        Ref.ObjectRef sig = new Ref.ObjectRef();
        SymbolTable $this$deserializeIrTypeParameter_u24lambda_u248 = this.symbolTable;
        boolean bl = false;
        if (isGlobal) {
            Pair<IrSymbol, IdSignature> p = this.symbolDeserializer.deserializeIrSymbolToDeclare(proto.getBase().getSymbol());
            IrSymbol symbol$iv = (IrSymbol)p.getFirst();
            boolean $i$f$checkSymbolType = false;
            if (!(symbol$iv instanceof IrTypeParameterSymbol)) {
                throw new IrSymbolTypeMismatchException(IrTypeParameterSymbol.class, symbol$iv);
            }
            IrTypeParameterSymbol symbol2 = (IrTypeParameterSymbol)symbol$iv;
            sig.element = p.getSecond();
            irTypeParameter = $this$deserializeIrTypeParameter_u24lambda_u248.declareGlobalTypeParameter((IdSignature)sig.element, (Function0<? extends IrTypeParameterSymbol>)((Function0)new Function0<IrTypeParameterSymbol>(symbol2){
                final /* synthetic */ IrTypeParameterSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrTypeParameterSymbol invoke() {
                    return this.$symbol;
                }
            }), (Function1<? super IrTypeParameterSymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrTypeParameter>)factory2);
        } else {
            long symbolData = BinarySymbolData.Companion.decode-9x8F8T0(proto.getBase().getSymbol());
            sig.element = this.symbolDeserializer.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(symbolData));
            irTypeParameter = $this$deserializeIrTypeParameter_u24lambda_u248.declareScopedTypeParameter((IdSignature)sig.element, (Function1<? super IdSignature, ? extends IrTypeParameterSymbol>)((Function1)new Function1<IdSignature, IrTypeParameterSymbol>(this, (Ref.ObjectRef<IdSignature>)sig){
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ Ref.ObjectRef<IdSignature> $sig;
                {
                    this.this$0 = $receiver;
                    this.$sig = $sig;
                    super(1);
                }

                @NotNull
                public final IrTypeParameterSymbol invoke(@NotNull IdSignature it) {
                    IrTypeParameterSymbol irTypeParameterSymbol;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (it.isPubliclyVisible()) {
                        IrSymbol irSymbol = this.this$0.getSymbolDeserializer().deserializeIrSymbol((IdSignature)this.$sig.element, BinarySymbolData.SymbolKind.TYPE_PARAMETER_SYMBOL);
                        Intrinsics.checkNotNull((Object)irSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol");
                        irTypeParameterSymbol = (IrTypeParameterSymbol)irSymbol;
                    } else {
                        irTypeParameterSymbol = new IrTypeParameterSymbolImpl(null, 1, null);
                    }
                    return irTypeParameterSymbol;
                }
            }), (Function1<? super IrTypeParameterSymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrTypeParameter>)factory2);
        }
        org.jetbrains.kotlin.ir.declarations.IrTypeParameter result2 = irTypeParameter;
        this.symbolDeserializer.referenceLocalIrSymbol(result2.getSymbol(), (IdSignature)sig.element);
        List<IrConstructorCall> list = proto.getBase().getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"proto.base.annotationList");
        result2.setAnnotations(this.deserializeAnnotations$ir_serialization_common(list));
        if (setParent) {
            result2.setParent(this.currentParent);
        }
        return result2;
    }

    static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrTypeParameter deserializeIrTypeParameter$default(IrDeclarationDeserializer irDeclarationDeserializer, IrTypeParameter irTypeParameter, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        return irDeclarationDeserializer.deserializeIrTypeParameter(irTypeParameter, n, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrValueParameter deserializeIrValueParameter(IrValueParameter proto, int index, boolean setParent) {
        org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void origin;
            void endOffset;
            void startOffset;
            org.jetbrains.kotlin.ir.declarations.IrValueParameter irValueParameter;
            void fcode;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = ((IrDeclarationDeserializer)this_$iv).deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            long flags = ValueParameterFlags.Companion.decode-eyNVhwA((long)fcode);
            long nameAndType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType());
            boolean $i$f$checkSymbolType = false;
            if (!(symbol2 instanceof IrValueParameterSymbol)) {
                throw new IrSymbolTypeMismatchException(IrValueParameterSymbol.class, symbol2);
            }
            org.jetbrains.kotlin.ir.declarations.IrValueParameter $this$deserializeIrValueParameter_u24lambda_u2410_u24lambda_u249 = irValueParameter = this.irFactory.createValueParameter((int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, (IrValueParameterSymbol)symbol2, this.deserializeName(BinaryNameAndType.getNameIndex-impl(nameAndType)), index, this.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameAndType)), proto.hasVarargElementType() ? this.deserializeIrType(proto.getVarargElementType()) : null, ValueParameterFlags.isCrossInline-impl(flags), ValueParameterFlags.isNoInline-impl(flags), ValueParameterFlags.isHidden-impl(flags), ValueParameterFlags.isAssignable-impl(flags));
            boolean bl2 = false;
            if (proto.hasDefaultValue()) {
                IrExpressionBody irExpressionBody = this.deserializeExpressionBody(proto.getDefaultValue());
                if (irExpressionBody == null) {
                    irExpressionBody = this.irFactory.createExpressionBody(new IrCompositeImpl((int)startOffset, (int)endOffset, $this$deserializeIrValueParameter_u24lambda_u2410_u24lambda_u249.getType(), null, 8, null));
                }
                $this$deserializeIrValueParameter_u24lambda_u2410_u24lambda_u249.setDefaultValue(irExpressionBody);
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = irValueParameter;
            List<IrConstructorCall> list = proto$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result$iv.setAnnotations(this_$iv.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            irDeclaration = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrValueParameter)irDeclaration;
    }

    static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrValueParameter deserializeIrValueParameter$default(IrDeclarationDeserializer irDeclarationDeserializer, IrValueParameter irValueParameter, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return irDeclarationDeserializer.deserializeIrValueParameter(irValueParameter, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrClass deserializeIrClass(IrClass proto, boolean setParent) {
        Object object;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void this_$iv2;
            void $this$usingParent$iv;
            void var26_24;
            void origin;
            void endOffset;
            void startOffset;
            void signature;
            void fcode;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = ((IrDeclarationDeserializer)this_$iv).deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            boolean $i$f$checkSymbolType = false;
            if (!(symbol2 instanceof IrClassSymbol)) {
                throw new IrSymbolTypeMismatchException(IrClassSymbol.class, symbol2);
            }
            long flags = ClassFlags.Companion.decode-K2PyDQs((long)fcode);
            Modality effectiveModality = ClassFlags.getKind-impl(flags) == ClassKind.ANNOTATION_CLASS ? Modality.OPEN : ClassFlags.getModality-impl(flags);
            IrDeclarationDeserializer irDeclarationDeserializer2 = this;
            IrDeclarationParent irDeclarationParent = this.symbolTable.declareClass((IdSignature)signature, (Function0<? extends IrClassSymbol>)((Function0)new Function0<IrClassSymbol>(symbol2){
                final /* synthetic */ IrSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrClassSymbol invoke() {
                    return (IrClassSymbol)this.$symbol;
                }
            }), (Function1<? super IrClassSymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrClass>)((Function1)new Function1<IrClassSymbol, org.jetbrains.kotlin.ir.declarations.IrClass>(this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, proto, flags, effectiveModality){
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                final /* synthetic */ IrClass $proto;
                final /* synthetic */ long $flags;
                final /* synthetic */ Modality $effectiveModality;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    this.$proto = $proto;
                    this.$flags = $flags;
                    this.$effectiveModality = $effectiveModality;
                    super(1);
                }

                @NotNull
                public final org.jetbrains.kotlin.ir.declarations.IrClass invoke(@NotNull IrClassSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return IrFactory.DefaultImpls.createClass$default(this.this$0.getIrFactory(), this.$startOffset, this.$endOffset, this.$origin, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, this.$proto.getName()), ClassFlags.getKind-impl(this.$flags), ClassFlags.getVisibility-impl(this.$flags), this.$effectiveModality, ClassFlags.isCompanion-impl(this.$flags), ClassFlags.isInner-impl(this.$flags), ClassFlags.isData-impl(this.$flags), ClassFlags.isExternal-impl(this.$flags) || IrDeclarationDeserializer.access$isEffectivelyExternal$p(this.this$0), ClassFlags.isValue-impl(this.$flags), ClassFlags.isExpect-impl(this.$flags), ClassFlags.isFun-impl(this.$flags), null, 32768, null);
                }
            }));
            boolean $i$f$usingParent = false;
            void $this$usingParent_u24lambda_u246$iv = var26_24 = $this$usingParent$iv;
            boolean bl2 = false;
            IrDeclarationParent oldParent$iv = ((IrDeclarationDeserializer)this_$iv2).currentParent;
            ((IrDeclarationDeserializer)this_$iv2).currentParent = (IrDeclarationParent)$this$usingParent_u24lambda_u246$iv;
            try {
                void $this$mapTo$iv$iv;
                ValueClassRepresentation valueClassRepresentation2;
                Object destination$iv;
                Iterable this_$iv3;
                Collection collection;
                void $this$mapTo$iv$iv2;
                IrDeclarationDeserializer $this$map$iv;
                org.jetbrains.kotlin.ir.declarations.IrClass $this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417 = (org.jetbrains.kotlin.ir.declarations.IrClass)$this$usingParent_u24lambda_u246$iv;
                boolean bl3 = false;
                List<IrTypeParameter> list = proto.getTypeParameterList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"proto.typeParameterList");
                $this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417.setTypeParameters(this.deserializeTypeParameters(list, true));
                List<Integer> list2 = proto.getSuperTypeList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.superTypeList");
                Iterable iterable = list2;
                org.jetbrains.kotlin.ir.declarations.IrClass irClass = $this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417;
                boolean $i$f$map = false;
                void var35_33 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Integer n3 = (Integer)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(this.deserializeIrType(it.intValue()));
                }
                irClass.setSuperTypes((List)destination$iv$iv);
                $this$map$iv = this;
                boolean value$iv = $this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417.isExternal();
                boolean $i$f$withExternalValue22 = false;
                boolean oldExternalValue$iv = ((IrDeclarationDeserializer)((Object)this_$iv3)).isEffectivelyExternal;
                ((IrDeclarationDeserializer)((Object)this_$iv3)).isEffectivelyExternal = value$iv;
                try {
                    void $this$mapNotNullTo$iv;
                    void $this$filterNotTo$iv$iv;
                    Iterable $this$filterNot$iv;
                    Object item$iv$iv;
                    boolean bl5 = false;
                    Set oldDeclarations = CollectionsKt.toSet((Iterable)$this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417.getDeclarations());
                    List<IrDeclaration> list3 = proto.getDeclarationList();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"proto.declarationList");
                    item$iv$iv = list3;
                    boolean $i$f$filterNot = false;
                    void bl4 = $this$filterNot$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                        IrDeclaration it = (IrDeclaration)element$iv$iv;
                        boolean bl6 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (this.isSkippableFakeOverride(it, $this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filterNot$iv = (List)destination$iv$iv2;
                    destination$iv = $this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417.getDeclarations();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        org.jetbrains.kotlin.ir.declarations.IrDeclaration it$iv;
                        org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration;
                        Object element$iv$iv;
                        Object element$iv = element$iv$iv = iterator.next();
                        boolean bl7 = false;
                        IrDeclaration declProto = (IrDeclaration)element$iv;
                        boolean bl8 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)declProto, (String)"declProto");
                        org.jetbrains.kotlin.ir.declarations.IrDeclaration it = irDeclaration = IrDeclarationDeserializer.deserializeDeclaration$default(this, declProto, false, 2, null);
                        boolean bl9 = false;
                        if ((!oldDeclarations.contains(it) ? irDeclaration : null) == null) continue;
                        it$iv = it$iv;
                        boolean bl10 = false;
                        destination$iv.add(it$iv);
                    }
                }
                finally {
                    ((IrDeclarationDeserializer)((Object)this_$iv3)).isEffectivelyExternal = oldExternalValue$iv;
                }
                IrValueParameter irValueParameter = proto.getThisReceiver();
                Intrinsics.checkNotNullExpressionValue((Object)irValueParameter, (String)"proto.thisReceiver");
                $this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417.setThisReceiver(IrDeclarationDeserializer.deserializeIrValueParameter$default(this, irValueParameter, -1, false, 4, null));
                if (!ClassFlags.isValue-impl(flags)) {
                    valueClassRepresentation2 = null;
                } else {
                    if (proto.hasMultiFieldValueClassRepresentation() && proto.hasInlineClassRepresentation()) {
                        throw new IllegalStateException(("Class cannot be both inline and multi-field value: " + $this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417.getName()).toString());
                    }
                    if (proto.hasInlineClassRepresentation()) {
                        IrInlineClassRepresentation irInlineClassRepresentation = proto.getInlineClassRepresentation();
                        Intrinsics.checkNotNullExpressionValue((Object)irInlineClassRepresentation, (String)"proto.inlineClassRepresentation");
                        valueClassRepresentation2 = (ValueClassRepresentation)this.deserializeInlineClassRepresentation(irInlineClassRepresentation);
                    } else if (proto.hasMultiFieldValueClassRepresentation()) {
                        IrMultiFieldValueClassRepresentation irMultiFieldValueClassRepresentation = proto.getMultiFieldValueClassRepresentation();
                        Intrinsics.checkNotNullExpressionValue((Object)irMultiFieldValueClassRepresentation, (String)"proto.multiFieldValueClassRepresentation");
                        valueClassRepresentation2 = (ValueClassRepresentation)this.deserializeMultiFieldValueClassRepresentation(irMultiFieldValueClassRepresentation);
                    } else {
                        valueClassRepresentation2 = (ValueClassRepresentation)this.computeMissingInlineClassRepresentationForCompatibility($this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417);
                    }
                }
                $this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417.setValueClassRepresentation(valueClassRepresentation2);
                List<Long> list4 = proto.getSealedSubclassList();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"proto.sealedSubclassList");
                this_$iv3 = list4;
                irClass = $this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417;
                $i$f$map = false;
                IrDeclarationDeserializer $i$f$withExternalValue22 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    destination$iv = (Long)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl11 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    IrSymbol irSymbol = this.deserializeIrSymbol$ir_serialization_common(it.longValue());
                    Intrinsics.checkNotNull((Object)irSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
                    collection.add((IrClassSymbol)irSymbol);
                }
                irClass.setSealedSubclasses((List)destination$iv$iv);
                this.fakeOverrideBuilder.enqueueClass($this$deserializeIrClass_u24lambda_u2418_u24lambda_u2417, (IdSignature)signature, this.compatibilityMode);
            }
            finally {
                ((IrDeclarationDeserializer)this_$iv2).currentParent = oldParent$iv;
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = (org.jetbrains.kotlin.ir.declarations.IrClass)var26_24;
            List<IrConstructorCall> list = proto$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result$iv.setAnnotations(this_$iv.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrClass)object;
    }

    static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrClass deserializeIrClass$default(IrDeclarationDeserializer irDeclarationDeserializer, IrClass irClass, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return irDeclarationDeserializer.deserializeIrClass(irClass, bl);
    }

    private final InlineClassRepresentation<org.jetbrains.kotlin.ir.types.IrSimpleType> deserializeInlineClassRepresentation(IrInlineClassRepresentation proto) {
        Name name = this.deserializeName(proto.getUnderlyingPropertyName());
        org.jetbrains.kotlin.ir.types.IrType irType = this.deserializeIrType(proto.getUnderlyingPropertyType());
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        return new InlineClassRepresentation(name, (SimpleTypeMarker)((org.jetbrains.kotlin.ir.types.IrSimpleType)irType));
    }

    /*
     * WARNING - void declaration
     */
    private final MultiFieldValueClassRepresentation<org.jetbrains.kotlin.ir.types.IrSimpleType> deserializeMultiFieldValueClassRepresentation(IrMultiFieldValueClassRepresentation proto) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List<Integer> list = proto.getUnderlyingPropertyNameList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"proto.underlyingPropertyNameList");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Integer n = (Integer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.deserializeName(it.intValue()));
        }
        List names = (List)destination$iv$iv;
        List<Integer> list2 = proto.getUnderlyingPropertyTypeList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.underlyingPropertyTypeList");
        Iterable $this$map$iv2 = list2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Integer bl = (Integer)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            org.jetbrains.kotlin.ir.types.IrType irType = this.deserializeIrType(it.intValue());
            Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            collection.add((org.jetbrains.kotlin.ir.types.IrSimpleType)irType);
        }
        List types = (List)destination$iv$iv2;
        return new MultiFieldValueClassRepresentation(CollectionsKt.zip((Iterable)names, (Iterable)types));
    }

    private final InlineClassRepresentation<org.jetbrains.kotlin.ir.types.IrSimpleType> computeMissingInlineClassRepresentationForCompatibility(org.jetbrains.kotlin.ir.declarations.IrClass irClass) {
        org.jetbrains.kotlin.ir.declarations.IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(irClass);
        if (irConstructor == null) {
            throw new IllegalStateException(("Inline class has no primary constructor: " + RenderIrElementKt.render(irClass)).toString());
        }
        org.jetbrains.kotlin.ir.declarations.IrConstructor ctor = irConstructor;
        org.jetbrains.kotlin.ir.declarations.IrValueParameter irValueParameter = (org.jetbrains.kotlin.ir.declarations.IrValueParameter)CollectionsKt.singleOrNull(ctor.getValueParameters());
        if (irValueParameter == null) {
            throw new IllegalStateException(("Failed to get single parameter of inline class constructor: " + RenderIrElementKt.render(ctor)).toString());
        }
        org.jetbrains.kotlin.ir.declarations.IrValueParameter parameter = irValueParameter;
        Name name = parameter.getName();
        org.jetbrains.kotlin.ir.types.IrType irType = parameter.getType();
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        return new InlineClassRepresentation(name, (SimpleTypeMarker)((org.jetbrains.kotlin.ir.types.IrSimpleType)irType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrTypeAlias deserializeIrTypeAlias(IrTypeAlias proto, boolean setParent) {
        Object object;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void this_$iv2;
            void $this$usingParent$iv;
            void var22_22;
            void origin;
            void endOffset;
            void startOffset;
            void fcode;
            void uniqId;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = ((IrDeclarationDeserializer)this_$iv).deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            boolean $i$f$checkSymbolType22 = false;
            if (!(symbol2 instanceof IrTypeAliasSymbol)) {
                throw new IrSymbolTypeMismatchException(IrTypeAliasSymbol.class, symbol2);
            }
            IrDeclarationDeserializer $i$f$checkSymbolType22 = this;
            IrDeclarationParent irDeclarationParent = this.symbolTable.declareTypeAlias((IdSignature)uniqId, (Function0<? extends IrTypeAliasSymbol>)((Function0)new Function0<IrTypeAliasSymbol>(symbol2){
                final /* synthetic */ IrSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrTypeAliasSymbol invoke() {
                    return (IrTypeAliasSymbol)this.$symbol;
                }
            }), (Function1<? super IrTypeAliasSymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrTypeAlias>)((Function1)new Function1<IrTypeAliasSymbol, org.jetbrains.kotlin.ir.declarations.IrTypeAlias>((long)fcode, proto, this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin){
                final /* synthetic */ long $fcode;
                final /* synthetic */ IrTypeAlias $proto;
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                {
                    this.$fcode = $fcode;
                    this.$proto = $proto;
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    super(1);
                }

                @NotNull
                public final org.jetbrains.kotlin.ir.declarations.IrTypeAlias invoke(@NotNull IrTypeAliasSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    long flags = TypeAliasFlags.Companion.decode-OrzgV44(this.$fcode);
                    long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(this.$proto.getNameType());
                    return this.this$0.getIrFactory().createTypeAlias(this.$startOffset, this.$endOffset, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, BinaryNameAndType.getNameIndex-impl(nameType)), TypeAliasFlags.getVisibility-impl(flags), this.this$0.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType)), TypeAliasFlags.isActual-impl(flags), this.$origin);
                }
            }));
            boolean $i$f$usingParent = false;
            void $this$usingParent_u24lambda_u246$iv = var22_22 = $this$usingParent$iv;
            boolean bl2 = false;
            IrDeclarationParent oldParent$iv = ((IrDeclarationDeserializer)this_$iv2).currentParent;
            ((IrDeclarationDeserializer)this_$iv2).currentParent = (IrDeclarationParent)$this$usingParent_u24lambda_u246$iv;
            try {
                org.jetbrains.kotlin.ir.declarations.IrTypeAlias $this$deserializeIrTypeAlias_u24lambda_u2422_u24lambda_u2421 = (org.jetbrains.kotlin.ir.declarations.IrTypeAlias)$this$usingParent_u24lambda_u246$iv;
                boolean bl3 = false;
                List<IrTypeParameter> list = proto.getTypeParameterList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"proto.typeParameterList");
                $this$deserializeIrTypeAlias_u24lambda_u2422_u24lambda_u2421.setTypeParameters(this.deserializeTypeParameters(list, true));
            }
            finally {
                ((IrDeclarationDeserializer)this_$iv2).currentParent = oldParent$iv;
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = (org.jetbrains.kotlin.ir.declarations.IrTypeAlias)var22_22;
            List<IrConstructorCall> list = proto$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result$iv.setAnnotations(this_$iv.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrTypeAlias)object;
    }

    static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrTypeAlias deserializeIrTypeAlias$default(IrDeclarationDeserializer irDeclarationDeserializer, IrTypeAlias irTypeAlias, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return irDeclarationDeserializer.deserializeIrTypeAlias(irTypeAlias, bl);
    }

    private final org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration deserializeErrorDeclaration(IrErrorDeclaration proto, boolean setParent) {
        org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration irErrorDeclaration;
        boolean errorNodesAllowed$iv = this.allowErrorNodes;
        boolean $i$f$checkErrorNodesAllowed = false;
        if (!errorNodesAllowed$iv) {
            throw new IrDisallowedErrorNode(org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration.class);
        }
        long coordinates = BinaryCoordinates.Companion.decode-ViYoqTc(proto.getCoordinates());
        org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration it = irErrorDeclaration = IrFactory.DefaultImpls.createErrorDeclaration$default(this.irFactory, BinaryCoordinates.getStartOffset-impl(coordinates), BinaryCoordinates.getEndOffset-impl(coordinates), null, 4, null);
        boolean bl = false;
        if (setParent) {
            it.setParent(this.currentParent);
        }
        return irErrorDeclaration;
    }

    static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration deserializeErrorDeclaration$default(IrDeclarationDeserializer irDeclarationDeserializer, IrErrorDeclaration irErrorDeclaration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return irDeclarationDeserializer.deserializeErrorDeclaration(irErrorDeclaration, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<org.jetbrains.kotlin.ir.declarations.IrTypeParameter> deserializeTypeParameters(List<IrTypeParameter> protos, boolean isGlobal) {
        Object proto;
        ArrayList<org.jetbrains.kotlin.ir.declarations.IrTypeParameter> result2 = new ArrayList<org.jetbrains.kotlin.ir.declarations.IrTypeParameter>(protos.size());
        int n = protos.size();
        for (int index = 0; index < n; ++index) {
            proto = protos.get(index);
            result2.add(IrDeclarationDeserializer.deserializeIrTypeParameter$default(this, (IrTypeParameter)proto, index, isGlobal, false, 8, null));
        }
        n = protos.size();
        for (int i = 0; i < n; ++i) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            org.jetbrains.kotlin.ir.declarations.IrTypeParameter irTypeParameter = (org.jetbrains.kotlin.ir.declarations.IrTypeParameter)result2.get(i);
            List<Integer> list = protos.get(i).getSuperTypeList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"protos[i].superTypeList");
            proto = list;
            org.jetbrains.kotlin.ir.declarations.IrTypeParameter irTypeParameter2 = irTypeParameter;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Integer n2 = (Integer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(this.deserializeIrType(it.intValue()));
            }
            irTypeParameter2.setSuperTypes((List)destination$iv$iv);
        }
        return result2;
    }

    private final List<org.jetbrains.kotlin.ir.declarations.IrValueParameter> deserializeValueParameters(List<IrValueParameter> protos) {
        ArrayList<org.jetbrains.kotlin.ir.declarations.IrValueParameter> result2 = new ArrayList<org.jetbrains.kotlin.ir.declarations.IrValueParameter>(protos.size());
        int n = protos.size();
        for (int i = 0; i < n; ++i) {
            result2.add(IrDeclarationDeserializer.deserializeIrValueParameter$default(this, protos.get(i), i, false, 4, null));
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkObjectLeak(org.jetbrains.kotlin.ir.types.IrType $this$checkObjectLeak) {
        boolean bl;
        if (!($this$checkObjectLeak instanceof org.jetbrains.kotlin.ir.types.IrSimpleType)) return false;
        IdSignature signature = ((org.jetbrains.kotlin.ir.types.IrSimpleType)$this$checkObjectLeak).getClassifier().getSignature();
        if ((signature == null || signature.isLocal()) && !(((org.jetbrains.kotlin.ir.types.IrSimpleType)$this$checkObjectLeak).getClassifier() instanceof IrTypeParameterSymbol)) {
            return true;
        }
        boolean bl2 = false;
        boolean possibleLeakedClassifier = bl2;
        if (possibleLeakedClassifier) return true;
        Iterable $this$any$iv = ((org.jetbrains.kotlin.ir.types.IrSimpleType)$this$checkObjectLeak).getArguments();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            IrTypeArgument it = (IrTypeArgument)element$iv;
            boolean bl3 = false;
            org.jetbrains.kotlin.ir.types.IrType irType = IrTypesKt.getTypeOrNull(it);
            if (irType != null) {
                if (this.checkObjectLeak(irType)) {
                    return true;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends org.jetbrains.kotlin.ir.declarations.IrFunction> void withBodyGuard(T $this$withBodyGuard, Function1<? super T, Unit> block) {
        boolean oldBodiesPolicy = this.deserializeBodies;
        try {
            this.deserializeBodies = oldBodiesPolicy || IrDeclarationDeserializer.withBodyGuard$checkInlineBody(this, $this$withBodyGuard) || this.checkObjectLeak($this$withBodyGuard.getReturnType());
            block.invoke($this$withBodyGuard);
        }
        finally {
            this.deserializeBodies = oldBodiesPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withInitializerGuard(org.jetbrains.kotlin.ir.declarations.IrField $this$withInitializerGuard, boolean isConst, Function1<? super org.jetbrains.kotlin.ir.declarations.IrField, Unit> f) {
        boolean oldBodiesPolicy = this.deserializeBodies;
        try {
            this.deserializeBodies = isConst || oldBodiesPolicy || this.checkObjectLeak($this$withInitializerGuard.getType());
            f.invoke((Object)$this$withInitializerGuard);
        }
        finally {
            this.deserializeBodies = oldBodiesPolicy;
        }
    }

    private final IrStatement loadStatementBodyProto(int index) {
        return this.libraryFile.statementBody(index);
    }

    private final IrExpression loadExpressionBodyProto(int index) {
        return this.libraryFile.expressionBody(index);
    }

    @Nullable
    public final IrExpressionBody deserializeExpressionBody(int index) {
        IrExpressionBody irExpressionBody;
        if (this.deserializeBodies) {
            IrExpression bodyData = this.loadExpressionBodyProto(index);
            irExpressionBody = this.irFactory.createExpressionBody(this.bodyDeserializer.deserializeExpression(bodyData));
        } else {
            irExpressionBody = null;
        }
        return irExpressionBody;
    }

    @Nullable
    public final IrElement deserializeStatementBody(int index) {
        IrElement irElement;
        if (this.deserializeBodies) {
            IrStatement bodyData = this.loadStatementBodyProto(index);
            irElement = this.bodyDeserializer.deserializeStatement$ir_serialization_common(bodyData);
        } else {
            irElement = null;
        }
        return irElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <T extends org.jetbrains.kotlin.ir.declarations.IrFunction> T withDeserializedIrFunctionBase(IrFunctionBase proto, boolean setParent, Function6<? super IrFunctionSymbol, ? super IdSignature, ? super Integer, ? super Integer, ? super IrDeclarationOrigin, ? super Long, ? extends T> block) {
        Object object;
        void this_$iv;
        boolean $i$f$withDeserializedIrFunctionBase = false;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void this_$iv2;
            IrDeclarationParent irDeclarationParent;
            void fcode;
            void origin;
            void endOffset;
            void startOffset;
            void idSig;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = ((IrDeclarationDeserializer)this_$iv).deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            SymbolTable $this$withScope$iv = this.symbolTable;
            boolean $i$f$withScope = false;
            $this$withScope$iv.enterScope(symbol2);
            SymbolTable $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427 = $this$withScope$iv;
            boolean bl2 = false;
            IrDeclarationDeserializer irDeclarationDeserializer2 = this;
            boolean $i$f$checkSymbolType = false;
            if (!(symbol2 instanceof IrFunctionSymbol)) {
                throw new IrSymbolTypeMismatchException(IrFunctionSymbol.class, symbol2);
            }
            IrDeclarationParent $this$usingParent$iv = (IrDeclarationParent)block.invoke((Object)symbol2, (Object)idSig, (Object)((int)startOffset), (Object)((int)endOffset), (Object)origin, (Object)((long)fcode));
            boolean $i$f$usingParent = false;
            IrDeclarationParent $this$usingParent_u24lambda_u246$iv = irDeclarationParent = $this$usingParent$iv;
            boolean bl3 = false;
            IrDeclarationParent oldParent$iv = ((IrDeclarationDeserializer)this_$iv2).currentParent;
            ((IrDeclarationDeserializer)this_$iv2).currentParent = $this$usingParent_u24lambda_u246$iv;
            try {
                org.jetbrains.kotlin.ir.declarations.IrFunction $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426 = (org.jetbrains.kotlin.ir.declarations.IrFunction)$this$usingParent_u24lambda_u246$iv;
                boolean bl4 = false;
                List<IrTypeParameter> list = proto.getTypeParameterList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"proto.typeParameterList");
                $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setTypeParameters(this.deserializeTypeParameters(list, false));
                long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType());
                $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setReturnType(this.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType)));
                this.withBodyGuard($this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426, new Function1<T, Unit>(this, proto){
                    final /* synthetic */ IrDeclarationDeserializer this$0;
                    final /* synthetic */ IrFunctionBase $proto;
                    {
                        this.this$0 = $receiver;
                        this.$proto = $proto;
                        super(1);
                    }

                    public final void invoke(@NotNull T $this$withBodyGuard) {
                        org.jetbrains.kotlin.ir.declarations.IrValueParameter irValueParameter;
                        org.jetbrains.kotlin.ir.declarations.IrValueParameter irValueParameter2;
                        Intrinsics.checkNotNullParameter($this$withBodyGuard, (String)"$this$withBodyGuard");
                        List<IrValueParameter> list = this.$proto.getValueParameterList();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"proto.valueParameterList");
                        ((org.jetbrains.kotlin.ir.declarations.IrFunction)$this$withBodyGuard).setValueParameters(IrDeclarationDeserializer.access$deserializeValueParameters(this.this$0, list));
                        if (this.$proto.hasDispatchReceiver()) {
                            IrValueParameter irValueParameter3 = this.$proto.getDispatchReceiver();
                            Intrinsics.checkNotNullExpressionValue((Object)irValueParameter3, (String)"proto.dispatchReceiver");
                            irValueParameter2 = IrDeclarationDeserializer.deserializeIrValueParameter$default(this.this$0, irValueParameter3, -1, false, 4, null);
                        } else {
                            irValueParameter2 = null;
                        }
                        ((org.jetbrains.kotlin.ir.declarations.IrFunction)$this$withBodyGuard).setDispatchReceiverParameter(irValueParameter2);
                        if (this.$proto.hasExtensionReceiver()) {
                            IrValueParameter irValueParameter4 = this.$proto.getExtensionReceiver();
                            Intrinsics.checkNotNullExpressionValue((Object)irValueParameter4, (String)"proto.extensionReceiver");
                            irValueParameter = IrDeclarationDeserializer.deserializeIrValueParameter$default(this.this$0, irValueParameter4, -1, false, 4, null);
                        } else {
                            irValueParameter = null;
                        }
                        ((org.jetbrains.kotlin.ir.declarations.IrFunction)$this$withBodyGuard).setExtensionReceiverParameter(irValueParameter);
                        ((org.jetbrains.kotlin.ir.declarations.IrFunction)$this$withBodyGuard).setContextReceiverParametersCount(this.$proto.hasContextReceiverParametersCount() ? this.$proto.getContextReceiverParametersCount() : 0);
                        ((org.jetbrains.kotlin.ir.declarations.IrFunction)$this$withBodyGuard).setBody(this.$proto.hasBody() ? (IrBody)this.this$0.deserializeStatementBody(this.$proto.getBody()) : null);
                    }
                });
            }
            finally {
                InlineMarker.finallyStart((int)1);
                ((IrDeclarationDeserializer)this_$iv2).currentParent = oldParent$iv;
                InlineMarker.finallyEnd((int)1);
            }
            org.jetbrains.kotlin.ir.declarations.IrFunction result$iv = (org.jetbrains.kotlin.ir.declarations.IrFunction)irDeclarationParent;
            $this$withScope$iv.leaveScope(symbol2);
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv2 = result$iv;
            List<IrConstructorCall> list = proto$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result$iv2.setAnnotations(this_$iv.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result$iv2.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)((org.jetbrains.kotlin.ir.declarations.IrFunction)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrFunction withDeserializedIrFunctionBase$default(IrDeclarationDeserializer $this, IrFunctionBase proto, boolean setParent, Function6 block, int n, Object object) {
        Object object2;
        void this_$iv;
        if ((n & 2) != 0) {
            setParent = true;
        }
        boolean $i$f$withDeserializedIrFunctionBase = false;
        object = $this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void this_$iv2;
            IrDeclarationParent irDeclarationParent;
            void fcode;
            void origin;
            void endOffset;
            void startOffset;
            void idSig;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = ((IrDeclarationDeserializer)this_$iv).deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n2 = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n3 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object2 = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            SymbolTable $this$withScope$iv = $this.symbolTable;
            boolean $i$f$withScope = false;
            $this$withScope$iv.enterScope(symbol2);
            SymbolTable $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427 = $this$withScope$iv;
            boolean bl2 = false;
            IrDeclarationDeserializer irDeclarationDeserializer = $this;
            boolean $i$f$checkSymbolType = false;
            if (!(symbol2 instanceof IrFunctionSymbol)) {
                throw new IrSymbolTypeMismatchException(IrFunctionSymbol.class, symbol2);
            }
            IrDeclarationParent $this$usingParent$iv = (IrDeclarationParent)block.invoke((Object)symbol2, (Object)idSig, (Object)((int)startOffset), (Object)((int)endOffset), (Object)origin, (Object)((long)fcode));
            boolean $i$f$usingParent = false;
            IrDeclarationParent $this$usingParent_u24lambda_u246$iv = irDeclarationParent = $this$usingParent$iv;
            boolean bl3 = false;
            IrDeclarationParent oldParent$iv = ((IrDeclarationDeserializer)this_$iv2).currentParent;
            ((IrDeclarationDeserializer)this_$iv2).currentParent = $this$usingParent_u24lambda_u246$iv;
            try {
                org.jetbrains.kotlin.ir.declarations.IrFunction $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426 = (org.jetbrains.kotlin.ir.declarations.IrFunction)$this$usingParent_u24lambda_u246$iv;
                boolean bl4 = false;
                List<IrTypeParameter> list = proto.getTypeParameterList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"proto.typeParameterList");
                $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setTypeParameters($this.deserializeTypeParameters(list, false));
                long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType());
                $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setReturnType($this.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType)));
                $this.withBodyGuard($this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426, new /* invalid duplicate definition of identical inner class */);
            }
            finally {
                InlineMarker.finallyStart((int)1);
                ((IrDeclarationDeserializer)this_$iv2).currentParent = oldParent$iv;
                InlineMarker.finallyEnd((int)1);
            }
            org.jetbrains.kotlin.ir.declarations.IrFunction result$iv = (org.jetbrains.kotlin.ir.declarations.IrFunction)irDeclarationParent;
            $this$withScope$iv.leaveScope(symbol2);
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv2 = result$iv;
            List<IrConstructorCall> list = proto$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result$iv2.setAnnotations(this_$iv.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result$iv2.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object2 = result$iv2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
            InlineMarker.finallyEnd((int)1);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrFunction)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final IrSimpleFunction deserializeIrFunction$ir_serialization_common(@NotNull IrFunction proto, boolean setParent) {
        Object object;
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrFunctionBase irFunctionBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irFunctionBase, (String)"proto.base");
        IrFunctionBase proto$iv = irFunctionBase;
        boolean $i$f$withDeserializedIrFunctionBase = false;
        void var6_6 = this_$iv;
        IrDeclarationBase irDeclarationBase = proto$iv.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv$iv.getSymbol());
        IrSymbol s$iv$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv$iv = (IdSignature)pair.component2();
        long coordinates$iv$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv$iv.getCoordinates());
        try {
            void this_$iv$iv2;
            IrDeclarationParent irDeclarationParent;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void origin;
            void endOffset;
            void startOffset;
            void idSig;
            IrSimpleFunction irSimpleFunction;
            void fcode;
            void idSig$iv;
            void startOffset$iv;
            void endOffset$iv;
            void origin$iv;
            void fcode$iv;
            ((IrDeclarationDeserializer)this_$iv$iv).recordDelegatedSymbol(s$iv$iv);
            long l = proto$iv$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = ((IrDeclarationDeserializer)this_$iv$iv).deserializeIrDeclarationOrigin(proto$iv$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv$iv);
            object = uid$iv$iv;
            IrSymbol symbol$iv = s$iv$iv;
            boolean bl = false;
            SymbolTable $this$withScope$iv$iv = ((IrDeclarationDeserializer)this_$iv).symbolTable;
            boolean $i$f$withScope = false;
            $this$withScope$iv$iv.enterScope(symbol$iv);
            SymbolTable $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427$iv = $this$withScope$iv$iv;
            boolean bl2 = false;
            void var26_25 = this_$iv;
            boolean $i$f$checkSymbolType = false;
            if (!(symbol$iv instanceof IrFunctionSymbol)) {
                throw new IrSymbolTypeMismatchException(IrFunctionSymbol.class, symbol$iv);
            }
            void var28_28 = fcode$iv;
            void var30_29 = origin$iv;
            void var31_30 = endOffset$iv;
            void var32_31 = startOffset$iv;
            void var33_32 = idSig$iv;
            IrFunctionSymbol symbol2 = (IrFunctionSymbol)symbol$iv;
            boolean bl3 = false;
            boolean $i$f$checkSymbolType2 = false;
            if (!((IrSymbol)symbol2 instanceof IrSimpleFunctionSymbol)) {
                throw new IrSymbolTypeMismatchException(IrSimpleFunctionSymbol.class, symbol2);
            }
            long flags = FunctionFlags.Companion.decode-UIJRpeM((long)fcode);
            IrSimpleFunction $this$deserializeIrFunction_u24lambda_u2431_u24lambda_u2430 = irSimpleFunction = this.symbolTable.declareSimpleFunction((IdSignature)idSig, (Function0<? extends IrSimpleFunctionSymbol>)((Function0)new Function0<IrSimpleFunctionSymbol>(symbol2){
                final /* synthetic */ IrFunctionSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrSimpleFunctionSymbol invoke() {
                    return (IrSimpleFunctionSymbol)this.$symbol;
                }
            }), (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)((Function1)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(proto, this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, flags){
                final /* synthetic */ IrFunction $proto;
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                final /* synthetic */ long $flags;
                {
                    this.$proto = $proto;
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    this.$flags = $flags;
                    super(1);
                }

                @NotNull
                public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(this.$proto.getBase().getNameType());
                    return IrFactory.DefaultImpls.createFunction$default(this.this$0.getIrFactory(), this.$startOffset, this.$endOffset, this.$origin, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, BinaryNameAndType.getNameIndex-impl(nameType)), FunctionFlags.getVisibility-impl(this.$flags), FunctionFlags.getModality-impl(this.$flags), IrUninitializedType.INSTANCE, FunctionFlags.isInline-impl(this.$flags), FunctionFlags.isExternal-impl(this.$flags) || IrDeclarationDeserializer.access$isEffectivelyExternal$p(this.this$0), FunctionFlags.isTailrec-impl(this.$flags), FunctionFlags.isSuspend-impl(this.$flags), FunctionFlags.isOperator-impl(this.$flags), FunctionFlags.isInfix-impl(this.$flags), FunctionFlags.isExpect-impl(this.$flags), FunctionFlags.isFakeOverride-impl(this.$flags), null, 65536, null);
                }
            }));
            boolean bl4 = false;
            List<Long> list = proto.getOverriddenList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.overriddenList");
            Iterable iterable = list;
            IrSimpleFunction irSimpleFunction2 = $this$deserializeIrFunction_u24lambda_u2431_u24lambda_u2430;
            boolean $i$f$map = false;
            void var45_44 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Long l2 = (Long)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                IrSymbol symbol$iv2 = this.deserializeIrSymbolAndRemap$ir_serialization_common(it.longValue());
                boolean $i$f$checkSymbolType3 = false;
                if (!(symbol$iv2 instanceof IrSimpleFunctionSymbol)) {
                    throw new IrSymbolTypeMismatchException(IrSimpleFunctionSymbol.class, symbol$iv2);
                }
                collection.add((IrSimpleFunctionSymbol)symbol$iv2);
            }
            irSimpleFunction2.setOverriddenSymbols((List)destination$iv$iv);
            IrDeclarationParent $this$usingParent$iv$iv = irSimpleFunction;
            boolean $i$f$usingParent = false;
            IrDeclarationParent $this$usingParent_u24lambda_u246$iv$iv = irDeclarationParent = $this$usingParent$iv$iv;
            boolean bl6 = false;
            IrDeclarationParent oldParent$iv$iv = ((IrDeclarationDeserializer)this_$iv$iv2).currentParent;
            ((IrDeclarationDeserializer)this_$iv$iv2).currentParent = $this$usingParent_u24lambda_u246$iv$iv;
            try {
                org.jetbrains.kotlin.ir.declarations.IrFunction $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426$iv = (org.jetbrains.kotlin.ir.declarations.IrFunction)$this$usingParent_u24lambda_u246$iv$iv;
                boolean bl7 = false;
                List<IrTypeParameter> list2 = proto$iv.getTypeParameterList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.typeParameterList");
                $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426$iv.setTypeParameters(((IrDeclarationDeserializer)this_$iv).deserializeTypeParameters(list2, false));
                long nameType$iv = BinaryNameAndType.Companion.decode-WXC2TjU(proto$iv.getNameType());
                $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426$iv.setReturnType(this_$iv.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType$iv)));
                ((IrDeclarationDeserializer)this_$iv).withBodyGuard($this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426$iv, new /* invalid duplicate definition of identical inner class */);
            }
            finally {
                ((IrDeclarationDeserializer)this_$iv$iv2).currentParent = oldParent$iv$iv;
            }
            org.jetbrains.kotlin.ir.declarations.IrFunction result$iv$iv = (org.jetbrains.kotlin.ir.declarations.IrFunction)irDeclarationParent;
            $this$withScope$iv$iv.leaveScope(symbol$iv);
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv$iv2 = result$iv$iv;
            List<IrConstructorCall> list3 = proto$iv$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"proto.annotationList");
            result$iv$iv2.setAnnotations(this_$iv$iv.deserializeAnnotations$ir_serialization_common(list3));
            if (setParent) {
                result$iv$iv2.setParent(((IrDeclarationDeserializer)this_$iv$iv).currentParent);
            }
            object = result$iv$iv2;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv$iv).eraseDelegatedSymbol(s$iv$iv);
        }
        return (IrSimpleFunction)((org.jetbrains.kotlin.ir.declarations.IrFunction)object);
    }

    public static /* synthetic */ IrSimpleFunction deserializeIrFunction$ir_serialization_common$default(IrDeclarationDeserializer irDeclarationDeserializer, IrFunction irFunction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return irDeclarationDeserializer.deserializeIrFunction$ir_serialization_common(irFunction, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final org.jetbrains.kotlin.ir.declarations.IrVariable deserializeIrVariable(@NotNull IrVariable proto, boolean setParent) {
        org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void origin;
            void endOffset;
            void startOffset;
            IrVariableImpl irVariableImpl;
            void fcode;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = ((IrDeclarationDeserializer)this_$iv).deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            boolean $i$f$checkSymbolType = false;
            if (!(symbol2 instanceof IrVariableSymbol)) {
                throw new IrSymbolTypeMismatchException(IrVariableSymbol.class, symbol2);
            }
            long flags = LocalVariableFlags.Companion.decode-QnIyQoc((long)fcode);
            long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType());
            IrVariableImpl $this$deserializeIrVariable_u24lambda_u2433_u24lambda_u2432 = irVariableImpl = new IrVariableImpl((int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, (IrVariableSymbol)symbol2, this.deserializeName(BinaryNameAndType.getNameIndex-impl(nameType)), this.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType)), LocalVariableFlags.isVar-impl(flags), LocalVariableFlags.isConst-impl(flags), LocalVariableFlags.isLateinit-impl(flags));
            boolean bl2 = false;
            if (proto.hasInitializer()) {
                IrExpression irExpression = proto.getInitializer();
                Intrinsics.checkNotNullExpressionValue((Object)irExpression, (String)"proto.initializer");
                $this$deserializeIrVariable_u24lambda_u2433_u24lambda_u2432.setInitializer(this.bodyDeserializer.deserializeExpression(irExpression));
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = irVariableImpl;
            List<IrConstructorCall> list = proto$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result$iv.setAnnotations(this_$iv.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            irDeclaration = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrVariable)irDeclaration;
    }

    public static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrVariable deserializeIrVariable$default(IrDeclarationDeserializer irDeclarationDeserializer, IrVariable irVariable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return irDeclarationDeserializer.deserializeIrVariable(irVariable, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrEnumEntry deserializeIrEnumEntry(IrEnumEntry proto, boolean setParent) {
        Object object;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void origin;
            void endOffset;
            void startOffset;
            void uniqId;
            org.jetbrains.kotlin.ir.declarations.IrEnumEntry irEnumEntry;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            int n = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            IrDeclarationOriginImpl irDeclarationOriginImpl = ((IrDeclarationDeserializer)this_$iv).deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = irDeclarationOriginImpl;
            int n3 = n2;
            int n4 = n;
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            org.jetbrains.kotlin.ir.declarations.IrEnumEntry $this$deserializeIrEnumEntry_u24lambda_u2435_u24lambda_u2434 = irEnumEntry = this.symbolTable.declareEnumEntry((IdSignature)uniqId, (Function0<? extends IrEnumEntrySymbol>)((Function0)new Function0<IrEnumEntrySymbol>(symbol2){
                final /* synthetic */ IrSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final IrEnumEntrySymbol invoke() {
                    void var1_1;
                    IrSymbol symbol$iv = this.$symbol;
                    boolean $i$f$checkSymbolType = false;
                    if (!(symbol$iv instanceof IrEnumEntrySymbol)) {
                        throw new IrSymbolTypeMismatchException(IrEnumEntrySymbol.class, symbol$iv);
                    }
                    return (IrEnumEntrySymbol)var1_1;
                }
            }), (Function1<? super IrEnumEntrySymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrEnumEntry>)((Function1)new Function1<IrEnumEntrySymbol, org.jetbrains.kotlin.ir.declarations.IrEnumEntry>(this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, proto){
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                final /* synthetic */ IrEnumEntry $proto;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    this.$proto = $proto;
                    super(1);
                }

                @NotNull
                public final org.jetbrains.kotlin.ir.declarations.IrEnumEntry invoke(@NotNull IrEnumEntrySymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.getIrFactory().createEnumEntry(this.$startOffset, this.$endOffset, this.$origin, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, this.$proto.getName()));
                }
            }));
            boolean bl2 = false;
            if (proto.hasCorrespondingClass()) {
                IrClass irClass = proto.getCorrespondingClass();
                Intrinsics.checkNotNullExpressionValue((Object)irClass, (String)"proto.correspondingClass");
                $this$deserializeIrEnumEntry_u24lambda_u2435_u24lambda_u2434.setCorrespondingClass(IrDeclarationDeserializer.deserializeIrClass$default(this, irClass, false, 2, null));
            }
            if (proto.hasInitializer()) {
                $this$deserializeIrEnumEntry_u24lambda_u2435_u24lambda_u2434.setInitializerExpression(this.deserializeExpressionBody(proto.getInitializer()));
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = irEnumEntry;
            List<IrConstructorCall> list = proto$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result$iv.setAnnotations(this_$iv.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrEnumEntry)object;
    }

    static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrEnumEntry deserializeIrEnumEntry$default(IrDeclarationDeserializer irDeclarationDeserializer, IrEnumEntry irEnumEntry, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return irDeclarationDeserializer.deserializeIrEnumEntry(irEnumEntry, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IrAnonymousInitializer deserializeIrAnonymousInit(IrAnonymousInit proto, boolean setParent) {
        org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void origin;
            void endOffset;
            void startOffset;
            IrAnonymousInitializer irAnonymousInitializer;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            int n = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            IrDeclarationOriginImpl irDeclarationOriginImpl = ((IrDeclarationDeserializer)this_$iv).deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = irDeclarationOriginImpl;
            int n3 = n2;
            int n4 = n;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            boolean $i$f$checkSymbolType = false;
            if (!(symbol2 instanceof IrAnonymousInitializerSymbol)) {
                throw new IrSymbolTypeMismatchException(IrAnonymousInitializerSymbol.class, symbol2);
            }
            IrAnonymousInitializer $this$deserializeIrAnonymousInit_u24lambda_u2437_u24lambda_u2436 = irAnonymousInitializer = IrFactory.DefaultImpls.createAnonymousInitializer$default(this.irFactory, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, (IrAnonymousInitializerSymbol)symbol2, false, 16, null);
            boolean bl2 = false;
            IrBlockBody irBlockBody = (IrBlockBody)this.deserializeStatementBody(proto.getBody());
            if (irBlockBody == null) {
                irBlockBody = this.irFactory.createBlockBody((int)startOffset, (int)endOffset);
            }
            $this$deserializeIrAnonymousInit_u24lambda_u2437_u24lambda_u2436.setBody(irBlockBody);
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = irAnonymousInitializer;
            List<IrConstructorCall> list = proto$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result$iv.setAnnotations(this_$iv.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            irDeclaration = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (IrAnonymousInitializer)irDeclaration;
    }

    static /* synthetic */ IrAnonymousInitializer deserializeIrAnonymousInit$default(IrDeclarationDeserializer irDeclarationDeserializer, IrAnonymousInit irAnonymousInit, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return irDeclarationDeserializer.deserializeIrAnonymousInit(irAnonymousInit, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrConstructor deserializeIrConstructor(IrConstructor proto, boolean setParent) {
        Object object;
        void this_$iv$iv;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrFunctionBase irFunctionBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irFunctionBase, (String)"proto.base");
        IrFunctionBase proto$iv = irFunctionBase;
        boolean $i$f$withDeserializedIrFunctionBase = false;
        void var6_6 = this_$iv;
        IrDeclarationBase irDeclarationBase = proto$iv.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv$iv.getSymbol());
        IrSymbol s$iv$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv$iv = (IdSignature)pair.component2();
        long coordinates$iv$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv$iv.getCoordinates());
        try {
            void this_$iv$iv2;
            IrDeclarationParent irDeclarationParent;
            void origin;
            void endOffset;
            void startOffset;
            void idSig;
            void fcode;
            void idSig$iv;
            void startOffset$iv;
            void endOffset$iv;
            void origin$iv;
            void fcode$iv;
            ((IrDeclarationDeserializer)this_$iv$iv).recordDelegatedSymbol(s$iv$iv);
            long l = proto$iv$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = ((IrDeclarationDeserializer)this_$iv$iv).deserializeIrDeclarationOrigin(proto$iv$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv$iv);
            object = uid$iv$iv;
            IrSymbol symbol$iv = s$iv$iv;
            boolean bl = false;
            SymbolTable $this$withScope$iv$iv = ((IrDeclarationDeserializer)this_$iv).symbolTable;
            boolean $i$f$withScope = false;
            $this$withScope$iv$iv.enterScope(symbol$iv);
            SymbolTable $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427$iv = $this$withScope$iv$iv;
            boolean bl2 = false;
            void var26_25 = this_$iv;
            boolean $i$f$checkSymbolType = false;
            if (!(symbol$iv instanceof IrFunctionSymbol)) {
                throw new IrSymbolTypeMismatchException(IrFunctionSymbol.class, symbol$iv);
            }
            void var28_28 = fcode$iv;
            void var30_29 = origin$iv;
            void var31_30 = endOffset$iv;
            void var32_31 = startOffset$iv;
            void var33_32 = idSig$iv;
            IrFunctionSymbol symbol2 = (IrFunctionSymbol)symbol$iv;
            boolean bl3 = false;
            boolean $i$f$checkSymbolType2 = false;
            if (!((IrSymbol)symbol2 instanceof IrConstructorSymbol)) {
                throw new IrSymbolTypeMismatchException(IrConstructorSymbol.class, symbol2);
            }
            long flags = FunctionFlags.Companion.decode-UIJRpeM((long)fcode);
            long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getBase().getNameType());
            IrDeclarationParent $this$usingParent$iv$iv = this.symbolTable.declareConstructor((IdSignature)idSig, (Function0<? extends IrConstructorSymbol>)((Function0)new Function0<IrConstructorSymbol>(symbol2){
                final /* synthetic */ IrFunctionSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrConstructorSymbol invoke() {
                    return (IrConstructorSymbol)this.$symbol;
                }
            }), (Function1<? super IrConstructorSymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrConstructor>)((Function1)new Function1<IrConstructorSymbol, org.jetbrains.kotlin.ir.declarations.IrConstructor>(this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, nameType, flags){
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                final /* synthetic */ long $nameType;
                final /* synthetic */ long $flags;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    this.$nameType = $nameType;
                    this.$flags = $flags;
                    super(1);
                }

                @NotNull
                public final org.jetbrains.kotlin.ir.declarations.IrConstructor invoke(@NotNull IrConstructorSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return IrFactory.DefaultImpls.createConstructor$default(this.this$0.getIrFactory(), this.$startOffset, this.$endOffset, this.$origin, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, BinaryNameAndType.getNameIndex-impl(this.$nameType)), FunctionFlags.getVisibility-impl(this.$flags), IrUninitializedType.INSTANCE, FunctionFlags.isInline-impl(this.$flags), FunctionFlags.isExternal-impl(this.$flags) || IrDeclarationDeserializer.access$isEffectivelyExternal$p(this.this$0), FunctionFlags.isPrimary-impl(this.$flags), FunctionFlags.isExpect-impl(this.$flags), null, 2048, null);
                }
            }));
            boolean $i$f$usingParent = false;
            IrDeclarationParent $this$usingParent_u24lambda_u246$iv$iv = irDeclarationParent = $this$usingParent$iv$iv;
            boolean bl4 = false;
            IrDeclarationParent oldParent$iv$iv = ((IrDeclarationDeserializer)this_$iv$iv2).currentParent;
            ((IrDeclarationDeserializer)this_$iv$iv2).currentParent = $this$usingParent_u24lambda_u246$iv$iv;
            try {
                org.jetbrains.kotlin.ir.declarations.IrFunction $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426$iv = (org.jetbrains.kotlin.ir.declarations.IrFunction)$this$usingParent_u24lambda_u246$iv$iv;
                boolean bl5 = false;
                List<IrTypeParameter> list = proto$iv.getTypeParameterList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"proto.typeParameterList");
                $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426$iv.setTypeParameters(((IrDeclarationDeserializer)this_$iv).deserializeTypeParameters(list, false));
                long nameType$iv = BinaryNameAndType.Companion.decode-WXC2TjU(proto$iv.getNameType());
                $this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426$iv.setReturnType(this_$iv.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType$iv)));
                ((IrDeclarationDeserializer)this_$iv).withBodyGuard($this$withDeserializedIrFunctionBase_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426$iv, new /* invalid duplicate definition of identical inner class */);
            }
            finally {
                ((IrDeclarationDeserializer)this_$iv$iv2).currentParent = oldParent$iv$iv;
            }
            org.jetbrains.kotlin.ir.declarations.IrFunction result$iv$iv = (org.jetbrains.kotlin.ir.declarations.IrFunction)irDeclarationParent;
            $this$withScope$iv$iv.leaveScope(symbol$iv);
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv$iv2 = result$iv$iv;
            List<IrConstructorCall> list = proto$iv$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result$iv$iv2.setAnnotations(this_$iv$iv.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result$iv$iv2.setParent(((IrDeclarationDeserializer)this_$iv$iv).currentParent);
            }
            object = result$iv$iv2;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv$iv).eraseDelegatedSymbol(s$iv$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrConstructor)((org.jetbrains.kotlin.ir.declarations.IrFunction)object);
    }

    static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrConstructor deserializeIrConstructor$default(IrDeclarationDeserializer irDeclarationDeserializer, IrConstructor irConstructor, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return irDeclarationDeserializer.deserializeIrConstructor(irConstructor, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrField deserializeIrField(IrField proto, boolean isConst, boolean setParent) {
        Object object;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void this_$iv2;
            IrDeclarationParent irDeclarationParent;
            void origin;
            void endOffset;
            void startOffset;
            void uniqId;
            void fcode;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = ((IrDeclarationDeserializer)this_$iv).deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            boolean $i$f$checkSymbolType = false;
            if (!(symbol2 instanceof IrFieldSymbol)) {
                throw new IrSymbolTypeMismatchException(IrFieldSymbol.class, symbol2);
            }
            long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType());
            org.jetbrains.kotlin.ir.types.IrType type2 = this.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType));
            long flags = FieldFlags.Companion.decode-TfoGUTA((long)fcode);
            org.jetbrains.kotlin.ir.declarations.IrField field2 = this.symbolTable.declareField((IdSignature)uniqId, (Function0<? extends IrFieldSymbol>)((Function0)new Function0<IrFieldSymbol>(symbol2){
                final /* synthetic */ IrSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrFieldSymbol invoke() {
                    return (IrFieldSymbol)this.$symbol;
                }
            }), (Function1<? super IrFieldSymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrField>)((Function1)new Function1<IrFieldSymbol, org.jetbrains.kotlin.ir.declarations.IrField>(this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, nameType, type2, flags){
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                final /* synthetic */ long $nameType;
                final /* synthetic */ org.jetbrains.kotlin.ir.types.IrType $type;
                final /* synthetic */ long $flags;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    this.$nameType = $nameType;
                    this.$type = $type;
                    this.$flags = $flags;
                    super(1);
                }

                @NotNull
                public final org.jetbrains.kotlin.ir.declarations.IrField invoke(@NotNull IrFieldSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.getIrFactory().createField(this.$startOffset, this.$endOffset, this.$origin, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, BinaryNameAndType.getNameIndex-impl(this.$nameType)), this.$type, FieldFlags.getVisibility-impl(this.$flags), FieldFlags.isFinal-impl(this.$flags), FieldFlags.isExternal-impl(this.$flags) || IrDeclarationDeserializer.access$isEffectivelyExternal$p(this.this$0), FieldFlags.isStatic-impl(this.$flags));
                }
            }));
            IrDeclarationDeserializer irDeclarationDeserializer2 = this;
            IrDeclarationParent $this$usingParent$iv = field2;
            boolean $i$f$usingParent = false;
            IrDeclarationParent $this$usingParent_u24lambda_u246$iv = irDeclarationParent = $this$usingParent$iv;
            boolean bl2 = false;
            IrDeclarationParent oldParent$iv = ((IrDeclarationDeserializer)this_$iv2).currentParent;
            ((IrDeclarationDeserializer)this_$iv2).currentParent = $this$usingParent_u24lambda_u246$iv;
            try {
                org.jetbrains.kotlin.ir.declarations.IrField $this$deserializeIrField_u24lambda_u2440_u24lambda_u2439 = (org.jetbrains.kotlin.ir.declarations.IrField)$this$usingParent_u24lambda_u246$iv;
                boolean bl3 = false;
                if (proto.hasInitializer()) {
                    this.withInitializerGuard($this$deserializeIrField_u24lambda_u2440_u24lambda_u2439, isConst, (Function1<? super org.jetbrains.kotlin.ir.declarations.IrField, Unit>)((Function1)new Function1<org.jetbrains.kotlin.ir.declarations.IrField, Unit>(this, proto){
                        final /* synthetic */ IrDeclarationDeserializer this$0;
                        final /* synthetic */ IrField $proto;
                        {
                            this.this$0 = $receiver;
                            this.$proto = $proto;
                            super(1);
                        }

                        public final void invoke(@NotNull org.jetbrains.kotlin.ir.declarations.IrField $this$withInitializerGuard) {
                            Intrinsics.checkNotNullParameter((Object)$this$withInitializerGuard, (String)"$this$withInitializerGuard");
                            $this$withInitializerGuard.setInitializer(this.this$0.deserializeExpressionBody(this.$proto.getInitializer()));
                        }
                    }));
                }
            }
            finally {
                ((IrDeclarationDeserializer)this_$iv2).currentParent = oldParent$iv;
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = field2;
            List<IrConstructorCall> list = proto$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result$iv.setAnnotations(this_$iv.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrField)object;
    }

    static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrField deserializeIrField$default(IrDeclarationDeserializer irDeclarationDeserializer, IrField irField, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return irDeclarationDeserializer.deserializeIrField(irField, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty deserializeIrLocalDelegatedProperty(IrLocalDelegatedProperty proto, boolean setParent) {
        org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void origin;
            void endOffset;
            void startOffset;
            org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty prop2;
            org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty irLocalDelegatedProperty;
            void fcode;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = ((IrDeclarationDeserializer)this_$iv).deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            boolean $i$f$checkSymbolType = false;
            if (!(symbol2 instanceof IrLocalDelegatedPropertySymbol)) {
                throw new IrSymbolTypeMismatchException(IrLocalDelegatedPropertySymbol.class, symbol2);
            }
            long flags = LocalVariableFlags.Companion.decode-QnIyQoc((long)fcode);
            long nameAndType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType());
            org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty $this$deserializeIrLocalDelegatedProperty_u24lambda_u2442_u24lambda_u2441 = irLocalDelegatedProperty = (prop2 = this.irFactory.createLocalDelegatedProperty((int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, (IrLocalDelegatedPropertySymbol)symbol2, this.deserializeName(BinaryNameAndType.getNameIndex-impl(nameAndType)), this.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameAndType)), LocalVariableFlags.isVar-impl(flags)));
            boolean bl2 = false;
            IrVariable irVariable = proto.getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)irVariable, (String)"proto.delegate");
            $this$deserializeIrLocalDelegatedProperty_u24lambda_u2442_u24lambda_u2441.setDelegate(IrDeclarationDeserializer.deserializeIrVariable$default(this, irVariable, false, 2, null));
            IrFunction irFunction = proto.getGetter();
            Intrinsics.checkNotNullExpressionValue((Object)irFunction, (String)"proto.getter");
            $this$deserializeIrLocalDelegatedProperty_u24lambda_u2442_u24lambda_u2441.setGetter(IrDeclarationDeserializer.deserializeIrFunction$ir_serialization_common$default(this, irFunction, false, 2, null));
            if (proto.hasSetter()) {
                IrFunction irFunction2 = proto.getSetter();
                Intrinsics.checkNotNullExpressionValue((Object)irFunction2, (String)"proto.setter");
                $this$deserializeIrLocalDelegatedProperty_u24lambda_u2442_u24lambda_u2441.setSetter(IrDeclarationDeserializer.deserializeIrFunction$ir_serialization_common$default(this, irFunction2, false, 2, null));
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = irLocalDelegatedProperty;
            List<IrConstructorCall> list = proto$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result$iv.setAnnotations(this_$iv.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            irDeclaration = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty)irDeclaration;
    }

    static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty deserializeIrLocalDelegatedProperty$default(IrDeclarationDeserializer irDeclarationDeserializer, IrLocalDelegatedProperty irLocalDelegatedProperty, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return irDeclarationDeserializer.deserializeIrLocalDelegatedProperty(irLocalDelegatedProperty, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrProperty deserializeIrProperty(IrProperty proto, boolean setParent) {
        Object object;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void this_$iv2;
            void origin;
            void endOffset;
            void startOffset;
            void uniqId;
            org.jetbrains.kotlin.ir.declarations.IrProperty prop2;
            org.jetbrains.kotlin.ir.declarations.IrProperty irProperty;
            void fcode;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = ((IrDeclarationDeserializer)this_$iv).deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            boolean $i$f$checkSymbolType = false;
            if (!(symbol2 instanceof IrPropertySymbol)) {
                throw new IrSymbolTypeMismatchException(IrPropertySymbol.class, symbol2);
            }
            long flags = PropertyFlags.Companion.decode-85tB66k((long)fcode);
            org.jetbrains.kotlin.ir.declarations.IrProperty $this$deserializeIrProperty_u24lambda_u2448_u24lambda_u2447 = irProperty = (prop2 = this.symbolTable.declareProperty((IdSignature)uniqId, (Function0<? extends IrPropertySymbol>)((Function0)new Function0<IrPropertySymbol>(symbol2){
                final /* synthetic */ IrSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrPropertySymbol invoke() {
                    return (IrPropertySymbol)this.$symbol;
                }
            }), (Function1<? super IrPropertySymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrProperty>)((Function1)new Function1<IrPropertySymbol, org.jetbrains.kotlin.ir.declarations.IrProperty>(this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, proto, flags){
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                final /* synthetic */ IrProperty $proto;
                final /* synthetic */ long $flags;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    this.$proto = $proto;
                    this.$flags = $flags;
                    super(1);
                }

                @NotNull
                public final org.jetbrains.kotlin.ir.declarations.IrProperty invoke(@NotNull IrPropertySymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return IrFactory.DefaultImpls.createProperty$default(this.this$0.getIrFactory(), this.$startOffset, this.$endOffset, this.$origin, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, this.$proto.getName()), PropertyFlags.getVisibility-impl(this.$flags), PropertyFlags.getModality-impl(this.$flags), PropertyFlags.isVar-impl(this.$flags), PropertyFlags.isConst-impl(this.$flags), PropertyFlags.isLateinit-impl(this.$flags), PropertyFlags.isDelegated-impl(this.$flags), PropertyFlags.isExternal-impl(this.$flags) || IrDeclarationDeserializer.access$isEffectivelyExternal$p(this.this$0), PropertyFlags.isExpect-impl(this.$flags), PropertyFlags.isFakeOverride-impl(this.$flags), null, 16384, null);
                }
            })));
            boolean bl2 = false;
            IrDeclarationDeserializer irDeclarationDeserializer2 = this;
            boolean value$iv = $this$deserializeIrProperty_u24lambda_u2448_u24lambda_u2447.isExternal();
            boolean $i$f$withExternalValue = false;
            boolean oldExternalValue$iv = this_$iv2.isEffectivelyExternal;
            this_$iv2.isEffectivelyExternal = value$iv;
            try {
                IrSimpleFunction it;
                org.jetbrains.kotlin.ir.declarations.IrProperty irProperty2;
                org.jetbrains.kotlin.ir.declarations.IrDeclarationBase irDeclarationBase2;
                boolean bl3 = false;
                if (proto.hasGetter()) {
                    IrFunction irFunction = proto.getGetter();
                    Intrinsics.checkNotNullExpressionValue((Object)irFunction, (String)"proto.getter");
                    IrSimpleFunction irSimpleFunction = irDeclarationBase2 = IrDeclarationDeserializer.deserializeIrFunction$ir_serialization_common$default(this, irFunction, false, 2, null);
                    irProperty2 = $this$deserializeIrProperty_u24lambda_u2448_u24lambda_u2447;
                    boolean bl4 = false;
                    it.setCorrespondingPropertySymbol((IrPropertySymbol)symbol2);
                    irProperty2.setGetter((IrSimpleFunction)irDeclarationBase2);
                }
                if (proto.hasSetter()) {
                    IrFunction irFunction = proto.getSetter();
                    Intrinsics.checkNotNullExpressionValue((Object)irFunction, (String)"proto.setter");
                    it = irDeclarationBase2 = IrDeclarationDeserializer.deserializeIrFunction$ir_serialization_common$default(this, irFunction, false, 2, null);
                    irProperty2 = $this$deserializeIrProperty_u24lambda_u2448_u24lambda_u2447;
                    boolean bl5 = false;
                    it.setCorrespondingPropertySymbol((IrPropertySymbol)symbol2);
                    irProperty2.setSetter((IrSimpleFunction)irDeclarationBase2);
                }
                if (proto.hasBackingField()) {
                    IrField irField = proto.getBackingField();
                    Intrinsics.checkNotNullExpressionValue((Object)irField, (String)"proto.backingField");
                    it = irDeclarationBase2 = IrDeclarationDeserializer.deserializeIrField$default(this, irField, prop2.isConst(), false, 4, null);
                    irProperty2 = $this$deserializeIrProperty_u24lambda_u2448_u24lambda_u2447;
                    boolean bl6 = false;
                    ((org.jetbrains.kotlin.ir.declarations.IrField)((Object)it)).setCorrespondingPropertySymbol((IrPropertySymbol)symbol2);
                    irProperty2.setBackingField((org.jetbrains.kotlin.ir.declarations.IrField)irDeclarationBase2);
                }
            }
            finally {
                this_$iv2.isEffectivelyExternal = oldExternalValue$iv;
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = irProperty;
            List<IrConstructorCall> list = proto$iv.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.annotationList");
            result$iv.setAnnotations(this_$iv.deserializeAnnotations$ir_serialization_common(list));
            if (setParent) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrProperty)object;
    }

    static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrProperty deserializeIrProperty$default(IrDeclarationDeserializer irDeclarationDeserializer, IrProperty irProperty, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return irDeclarationDeserializer.deserializeIrProperty(irProperty, bl);
    }

    private final IrDeclarationOriginImpl deserializeIrDeclarationOrigin(int protoName) {
        String originName = this.libraryFile.string(protoName);
        IrDeclarationOriginImpl irDeclarationOriginImpl = declarationOriginIndex.get(originName);
        if (irDeclarationOriginImpl == null) {
            irDeclarationOriginImpl = new IrDeclarationOriginImpl(originName){};
        }
        return irDeclarationOriginImpl;
    }

    @NotNull
    public final org.jetbrains.kotlin.ir.declarations.IrDeclaration deserializeDeclaration(@NotNull IrDeclaration proto, boolean setParent) {
        org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        IrDeclaration.DeclaratorCase declaratorCase = proto.getDeclaratorCase();
        Intrinsics.checkNotNull((Object)((Object)declaratorCase));
        switch (WhenMappings.$EnumSwitchMapping$2[declaratorCase.ordinal()]) {
            case 1: {
                IrAnonymousInit irAnonymousInit = proto.getIrAnonymousInit();
                Intrinsics.checkNotNullExpressionValue((Object)irAnonymousInit, (String)"proto.irAnonymousInit");
                irDeclaration = this.deserializeIrAnonymousInit(irAnonymousInit, setParent);
                break;
            }
            case 2: {
                IrConstructor irConstructor = proto.getIrConstructor();
                Intrinsics.checkNotNullExpressionValue((Object)irConstructor, (String)"proto.irConstructor");
                irDeclaration = this.deserializeIrConstructor(irConstructor, setParent);
                break;
            }
            case 3: {
                IrField irField = proto.getIrField();
                Intrinsics.checkNotNullExpressionValue((Object)irField, (String)"proto.irField");
                irDeclaration = this.deserializeIrField(irField, false, setParent);
                break;
            }
            case 4: {
                IrClass irClass = proto.getIrClass();
                Intrinsics.checkNotNullExpressionValue((Object)irClass, (String)"proto.irClass");
                irDeclaration = this.deserializeIrClass(irClass, setParent);
                break;
            }
            case 5: {
                IrFunction irFunction = proto.getIrFunction();
                Intrinsics.checkNotNullExpressionValue((Object)irFunction, (String)"proto.irFunction");
                irDeclaration = this.deserializeIrFunction$ir_serialization_common(irFunction, setParent);
                break;
            }
            case 6: {
                IrProperty irProperty = proto.getIrProperty();
                Intrinsics.checkNotNullExpressionValue((Object)irProperty, (String)"proto.irProperty");
                irDeclaration = this.deserializeIrProperty(irProperty, setParent);
                break;
            }
            case 7: {
                throw new IllegalStateException("".toString());
            }
            case 8: {
                IrVariable irVariable = proto.getIrVariable();
                Intrinsics.checkNotNullExpressionValue((Object)irVariable, (String)"proto.irVariable");
                irDeclaration = this.deserializeIrVariable(irVariable, setParent);
                break;
            }
            case 9: {
                throw new IllegalStateException("".toString());
            }
            case 10: {
                IrEnumEntry irEnumEntry = proto.getIrEnumEntry();
                Intrinsics.checkNotNullExpressionValue((Object)irEnumEntry, (String)"proto.irEnumEntry");
                irDeclaration = this.deserializeIrEnumEntry(irEnumEntry, setParent);
                break;
            }
            case 11: {
                IrLocalDelegatedProperty irLocalDelegatedProperty = proto.getIrLocalDelegatedProperty();
                Intrinsics.checkNotNullExpressionValue((Object)irLocalDelegatedProperty, (String)"proto.irLocalDelegatedProperty");
                irDeclaration = this.deserializeIrLocalDelegatedProperty(irLocalDelegatedProperty, setParent);
                break;
            }
            case 12: {
                IrTypeAlias irTypeAlias = proto.getIrTypeAlias();
                Intrinsics.checkNotNullExpressionValue((Object)irTypeAlias, (String)"proto.irTypeAlias");
                irDeclaration = this.deserializeIrTypeAlias(irTypeAlias, setParent);
                break;
            }
            case 13: {
                IrErrorDeclaration irErrorDeclaration = proto.getIrErrorDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)irErrorDeclaration, (String)"proto.irErrorDeclaration");
                irDeclaration = this.deserializeErrorDeclaration(irErrorDeclaration, setParent);
                break;
            }
            case 14: {
                throw new IllegalStateException(("Declaration deserialization not implemented: " + (Object)((Object)proto.getDeclaratorCase())).toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        org.jetbrains.kotlin.ir.declarations.IrDeclaration declaration = irDeclaration;
        return declaration;
    }

    public static /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrDeclaration deserializeDeclaration$default(IrDeclarationDeserializer irDeclarationDeserializer, IrDeclaration irDeclaration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return irDeclarationDeserializer.deserializeDeclaration(irDeclaration, bl);
    }

    private final boolean isSkippableFakeOverride(IrDeclaration proto, org.jetbrains.kotlin.ir.declarations.IrClass parent2) {
        boolean bl;
        IrSymbol irSymbol;
        if (!this.platformFakeOverrideClassFilter.needToConstructFakeOverrides(parent2)) {
            return false;
        }
        IrDeclaration.DeclaratorCase declaratorCase = proto.getDeclaratorCase();
        Intrinsics.checkNotNull((Object)((Object)declaratorCase));
        switch (WhenMappings.$EnumSwitchMapping$2[declaratorCase.ordinal()]) {
            case 5: {
                irSymbol = this.symbolDeserializer.deserializeIrSymbol(proto.getIrFunction().getBase().getBase().getSymbol());
                break;
            }
            case 6: {
                irSymbol = this.symbolDeserializer.deserializeIrSymbol(proto.getIrProperty().getBase().getSymbol());
                break;
            }
            default: {
                return false;
            }
        }
        IrSymbol symbol2 = irSymbol;
        if (!(symbol2 instanceof IrPublicSymbolBase)) {
            return false;
        }
        if (!((IrPublicSymbolBase)symbol2).getSignature().isPubliclyVisible()) {
            return false;
        }
        IrDeclaration.DeclaratorCase declaratorCase2 = proto.getDeclaratorCase();
        Intrinsics.checkNotNull((Object)((Object)declaratorCase2));
        switch (WhenMappings.$EnumSwitchMapping$2[declaratorCase2.ordinal()]) {
            case 5: {
                bl = FunctionFlags.isFakeOverride-impl(FunctionFlags.Companion.decode-UIJRpeM(proto.getIrFunction().getBase().getBase().getFlags()));
                break;
            }
            case 6: {
                bl = PropertyFlags.isFakeOverride-impl(PropertyFlags.Companion.decode-85tB66k(proto.getIrProperty().getBase().getFlags()));
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private static final <T extends org.jetbrains.kotlin.ir.declarations.IrFunction> boolean withBodyGuard$checkInlineBody(IrDeclarationDeserializer this$0, T $this_withBodyGuard) {
        return this$0.deserializeInlineFunctions && $this_withBodyGuard instanceof IrSimpleFunction && $this_withBodyGuard.isInline();
    }

    public static final /* synthetic */ Name access$deserializeName(IrDeclarationDeserializer $this, int index) {
        return $this.deserializeName(index);
    }

    public static final /* synthetic */ boolean access$isEffectivelyExternal$p(IrDeclarationDeserializer $this) {
        return $this.isEffectivelyExternal;
    }

    public static final /* synthetic */ List access$deserializeValueParameters(IrDeclarationDeserializer $this, List protos) {
        return $this.deserializeValueParameters(protos);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Companion = new Companion(null);
        allKnownDeclarationOrigins = CollectionsKt.toList((Iterable)Reflection.getOrCreateKotlinClass(IrDeclarationOrigin.class).getNestedClasses());
        Iterable $this$mapNotNull$iv = allKnownDeclarationOrigins;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<IrDeclarationOriginImpl> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IrDeclarationOriginImpl it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KClass it = (KClass)element$iv$iv;
            boolean bl2 = false;
            Object object = it.getObjectInstance();
            if ((object instanceof IrDeclarationOriginImpl ? (IrDeclarationOriginImpl)object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            element$iv$iv$iv = (IrDeclarationOriginImpl)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        declarationOriginIndex = destination$iv$iv2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer$Companion;", "", "()V", "allKnownDeclarationOrigins", "", "Lkotlin/reflect/KClass;", "declarationOriginIndex", "", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "ir.serialization.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[IrSimpleTypeNullability.values().length];
            try {
                nArray[IrSimpleTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrSimpleTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrSimpleTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrType.KindCase.values().length];
            try {
                nArray[IrType.KindCase.DNN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrType.KindCase.SIMPLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrType.KindCase.LEGACYSIMPLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrType.KindCase.DYNAMIC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrType.KindCase.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[IrDeclaration.DeclaratorCase.values().length];
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_ANONYMOUS_INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_CONSTRUCTOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_FIELD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_CLASS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_FUNCTION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_PROPERTY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_TYPE_PARAMETER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_VARIABLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_VALUE_PARAMETER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_ENUM_ENTRY.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_LOCAL_DELEGATED_PROPERTY.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_TYPE_ALIAS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.IR_ERROR_DECLARATION.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeclaration.DeclaratorCase.DECLARATOR_NOT_SET.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

