/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.ExpressionHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IterableHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.matchers.IrCallMatcher;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/DefaultIterableHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ExpressionHandler;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "iterableClassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "build", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfo;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "scopeOwner", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "matchIterable", "", "ir.backend.common"})
public final class DefaultIterableHandler
implements ExpressionHandler {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrClassSymbol iterableClassSymbol;

    public DefaultIterableHandler(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.iterableClassSymbol = this.context.getIr().getSymbols().getIterable();
    }

    public boolean matchIterable(@NotNull IrExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return IrTypeUtilsKt.isSubtypeOfClass(expression.getType(), this.iterableClassSymbol);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public HeaderInfo build(@NotNull IrExpression expression, @NotNull IrSymbol scopeOwner) {
        void $this$build_u24lambda_u241_u24lambda_u240;
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)scopeOwner, (String)"scopeOwner");
        DeclarationIrBuilder $this$build_u24lambda_u241 = LowerUtilsKt.createIrBuilder(this.context, scopeOwner, expression.getStartOffset(), expression.getEndOffset());
        boolean bl = false;
        String string = OperatorNameConventions.ITERATOR.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ITERATOR.asString()");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction(this.iterableClassSymbol, string);
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        IrSimpleFunction iteratorFun = (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$build_u24lambda_u241, iteratorFun);
        Scope scope = $this$build_u24lambda_u241.getScope();
        boolean bl2 = false;
        $this$build_u24lambda_u241_u24lambda_u240.setDispatchReceiver(expression);
        IrVariable irVariable = IrBuilderKt.createTmpVariable$default(scope, (IrExpression)irFunctionAccessExpression, "iterator", false, null, null, 28, null);
        return new IterableHeaderInfo(irVariable);
    }

    @Override
    @Nullable
    public HeaderInfo build(@NotNull IrExpression expression, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        return ExpressionHandler.DefaultImpls.build(this, expression, data, scopeOwner);
    }

    @Override
    @Nullable
    public IrCallMatcher getIteratorCallMatcher() {
        return ExpressionHandler.DefaultImpls.getIteratorCallMatcher(this);
    }

    @Nullable
    public HeaderInfo handle(@NotNull IrExpression expression, @Nullable IrCall iteratorCall, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        return ExpressionHandler.DefaultImpls.handle(this, expression, iteratorCall, data, scopeOwner);
    }
}

