/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.ComparableRangeInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.FloatingPointRangeHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.IterableHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IterableLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.WithIndexHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.WithIndexLoopHeader;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;", "scopeOwnerSymbol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;Lkotlin/jvm/functions/Function0;)V", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "extractHeader", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "ir.backend.common"})
public final class HeaderProcessor {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final HeaderInfoBuilder headerInfoBuilder;
    @NotNull
    private final Function0<IrSymbol> scopeOwnerSymbol;
    @NotNull
    private final Symbols<CommonBackendContext> symbols;

    public HeaderProcessor(@NotNull CommonBackendContext context, @NotNull HeaderInfoBuilder headerInfoBuilder2, @NotNull Function0<? extends IrSymbol> scopeOwnerSymbol) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)headerInfoBuilder2, (String)"headerInfoBuilder");
        Intrinsics.checkNotNullParameter(scopeOwnerSymbol, (String)"scopeOwnerSymbol");
        this.context = context;
        this.headerInfoBuilder = headerInfoBuilder2;
        this.scopeOwnerSymbol = scopeOwnerSymbol;
        this.symbols = this.context.getIr().getSymbols();
    }

    @Nullable
    public final ForLoopHeader extractHeader(@NotNull IrVariable variable2) {
        ForLoopHeader forLoopHeader;
        IrExpression iterable;
        Object object;
        IrExpression irExpression;
        IrCall iteratorCall;
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        boolean bl = Intrinsics.areEqual((Object)variable2.getOrigin(), (Object)IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (!IrTypeUtilsKt.isSubtypeOfClass(variable2.getType(), this.symbols.getIterator())) {
            return null;
        }
        IrExpression irExpression2 = variable2.getInitializer();
        IrCall irCall = iteratorCall = irExpression2 instanceof IrCall ? (IrCall)irExpression2 : null;
        if (irCall != null) {
            IrCall $this$extractHeader_u24lambda_u240 = irCall;
            boolean bl2 = false;
            irExpression = $this$extractHeader_u24lambda_u240.getExtensionReceiver() != null ? $this$extractHeader_u24lambda_u240.getExtensionReceiver() : $this$extractHeader_u24lambda_u240.getDispatchReceiver();
        } else {
            irExpression = null;
        }
        if ((object = (iterable = irExpression)) == null || (object = (HeaderInfo)object.accept(this.headerInfoBuilder, iteratorCall)) == null) {
            return null;
        }
        Object headerInfo = object;
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder(this.context, (IrSymbol)this.scopeOwnerSymbol.invoke(), variable2.getStartOffset(), variable2.getEndOffset());
        Object object2 = headerInfo;
        if (object2 instanceof IndexedGetHeaderInfo) {
            forLoopHeader = new IndexedGetLoopHeader((IndexedGetHeaderInfo)headerInfo, builder, this.context);
        } else if (object2 instanceof ProgressionHeaderInfo) {
            forLoopHeader = new ProgressionLoopHeader((ProgressionHeaderInfo)headerInfo, builder, this.context);
        } else if (object2 instanceof WithIndexHeaderInfo) {
            forLoopHeader = new WithIndexLoopHeader((WithIndexHeaderInfo)headerInfo, builder, this.context);
        } else if (object2 instanceof IterableHeaderInfo) {
            forLoopHeader = new IterableLoopHeader((IterableHeaderInfo)headerInfo);
        } else {
            if (object2 instanceof FloatingPointRangeHeaderInfo ? true : object2 instanceof ComparableRangeInfo) {
                throw new IllegalStateException(("Unexpected " + Reflection.getOrCreateKotlinClass(headerInfo.getClass()).getSimpleName() + " for loops").toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return forLoopHeader;
    }
}

