/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.optimizations.FoldConstantLowering;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/FlattenStringConcatenationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Companion", "ir.backend.common"})
public final class FlattenStringConcatenationLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private static final Set<FqName> PARENT_NAMES;

    public FlattenStringConcatenationLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (FlattenStringConcatenationLowering.Companion.isStringConcatenationExpression(expression) || expression instanceof IrCall && FlattenStringConcatenationLowering.Companion.isSpecialToStringCall((IrCall)expression)) {
            IrExpression $this$visitExpression_u24lambda_u240 = expression;
            boolean bl = false;
            irExpression = FoldConstantLowering.Companion.tryToFold(new IrStringConcatenationImpl($this$visitExpression_u24lambda_u240.getStartOffset(), $this$visitExpression_u24lambda_u240.getEndOffset(), $this$visitExpression_u24lambda_u240.getType(), FlattenStringConcatenationLowering.Companion.collectStringConcatenationArguments($this$visitExpression_u24lambda_u240)), this.context, false);
        } else {
            irExpression = expression;
        }
        IrExpression transformedExpression = irExpression;
        IrElementTransformerVoidKt.transformChildrenVoid(transformedExpression, this);
        return transformedExpression;
    }

    static {
        Object[] objectArray = new FqName[2];
        objectArray[0] = StandardNames.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)StandardNames.FqNames.string.toSafe(), (String)"string.toSafe()");
        PARENT_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\tR\u0018\u0010\n\u001a\u00020\u0007*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0018\u0010\r\u001a\u00020\u0007*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0015\u0010\u000e\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u0018\u0010\u000f\u001a\u00020\u0007*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/FlattenStringConcatenationLowering$Companion;", "", "()V", "PARENT_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "isNullableToString", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Z", "isSpecialToStringCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Z", "isStringPlusCall", "isToString", "isToStringCall", "collectStringConcatenationArguments", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "isStringConcatenationExpression", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isStringPlusCall(IrCall $this$isStringPlusCall) {
            IrValueParameter receiverParameter;
            IrSimpleFunction function = (IrSimpleFunction)$this$isStringPlusCall.getSymbol().getOwner();
            IrValueParameter irValueParameter = function.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                irValueParameter = function.getExtensionReceiverParameter();
            }
            if ((receiverParameter = irValueParameter) == null) return false;
            if (!IrTypePredicatesKt.isStringClassType(receiverParameter.getType())) return false;
            if (!IrTypePredicatesKt.isStringClassType(function.getReturnType())) return false;
            if (function.getValueParameters().size() != 1) return false;
            if (!Intrinsics.areEqual((Object)function.getName(), (Object)OperatorNameConventions.PLUS)) return false;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable(function);
            if (!CollectionsKt.contains((Iterable)PARENT_NAMES, (Object)(fqName != null ? fqName.parent() : null))) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isToString(@NotNull IrSimpleFunction $this$isToString) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$this$isToString, (String)"<this>");
            if (!Intrinsics.areEqual((Object)$this$isToString.getName(), (Object)OperatorNameConventions.TO_STRING)) return false;
            if (!((Collection)$this$isToString.getValueParameters()).isEmpty()) {
                return false;
            }
            boolean bl2 = false;
            if (bl2) return false;
            if (!IrTypePredicatesKt.isString($this$isToString.getReturnType())) {
                return false;
            }
            if ($this$isToString.getDispatchReceiverParameter() == null) return false;
            if ($this$isToString.getExtensionReceiverParameter() != null) return false;
            IrAnnotationContainer irAnnotationContainer = $this$isToString.getDispatchReceiverParameter();
            if (irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null) {
                if (IrTypePredicatesKt.isAny((IrType)irAnnotationContainer)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (((Collection)$this$isToString.getOverriddenSymbols()).isEmpty()) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNullableToString(IrSimpleFunction $this$isNullableToString) {
            if (!Intrinsics.areEqual((Object)$this$isNullableToString.getName(), (Object)OperatorNameConventions.TO_STRING)) return false;
            if (!((Collection)$this$isNullableToString.getValueParameters()).isEmpty()) {
                return false;
            }
            boolean bl = false;
            if (bl) return false;
            if (!IrTypePredicatesKt.isString($this$isNullableToString.getReturnType())) {
                return false;
            }
            if ($this$isNullableToString.getDispatchReceiverParameter() != null) return false;
            IrValueParameter irValueParameter = $this$isNullableToString.getExtensionReceiverParameter();
            IrAnnotationContainer irAnnotationContainer = irValueParameter;
            if (irValueParameter == null) return false;
            IrType irType = irAnnotationContainer.getType();
            irAnnotationContainer = irType;
            if (irType == null) return false;
            if (!IrTypePredicatesKt.isNullableAny((IrType)irAnnotationContainer)) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable($this$isNullableToString);
            if (!Intrinsics.areEqual((Object)(fqName != null ? fqName.parent() : null), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
            return true;
        }

        private final boolean isToStringCall(IrCall $this$isToStringCall) {
            if ($this$isToStringCall.getSuperQualifierSymbol() != null) {
                return false;
            }
            IrFunction irFunction = $this$isToStringCall.getSymbol().getOwner();
            IrSimpleFunction irSimpleFunction = irFunction instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction : null;
            if (irSimpleFunction == null) {
                return false;
            }
            IrSimpleFunction function = irSimpleFunction;
            return this.isToString(function) || this.isNullableToString(function);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSpecialToStringCall(IrCall $this$isSpecialToStringCall) {
            if (!this.isToStringCall($this$isSpecialToStringCall)) return false;
            IrExpression irExpression = $this$isSpecialToStringCall.getDispatchReceiver();
            Object object = irExpression;
            if (irExpression == null) return true;
            IrType irType = ((IrExpression)object).getType();
            object = irType;
            if (irType == null) return true;
            if (IrTypePredicatesKt.isPrimitiveType$default((IrType)object, false, 1, null)) return true;
            return false;
        }

        private final boolean isStringConcatenationExpression(IrExpression expression) {
            return expression instanceof IrStringConcatenation || expression instanceof IrCall && this.isStringPlusCall((IrCall)expression);
        }

        private final List<IrExpression> collectStringConcatenationArguments(IrExpression expression) {
            List arguments2 = new ArrayList();
            IrVisitorsKt.acceptChildrenVoid(expression, new IrElementVisitorVoid(arguments2){
                final /* synthetic */ List<IrExpression> $arguments;
                {
                    this.$arguments = $arguments;
                }

                public void visitElement(@NotNull IrElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    IrVisitorsKt.acceptChildrenVoid(element, this);
                }

                public void visitCall(@NotNull IrCall expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    if (org.jetbrains.kotlin.backend.common.lower.FlattenStringConcatenationLowering$Companion.access$isStringConcatenationExpression(FlattenStringConcatenationLowering.Companion, expression) || org.jetbrains.kotlin.backend.common.lower.FlattenStringConcatenationLowering$Companion.access$isToStringCall(FlattenStringConcatenationLowering.Companion, expression)) {
                        IrVisitorsKt.acceptChildrenVoid(expression, this);
                    } else {
                        this.$arguments.add(expression);
                    }
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    IrVisitorsKt.acceptChildrenVoid(expression, this);
                }

                public void visitExpression(@NotNull IrExpression expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.$arguments.add(expression);
                }

                public void visitElement(@NotNull IrElement element, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
                }

                public void visitCall(@NotNull IrCall expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression, data);
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression, data);
                }

                public void visitExpression(@NotNull IrExpression expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression, data);
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
                }

                public void visitBlock(@NotNull IrBlock expression) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression);
                }

                public void visitBlock(@NotNull IrBlock expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression, data);
                }

                public void visitBlockBody(@NotNull IrBlockBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                }

                public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
                }

                public void visitBody(@NotNull IrBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                }

                public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
                }

                public void visitBranch(@NotNull IrBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                }

                public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
                }

                public void visitBreak(@NotNull IrBreak jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                }

                public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                public void visitCallableReference(@NotNull IrCallableReference<?> expression) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression);
                }

                public void visitCallableReference(@NotNull IrCallableReference<?> expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression, data);
                }

                public void visitCatch(@NotNull IrCatch aCatch) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                }

                public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
                }

                public void visitClass(@NotNull IrClass declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
                }

                public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
                }

                public void visitClassReference(@NotNull IrClassReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression);
                }

                public void visitClassReference(@NotNull IrClassReference expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression, data);
                }

                public void visitComposite(@NotNull IrComposite expression) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression);
                }

                public void visitComposite(@NotNull IrComposite expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression, data);
                }

                public void visitConst(@NotNull IrConst<?> expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression);
                }

                public void visitConst(@NotNull IrConst<?> expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression, data);
                }

                public void visitConstantArray(@NotNull IrConstantArray expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression);
                }

                public void visitConstantArray(@NotNull IrConstantArray expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression, data);
                }

                public void visitConstantObject(@NotNull IrConstantObject expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression);
                }

                public void visitConstantObject(@NotNull IrConstantObject expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression, data);
                }

                public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression);
                }

                public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression, data);
                }

                public void visitConstantValue(@NotNull IrConstantValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression);
                }

                public void visitConstantValue(@NotNull IrConstantValue expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression, data);
                }

                public void visitConstructor(@NotNull IrConstructor declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
                }

                public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
                }

                public void visitConstructorCall(@NotNull IrConstructorCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression);
                }

                public void visitConstructorCall(@NotNull IrConstructorCall expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression, data);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression, data);
                }

                public void visitContinue(@NotNull IrContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                }

                public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
                }

                public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
                }

                public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression, data);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression, data);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
                }

                public void visitDynamicExpression(@NotNull IrDynamicExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression);
                }

                public void visitDynamicExpression(@NotNull IrDynamicExpression expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression, data);
                }

                public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression);
                }

                public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression, data);
                }

                public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression);
                }

                public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression, data);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression, data);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression, data);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression, data);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
                }

                public void visitField(@NotNull IrField declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
                }

                public void visitField(@NotNull IrField declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression, data);
                }

                public void visitFile(@NotNull IrFile declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
                }

                public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
                }

                public void visitFunction(@NotNull IrFunction declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
                }

                public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression, data);
                }

                public void visitFunctionExpression(@NotNull IrFunctionExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression);
                }

                public void visitFunctionExpression(@NotNull IrFunctionExpression expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression, data);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression, data);
                }

                public void visitGetClass(@NotNull IrGetClass expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression);
                }

                public void visitGetClass(@NotNull IrGetClass expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression, data);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression, data);
                }

                public void visitGetField(@NotNull IrGetField expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression);
                }

                public void visitGetField(@NotNull IrGetField expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression, data);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression, data);
                }

                public void visitGetValue(@NotNull IrGetValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression);
                }

                public void visitGetValue(@NotNull IrGetValue expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression, data);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression, data);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression, data);
                }

                public void visitLoop(@NotNull IrLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
                }

                public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
                }

                public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression);
                }

                public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression, data);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
                }

                public void visitProperty(@NotNull IrProperty declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
                }

                public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression, data);
                }

                public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression);
                }

                public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression, data);
                }

                public void visitReturn(@NotNull IrReturn expression) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression);
                }

                public void visitReturn(@NotNull IrReturn expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression, data);
                }

                public void visitScript(@NotNull IrScript declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
                }

                public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
                }

                public void visitSetField(@NotNull IrSetField expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression);
                }

                public void visitSetField(@NotNull IrSetField expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression, data);
                }

                public void visitSetValue(@NotNull IrSetValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression);
                }

                public void visitSetValue(@NotNull IrSetValue expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression, data);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression, data);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression);
                }

                public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression, data);
                }

                public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression);
                }

                public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression, data);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
                }

                public void visitThrow(@NotNull IrThrow expression) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression);
                }

                public void visitThrow(@NotNull IrThrow expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression, data);
                }

                public void visitTry(@NotNull IrTry aTry) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                }

                public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
                }

                public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
                }

                public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression, data);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
                }

                public void visitValueAccess(@NotNull IrValueAccessExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression);
                }

                public void visitValueAccess(@NotNull IrValueAccessExpression expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression, data);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
                }

                public void visitVararg(@NotNull IrVararg expression) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression);
                }

                public void visitVararg(@NotNull IrVararg expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression, data);
                }

                public void visitVariable(@NotNull IrVariable declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
                }

                public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
                }

                public void visitWhen(@NotNull IrWhen expression) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression);
                }

                public void visitWhen(@NotNull IrWhen expression, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression, data);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
                }
            });
            return arguments2;
        }

        public static final /* synthetic */ boolean access$isToStringCall(Companion $this, IrCall $receiver) {
            return $this.isToStringCall($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

