/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrEnumConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrPropertyReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeParameterRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolverKt;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\"2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020%2\u0006\u0010&\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0016J\u0010\u00101\u001a\u00020%2\u0006\u0010&\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J\u0010\u00104\u001a\u00020%2\u0006\u0010&\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020%2\u0006\u0010&\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\u000e\u0010:\u001a\u0004\u0018\u00010;*\u00020;H\u0002J\u000e\u0010<\u001a\u0004\u0018\u00010;*\u00020;H\u0002J\f\u0010=\u001a\u00020%*\u00020%H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR2\u0010\r\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ExpectDeclarationRemover;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "doRemove", "", "(Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Z)V", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "typeParameterSubstitutionMap", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "isOptionalAnnotationClass", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "remapExpectValue", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "shouldRemoveTopLevelDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "transformFlat", "", "tryCopyDefaultArguments", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClassReference", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "element", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitFile", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitValueParameter", "Lorg/jetbrains/kotlin/ir/IrStatement;", "findActualForExpect", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "findExpectForActual", "remapExpectValueSymbols", "ir.backend.common"})
public final class ExpectDeclarationRemover
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    private final boolean doRemove;
    @NotNull
    private final Map<Pair<IrFunction, IrFunction>, Map<IrTypeParameter, IrTypeParameter>> typeParameterSubstitutionMap;

    public ExpectDeclarationRemover(@NotNull ReferenceSymbolTable symbolTable, boolean doRemove) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        this.symbolTable = symbolTable;
        this.doRemove = doRemove;
        this.typeParameterSubstitutionMap = new LinkedHashMap();
    }

    @NotNull
    public final ReferenceSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public ExpectDeclarationRemover(@NotNull BackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context.getIr().getSymbols().getExternalSymbolTable(), true);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.visitFile(irFile);
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.transformChildrenVoid(element);
        return element;
    }

    @Override
    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        CollectionsKt.removeAll(declaration.getDeclarations(), (Function1)((Function1)new Function1<IrDeclaration, Boolean>(this){
            final /* synthetic */ ExpectDeclarationRemover this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IrDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExpectDeclarationRemover.access$shouldRemoveTopLevelDeclaration(this.this$0, it);
            }
        }));
        return super.visitFile(declaration);
    }

    @Override
    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.tryCopyDefaultArguments(declaration);
        return super.visitValueParameter(declaration);
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression) {
        IrConstructorCallImpl irConstructorCallImpl;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrExpression irExpression = super.visitConstructorCall(expression);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConstructorCall");
        IrConstructorCall nExpression = (IrConstructorCall)irExpression;
        if (!((IrConstructor)nExpression.getSymbol().getOwner()).isExpect()) {
            return nExpression;
        }
        MemberDescriptor memberDescriptor = this.findActualForExpect((MemberDescriptor)nExpression.getSymbol().getDescriptor());
        ClassConstructorDescriptor classConstructorDescriptor = memberDescriptor instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)memberDescriptor : null;
        if (classConstructorDescriptor == null) {
            return nExpression;
        }
        IrConstructorSymbol newCallee = this.symbolTable.referenceConstructor(classConstructorDescriptor);
        IrConstructorCall $this$visitConstructorCall_u24lambda_u241 = nExpression;
        boolean bl = false;
        IrConstructorCallImpl it = irConstructorCallImpl = new IrConstructorCallImpl($this$visitConstructorCall_u24lambda_u241.getStartOffset(), $this$visitConstructorCall_u24lambda_u241.getEndOffset(), $this$visitConstructorCall_u24lambda_u241.getType(), newCallee, $this$visitConstructorCall_u24lambda_u241.getTypeArgumentsCount(), $this$visitConstructorCall_u24lambda_u241.getConstructorTypeArgumentsCount(), $this$visitConstructorCall_u24lambda_u241.getValueArgumentsCount(), $this$visitConstructorCall_u24lambda_u241.getOrigin(), null, 256, null);
        boolean bl2 = false;
        it.setAttributeOwnerId($this$visitConstructorCall_u24lambda_u241.getAttributeOwnerId());
        IrUtilsKt.copyTypeAndValueArgumentsFrom$default(it, nExpression, false, false, 6, null);
        return irConstructorCallImpl;
    }

    @Override
    @NotNull
    public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression) {
        IrDelegatingConstructorCallImpl irDelegatingConstructorCallImpl;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrExpression irExpression = super.visitDelegatingConstructorCall(expression);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall");
        IrDelegatingConstructorCall nExpression = (IrDelegatingConstructorCall)irExpression;
        if (!((IrConstructor)nExpression.getSymbol().getOwner()).isExpect()) {
            return nExpression;
        }
        MemberDescriptor memberDescriptor = this.findActualForExpect((MemberDescriptor)nExpression.getSymbol().getDescriptor());
        ClassConstructorDescriptor classConstructorDescriptor = memberDescriptor instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)memberDescriptor : null;
        if (classConstructorDescriptor == null) {
            return nExpression;
        }
        IrConstructorSymbol newCallee = this.symbolTable.referenceConstructor(classConstructorDescriptor);
        IrDelegatingConstructorCall $this$visitDelegatingConstructorCall_u24lambda_u243 = nExpression;
        boolean bl = false;
        IrDelegatingConstructorCallImpl it = irDelegatingConstructorCallImpl = new IrDelegatingConstructorCallImpl($this$visitDelegatingConstructorCall_u24lambda_u243.getStartOffset(), $this$visitDelegatingConstructorCall_u24lambda_u243.getEndOffset(), $this$visitDelegatingConstructorCall_u24lambda_u243.getType(), newCallee, $this$visitDelegatingConstructorCall_u24lambda_u243.getTypeArgumentsCount(), $this$visitDelegatingConstructorCall_u24lambda_u243.getValueArgumentsCount());
        boolean bl2 = false;
        it.setAttributeOwnerId($this$visitDelegatingConstructorCall_u24lambda_u243.getAttributeOwnerId());
        IrUtilsKt.copyTypeAndValueArgumentsFrom$default(it, nExpression, false, false, 6, null);
        return irDelegatingConstructorCallImpl;
    }

    @Override
    @NotNull
    public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression) {
        IrEnumConstructorCallImpl irEnumConstructorCallImpl;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrExpression irExpression = super.visitEnumConstructorCall(expression);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall");
        IrEnumConstructorCall nExpression = (IrEnumConstructorCall)irExpression;
        if (!((IrConstructor)nExpression.getSymbol().getOwner()).isExpect()) {
            return nExpression;
        }
        MemberDescriptor memberDescriptor = this.findActualForExpect((MemberDescriptor)nExpression.getSymbol().getDescriptor());
        ClassConstructorDescriptor classConstructorDescriptor = memberDescriptor instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)memberDescriptor : null;
        if (classConstructorDescriptor == null) {
            return nExpression;
        }
        IrConstructorSymbol newCallee = this.symbolTable.referenceConstructor(classConstructorDescriptor);
        IrEnumConstructorCall $this$visitEnumConstructorCall_u24lambda_u245 = nExpression;
        boolean bl = false;
        IrEnumConstructorCallImpl it = irEnumConstructorCallImpl = new IrEnumConstructorCallImpl($this$visitEnumConstructorCall_u24lambda_u245.getStartOffset(), $this$visitEnumConstructorCall_u24lambda_u245.getEndOffset(), $this$visitEnumConstructorCall_u24lambda_u245.getType(), newCallee, $this$visitEnumConstructorCall_u24lambda_u245.getTypeArgumentsCount(), $this$visitEnumConstructorCall_u24lambda_u245.getValueArgumentsCount());
        boolean bl2 = false;
        it.setAttributeOwnerId($this$visitEnumConstructorCall_u24lambda_u245.getAttributeOwnerId());
        IrUtilsKt.copyTypeAndValueArgumentsFrom$default(it, nExpression, false, false, 6, null);
        return irEnumConstructorCallImpl;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression) {
        IrCall irCall;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrExpression irExpression = super.visitCall(expression);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
        IrCall nExpression = (IrCall)irExpression;
        if (!((IrSimpleFunction)nExpression.getSymbol().getOwner()).isExpect()) {
            return nExpression;
        }
        MemberDescriptor memberDescriptor = this.findActualForExpect((MemberDescriptor)nExpression.getSymbol().getDescriptor());
        FunctionDescriptor functionDescriptor = memberDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)memberDescriptor : null;
        if (functionDescriptor == null) {
            return nExpression;
        }
        IrSimpleFunctionSymbol newCallee = this.symbolTable.referenceSimpleFunction(functionDescriptor);
        IrCall it = irCall = IrUtilsKt.irCall$default((IrFunctionAccessExpression)nExpression, newCallee, false, false, null, null, 60, null);
        boolean bl = false;
        it.setAttributeOwnerId(nExpression.getAttributeOwnerId());
        return irCall;
    }

    @Override
    @NotNull
    public IrExpression visitPropertyReference(@NotNull IrPropertyReference expression) {
        IrPropertyReferenceImpl irPropertyReferenceImpl;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrExpression irExpression = super.visitPropertyReference(expression);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrPropertyReference");
        IrPropertyReference nExpression = (IrPropertyReference)irExpression;
        if (!((IrProperty)((IrPropertySymbol)nExpression.getSymbol()).getOwner()).isExpect()) {
            return nExpression;
        }
        MemberDescriptor memberDescriptor = this.findActualForExpect((MemberDescriptor)((IrPropertySymbol)nExpression.getSymbol()).getDescriptor());
        PropertyDescriptor propertyDescriptor = memberDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)memberDescriptor : null;
        if (propertyDescriptor == null) {
            return nExpression;
        }
        IrPropertySymbol newSymbol = this.symbolTable.referenceProperty(propertyDescriptor);
        PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)newSymbol.getDescriptor()).getGetter();
        if (propertyGetterDescriptor != null) {
            PropertyGetterDescriptor it = propertyGetterDescriptor;
            boolean bl = false;
            irSimpleFunctionSymbol2 = this.symbolTable.referenceSimpleFunction((FunctionDescriptor)it);
        } else {
            irSimpleFunctionSymbol2 = null;
        }
        IrSimpleFunctionSymbol newGetter = irSimpleFunctionSymbol2;
        PropertySetterDescriptor propertySetterDescriptor = ((PropertyDescriptor)newSymbol.getDescriptor()).getSetter();
        if (propertySetterDescriptor != null) {
            PropertySetterDescriptor it = propertySetterDescriptor;
            boolean bl = false;
            irSimpleFunctionSymbol = this.symbolTable.referenceSimpleFunction((FunctionDescriptor)it);
        } else {
            irSimpleFunctionSymbol = null;
        }
        IrSimpleFunctionSymbol newSetter = irSimpleFunctionSymbol;
        IrPropertyReference $this$visitPropertyReference_u24lambda_u2410 = nExpression;
        boolean bl = false;
        IrPropertyReferenceImpl it = irPropertyReferenceImpl = new IrPropertyReferenceImpl($this$visitPropertyReference_u24lambda_u2410.getStartOffset(), $this$visitPropertyReference_u24lambda_u2410.getEndOffset(), $this$visitPropertyReference_u24lambda_u2410.getType(), newSymbol, $this$visitPropertyReference_u24lambda_u2410.getTypeArgumentsCount(), $this$visitPropertyReference_u24lambda_u2410.getField(), newGetter, newSetter, $this$visitPropertyReference_u24lambda_u2410.getOrigin());
        boolean bl2 = false;
        it.setAttributeOwnerId($this$visitPropertyReference_u24lambda_u2410.getAttributeOwnerId());
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default($this$visitPropertyReference_u24lambda_u2410, nExpression, 0, 2, null);
        it.setDispatchReceiver($this$visitPropertyReference_u24lambda_u2410.getDispatchReceiver());
        it.setExtensionReceiver($this$visitPropertyReference_u24lambda_u2410.getExtensionReceiver());
        return irPropertyReferenceImpl;
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression) {
        IrFunctionReferenceImpl irFunctionReferenceImpl;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrExpression irExpression = super.visitFunctionReference(expression);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
        IrFunctionReference nExpression = (IrFunctionReference)irExpression;
        if (!((IrFunctionSymbol)nExpression.getSymbol()).getOwner().isExpect()) {
            return nExpression;
        }
        MemberDescriptor memberDescriptor = this.findActualForExpect((MemberDescriptor)((IrFunctionSymbol)nExpression.getSymbol()).getDescriptor());
        FunctionDescriptor functionDescriptor = memberDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)memberDescriptor : null;
        if (functionDescriptor == null) {
            return nExpression;
        }
        IrSimpleFunctionSymbol newCallee = this.symbolTable.referenceSimpleFunction(functionDescriptor);
        IrFunctionReference $this$visitFunctionReference_u24lambda_u2412 = nExpression;
        boolean bl = false;
        IrFunctionReferenceImpl it = irFunctionReferenceImpl = new IrFunctionReferenceImpl($this$visitFunctionReference_u24lambda_u2412.getStartOffset(), $this$visitFunctionReference_u24lambda_u2412.getEndOffset(), $this$visitFunctionReference_u24lambda_u2412.getType(), newCallee, $this$visitFunctionReference_u24lambda_u2412.getTypeArgumentsCount(), $this$visitFunctionReference_u24lambda_u2412.getValueArgumentsCount(), $this$visitFunctionReference_u24lambda_u2412.getReflectionTarget(), $this$visitFunctionReference_u24lambda_u2412.getOrigin());
        boolean bl2 = false;
        it.setAttributeOwnerId($this$visitFunctionReference_u24lambda_u2412.getAttributeOwnerId());
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default(it, nExpression, 0, 2, null);
        it.setDispatchReceiver($this$visitFunctionReference_u24lambda_u2412.getDispatchReceiver());
        it.setExtensionReceiver($this$visitFunctionReference_u24lambda_u2412.getExtensionReceiver());
        return irFunctionReferenceImpl;
    }

    @Override
    @NotNull
    public IrExpression visitClassReference(@NotNull IrClassReference expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrExpression irExpression = super.visitClassReference(expression);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrClassReference");
        IrClassReference nExpression = (IrClassReference)irExpression;
        IrClassifierSymbol irClassifierSymbol = nExpression.getSymbol();
        IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
        if (irClassSymbol == null) {
            return nExpression;
        }
        IrClassSymbol oldSymbol = irClassSymbol;
        if (!((IrClass)oldSymbol.getOwner()).isExpect()) {
            return nExpression;
        }
        MemberDescriptor memberDescriptor = this.findActualForExpect((MemberDescriptor)oldSymbol.getDescriptor());
        ClassDescriptor classDescriptor = memberDescriptor instanceof ClassDescriptor ? (ClassDescriptor)memberDescriptor : null;
        if (classDescriptor == null) {
            return nExpression;
        }
        IrClassSymbol newSymbol = this.symbolTable.referenceClass(classDescriptor);
        IrClassReference $this$visitClassReference_u24lambda_u2413 = nExpression;
        boolean bl = false;
        return new IrClassReferenceImpl($this$visitClassReference_u24lambda_u2413.getStartOffset(), $this$visitClassReference_u24lambda_u2413.getEndOffset(), $this$visitClassReference_u24lambda_u2413.getType(), newSymbol, $this$visitClassReference_u24lambda_u2413.getClassType());
    }

    @Nullable
    public final List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (AdditionalIrUtilsKt.isTopLevelDeclaration(declaration) && this.shouldRemoveTopLevelDeclaration(declaration)) {
            return CollectionsKt.emptyList();
        }
        if (declaration instanceof IrValueParameter) {
            this.tryCopyDefaultArguments((IrValueParameter)declaration);
        }
        return null;
    }

    private final boolean shouldRemoveTopLevelDeclaration(IrDeclaration declaration) {
        IrDeclaration irDeclaration;
        return this.doRemove && ((irDeclaration = declaration) instanceof IrClass ? ((IrClass)declaration).isExpect() : (irDeclaration instanceof IrProperty ? ((IrProperty)declaration).isExpect() : (irDeclaration instanceof IrFunction ? ((IrFunction)declaration).isExpect() : false)));
    }

    private final boolean isOptionalAnnotationClass(IrClass klass) {
        return klass.getKind() == ClassKind.ANNOTATION_CLASS && klass.isExpect() && AdditionalIrUtilsKt.hasAnnotation(klass.getAnnotations(), OptionalAnnotationUtil.INSTANCE.getOPTIONAL_EXPECTATION_FQ_NAME());
    }

    private final void tryCopyDefaultArguments(IrValueParameter declaration) {
        Object object;
        int index;
        IrFunction function;
        block13: {
            block12: {
                if (declaration.getDefaultValue() != null) {
                    return;
                }
                IrDeclarationParent irDeclarationParent = declaration.getParent();
                IrFunction irFunction = irDeclarationParent instanceof IrFunction ? (IrFunction)irDeclarationParent : null;
                if (irFunction == null) {
                    return;
                }
                function = irFunction;
                if (function instanceof IrConstructor && this.isOptionalAnnotationClass(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)function))) {
                    return;
                }
                if (!function.getDescriptor().isActual()) {
                    return;
                }
                index = declaration.getIndex();
                if (index < 0) {
                    return;
                }
                boolean bl = Intrinsics.areEqual((Object)function.getValueParameters().get(index), (Object)declaration);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                MemberDescriptor $this$safeAs$iv = this.findExpectForActual((MemberDescriptor)function.getDescriptor());
                boolean $i$f$safeAs = false;
                MemberDescriptor memberDescriptor = $this$safeAs$iv;
                if (!(memberDescriptor instanceof FunctionDescriptor)) {
                    memberDescriptor = null;
                }
                if ((object = (FunctionDescriptor)memberDescriptor) == null) break block12;
                FunctionDescriptor it = object;
                boolean bl2 = false;
                IrFunction irFunction2 = IrUtilsKt.referenceFunction(this.symbolTable, (CallableDescriptor)it).getOwner();
                object = irFunction2;
                if (irFunction2 != null) break block13;
            }
            return;
        }
        Object expectFunction = object;
        IrExpressionBody irExpressionBody = ((IrFunction)expectFunction).getValueParameters().get(index).getDefaultValue();
        if (irExpressionBody == null) {
            return;
        }
        IrExpressionBody defaultValue = irExpressionBody;
        Pair expectToActual = TuplesKt.to((Object)expectFunction, (Object)function);
        if (!this.typeParameterSubstitutionMap.containsKey(expectToActual)) {
            List<IrTypeParameter> functionTypeParameters = IrTypeSystemContextKt.extractTypeParameters(function);
            List<IrTypeParameter> expectFunctionTypeParameters = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)expectFunction);
            List typeParametersMapping = CollectionsKt.zip((Iterable)expectFunctionTypeParameters, (Iterable)functionTypeParameters);
            boolean bl = false;
            this.typeParameterSubstitutionMap.put((Pair<IrFunction, IrFunction>)expectToActual, MapsKt.toMap((Iterable)typeParametersMapping));
        }
        IrExpressionBody originalDefault = defaultValue;
        boolean bl = false;
        declaration.setDefaultValue(declaration.getFactory().createExpressionBody(originalDefault.getStartOffset(), originalDefault.getEndOffset(), (Function1<? super IrExpressionBody, Unit>)((Function1)new Function1<IrExpressionBody, Unit>(this, originalDefault, function, (Pair<? extends IrFunction, ? extends IrFunction>)expectToActual){
            final /* synthetic */ ExpectDeclarationRemover this$0;
            final /* synthetic */ IrExpressionBody $originalDefault;
            final /* synthetic */ IrFunction $function;
            final /* synthetic */ Pair<IrFunction, IrFunction> $expectToActual;
            {
                this.this$0 = $receiver;
                this.$originalDefault = $originalDefault;
                this.$function = $function;
                this.$expectToActual = $expectToActual;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull IrExpressionBody $this$createExpressionBody) {
                void initialParent$iv;
                void symbolRemapper;
                void $this$deepCopyWithSymbols$iv$iv;
                void $this$deepCopyWithSymbols$iv;
                Intrinsics.checkNotNullParameter((Object)$this$createExpressionBody, (String)"$this$createExpressionBody");
                IrElement irElement = this.$originalDefault.getExpression();
                IrDeclarationParent irDeclarationParent = this.$function;
                ExpectDeclarationRemover expectDeclarationRemover = this.this$0;
                Pair<IrFunction, IrFunction> pair = this.$expectToActual;
                boolean $i$f$deepCopyWithSymbols = false;
                void var7_7 = $this$deepCopyWithSymbols$iv;
                DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                boolean $i$f$deepCopyWithSymbols2 = false;
                IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
                DeepCopyTypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
                TypeRemapper cfr_ignored_0 = (TypeRemapper)typeRemapper$iv$iv;
                SymbolRemapper symbolRemapper2 = symbolRemapper$iv$iv;
                void var15_12 = $this$deepCopyWithSymbols$iv$iv;
                ExpectDeclarationRemover expectDeclarationRemover2 = this.this$0;
                IrExpressionBody irExpressionBody = $this$createExpressionBody;
                boolean bl = false;
                DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)symbolRemapper, new IrTypeParameterRemapper((Map)MapsKt.getValue((Map)ExpectDeclarationRemover.access$getTypeParameterSubstitutionMap$p(expectDeclarationRemover), pair)));
                IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var15_12.transform(deepCopyIrTreeWithSymbols, null), (IrDeclarationParent)initialParent$iv);
                if (irElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                }
                irExpressionBody.setExpression(ExpectDeclarationRemover.access$remapExpectValueSymbols(expectDeclarationRemover2, (IrExpression)((IrElement)((IrExpression)irElement2))));
            }
        })));
    }

    private final MemberDescriptor findActualForExpect(MemberDescriptor $this$findActualForExpect) {
        if (!$this$findActualForExpect.isExpect()) {
            throw new IllegalStateException($this$findActualForExpect.toString());
        }
        return (MemberDescriptor)CollectionsKt.singleOrNull((List)ExpectedActualResolverKt.findCompatibleActualsForExpected$default((MemberDescriptor)$this$findActualForExpect, (ModuleDescriptor)DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)$this$findActualForExpect)), null, (int)2, null));
    }

    private final MemberDescriptor findExpectForActual(MemberDescriptor $this$findExpectForActual) {
        if (!$this$findExpectForActual.isActual()) {
            throw new IllegalStateException($this$findExpectForActual.toString());
        }
        return (MemberDescriptor)CollectionsKt.singleOrNull((List)ExpectedActualResolverKt.findCompatibleExpectsForActual$default((MemberDescriptor)$this$findExpectForActual, null, (int)1, null));
    }

    private final IrExpression remapExpectValueSymbols(IrExpression $this$remapExpectValueSymbols) {
        return $this$remapExpectValueSymbols.transform((IrElementTransformer)new IrElementTransformerVoid(this){
            final /* synthetic */ ExpectDeclarationRemover this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                this.transformChildrenVoid(expression);
                IrValueParameter irValueParameter = ExpectDeclarationRemover.access$remapExpectValue(this.this$0, expression.getSymbol());
                if (irValueParameter == null) {
                    return expression;
                }
                IrValueParameter newValue = irValueParameter;
                return new IrGetValueImpl(expression.getStartOffset(), expression.getEndOffset(), newValue.getType(), newValue.getSymbol(), expression.getOrigin());
            }
        }, (Object)null);
    }

    private final IrValueParameter remapExpectValue(IrValueSymbol symbol2) {
        IrValueParameter irValueParameter;
        if (!(symbol2 instanceof IrValueParameterSymbol)) {
            return null;
        }
        IrValueParameter parameter = (IrValueParameter)((IrValueParameterSymbol)symbol2).getOwner();
        IrDeclarationParent parent2 = parameter.getParent();
        if (parent2 instanceof IrClass) {
            boolean bl = Intrinsics.areEqual((Object)parameter, (Object)((IrClass)parent2).getThisReceiver());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            MemberDescriptor memberDescriptor = this.findActualForExpect((MemberDescriptor)((IrClass)parent2).getDescriptor());
            Intrinsics.checkNotNull((Object)memberDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            IrValueParameter irValueParameter2 = ((IrClass)this.symbolTable.referenceClass((ClassDescriptor)memberDescriptor).getOwner()).getThisReceiver();
            irValueParameter = irValueParameter2;
            Intrinsics.checkNotNull((Object)irValueParameter2);
        } else if (parent2 instanceof IrFunction) {
            MemberDescriptor memberDescriptor = this.findActualForExpect((MemberDescriptor)((IrFunction)parent2).getDescriptor());
            Intrinsics.checkNotNull((Object)memberDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            IrFunction actualFunction = IrUtilsKt.referenceFunction(this.symbolTable, (CallableDescriptor)((FunctionDescriptor)memberDescriptor)).getOwner();
            IrValueParameter irValueParameter3 = parameter;
            if (Intrinsics.areEqual((Object)irValueParameter3, (Object)((IrFunction)parent2).getDispatchReceiverParameter())) {
                IrValueParameter irValueParameter4 = actualFunction.getDispatchReceiverParameter();
                irValueParameter = irValueParameter4;
                Intrinsics.checkNotNull((Object)irValueParameter4);
            } else if (Intrinsics.areEqual((Object)irValueParameter3, (Object)((IrFunction)parent2).getExtensionReceiverParameter())) {
                IrValueParameter irValueParameter5 = actualFunction.getExtensionReceiverParameter();
                irValueParameter = irValueParameter5;
                Intrinsics.checkNotNull((Object)irValueParameter5);
            } else {
                boolean bl = Intrinsics.areEqual((Object)((IrFunction)parent2).getValueParameters().get(parameter.getIndex()), (Object)parameter);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                irValueParameter = actualFunction.getValueParameters().get(parameter.getIndex());
            }
        } else {
            throw new IllegalStateException(parent2.toString());
        }
        return irValueParameter;
    }

    public static final /* synthetic */ boolean access$shouldRemoveTopLevelDeclaration(ExpectDeclarationRemover $this, IrDeclaration declaration) {
        return $this.shouldRemoveTopLevelDeclaration(declaration);
    }

    public static final /* synthetic */ IrValueParameter access$remapExpectValue(ExpectDeclarationRemover $this, IrValueSymbol symbol2) {
        return $this.remapExpectValue(symbol2);
    }

    public static final /* synthetic */ IrExpression access$remapExpectValueSymbols(ExpectDeclarationRemover $this, IrExpression $receiver) {
        return $this.remapExpectValueSymbols($receiver);
    }

    public static final /* synthetic */ Map access$getTypeParameterSubstitutionMap$p(ExpectDeclarationRemover $this) {
        return $this.typeParameterSubstitutionMap;
    }
}

