/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.FqNameEqualityChecker;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeCheckerStateKt;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012*\u00020\t\u001a\u0012\u0010\u0013\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0014"}, d2={"isBoxedArray", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "getArrayElementType", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "isNullable", "isStrictSubtypeOfClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "superClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "isSubtypeOf", "superType", "typeSystem", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "isSubtypeOfClass", "superTypes", "", "toArrayOrPrimitiveArrayType", "ir.tree"})
public final class IrTypeUtilsKt {
    @NotNull
    public static final List<IrType> superTypes(@NotNull IrClassifierSymbol $this$superTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$superTypes, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = $this$superTypes;
        return irClassifierSymbol instanceof IrClassSymbol ? ((IrClass)((IrClassSymbol)$this$superTypes).getOwner()).getSuperTypes() : (irClassifierSymbol instanceof IrTypeParameterSymbol ? ((IrTypeParameter)((IrTypeParameterSymbol)$this$superTypes).getOwner()).getSuperTypes() : CollectionsKt.emptyList());
    }

    public static final boolean isSubtypeOfClass(@NotNull IrClassifierSymbol $this$isSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        return FqNameEqualityChecker.INSTANCE.areEqual($this$isSubtypeOfClass, superClass) || IrTypeUtilsKt.isStrictSubtypeOfClass($this$isSubtypeOfClass, superClass);
    }

    public static final boolean isStrictSubtypeOfClass(@NotNull IrClassifierSymbol $this$isStrictSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isStrictSubtypeOfClass, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
            Iterable $this$any$iv = IrTypeUtilsKt.superTypes($this$isStrictSubtypeOfClass);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrType it = (IrType)element$iv;
                    boolean bl2 = false;
                    if (!IrTypeUtilsKt.isSubtypeOfClass(it, superClass)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isSubtypeOfClass(@NotNull IrType $this$isSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        return $this$isSubtypeOfClass instanceof IrSimpleType && IrTypeUtilsKt.isSubtypeOfClass(((IrSimpleType)$this$isSubtypeOfClass).getClassifier(), superClass);
    }

    public static final boolean isStrictSubtypeOfClass(@NotNull IrType $this$isStrictSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isStrictSubtypeOfClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        return $this$isStrictSubtypeOfClass instanceof IrSimpleType && IrTypeUtilsKt.isStrictSubtypeOfClass(((IrSimpleType)$this$isStrictSubtypeOfClass).getClassifier(), superClass);
    }

    public static final boolean isSubtypeOf(@NotNull IrType $this$isSubtypeOf, @NotNull IrType superType, @NotNull IrTypeSystemContext typeSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        return AbstractTypeChecker.isSubtypeOf$default((AbstractTypeChecker)AbstractTypeChecker.INSTANCE, (TypeCheckerState)IrTypeCheckerStateKt.createIrTypeCheckerState(typeSystem), (KotlinTypeMarker)$this$isSubtypeOf, (KotlinTypeMarker)superType, (boolean)false, (int)8, null);
    }

    public static final boolean isNullable(@NotNull IrType $this$isNullable) {
        boolean bl;
        block8: {
            IrType irType;
            block9: {
                IrClassifierSymbol classifier;
                block11: {
                    block10: {
                        Intrinsics.checkNotNullParameter((Object)$this$isNullable, (String)"<this>");
                        irType = $this$isNullable;
                        if (!(irType instanceof IrSimpleType)) break block9;
                        classifier = ((IrSimpleType)$this$isNullable).getClassifier();
                        if (!(classifier instanceof IrClassSymbol)) break block10;
                        bl = ((IrSimpleType)$this$isNullable).getNullability() == SimpleTypeNullability.MARKED_NULLABLE;
                        break block8;
                    }
                    if (!(classifier instanceof IrTypeParameterSymbol)) break block11;
                    switch (WhenMappings.$EnumSwitchMapping$0[((IrSimpleType)$this$isNullable).getNullability().ordinal()]) {
                        case 1: {
                            bl = true;
                            break block8;
                        }
                        case 2: {
                            Iterable $this$any$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    IrType p0 = (IrType)element$iv;
                                    boolean bl2 = false;
                                    if (!IrTypeUtilsKt.isNullable(p0)) continue;
                                    bl = true;
                                    break block8;
                                }
                                bl = false;
                            }
                            break block8;
                        }
                        case 3: {
                            bl = false;
                            break block8;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                throw new IllegalStateException(("Unsupported classifier: " + classifier).toString());
            }
            bl = irType instanceof IrDynamicType;
        }
        return bl;
    }

    public static final boolean isBoxedArray(@NotNull IrType $this$isBoxedArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isBoxedArray, (String)"<this>");
        Object object = IrTypesKt.getClassOrNull($this$isBoxedArray);
        return Intrinsics.areEqual(object != null && (object = (IrClass)object.getOwner()) != null ? IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object) : null, (Object)StandardNames.FqNames.array.toSafe());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final IrType getArrayElementType(@NotNull IrType $this$getArrayElementType, @NotNull IrBuiltIns irBuiltIns) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)$this$getArrayElementType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if (IrTypeUtilsKt.isBoxedArray($this$getArrayElementType)) {
            IrTypeArgument argument = (IrTypeArgument)CollectionsKt.singleOrNull(((IrSimpleType)$this$getArrayElementType).getArguments());
            if (argument instanceof IrTypeProjection) {
                irType = ((IrTypeProjection)argument).getType();
                return irType;
            } else {
                if (!(argument instanceof IrStarProjection)) throw new IllegalStateException(("Unexpected array argument type: " + argument).toString());
                irType = irBuiltIns.getAnyNType();
            }
            return irType;
        } else {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getArrayElementType);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClassSymbol classifier = irClassSymbol;
            irType = irBuiltIns.getPrimitiveArrayElementTypes().get(classifier);
            if (irType != null) return irType;
            throw new AssertionError((Object)("Primitive array expected: " + classifier));
        }
    }

    @NotNull
    public static final IrType toArrayOrPrimitiveArrayType(@NotNull IrType $this$toArrayOrPrimitiveArrayType, @NotNull IrBuiltIns irBuiltIns) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toArrayOrPrimitiveArrayType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if (IrTypePredicatesKt.isPrimitiveType$default($this$toArrayOrPrimitiveArrayType, false, 1, null)) {
            object = irBuiltIns.getPrimitiveArrayForType().get($this$toArrayOrPrimitiveArrayType);
            if (object == null || (object = IrTypesKt.getDefaultType((IrClassifierSymbol)object)) == null) {
                throw new AssertionError((Object)($this$toArrayOrPrimitiveArrayType + " not in primitiveArrayForType"));
            }
        } else {
            IrType[] irTypeArray = new IrType[]{$this$toArrayOrPrimitiveArrayType};
            object = IrTypesKt.typeWith((IrClassifierSymbol)irBuiltIns.getArrayClass(), irTypeArray);
        }
        return object;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SimpleTypeNullability.values().length];
            nArray[SimpleTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
            nArray[SimpleTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
            nArray[SimpleTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

