/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.phaser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.phaser.ActionState;
import org.jetbrains.kotlin.backend.common.phaser.BeforeOrAfter;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.phaser.PhaserState;
import org.jetbrains.kotlin.backend.common.phaser.SameTypeCompilerPhase;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u00fd\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0018\b\u0002\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00000\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\u000b\u0012$\b\u0002\u0010\f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00028\u0001`\u000f0\t\u0012$\b\u0002\u0010\u0010\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00028\u0001`\u000f0\t\u0012$\b\u0002\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00028\u0001`\u000f0\t\u00126\b\u0002\u0010\u0012\u001a0\u0012,\u0012*\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\u0013j\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000`\u00150\t\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J,\u0010!\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0017\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00000#0\"2\u0006\u0010$\u001a\u00020\u0017H\u0016J3\u0010%\u001a\u00028\u00012\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010)2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010,J3\u0010-\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010)2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010.\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010/J3\u00100\u001a\u00028\u00012\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010)2\u0006\u0010*\u001a\u00028\u00002\u0006\u00101\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010,J3\u00102\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010)2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010/J\b\u00103\u001a\u00020\u0006H\u0016R<\u0010\u0012\u001a0\u0012,\u0012*\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\u0013j\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000`\u00150\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0010\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00028\u0001`\u000f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR-\u0010\f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00028\u0001`\u000f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR!\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR0\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00028\u0001`\u000f0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001d\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Data", "Lorg/jetbrains/kotlin/backend/common/phaser/SameTypeCompilerPhase;", "name", "", "description", "prerequisite", "", "lower", "Lorg/jetbrains/kotlin/backend/common/phaser/CompilerPhase;", "preconditions", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/backend/common/phaser/Checker;", "postconditions", "stickyPostconditions", "actions", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/backend/common/phaser/ActionState;", "Lorg/jetbrains/kotlin/backend/common/phaser/Action;", "nlevels", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lorg/jetbrains/kotlin/backend/common/phaser/CompilerPhase;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;I)V", "getDescription", "()Ljava/lang/String;", "getName", "getPostconditions", "()Ljava/util/Set;", "getPreconditions", "getPrerequisite", "getStickyPostconditions", "getNamedSubphases", "", "Lkotlin/Pair;", "startDepth", "invoke", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "phaserState", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;", "context", "input", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Ljava/lang/Object;)Ljava/lang/Object;", "runAfter", "output", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Ljava/lang/Object;)V", "runAndProfile", "source", "runBefore", "toString", "ir.backend.common"})
public final class NamedCompilerPhase<Context extends CommonBackendContext, Data>
implements SameTypeCompilerPhase<Context, Data> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @NotNull
    private final Set<NamedCompilerPhase<Context, ?>> prerequisite;
    @NotNull
    private final CompilerPhase<Context, Data, Data> lower;
    @NotNull
    private final Set<Function1<Data, Unit>> preconditions;
    @NotNull
    private final Set<Function1<Data, Unit>> postconditions;
    @NotNull
    private final Set<Function1<Data, Unit>> stickyPostconditions;
    @NotNull
    private final Set<Function3<ActionState, Data, Context, Unit>> actions;
    private final int nlevels;

    public NamedCompilerPhase(@NotNull String name, @NotNull String description, @NotNull Set<? extends NamedCompilerPhase<? super Context, ?>> prerequisite, @NotNull CompilerPhase<? super Context, Data, Data> lower2, @NotNull Set<? extends Function1<? super Data, Unit>> preconditions, @NotNull Set<? extends Function1<? super Data, Unit>> postconditions, @NotNull Set<? extends Function1<? super Data, Unit>> stickyPostconditions, @NotNull Set<? extends Function3<? super ActionState, ? super Data, ? super Context, Unit>> actions, int nlevels) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(prerequisite, (String)"prerequisite");
        Intrinsics.checkNotNullParameter(lower2, (String)"lower");
        Intrinsics.checkNotNullParameter(preconditions, (String)"preconditions");
        Intrinsics.checkNotNullParameter(postconditions, (String)"postconditions");
        Intrinsics.checkNotNullParameter(stickyPostconditions, (String)"stickyPostconditions");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        this.name = name;
        this.description = description;
        this.prerequisite = prerequisite;
        this.lower = lower2;
        this.preconditions = preconditions;
        this.postconditions = postconditions;
        this.stickyPostconditions = stickyPostconditions;
        this.actions = actions;
        this.nlevels = nlevels;
    }

    public /* synthetic */ NamedCompilerPhase(String string, String string2, Set set, CompilerPhase compilerPhase, Set set2, Set set3, Set set4, Set set5, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n2 & 0x10) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n2 & 0x20) != 0) {
            set3 = SetsKt.emptySet();
        }
        if ((n2 & 0x40) != 0) {
            set4 = SetsKt.emptySet();
        }
        if ((n2 & 0x80) != 0) {
            set5 = SetsKt.emptySet();
        }
        if ((n2 & 0x100) != 0) {
            n = 0;
        }
        this(string, string2, set, compilerPhase, set2, set3, set4, set5, n);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final Set<NamedCompilerPhase<Context, ?>> getPrerequisite() {
        return this.prerequisite;
    }

    @NotNull
    public final Set<Function1<Data, Unit>> getPreconditions() {
        return this.preconditions;
    }

    @NotNull
    public final Set<Function1<Data, Unit>> getPostconditions() {
        return this.postconditions;
    }

    @Override
    @NotNull
    public Set<Function1<Data, Unit>> getStickyPostconditions() {
        return this.stickyPostconditions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Data invoke(@NotNull PhaseConfig phaseConfig, @NotNull PhaserState<Data> phaserState, @NotNull Context context, Data input) {
        Data Data2;
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter(phaserState, (String)"phaserState");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        if (!phaseConfig.getEnabled().contains(this)) {
            return input;
        }
        boolean bl = phaserState.getAlreadyDone().containsAll((Collection)this.prerequisite);
        if (_Assertions.ENABLED && !bl) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean $i$a$-assert-NamedCompilerPhase$invoke$22 = false;
            Iterable iterable = SetsKt.minus(this.prerequisite, (Iterable)phaserState.getAlreadyDone());
            StringBuilder stringBuilder = new StringBuilder().append("Lowering ").append(this.name).append(": phases ");
            boolean $i$f$map = false;
            void var10_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NamedCompilerPhase namedCompilerPhase = (NamedCompilerPhase)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.name);
            }
            String $i$a$-assert-NamedCompilerPhase$invoke$22 = stringBuilder.append((List)destination$iv$iv).append(" are required, but not satisfied").toString();
            throw new AssertionError((Object)$i$a$-assert-NamedCompilerPhase$invoke$22);
        }
        context.setInVerbosePhase(phaseConfig.getVerbose().contains(this));
        this.runBefore(phaseConfig, phaserState, context, input);
        if (phaseConfig.getNeedProfiling()) {
            Data2 = this.runAndProfile(phaseConfig, phaserState, context, input);
        } else {
            void $this$downlevel$iv;
            PhaserState<Data> $i$a$-assert-NamedCompilerPhase$invoke$22 = phaserState;
            int nlevels$iv = this.nlevels;
            boolean $i$f$downlevel = false;
            $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() + nlevels$iv);
            boolean bl3 = false;
            Data result$iv = this.lower.invoke(phaseConfig, phaserState, context, input);
            $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() - nlevels$iv);
            Data2 = result$iv;
        }
        Data output = Data2;
        this.runAfter(phaseConfig, phaserState, context, output);
        phaserState.getAlreadyDone().add(this);
        int n = phaserState.getPhaseCount();
        phaserState.setPhaseCount(n + 1);
        return output;
    }

    private final void runBefore(PhaseConfig phaseConfig, PhaserState<Data> phaserState, Context context, Data input) {
        ActionState state = new ActionState(phaseConfig, this, phaserState.getPhaseCount(), BeforeOrAfter.BEFORE);
        for (Function3<ActionState, Data, Context, Unit> function3 : this.actions) {
            function3.invoke((Object)state, input, context);
        }
        if (phaseConfig.getCheckConditions()) {
            for (Function1 function1 : this.preconditions) {
                function1.invoke(input);
            }
        }
    }

    private final void runAfter(PhaseConfig phaseConfig, PhaserState<Data> phaserState, Context context, Data output) {
        ActionState state = new ActionState(phaseConfig, this, phaserState.getPhaseCount(), BeforeOrAfter.AFTER);
        for (Function3<ActionState, Data, Context, Unit> function3 : this.actions) {
            function3.invoke((Object)state, output, context);
        }
        if (phaseConfig.getCheckConditions()) {
            for (Function1 function1 : this.postconditions) {
                function1.invoke(output);
            }
            for (Function1 function1 : this.getStickyPostconditions()) {
                function1.invoke(output);
            }
            if (phaseConfig.getCheckStickyConditions()) {
                for (Function1 function1 : phaserState.getStickyPostconditions()) {
                    function1.invoke(output);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Data runAndProfile(PhaseConfig phaseConfig, PhaserState<Data> phaserState, Context context, Data source) {
        void $this$downlevel$iv;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        PhaserState<Data> phaserState2 = phaserState;
        int nlevels$iv = this.nlevels;
        boolean $i$f$downlevel = false;
        $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() + nlevels$iv);
        Ref.ObjectRef objectRef = result2;
        boolean bl2 = false;
        Data result$iv = this.lower.invoke(phaseConfig, phaserState, context, source);
        $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() - nlevels$iv);
        objectRef.element = result$iv;
        long msec = System.currentTimeMillis() - start$iv;
        System.out.println((Object)(StringsKt.repeat((CharSequence)"\t", (int)phaserState.getDepth()) + this.description + ": " + msec + " msec"));
        Object object = result2.element;
        Intrinsics.checkNotNull((Object)object);
        return (Data)object;
    }

    @Override
    @NotNull
    public List<Pair<Integer, NamedCompilerPhase<Context, ?>>> getNamedSubphases(int startDepth) {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)TuplesKt.to((Object)startDepth, (Object)this)), (Iterable)this.lower.getNamedSubphases(startDepth + this.nlevels));
    }

    @NotNull
    public String toString() {
        return "Compiler Phase @" + this.name;
    }
}

