/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir;

import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0004J\u0014\u0010\u0012\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J$\u0010\u0016\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020 J\u000e\u0010!\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0004J\u0014\u0010\"\u001a\u00020\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014J\u000e\u0010#\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020$J\u0006\u0010%\u001a\u00020\nJ\u0006\u0010&\u001a\u00020\nJ\u0006\u0010'\u001a\u00020\nJ\u0014\u0010(\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0014J\u000e\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-J\u001c\u0010.\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ)\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u0002012\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020403\"\u000204H&\u00a2\u0006\u0002\u00105J\u001c\u00106\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0006\u00107\u001a\u00020\nJ\u000e\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020:J\u0014\u0010;\u001a\u00020\n2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u0014J\u0014\u0010>\u001a\u00020\n2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u0014J\u0014\u0010?\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0014J\u000e\u0010@\u001a\u00020\n2\u0006\u0010,\u001a\u00020-J\"\u0010A\u001a\u00020\n2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020=0\u00142\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014J\u0014\u0010D\u001a\u00020\n2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020=0\u0014J\"\u0010E\u001a\u00020\n2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020=0\u00142\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014J\u000e\u0010F\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0004J\u001c\u0010G\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010H\u001a\u00020\nR\u0018\u0010\u0003\u001a\u00020\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "", "()V", "numberOfNestedBlocks", "", "getNumberOfNestedBlocks", "()I", "setNumberOfNestedBlocks", "(I)V", "buildBlock", "", "label", "", "resultType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "buildBr", "absoluteBlockLevel", "buildBrIf", "buildCall", "symbol", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "buildCallIndirect", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "tableIdx", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;", "buildCatch", "tagIdx", "buildConstF32", "value", "", "buildConstF64", "", "buildConstI32", "buildConstI32Symbol", "buildConstI64", "", "buildDrop", "buildElse", "buildEnd", "buildGetGlobal", "global", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "buildGetLocal", "local", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "buildIf", "buildInstr", "op", "Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "immediates", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "buildLoop", "buildRefCast", "buildRefNull", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType;", "buildRttCanon", "decl", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "buildRttSub", "buildSetGlobal", "buildSetLocal", "buildStructGet", "struct", "fieldId", "buildStructNew", "buildStructSet", "buildThrow", "buildTry", "buildUnreachable", "wasm.ir"})
public abstract class WasmExpressionBuilder {
    public abstract void buildInstr(@NotNull WasmOp var1, WasmImmediate ... var2);

    public abstract int getNumberOfNestedBlocks();

    public abstract void setNumberOfNestedBlocks(int var1);

    public final void buildConstI32(int value) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstI32(value)};
        this.buildInstr(WasmOp.I32_CONST, wasmImmediateArray);
    }

    public final void buildConstI64(long value) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstI64(value)};
        this.buildInstr(WasmOp.I64_CONST, wasmImmediateArray);
    }

    public final void buildConstF32(float value) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstF32(UInt.constructor-impl((int)Float.floatToRawIntBits(value)), null)};
        this.buildInstr(WasmOp.F32_CONST, wasmImmediateArray);
    }

    public final void buildConstF64(double value) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstF64(ULong.constructor-impl((long)Double.doubleToRawLongBits(value)), null)};
        this.buildInstr(WasmOp.F64_CONST, wasmImmediateArray);
    }

    public final void buildConstI32Symbol(@NotNull WasmSymbol<Integer> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.SymbolI32(value)};
        this.buildInstr(WasmOp.I32_CONST, wasmImmediateArray);
    }

    public final void buildUnreachable() {
        this.buildInstr(WasmOp.UNREACHABLE, new WasmImmediate[0]);
    }

    public final void buildBlock(@Nullable String label, @Nullable WasmType resultType) {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.BLOCK, wasmImmediateArray);
    }

    public static /* synthetic */ void buildBlock$default(WasmExpressionBuilder wasmExpressionBuilder, String string, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildBlock");
        }
        if ((n & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildBlock(string, wasmType);
    }

    public final void buildLoop(@Nullable String label, @Nullable WasmType resultType) {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.LOOP, wasmImmediateArray);
    }

    public static /* synthetic */ void buildLoop$default(WasmExpressionBuilder wasmExpressionBuilder, String string, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildLoop");
        }
        if ((n & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildLoop(string, wasmType);
    }

    public final void buildIf(@Nullable String label, @Nullable WasmType resultType) {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.IF, wasmImmediateArray);
    }

    public static /* synthetic */ void buildIf$default(WasmExpressionBuilder wasmExpressionBuilder, String string, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildIf");
        }
        if ((n & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildIf(string, wasmType);
    }

    public final void buildElse() {
        this.buildInstr(WasmOp.ELSE, new WasmImmediate[0]);
    }

    public final void buildEnd() {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + -1);
        this.buildInstr(WasmOp.END, new WasmImmediate[0]);
    }

    public final void buildBr(int absoluteBlockLevel) {
        boolean bl;
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Negative relative block index";
            throw new AssertionError((Object)string);
        }
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LabelIdx(relativeLevel)};
        this.buildInstr(WasmOp.BR, wasmImmediateArray);
    }

    public final void buildThrow(int tagIdx) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TagIdx(tagIdx)};
        this.buildInstr(WasmOp.THROW, wasmImmediateArray);
    }

    public final void buildTry(@Nullable String label, @Nullable WasmType resultType) {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.TRY, wasmImmediateArray);
    }

    public static /* synthetic */ void buildTry$default(WasmExpressionBuilder wasmExpressionBuilder, String string, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildTry");
        }
        if ((n & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildTry(string, wasmType);
    }

    public final void buildCatch(int tagIdx) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TagIdx(tagIdx)};
        this.buildInstr(WasmOp.CATCH, wasmImmediateArray);
    }

    public final void buildBrIf(int absoluteBlockLevel) {
        boolean bl;
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Negative relative block index";
            throw new AssertionError((Object)string);
        }
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LabelIdx(relativeLevel)};
        this.buildInstr(WasmOp.BR_IF, wasmImmediateArray);
    }

    public final void buildCall(@NotNull WasmSymbol<? extends WasmFunction> symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.FuncIdx(symbol2)};
        this.buildInstr(WasmOp.CALL, wasmImmediateArray);
    }

    public final void buildCallIndirect(@NotNull WasmSymbol<WasmFunctionType> symbol2, @NotNull WasmSymbolReadOnly<Integer> tableIdx) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter(tableIdx, (String)"tableIdx");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TypeIdx((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)symbol2), new WasmImmediate.TableIdx(tableIdx)};
        this.buildInstr(WasmOp.CALL_INDIRECT, wasmImmediateArray);
    }

    public static /* synthetic */ void buildCallIndirect$default(WasmExpressionBuilder wasmExpressionBuilder, WasmSymbol wasmSymbol, WasmSymbolReadOnly wasmSymbolReadOnly, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildCallIndirect");
        }
        if ((n & 2) != 0) {
            wasmSymbolReadOnly = new WasmSymbol<Integer>(0);
        }
        wasmExpressionBuilder.buildCallIndirect(wasmSymbol, wasmSymbolReadOnly);
    }

    public final void buildGetLocal(@NotNull WasmLocal local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LocalIdx(local)};
        this.buildInstr(WasmOp.LOCAL_GET, wasmImmediateArray);
    }

    public final void buildSetLocal(@NotNull WasmLocal local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LocalIdx(local)};
        this.buildInstr(WasmOp.LOCAL_SET, wasmImmediateArray);
    }

    public final void buildGetGlobal(@NotNull WasmSymbol<WasmGlobal> global) {
        Intrinsics.checkNotNullParameter(global, (String)"global");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GlobalIdx(global)};
        this.buildInstr(WasmOp.GLOBAL_GET, wasmImmediateArray);
    }

    public final void buildSetGlobal(@NotNull WasmSymbol<WasmGlobal> global) {
        Intrinsics.checkNotNullParameter(global, (String)"global");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GlobalIdx(global)};
        this.buildInstr(WasmOp.GLOBAL_SET, wasmImmediateArray);
    }

    public final void buildStructGet(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull WasmSymbol<Integer> fieldId) {
        Intrinsics.checkNotNullParameter(struct, (String)"struct");
        Intrinsics.checkNotNullParameter(fieldId, (String)"fieldId");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct), new WasmImmediate.StructFieldIdx(fieldId)};
        this.buildInstr(WasmOp.STRUCT_GET, wasmImmediateArray);
    }

    public final void buildStructNew(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct) {
        Intrinsics.checkNotNullParameter(struct, (String)"struct");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct)};
        this.buildInstr(WasmOp.STRUCT_NEW_WITH_RTT, wasmImmediateArray);
    }

    public final void buildStructSet(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull WasmSymbol<Integer> fieldId) {
        Intrinsics.checkNotNullParameter(struct, (String)"struct");
        Intrinsics.checkNotNullParameter(fieldId, (String)"fieldId");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct), new WasmImmediate.StructFieldIdx(fieldId)};
        this.buildInstr(WasmOp.STRUCT_SET, wasmImmediateArray);
    }

    public final void buildRefCast() {
        this.buildInstr(WasmOp.REF_CAST, new WasmImmediate[0]);
    }

    public final void buildRefNull(@NotNull WasmHeapType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmRefType(type2))};
        this.buildInstr(WasmOp.REF_NULL, wasmImmediateArray);
    }

    public final void buildRttSub(@NotNull WasmSymbol<? extends WasmTypeDeclaration> decl) {
        Intrinsics.checkNotNullParameter(decl, (String)"decl");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TypeIdx((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)decl)};
        this.buildInstr(WasmOp.RTT_SUB, wasmImmediateArray);
    }

    public final void buildRttCanon(@NotNull WasmSymbol<? extends WasmTypeDeclaration> decl) {
        Intrinsics.checkNotNullParameter(decl, (String)"decl");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TypeIdx((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)decl)};
        this.buildInstr(WasmOp.RTT_CANON, wasmImmediateArray);
    }

    public final void buildDrop() {
        this.buildInstr(WasmOp.DROP, new WasmImmediate[0]);
    }
}

