/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.serialization;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.IrFileSerializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFlags;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrConstructorCall;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrInlineClassRepresentation;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrVariable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.serialization.IrCarrierSerializer;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.serialization.deserialization.ProtoEnumFlags;
import org.jetbrains.kotlin.serialization.deserialization.ProtoEnumFlagsUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020 H\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0016H\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020.H\u0016J\u0010\u00100\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u000201H\u0016J\u0010\u00103\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002082\u0006\u0010\u000f\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020;H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/ir/serialization/IrCarrierSerializerImpl;", "Lorg/jetbrains/kotlin/ir/serialization/IrCarrierSerializer;", "fileSerializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "bodyIndex", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;Lkotlin/jvm/functions/Function1;)V", "getBodyIndex", "()Lkotlin/jvm/functions/Function1;", "getFileSerializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "serializeAnnotation", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrConstructorCall;", "value", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "serializeBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "serializeBody", "serializeClass", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "serializeExpressionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "serializeField", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "serializeInlineClassRepresentation", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrInlineClassRepresentation;", "Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "serializeIsExternalClass", "", "serializeIsExternalField", "serializeIsExternalFunction", "serializeIsExternalProperty", "serializeModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "serializeOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "serializeParentSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "serializePropertySymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "serializeSealedSubclass", "serializeSimpleFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "serializeSimpleFunctionSymbol", "serializeSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "serializeType", "serializeTypeParameter", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "serializeValueParameter", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "serializeVariable", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrVariable;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "serializeVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "ir.tree.persistent"})
public final class IrCarrierSerializerImpl
extends IrCarrierSerializer {
    @NotNull
    private final IrFileSerializer fileSerializer;
    @NotNull
    private final Function1<IrBody, Integer> bodyIndex;

    public IrCarrierSerializerImpl(@NotNull IrFileSerializer fileSerializer, @NotNull Function1<? super IrBody, Integer> bodyIndex) {
        Intrinsics.checkNotNullParameter((Object)fileSerializer, (String)"fileSerializer");
        Intrinsics.checkNotNullParameter(bodyIndex, (String)"bodyIndex");
        this.fileSerializer = fileSerializer;
        this.bodyIndex = bodyIndex;
    }

    @NotNull
    public final IrFileSerializer getFileSerializer() {
        return this.fileSerializer;
    }

    @NotNull
    public final Function1<IrBody, Integer> getBodyIndex() {
        return this.bodyIndex;
    }

    @Override
    public long serializeParentSymbol(@NotNull IrSymbol value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value);
    }

    @Override
    public int serializeOrigin(@NotNull IrDeclarationOrigin value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrDeclarationOrigin(value);
    }

    @Override
    @NotNull
    public IrConstructorCall serializeAnnotation(@NotNull org.jetbrains.kotlin.ir.expressions.IrConstructorCall value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeConstructorCall(value);
    }

    @Override
    public int serializeBody(@NotNull IrBody value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return ((Number)this.bodyIndex.invoke((Object)value)).intValue();
    }

    @Override
    public int serializeBlockBody(@NotNull IrBlockBody value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.serializeBody(value);
    }

    @Override
    public int serializeExpressionBody(@NotNull IrExpressionBody value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.serializeBody(value);
    }

    @Override
    public long serializeValueParameter(@NotNull IrValueParameterSymbol value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value);
    }

    @Override
    public long serializeTypeParameter(@NotNull IrTypeParameterSymbol value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value);
    }

    @Override
    public int serializeSuperType(@NotNull IrType value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrType(value);
    }

    @Override
    public long serializeSealedSubclass(@NotNull IrClassSymbol value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value);
    }

    @Override
    public int serializeType(@NotNull IrType value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrType(value);
    }

    @Override
    public long serializeClass(@NotNull IrClassSymbol value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value);
    }

    @Override
    public long serializePropertySymbol(@NotNull IrPropertySymbol value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value);
    }

    @Override
    public long serializeSimpleFunction(@NotNull IrSimpleFunctionSymbol value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value);
    }

    @Override
    public long serializeSimpleFunctionSymbol(@NotNull IrSimpleFunctionSymbol value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value);
    }

    @Override
    public long serializeField(@NotNull IrFieldSymbol value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value);
    }

    @Override
    @NotNull
    public IrVariable serializeVariable(@NotNull org.jetbrains.kotlin.ir.declarations.IrVariable value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fileSerializer.serializeIrVariable(value);
    }

    @Override
    public long serializeVisibility(@NotNull DescriptorVisibility value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Flags.VISIBILITY.toFlags((Object)ProtoEnumFlagsUtilsKt.descriptorVisibility((ProtoEnumFlags)ProtoEnumFlags.INSTANCE, (DescriptorVisibility)value));
    }

    @Override
    public long serializeModality(@NotNull Modality value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Flags.MODALITY.toFlags((Object)ProtoEnumFlags.INSTANCE.modality(value));
    }

    @Override
    @NotNull
    public IrInlineClassRepresentation serializeInlineClassRepresentation(@NotNull InlineClassRepresentation<IrSimpleType> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.fileSerializer.serializeInlineClassRepresentation(value);
    }

    @Override
    public long serializeIsExternalClass(boolean value) {
        return IrFlags.IS_EXTERNAL_CLASS.toFlags(Boolean.valueOf(value));
    }

    @Override
    public long serializeIsExternalField(boolean value) {
        return IrFlags.IS_EXTERNAL_FIELD.toFlags(Boolean.valueOf(value));
    }

    @Override
    public long serializeIsExternalFunction(boolean value) {
        return IrFlags.IS_EXTERNAL_FUNCTION.toFlags(Boolean.valueOf(value));
    }

    @Override
    public long serializeIsExternalProperty(boolean value) {
        return IrFlags.IS_EXTERNAL_PROPERTY.toFlags(Boolean.valueOf(value));
    }
}

