/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureSerializer;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.JsMapping;
import org.jetbrains.kotlin.ir.backend.js.SerializedMappings;
import org.jetbrains.kotlin.ir.backend.js.ic.IcSerializerKt;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcData;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcDataForFile;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedOrder;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsGlobalDeclarationTable;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrFileSerializer;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFakeOverrideFunction;
import org.jetbrains.kotlin.ir.declarations.IrFakeOverrideProperty;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrBodyBase;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrFactory;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.serialization.CarrierSerializerKt;
import org.jetbrains.kotlin.ir.serialization.SerializedCarriers;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.library.SerializedIrFile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IcSerializer;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "mappings", "Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/persistent/PersistentIrFactory;", "linker", "Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsIrLinker;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;Lorg/jetbrains/kotlin/ir/declarations/persistent/PersistentIrFactory;Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsIrLinker;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)V", "globalDeclarationTable", "Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsGlobalDeclarationTable;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/persistent/PersistentIrFactory;", "getLinker", "()Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsIrLinker;", "getMappings", "()Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;", "getModule", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "serializeDeclarations", "Lorg/jetbrains/kotlin/ir/backend/js/ic/SerializedIcData;", "moduleDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "IcDeclarationTable", "ir.serialization.js"})
public final class IcSerializer {
    @NotNull
    private final JsMapping mappings;
    @NotNull
    private final PersistentIrFactory irFactory;
    @NotNull
    private final JsIrLinker linker;
    @NotNull
    private final IrModuleFragment module;
    @NotNull
    private final JsGlobalDeclarationTable globalDeclarationTable;

    public IcSerializer(@NotNull IrBuiltIns irBuiltIns, @NotNull JsMapping mappings, @NotNull PersistentIrFactory irFactory, @NotNull JsIrLinker linker, @NotNull IrModuleFragment module) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)mappings, (String)"mappings");
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        Intrinsics.checkNotNullParameter((Object)linker, (String)"linker");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.mappings = mappings;
        this.irFactory = irFactory;
        this.linker = linker;
        this.module = module;
        this.globalDeclarationTable = new JsGlobalDeclarationTable(irBuiltIns, null, 2, null);
    }

    @NotNull
    public final JsMapping getMappings() {
        return this.mappings;
    }

    @NotNull
    public final PersistentIrFactory getIrFactory() {
        return this.irFactory;
    }

    @NotNull
    public final JsIrLinker getLinker() {
        return this.linker;
    }

    @NotNull
    public final IrModuleFragment getModule() {
        return this.module;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SerializedIcData serializeDeclarations(@NotNull Iterable<? extends IrDeclaration> moduleDeclarations) {
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$groupByTo$iv$iv2;
        void $this$filterTo$iv$iv;
        IrDeclaration it;
        Iterable<? extends IrDeclaration> $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(moduleDeclarations, (String)"moduleDeclarations");
        IrModuleDeserializer moduleDeserializer = this.linker.moduleDeserializer(this.module.getDescriptor());
        Iterable $this$associateBy$iv = moduleDeserializer.fileDeserializers();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object t : $this$associateByTo$iv$iv) {
            IrFileDeserializer irFileDeserializer = (IrFileDeserializer)t;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(((IrFileDeserializer)((Object)it)).getFile(), t);
        }
        Map fileToDeserializer = destination$iv$iv;
        Iterable<? extends IrDeclaration> $this$filter$iv = moduleDeclarations;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            boolean bl;
            it = (IrDeclaration)t;
            boolean bl2 = false;
            IrDeclarationParent it2 = IrUtilsKt.getFileOrNull(it);
            boolean bl3 = false;
            boolean bl4 = it2 == null || fileToDeserializer.get(it2) == null;
            if (bl4) {
                bl = false;
            } else if (it instanceof IrFakeOverrideFunction) {
                bl = ((IrFakeOverrideFunction)it).isBound();
            } else if (it instanceof IrFakeOverrideProperty) {
                bl = ((IrFakeOverrideProperty)it).isBound();
            } else {
                it2 = it.getParent();
                IrFakeOverrideFunction irFakeOverrideFunction = it2 instanceof IrFakeOverrideFunction ? (IrFakeOverrideFunction)((Object)it2) : null;
                if (irFakeOverrideFunction != null) {
                    bl = irFakeOverrideFunction.isBound();
                } else {
                    IrDeclarationParent irDeclarationParent = it.getParent();
                    IrFakeOverrideProperty irFakeOverrideProperty = irDeclarationParent instanceof IrFakeOverrideProperty ? (IrFakeOverrideProperty)((Object)irDeclarationParent) : null;
                    bl = irFakeOverrideProperty != null ? irFakeOverrideProperty.isBound() : true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(t);
        }
        List filteredDeclarations = (List)destination$iv$iv;
        Iterable $this$groupBy$iv = this.irFactory.getAllBodies();
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object;
            IrFile irFile;
            IrBody it3 = (IrBody)element$iv$iv;
            boolean bl = false;
            if ((it3 instanceof PersistentIrBodyBase ? (PersistentIrBodyBase)((Object)it3) : null) != null) {
                PersistentIrBodyBase it4;
                it4 = it4;
                boolean bl5 = false;
                irFile = it4.getHasContainer() ? IrUtilsKt.getFileOrNull(it4.getContainer()) : null;
            } else {
                irFile = null;
            }
            IrFile key$iv$iv = irFile;
            Object $this$getOrPut$iv$iv$iv2 = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map filteredBodies = destination$iv$iv2;
        Iterable $this$groupBy$iv2 = filteredDeclarations;
        boolean $i$f$groupBy2 = false;
        destination$iv$iv2 = $this$groupBy$iv2;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean bl = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            IrDeclaration it5 = (IrDeclaration)element$iv$iv;
            boolean bl5 = false;
            IrFile key$iv$iv = IrUtilsKt.getFile(it5);
            $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl7 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map dataToSerialize = destination$iv$iv3;
        List icData = new ArrayList();
        for (IrFile file : fileToDeserializer.keySet()) {
            void $this$associateTo$iv$iv;
            List list;
            List fileDeclarations;
            List list2 = (List)dataToSerialize.get(file);
            if (list2 == null) {
                list2 = fileDeclarations = CollectionsKt.emptyList();
            }
            if ((list = (List)filteredBodies.get(file)) == null) {
                list = CollectionsKt.emptyList();
            }
            List list3 = list;
            Object v = fileToDeserializer.get(file);
            Intrinsics.checkNotNull(v);
            IrFileDeserializer fileDeserializer = (IrFileDeserializer)v;
            Iterable $this$associate$iv = fileDeserializer.getSymbolDeserializer().getDeserializedSymbols().entrySet();
            boolean $i$f$associate = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            $this$getOrPut$iv$iv$iv = $this$associate$iv;
            Map destination$iv$iv4 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv4;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl6 = false;
                IdSignature idSig = (IdSignature)entry.getKey();
                IrSymbol symbol2 = (IrSymbol)entry.getValue();
                entry = TuplesKt.to((Object)symbol2, (Object)idSig);
                map.put(entry.getFirst(), entry.getSecond());
            }
            Map symbolToSignature = MapsKt.toMutableMap((Map)destination$iv$iv4);
            IcDeclarationTable icDeclarationTable = new IcDeclarationTable(this.globalDeclarationTable, this.irFactory, 1000000, symbolToSignature);
            IrMessageLogger irMessageLogger = this.linker.getMessageLogger();
            Map map = new LinkedHashMap();
            CompatibilityMode compatibilityMode = CompatibilityMode.Companion.getCURRENT();
            List list4 = CollectionsKt.emptyList();
            JsIrFileSerializer fileSerializer = new JsIrFileSerializer(irMessageLogger, icDeclarationTable, map, compatibilityMode, true, false, true, true, false, list4, 32, null);
            icDeclarationTable.inFile(file, (Function0<Unit>)((Function0)new Function0<Unit>((List<? extends IrBody>)list3, (List<? extends IrDeclaration>)fileDeclarations, fileSerializer, this, file, (List<SerializedIcDataForFile>)icData, icDeclarationTable){
                final /* synthetic */ List<IrBody> $bodies;
                final /* synthetic */ List<IrDeclaration> $fileDeclarations;
                final /* synthetic */ JsIrFileSerializer $fileSerializer;
                final /* synthetic */ IcSerializer this$0;
                final /* synthetic */ IrFile $file;
                final /* synthetic */ List<SerializedIcDataForFile> $icData;
                final /* synthetic */ IcDeclarationTable $icDeclarationTable;
                {
                    this.$bodies = $bodies;
                    this.$fileDeclarations = $fileDeclarations;
                    this.$fileSerializer = $fileSerializer;
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$icData = $icData;
                    this.$icDeclarationTable = $icDeclarationTable;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$filterTo$iv$iv;
                    void $this$forEach$iv;
                    Iterable iterable = this.$bodies;
                    JsIrFileSerializer jsIrFileSerializer = this.$fileSerializer;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        IrBody body2 = (IrBody)element$iv;
                        boolean bl = false;
                        if (body2 instanceof IrExpressionBody) {
                            jsIrFileSerializer.serializeIrExpressionBody(((IrExpressionBody)body2).getExpression());
                            continue;
                        }
                        jsIrFileSerializer.serializeIrStatementBody(body2);
                    }
                    Iterable $this$filter$iv = this.$fileDeclarations;
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        IrDeclaration d = (IrDeclaration)element$iv$iv;
                        boolean bl = false;
                        if (!(d instanceof PersistentIrDeclarationBase && (((PersistentIrDeclarationBase)d).getCreatedOn() > 0 || (d instanceof IrValueParameter || d instanceof IrTypeParameter) && IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)((Object)d.getParent()))))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List newDeclarations = (List)destination$iv$iv;
                    SerializedCarriers serializedCarriers2 = CarrierSerializerKt.serializeCarriers(this.$fileSerializer, (Iterable<? extends IrDeclaration>)this.$fileDeclarations, this.$bodies, (Function1<? super IrDeclaration, ? extends IdSignature>)((Function1)new Function1<IrDeclaration, IdSignature>(this.$icDeclarationTable){
                        final /* synthetic */ IcDeclarationTable $icDeclarationTable;
                        {
                            this.$icDeclarationTable = $icDeclarationTable;
                            super(1);
                        }

                        @NotNull
                        public final IdSignature invoke(@NotNull IrDeclaration declaration) {
                            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                            return this.$icDeclarationTable.signatureByDeclaration(declaration, false);
                        }
                    }));
                    SerializedMappings serializedMappings2 = this.this$0.getMappings().getState().serializeMappings((Iterable<? extends IrDeclaration>)this.$fileDeclarations, (Function1<? super IrSymbol, Long>)((Function1)new Function1<IrSymbol, Long>(this.$fileSerializer){
                        final /* synthetic */ JsIrFileSerializer $fileSerializer;
                        {
                            this.$fileSerializer = $fileSerializer;
                            super(1);
                        }

                        @NotNull
                        public final Long invoke(@NotNull IrSymbol symbol2) {
                            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                            return this.$fileSerializer.serializeIrSymbol(symbol2);
                        }
                    }));
                    SerializedOrder order2 = IcSerializerKt.storeOrder(this.$file, (Iterable<? extends IrDeclaration>)this.$fileDeclarations, (Function1<? super IrSymbol, Long>)((Function1)new Function1<IrSymbol, Long>(this.$fileSerializer){
                        final /* synthetic */ JsIrFileSerializer $fileSerializer;
                        {
                            this.$fileSerializer = $fileSerializer;
                            super(1);
                        }

                        @NotNull
                        public final Long invoke(@NotNull IrSymbol symbol2) {
                            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                            return this.$fileSerializer.serializeIrSymbol(symbol2);
                        }
                    }));
                    SerializedIrFile serializedIrFile = this.$fileSerializer.serializeDeclarationsForIC(this.$file, newDeclarations);
                    ((Collection)this.$icData).add(new SerializedIcDataForFile(serializedIrFile, serializedCarriers2, serializedMappings2, order2));
                }
            }));
        }
        return new SerializedIcData(icData);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IcSerializer$IcDeclarationTable;", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "globalDeclarationTable", "Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsGlobalDeclarationTable;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/persistent/PersistentIrFactory;", "startIndex", "", "existingMappings", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsGlobalDeclarationTable;Lorg/jetbrains/kotlin/ir/declarations/persistent/PersistentIrFactory;ILjava/util/Map;)V", "getExistingMappings", "()Ljava/util/Map;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/persistent/PersistentIrFactory;", "signaturer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "getSignaturer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "signatureByDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "compatibleMode", "", "ir.serialization.js"})
    public static final class IcDeclarationTable
    extends DeclarationTable {
        @NotNull
        private final PersistentIrFactory irFactory;
        @NotNull
        private final Map<IrSymbol, IdSignature> existingMappings;
        @NotNull
        private final IdSignatureSerializer signaturer;

        public IcDeclarationTable(@NotNull JsGlobalDeclarationTable globalDeclarationTable, @NotNull PersistentIrFactory irFactory, int startIndex, @NotNull Map<IrSymbol, IdSignature> existingMappings) {
            Intrinsics.checkNotNullParameter((Object)globalDeclarationTable, (String)"globalDeclarationTable");
            Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
            Intrinsics.checkNotNullParameter(existingMappings, (String)"existingMappings");
            super(globalDeclarationTable);
            this.irFactory = irFactory;
            this.existingMappings = existingMappings;
            this.signaturer = new IdSignatureSerializer(globalDeclarationTable.getPublicIdSignatureComputer(), this, startIndex);
        }

        @NotNull
        public final PersistentIrFactory getIrFactory() {
            return this.irFactory;
        }

        @NotNull
        public final Map<IrSymbol, IdSignature> getExistingMappings() {
            return this.existingMappings;
        }

        @Override
        @NotNull
        public IdSignatureSerializer getSignaturer() {
            return this.signaturer;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IdSignature signatureByDeclaration(@NotNull IrDeclaration declaration, boolean compatibleMode) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Map<IrSymbol, IdSignature> map = this.existingMappings;
            IrSymbol key$iv = declaration.getSymbol();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                IdSignature idSignature = this.irFactory.declarationSignature(declaration);
                if (idSignature == null) {
                    idSignature = super.signatureByDeclaration(declaration, compatibleMode);
                }
                IdSignature answer$iv = idSignature;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (IdSignature)object;
        }
    }
}

