/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.SerializedMapping;
import org.jetbrains.kotlin.ir.backend.js.SerializedMappings;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcData;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcDataForFile;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedOrder;
import org.jetbrains.kotlin.ir.serialization.SerializedCarriers;
import org.jetbrains.kotlin.library.SerializedIrFile;
import org.jetbrains.kotlin.library.impl.IrArrayMemoryReader;
import org.jetbrains.kotlin.library.impl.IrArrayReader;
import org.jetbrains.kotlin.library.impl.IrFileReadersKt;
import org.jetbrains.kotlin.library.impl.IrMemoryArrayWriter;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0001\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0001\u001a\f\u0010\f\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0012\u0010\u000f\u001a\u00020\u000e*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0001\u00a8\u0006\u0011"}, d2={"newFile", "Ljava/io/File;", "fileDir", "name", "", "keyBytes", "", "Lorg/jetbrains/kotlin/ir/backend/js/SerializedMappings;", "readIcData", "Lorg/jetbrains/kotlin/ir/backend/js/ic/SerializedIcData;", "readIcDataBinary", "Lorg/jetbrains/kotlin/ir/backend/js/ic/SerializedIcDataForFile;", "valueBytes", "writeData", "", "writeTo", "dir", "ir.serialization.js"})
public final class DataKt {
    @NotNull
    public static final File newFile(@NotNull File fileDir, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)fileDir, (String)"fileDir");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File f = new File(fileDir, name);
        if (f.exists()) {
            f.delete();
        }
        return f;
    }

    public static final void writeData(@NotNull SerializedIcDataForFile $this$writeData, @NotNull File fileDir) {
        Intrinsics.checkNotNullParameter((Object)$this$writeData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileDir, (String)"fileDir");
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "file.fileData"), (byte[])$this$writeData.getFile().getFileData());
        File file = DataKt.newFile(fileDir, "file.path");
        byte[] byArray = $this$writeData.getFile().getPath().getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        FilesKt.writeBytes((File)file, (byte[])byArray);
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "file.declarations"), (byte[])$this$writeData.getFile().getDeclarations());
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "file.types"), (byte[])$this$writeData.getFile().getTypes());
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "file.signatures"), (byte[])$this$writeData.getFile().getSignatures());
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "file.strings"), (byte[])$this$writeData.getFile().getStrings());
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "file.bodies"), (byte[])$this$writeData.getFile().getBodies());
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "carriers.signatures"), (byte[])$this$writeData.getCarriers().getSignatures());
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "carriers.declarationCarriers"), (byte[])$this$writeData.getCarriers().getDeclarationCarriers());
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "carriers.bodyCarriers"), (byte[])$this$writeData.getCarriers().getBodyCarriers());
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "carriers.removedOn"), (byte[])$this$writeData.getCarriers().getRemovedOn());
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "mappings.keys"), (byte[])DataKt.keyBytes($this$writeData.getMappings()));
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "mappings.values"), (byte[])DataKt.valueBytes($this$writeData.getMappings()));
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "order.topLevelSignatures"), (byte[])$this$writeData.getOrder().getTopLevelSignatures());
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "order.containerSignatures"), (byte[])$this$writeData.getOrder().getContainerSignatures());
        FilesKt.writeBytes((File)DataKt.newFile(fileDir, "order.declarationSignatures"), (byte[])$this$writeData.getOrder().getDeclarationSignatures());
    }

    public static final void writeTo(@NotNull SerializedIcData $this$writeTo, @NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.exists()) {
            throw new IllegalStateException(("Directory doesn't exist: " + dir.getAbsolutePath()).toString());
        }
        if (!dir.isDirectory()) {
            throw new IllegalStateException(("Not a directory: " + dir.getAbsolutePath()).toString());
        }
        Iterable $this$forEach$iv = $this$writeTo.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fileId;
            SerializedIcDataForFile it = (SerializedIcDataForFile)element$iv;
            boolean bl = false;
            String fqnPath = it.getFile().getFqName();
            Intrinsics.checkNotNullExpressionValue((Object)Integer.toString(it.getFile().getPath().hashCode(), CharsKt.checkRadix((int)36)), (String)"toString(this, checkRadix(radix))");
            String irFileDirectory = "ic-" + fqnPath + '.' + fileId + ".file";
            File fileDir = new File(dir, irFileDirectory);
            if (!fileDir.exists() && !fileDir.mkdirs()) {
                throw new IllegalStateException(("Failed to create output dir for file " + fileDir.getAbsolutePath()).toString());
            }
            DataKt.writeData(it, fileDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] keyBytes(SerializedMappings $this$keyBytes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$keyBytes.getMappings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SerializedMapping serializedMapping = (SerializedMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKeys());
        }
        List list = (List)destination$iv$iv;
        return new IrMemoryArrayWriter(list).writeIntoMemory();
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] valueBytes(SerializedMappings $this$valueBytes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$valueBytes.getMappings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SerializedMapping serializedMapping = (SerializedMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValues());
        }
        List list = (List)destination$iv$iv;
        return new IrMemoryArrayWriter(list).writeIntoMemory();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SerializedIcDataForFile readIcDataBinary(@NotNull File $this$readIcDataBinary) {
        void $this$mapTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$readIcDataBinary, (String)"<this>");
        byte[] byArray = FilesKt.readBytes((File)new File($this$readIcDataBinary, "file.fileData"));
        String string = $this$readIcDataBinary.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        char[] cArray = new char[]{'.'};
        SerializedIrFile file = new SerializedIrFile(byArray, CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null), (int)2), (CharSequence)".", null, null, (int)0, null, null, (int)62, null), new String(FilesKt.readBytes((File)new File($this$readIcDataBinary, "file.path")), Charsets.UTF_8), FilesKt.readBytes((File)new File($this$readIcDataBinary, "file.types")), FilesKt.readBytes((File)new File($this$readIcDataBinary, "file.signatures")), FilesKt.readBytes((File)new File($this$readIcDataBinary, "file.strings")), FilesKt.readBytes((File)new File($this$readIcDataBinary, "file.bodies")), FilesKt.readBytes((File)new File($this$readIcDataBinary, "file.declarations")), null);
        SerializedCarriers carriers = new SerializedCarriers(FilesKt.readBytes((File)new File($this$readIcDataBinary, "carriers.signatures")), FilesKt.readBytes((File)new File($this$readIcDataBinary, "carriers.declarationCarriers")), FilesKt.readBytes((File)new File($this$readIcDataBinary, "carriers.bodyCarriers")), FilesKt.readBytes((File)new File($this$readIcDataBinary, "carriers.removedOn")));
        byte[][] mappingKeys = IrFileReadersKt.toArray((IrArrayReader)((IrArrayReader)new IrArrayMemoryReader(FilesKt.readBytes((File)new File($this$readIcDataBinary, "mappings.keys")))));
        byte[][] mappingValues = IrFileReadersKt.toArray((IrArrayReader)((IrArrayReader)new IrArrayMemoryReader(FilesKt.readBytes((File)new File($this$readIcDataBinary, "mappings.values")))));
        boolean bl2 = bl = ((Object[])mappingKeys).length == ((Object[])mappingValues).length;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Iterable $this$map$iv = ArraysKt.zip((Object[])((Object[])mappingKeys), (Object[])((Object[])mappingValues));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            byte[] k = (byte[])pair.component1();
            byte[] v = (byte[])pair.component2();
            collection.add(new SerializedMapping(k, v));
        }
        List list = (List)destination$iv$iv;
        SerializedMappings mappings = new SerializedMappings(list);
        SerializedOrder order2 = new SerializedOrder(FilesKt.readBytes((File)new File($this$readIcDataBinary, "order.topLevelSignatures")), FilesKt.readBytes((File)new File($this$readIcDataBinary, "order.containerSignatures")), FilesKt.readBytes((File)new File($this$readIcDataBinary, "order.declarationSignatures")));
        return new SerializedIcDataForFile(file, carriers, mappings, order2);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final SerializedIcData readIcData(@NotNull File $this$readIcData) {
        Intrinsics.checkNotNullParameter((Object)$this$readIcData, (String)"<this>");
        if (!$this$readIcData.isDirectory()) {
            throw new IllegalStateException(("Directory doesn't exist: " + $this$readIcData.getAbsolutePath()).toString());
        }
        v0 = $this$readIcData.listFiles();
        Intrinsics.checkNotNull((Object)v0);
        $this$filter$iv = v0;
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (File element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            $i$a$-filter-DataKt$readIcData$1 = false;
            if (!it.isDirectory()) ** GOTO lbl-1000
            v1 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.name");
            if (StringsKt.startsWith$default((String)v1, (String)"ic-", (boolean)false, (int)2, null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            element$iv$iv = (File)item$iv$iv;
            var11_14 = destination$iv$iv;
            $i$a$-map-DataKt$readIcData$2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)fileDir, (String)"fileDir");
            var11_14.add(DataKt.readIcDataBinary((File)fileDir));
        }
        var12_15 = (List)destination$iv$iv;
        return new SerializedIcData(var12_15);
    }
}

