/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.metadata;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataSerializerExtensionKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.library.metadata.KlibMetadataSerializerProtocol;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.serialization.MutableVersionRequirementTable;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.StringTableImpl;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020%H\u0016J*\u0010+\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020-2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J*\u0010.\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020/2\u0006\u0010\u0018\u001a\u0002002\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u00101\u001a\u00020\tH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataSerializerExtension;", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "stringTable", "Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "allowErrorTypes", "", "exportKDoc", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/serialization/StringTableImpl;ZZ)V", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getStringTable", "()Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "descriptorFileId", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;)Ljava/lang/Integer;", "serializeClass", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class$Builder;", "versionRequirementTable", "Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;", "childSerializer", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "serializeConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor$Builder;", "serializeErrorType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "builder", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;", "serializeFlexibleType", "flexibleType", "Lorg/jetbrains/kotlin/types/FlexibleType;", "lowerProto", "upperProto", "serializeFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "serializeProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property$Builder;", "shouldUseTypeTable", "ir.serialization.common"})
public final class KlibMetadataSerializerExtension
extends KotlinSerializerExtensionBase {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final BinaryVersion metadataVersion;
    @NotNull
    private final StringTableImpl stringTable;
    private final boolean allowErrorTypes;
    private final boolean exportKDoc;

    public KlibMetadataSerializerExtension(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull BinaryVersion metadataVersion, @NotNull StringTableImpl stringTable, boolean allowErrorTypes, boolean exportKDoc) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        Intrinsics.checkNotNullParameter((Object)stringTable, (String)"stringTable");
        super((SerializerExtensionProtocol)KlibMetadataSerializerProtocol.INSTANCE);
        this.languageVersionSettings = languageVersionSettings;
        this.metadataVersion = metadataVersion;
        this.stringTable = stringTable;
        this.allowErrorTypes = allowErrorTypes;
        this.exportKDoc = exportKDoc;
    }

    @NotNull
    public BinaryVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @NotNull
    public StringTableImpl getStringTable() {
        return this.stringTable;
    }

    public boolean shouldUseTypeTable() {
        return true;
    }

    private final Integer descriptorFileId(DeclarationDescriptorWithSource descriptor) {
        String string = descriptor.getSource().getContainingFile().getName();
        if (string == null) {
            return null;
        }
        String fileName = string;
        return this.getStringTable().getStringIndex(fileName);
    }

    public void serializeFlexibleType(@NotNull FlexibleType flexibleType, @NotNull ProtoBuf.Type.Builder lowerProto, @NotNull ProtoBuf.Type.Builder upperProto) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"flexibleType");
        Intrinsics.checkNotNullParameter((Object)lowerProto, (String)"lowerProto");
        Intrinsics.checkNotNullParameter((Object)upperProto, (String)"upperProto");
        lowerProto.setFlexibleTypeCapabilitiesId(this.getStringTable().getStringIndex("kotlin.DynamicType"));
    }

    public void serializeErrorType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!this.allowErrorTypes) {
            super.serializeErrorType(type2, builder);
        }
    }

    public void serializeClass(@NotNull ClassDescriptor descriptor, @NotNull ProtoBuf.Class.Builder proto, @NotNull MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
            Intrinsics.checkNotNullParameter((Object)versionRequirementTable, (String)"versionRequirementTable");
            Intrinsics.checkNotNullParameter((Object)childSerializer, (String)"childSerializer");
            Integer n = this.descriptorFileId((DeclarationDescriptorWithSource)descriptor);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                ProtoBuf.Class.Builder cfr_ignored_0 = (ProtoBuf.Class.Builder)proto.setExtension(KlibMetadataProtoBuf.classFile, (Object)it);
            }
            if (this.exportKDoc) {
                String string = KlibMetadataSerializerExtensionKt.findKDocString((DeclarationDescriptorWithSource)descriptor);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    ProtoBuf.Class.Builder cfr_ignored_1 = (ProtoBuf.Class.Builder)proto.setExtension(KlibMetadataProtoBuf.classKdoc, (Object)it);
                }
            }
            super.serializeClass(descriptor, proto, versionRequirementTable, childSerializer);
            ProtoBuf.TypeTable typeTable = (ProtoBuf.TypeTable)childSerializer.getTypeTable().serialize();
            if (typeTable == null) break block3;
            ProtoBuf.TypeTable it = typeTable;
            boolean bl = false;
            proto.mergeTypeTable(it);
        }
    }

    public void serializeConstructor(@NotNull ConstructorDescriptor descriptor, @NotNull ProtoBuf.Constructor.Builder proto, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)childSerializer, (String)"childSerializer");
        if (this.exportKDoc) {
            String string = KlibMetadataSerializerExtensionKt.findKDocString((DeclarationDescriptorWithSource)descriptor);
            if (string != null) {
                String it = string;
                boolean bl = false;
                ProtoBuf.Constructor.Builder cfr_ignored_0 = (ProtoBuf.Constructor.Builder)proto.setExtension(KlibMetadataProtoBuf.constructorKdoc, (Object)it);
            }
        }
        super.serializeConstructor(descriptor, proto, childSerializer);
    }

    public void serializeProperty(@NotNull PropertyDescriptor descriptor, @NotNull ProtoBuf.Property.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)childSerializer, (String)"childSerializer");
        Integer n = this.descriptorFileId((DeclarationDescriptorWithSource)descriptor);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            ProtoBuf.Property.Builder cfr_ignored_0 = (ProtoBuf.Property.Builder)proto.setExtension(KlibMetadataProtoBuf.propertyFile, (Object)it);
        }
        if (this.exportKDoc) {
            String string = KlibMetadataSerializerExtensionKt.findKDocString((DeclarationDescriptorWithSource)descriptor);
            if (string != null) {
                String it = string;
                boolean bl = false;
                ProtoBuf.Property.Builder cfr_ignored_1 = (ProtoBuf.Property.Builder)proto.setExtension(KlibMetadataProtoBuf.propertyKdoc, (Object)it);
            }
        }
        super.serializeProperty(descriptor, proto, versionRequirementTable, childSerializer);
    }

    public void serializeFunction(@NotNull FunctionDescriptor descriptor, @NotNull ProtoBuf.Function.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)childSerializer, (String)"childSerializer");
        Integer n = this.descriptorFileId((DeclarationDescriptorWithSource)descriptor);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            ProtoBuf.Function.Builder cfr_ignored_0 = (ProtoBuf.Function.Builder)proto.setExtension(KlibMetadataProtoBuf.functionFile, (Object)it);
        }
        if (this.exportKDoc) {
            String string = KlibMetadataSerializerExtensionKt.findKDocString((DeclarationDescriptorWithSource)descriptor);
            if (string != null) {
                String it = string;
                boolean bl = false;
                ProtoBuf.Function.Builder cfr_ignored_1 = (ProtoBuf.Function.Builder)proto.setExtension(KlibMetadataProtoBuf.functionKdoc, (Object)it);
            }
        }
        super.serializeFunction(descriptor, proto, versionRequirementTable, childSerializer);
    }
}

