/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.IdSignatureDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKind;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0011\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020)H\u00a6\u0002J\u0010\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020.2\u0006\u0010(\u001a\u00020)2\u0006\u00100\u001a\u000201H&J\b\u00102\u001a\u00020'H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0016H\u0016J\b\u00105\u001a\u00020'H\u0016J\u0010\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020\u0000H\u0016J\b\u00107\u001a\u00020'H\u0016J\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020)H\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020)H\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\"H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "", "_moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "libraryAbiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/library/KotlinAbiVersion;)V", "compatibilityMode", "Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "getCompatibilityMode", "()Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "kind", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "getKind", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "getKlib", "()Lorg/jetbrains/kotlin/library/IrLibrary;", "getLibraryAbiVersion", "()Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/Collection;", "moduleDescriptor", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "strategyResolver", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "getStrategyResolver", "()Lkotlin/jvm/functions/Function1;", "addModuleReachableTopLevel", "", "idSig", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "contains", "", "declareIrSymbol", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "deserializeIrSymbol", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "deserializeReachableDeclarations", "fileDeserializers", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "init", "delegate", "postProcess", "referencePropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "idSignature", "referenceSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "signatureDeserializerForFile", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "fileName", "ir.serialization.common"})
public abstract class IrModuleDeserializer {
    @Nullable
    private final ModuleDescriptor _moduleDescriptor;
    @NotNull
    private final KotlinAbiVersion libraryAbiVersion;
    @NotNull
    private final Function1<String, DeserializationStrategy> strategyResolver;

    public IrModuleDeserializer(@Nullable ModuleDescriptor _moduleDescriptor, @NotNull KotlinAbiVersion libraryAbiVersion) {
        Intrinsics.checkNotNullParameter((Object)libraryAbiVersion, (String)"libraryAbiVersion");
        this._moduleDescriptor = _moduleDescriptor;
        this.libraryAbiVersion = libraryAbiVersion;
        this.strategyResolver = strategyResolver.1.INSTANCE;
    }

    @NotNull
    public final KotlinAbiVersion getLibraryAbiVersion() {
        return this.libraryAbiVersion;
    }

    public abstract boolean contains(@NotNull IdSignature var1);

    @NotNull
    public abstract IrSymbol deserializeIrSymbol(@NotNull IdSignature var1, @NotNull BinarySymbolData.SymbolKind var2);

    @NotNull
    public final ModuleDescriptor getModuleDescriptor() {
        ModuleDescriptor moduleDescriptor = this._moduleDescriptor;
        if (moduleDescriptor == null) {
            throw new IllegalStateException("No ModuleDescriptor provided".toString());
        }
        return moduleDescriptor;
    }

    @NotNull
    public IrSimpleFunctionSymbol referenceSimpleFunctionByLocalSignature(@NotNull IrFile file, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        throw new IllegalStateException("Unsupported operation".toString());
    }

    @NotNull
    public IrPropertySymbol referencePropertyByLocalSignature(@NotNull IrFile file, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        throw new IllegalStateException("Unsupported operation".toString());
    }

    public void declareIrSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        IdSignature signature = symbol2.getSignature();
        if (!(signature != null)) {
            boolean bl = false;
            String string = "Symbol is not public API: " + symbol2.getDescriptor();
            throw new IllegalArgumentException(string.toString());
        }
        boolean bl = symbol2.getHasDescriptor();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.deserializeIrSymbol(signature, IrModuleDeserializerKt.kind(symbol2));
    }

    @NotNull
    public IrLibrary getKlib() {
        throw new IllegalStateException("Unsupported operation".toString());
    }

    public void init() {
        this.init(this);
    }

    public void postProcess() {
    }

    public void init(@NotNull IrModuleDeserializer delegate2) {
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
    }

    public void addModuleReachableTopLevel(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        throw new IllegalStateException(("Unsupported Operation (sig: " + idSig).toString());
    }

    public void deserializeReachableDeclarations() {
        throw new IllegalStateException("Unsupported Operation".toString());
    }

    @NotNull
    public abstract IrModuleFragment getModuleFragment();

    @NotNull
    public abstract Collection<IrModuleDeserializer> getModuleDependencies();

    @NotNull
    public Function1<String, DeserializationStrategy> getStrategyResolver() {
        return this.strategyResolver;
    }

    @NotNull
    public abstract IrModuleDeserializerKind getKind();

    @NotNull
    public Collection<IrFileDeserializer> fileDeserializers() {
        throw new IllegalStateException("Unsupported".toString());
    }

    @NotNull
    public final CompatibilityMode getCompatibilityMode() {
        return new CompatibilityMode(this.libraryAbiVersion);
    }

    @NotNull
    public IdSignatureDeserializer signatureDeserializerForFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        throw new IllegalStateException("Unsupported".toString());
    }
}

