/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.ProtoDataProvider;
import org.jetbrains.kotlin.incremental.TranslationResultValueExternalizer;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0013\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u0004H\u0086\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014J\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/TranslationResultMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "storageFile", "Ljava/io/File;", "protoData", "Lorg/jetbrains/kotlin/incremental/ProtoDataProvider;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/ProtoDataProvider;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "dumpValue", "", "value", "get", "sourceFile", "keys", "", "put", "", "newMetadata", "", "newBinaryAst", "newInlineData", "remove", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nIncrementalJsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalJsCache.kt\norg/jetbrains/kotlin/incremental/TranslationResultMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,454:1\n1549#2:455\n1620#2,3:456\n*S KotlinDebug\n*F\n+ 1 IncrementalJsCache.kt\norg/jetbrains/kotlin/incremental/TranslationResultMap\n*L\n247#1:455\n247#1:456,3\n*E\n"})
final class TranslationResultMap
extends BasicStringMap<TranslationResultValue> {
    @NotNull
    private final ProtoDataProvider protoData;

    public TranslationResultMap(@NotNull File storageFile, @NotNull ProtoDataProvider protoData2, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)protoData2, (String)"protoData");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(storageFile, TranslationResultValueExternalizer.INSTANCE, icContext);
        this.protoData = protoData2;
    }

    @Override
    @NotNull
    public String dumpValue(@NotNull TranslationResultValue value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return "Metadata: " + IncrementalJvmCacheKt.md5(value2.getMetadata()) + ", Binary AST: " + IncrementalJvmCacheKt.md5(value2.getBinaryAst()) + ", InlineData: " + IncrementalJvmCacheKt.md5(value2.getInlineData());
    }

    public final synchronized void put(@NotNull File sourceFile, @NotNull byte[] newMetadata, @NotNull byte[] newBinaryAst, @NotNull byte[] newInlineData) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        Intrinsics.checkNotNullParameter((Object)newBinaryAst, (String)"newBinaryAst");
        Intrinsics.checkNotNullParameter((Object)newInlineData, (String)"newInlineData");
        this.getStorage().set(this.getPathConverter().toPath(sourceFile), new TranslationResultValue(newMetadata, newBinaryAst, newInlineData));
    }

    @Override
    @Nullable
    public final synchronized TranslationResultValue get(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return (TranslationResultValue)this.getStorage().get(this.getPathConverter().toPath(sourceFile));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> keys() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getStorage().getKeys();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getPathConverter().toFile((String)it));
        }
        return (List)destination$iv$iv;
    }

    public final synchronized void remove(@NotNull File sourceFile, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        String path = this.getPathConverter().toPath(sourceFile);
        Object VALUE = this.getStorage().get(path);
        Intrinsics.checkNotNull(VALUE);
        byte[] protoBytes = ((TranslationResultValue)VALUE).getMetadata();
        Map<ClassId, ProtoData> protoMap = this.protoData.invoke(sourceFile, protoBytes);
        Iterator<Map.Entry<ClassId, ProtoData>> iterator2 = protoMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            ProtoData protoData2 = iterator2.next().getValue();
            ChangesCollector.collectProtoChanges$default(changesCollector, protoData2, null, false, null, 12, null);
        }
        this.getStorage().remove(path);
    }
}

