/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ*\u0010\u0003\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker;", "", "()V", "checkSupertypes", "", "declaration", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "classifierType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "collectSuperTypes", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "ForDeclarations", "ForQualifiedAccessExpressions", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencySupertypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencySupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n26#2:127\n26#2:128\n1#3:129\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencySupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker\n*L\n103#1:127\n104#1:128\n*E\n"})
public final class FirMissingDependencySupertypeChecker {
    @NotNull
    public static final FirMissingDependencySupertypeChecker INSTANCE = new FirMissingDependencySupertypeChecker();

    private FirMissingDependencySupertypeChecker() {
    }

    public final boolean checkSupertypes(@Nullable ConeKotlinType classifierType, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ConeKotlinType coneKotlinType = classifierType;
        return this.checkSupertypes((FirBasedSymbol)(coneKotlinType != null ? TypeUtilsKt.toSymbol(coneKotlinType, context2.getSession()) : null), source, reporter, context2);
    }

    public final boolean checkSupertypes(@Nullable FirBasedSymbol<?> declaration, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration instanceof FirClassSymbol)) {
            return false;
        }
        boolean missingSupertype = false;
        Set<ConeKotlinType> superTypes2 = this.collectSuperTypes((FirClassSymbol)declaration, context2.getSession());
        for (ConeKotlinType superType2 : superTypes2) {
            FirClassifierSymbol<?> superTypeSymbol;
            if (superType2 instanceof ConeErrorType || superType2 instanceof ConeDynamicType || (superTypeSymbol = TypeUtilsKt.toSymbol(superType2, context2.getSession())) != null) continue;
            missingSupertype = true;
            boolean $i$f$emptyArray = false;
            $i$f$emptyArray = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS(), (Object)TypeUtilsKt.withNullability$default(TypeUtilsKt.withArguments(superType2, new ConeTypeProjection[0]), ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(context2.getSession()), null, false, 12, null), (Object)TypeConstructionUtilsKt.constructType$default((FirClassLikeSymbol)declaration, new ConeTypeProjection[0], false, null, 4, null), (DiagnosticContext)context2, null, 32, null);
        }
        return missingSupertype;
    }

    private final Set<ConeKotlinType> collectSuperTypes(FirClassSymbol<?> $this$collectSuperTypes, FirSession session) {
        Set superTypes2 = new LinkedHashSet();
        FirMissingDependencySupertypeChecker.collectSuperTypes$collect(superTypes2, session, $this$collectSuperTypes);
        return superTypes2;
    }

    private static final void collectSuperTypes$collect(Set<ConeKotlinType> superTypes2, FirSession $session, FirClassSymbol<?> symbol2) {
        for (ConeKotlinType superType2 : symbol2.getResolvedSuperTypes()) {
            FirClassSymbol p0;
            if (!superTypes2.add(superType2)) continue;
            FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(superType2, $session);
            if ((firClassifierSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassifierSymbol : null) == null) continue;
            p0 = p0;
            boolean bl = false;
            FirMissingDependencySupertypeChecker.collectSuperTypes$collect(superTypes2, $session, p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker$ForDeclarations;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    public static final class ForDeclarations
    extends FirDeclarationChecker<FirDeclaration> {
        @NotNull
        public static final ForDeclarations INSTANCE = new ForDeclarations();

        private ForDeclarations() {
        }

        @Override
        public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (declaration instanceof FirClass) {
                INSTANCE.checkSupertypes((FirBasedSymbol)((FirClass)declaration).getSymbol(), declaration.getSource(), reporter, context2);
            }
            if (declaration instanceof FirTypeParameterRefsOwner) {
                for (FirTypeParameterRef typeParameter2 : ((FirTypeParameterRefsOwner)((Object)declaration)).getTypeParameters()) {
                    for (ConeClassLikeType upperBound : FirHelpersKt.collectUpperBounds(FirNestedClassifierScopeKt.toConeType(typeParameter2))) {
                        INSTANCE.checkSupertypes(upperBound, typeParameter2.getSource(), reporter, context2);
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker$ForQualifiedAccessExpressions;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    public static final class ForQualifiedAccessExpressions
    extends FirExpressionChecker<FirQualifiedAccessExpression> {
        @NotNull
        public static final ForQualifiedAccessExpressions INSTANCE = new ForQualifiedAccessExpressions();

        private ForQualifiedAccessExpressions() {
        }

        @Override
        public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            boolean unresolvedLazySupertypesByDefault;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            KtSourceElement source = expression2.getSource();
            FirCallableSymbol symbol2 = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
            if (symbol2 == null) {
                ConeKotlinType coneKotlinType;
                ConeSimpleKotlinType coneSimpleKotlinType;
                ConeKotlinType coneKotlinType2;
                FirExpression firExpression2 = expression2.getExplicitReceiver();
                ConeKotlinType receiverType = firExpression2 != null && (coneKotlinType2 = FirTypeUtilsKt.getResolvedType(firExpression2)) != null && (coneSimpleKotlinType = ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType2)) != null && (coneKotlinType = ConeTypeUtilsKt.originalIfDefinitelyNotNullable(coneSimpleKotlinType)) != null ? TypeExpansionUtilsKt.fullyExpandedType(coneKotlinType, context2.getSession()) : null;
                INSTANCE.checkSupertypes(receiverType, source, reporter, context2);
                return;
            }
            boolean missingSupertype = INSTANCE.checkSupertypes(symbol2.getDispatchReceiverType(), source, reporter, context2);
            boolean eagerChecksAllowed = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getExtendedCompilerChecks());
            boolean bl = unresolvedLazySupertypesByDefault = symbol2 instanceof FirConstructorSymbol || symbol2 instanceof FirAnonymousFunctionSymbol;
            if (eagerChecksAllowed || !unresolvedLazySupertypesByDefault && !missingSupertype) {
                ConeClassLikeLookupTag coneClassLikeLookupTag = FirVisibilityCheckerKt.getOwnerLookupTag(symbol2);
                INSTANCE.checkSupertypes((FirBasedSymbol)(coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession()) : null), source, reporter, context2);
                FirResolvedTypeRef firResolvedTypeRef = symbol2.getResolvedReceiverTypeRef();
                INSTANCE.checkSupertypes(firResolvedTypeRef != null ? FirTypeUtilsKt.getConeTypeOrNull(firResolvedTypeRef) : null, source, reporter, context2);
            }
        }
    }
}

