/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderComponents;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.AnnotationLoaderForClassFileStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedDataFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinClsStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "()V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "createStubBuilderComponents", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderComponents;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "fileContent", "", "jvmMetadataVersion", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "doBuildFileStub", "Lorg/jetbrains/kotlin/psi/KtFile;", "getStubVersion", "", "Companion", "decompiler-to-file-stubs"})
@SourceDebugExtension(value={"SMAP\nKotlinClsStubBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinClsStubBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1#2:241\n*E\n"})
public class KotlinClsStubBuilder
extends ClsStubBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String VERSIONED_PATH_MARKER;

    public int getStubVersion() {
        return 119;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        VirtualFile virtualFile = content2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        if (ClsClassFinder.INSTANCE.isKotlinInternalCompiledFile(virtualFile2, content2.getContent())) {
            return null;
        }
        if (Companion.isVersioned(virtualFile2)) {
            return null;
        }
        byte[] byArray = content2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getContent(...)");
        return this.doBuildFileStub(virtualFile2, byArray);
    }

    /*
     * Unable to fully structure code
     */
    private final PsiFileStub<KtFile> doBuildFileStub(VirtualFile file, byte[] fileContent) {
        v0 = ClsKotlinBinaryClassCache.Companion.getInstance().getKotlinBinaryClass(file, fileContent);
        if (v0 == null) {
            throw new IllegalStateException(("Can't find binary class for Kotlin file: " + file).toString());
        }
        kotlinClass = v0;
        header = kotlinClass.getClassHeader();
        classId = kotlinClass.getClassId();
        v1 = header.getPackageName();
        if (v1 != null) {
            it = v1;
            $i$a$-let-KotlinClsStubBuilder$doBuildFileStub$packageFqName$1 = false;
            v2 = new FqName(it);
        } else {
            v2 = packageFqName = classId.getPackageFqName();
        }
        if (!header.getMetadataVersion().isCompatibleWithCurrentCompilerVersion()) {
            return ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        components = this.createStubBuilderComponents(file, packageFqName, fileContent, header.getMetadataVersion());
        if (header.getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS) {
            partFiles = ClsClassFinder.INSTANCE.findMultifileClassParts(file, classId, header.getMultifilePartNames());
            return ClsStubBuildingKt.createMultifileClassStub(header, partFiles, classId.asSingleFqName(), components);
        }
        annotationData = header.getData();
        if (annotationData == null) {
            KotlinClsStubBuilder.LOG.error("Corrupted kotlin header for file " + file.getName());
            return null;
        }
        strings = header.getStrings();
        if (strings == null) {
            KotlinClsStubBuilder.LOG.error("String table not found in file " + file.getName());
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                if (classId.isLocal()) {
                    return null;
                }
                var12_13 = JvmProtoBufUtil.readClassDataFrom(annotationData, strings);
                nameResolver = (JvmNameResolver)var12_13.component1();
                classProto = (ProtoBuf.Class)var12_13.component2();
                if (Flags.VISIBILITY.get(classProto.getFlags()) == ProtoBuf.Visibility.LOCAL) {
                    return null;
                }
                v3 = nameResolver;
                v4 = classProto.getTypeTable();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getTypeTable(...)");
                context = components.createContext(v3, packageFqName, new TypeTable(v4));
                v5 = ClsStubBuildingKt.createTopLevelClassStub(classId, classProto, new KotlinJvmBinarySourceElement(kotlinClass, null, false, null, 14, null), context, header.isScript());
                break;
            }
            case 2: {
                var12_14 = JvmProtoBufUtil.readPackageDataFrom(annotationData, strings);
                nameResolver = (JvmNameResolver)var12_14.component1();
                packageProto = (ProtoBuf.Package)var12_14.component2();
                v6 = nameResolver;
                v7 = packageProto.getTypeTable();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getTypeTable(...)");
                context = components.createContext(v6, packageFqName, new TypeTable(v7));
                v8 = header.getPackageName();
                if (v8 == null) ** GOTO lbl60
                it = v8;
                $i$a$-let-KotlinClsStubBuilder$doBuildFileStub$fqName$1 = false;
                v9 = new ClassId(new FqName(it), classId.getRelativeClassName(), classId.isLocal()).asSingleFqName();
                v8 = v9;
                if (v9 != null) ** GOTO lbl61
lbl60:
                // 2 sources

                v8 = classId.asSingleFqName();
lbl61:
                // 2 sources

                fqName = v8;
                v5 = ClsStubBuildingKt.createFileFacadeStub(packageProto, (FqName)fqName, context);
                break;
            }
            default: {
                throw new IllegalStateException("Should have processed " + file.getPath() + " with header " + header);
            }
        }
        return v5;
    }

    private final ClsStubBuilderComponents createStubBuilderComponents(VirtualFile file2, FqName packageFqName, byte[] fileContent, JvmMetadataVersion jvmMetadataVersion) {
        VirtualFile virtualFile = file2.getParent();
        Intrinsics.checkNotNull((Object)virtualFile);
        DirectoryBasedClassFinder classFinder = new DirectoryBasedClassFinder(virtualFile, packageFqName);
        DirectoryBasedDataFinder classDataFinder2 = new DirectoryBasedDataFinder(classFinder, LOG, jvmMetadataVersion);
        AnnotationLoaderForClassFileStubBuilder annotationLoader = new AnnotationLoaderForClassFileStubBuilder(classFinder, file2, fileContent, jvmMetadataVersion);
        return new ClsStubBuilderComponents(classDataFinder2, annotationLoader, file2, BuiltInSerializerProtocol.INSTANCE, classFinder, jvmMetadataVersion);
    }

    static {
        Logger logger = Logger.getInstance(KotlinClsStubBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        VERSIONED_PATH_MARKER = "!/META-INF/versions/";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinClsStubBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "VERSIONED_PATH_MARKER", "", "isVersioned", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "decompiler-to-file-stubs"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public final boolean isVersioned(@NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            String string2 = virtualFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            return StringsKt.contains$default((CharSequence)string2, (CharSequence)VERSIONED_PATH_MARKER, (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinClassHeader.Kind.values().length];
            try {
                nArray[KotlinClassHeader.Kind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.FILE_FACADE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

