/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategies;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContext;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContextFactory;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContextKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirExpectActualDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.mpp.DeclarationSymbolMarker;
import org.jetbrains.kotlin.mpp.SourceElementMarker;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualAnnotationMatchChecker;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualAnnotationsIncompatibilityType;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002JX\u0010\u0010\u001a\u00020\u00062\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122&\u0010\u0013\u001a\"\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0015\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00160\u00142\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\u0018\u001a\u00020\u00062\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00122\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u001c\u0010&\u001a\u00020\u000f2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010'\u001a\u00020(H\u0002J\u001a\u0010)\u001a\u00020\u000f*\u0012\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u0002\b\u00030\u0014\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkActualDeclarationHasExpected", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkActual", "", "checkAmbiguousExpects", "actualDeclaration", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "compatibility", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCompatibility;", "", "symbol", "checkAnnotationsMatch", "expectSymbol", "actualSymbol", "checkExpectDeclarationHasNoExternalModifier", "checkExpectDeclarationModifiers", "checkExpectPropertyAccessorModifiers", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "checkExpectPropertyAccessorsModifiers", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkOptInAnnotation", "expectDeclarationSymbol", "containsExpectOrActualModifier", "requireActualModifier", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "allStrongIncompatibilities", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExpectActualDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectActualDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,279:1\n37#2:280\n36#2:281\n37#2:282\n36#2:283\n44#2:284\n45#2:285\n36#2:286\n819#3:287\n847#3,2:288\n1747#3,3:290\n1726#3,3:294\n603#4:293\n*S KotlinDebug\n*F\n+ 1 FirExpectActualDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker\n*L\n43#1:280\n43#1:281\n53#1:282\n57#1:283\n78#1:284\n112#1:285\n130#1:286\n163#1:287\n163#1:288,2\n172#1:290,3\n251#1:294,3\n210#1:293\n*E\n"})
public final class FirExpectActualDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExpectActualDeclarationChecker INSTANCE = new FirExpectActualDeclarationChecker();

    private FirExpectActualDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block7: {
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                    if (!(declaration instanceof FirMemberDeclaration)) {
                        return;
                    }
                    if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.MultiPlatformProjects)) break block7;
                    FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration;
                    boolean $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) break block8;
                    FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration;
                    boolean $i$f$isActual = false;
                    if (!$this$isActual$iv.getStatus().isActual()) break block9;
                }
                if (this.containsExpectOrActualModifier((FirMemberDeclaration)declaration)) {
                    KtDiagnosticReportHelpersKt.reportOn(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNOT_A_MULTIPLATFORM_COMPILATION(), (DiagnosticContext)context2, (AbstractSourceElementPositioningStrategy)SourceElementPositioningStrategies.INSTANCE.getEXPECT_ACTUAL_MODIFIER());
                }
            }
            return;
        }
        FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            this.checkExpectDeclarationModifiers((FirMemberDeclaration)declaration, context2, reporter);
            this.checkOptInAnnotation((FirMemberDeclaration)declaration, declaration.getSymbol(), context2, reporter);
        }
        FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isActual = false;
        if ($this$isActual$iv.getStatus().isActual()) {
            FirExpectActualDeclarationChecker.checkActualDeclarationHasExpected$default(this, (FirMemberDeclaration)declaration, context2, reporter, false, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsExpectOrActualModifier(FirMemberDeclaration declaration) {
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(declaration.getSource());
        if (firModifierList == null) return false;
        FirModifierList modifiers = firModifierList;
        boolean bl = false;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.EXPECT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"EXPECT_KEYWORD");
        if (modifiers.contains(ktModifierKeywordToken)) return true;
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.ACTUAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken2), (String)"ACTUAL_KEYWORD");
        if (!modifiers.contains(ktModifierKeywordToken2)) return false;
        return true;
    }

    private final void checkExpectDeclarationModifiers(FirMemberDeclaration declaration, CheckerContext context2, DiagnosticReporter reporter) {
        this.checkExpectDeclarationHasNoExternalModifier(declaration, context2, reporter);
        if (declaration instanceof FirProperty) {
            this.checkExpectPropertyAccessorsModifiers((FirProperty)declaration, context2, reporter);
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions) && declaration instanceof FirFunction) {
            FirMemberDeclaration $this$isTailRec$iv = declaration;
            boolean $i$f$isTailRec = false;
            if ($this$isTailRec$iv.getStatus().isTailRec()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPECTED_TAILREC_FUNCTION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkExpectPropertyAccessorsModifiers(FirProperty property, CheckerContext context2, DiagnosticReporter reporter) {
        Object[] objectArray = new FirPropertyAccessor[]{property.getGetter(), property.getSetter()};
        for (FirPropertyAccessor accessor : CollectionsKt.listOfNotNull((Object[])objectArray)) {
            this.checkExpectPropertyAccessorModifiers(accessor, context2, reporter);
        }
    }

    private final void checkExpectPropertyAccessorModifiers(FirPropertyAccessor accessor, CheckerContext context2, DiagnosticReporter reporter) {
        if (!FirExpectActualDeclarationChecker.checkExpectPropertyAccessorModifiers$isDefault(accessor)) {
            this.checkExpectDeclarationHasNoExternalModifier(accessor, context2, reporter);
        }
    }

    private final void checkExpectDeclarationHasNoExternalModifier(FirMemberDeclaration declaration, CheckerContext context2, DiagnosticReporter reporter) {
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            FirMemberDeclaration $this$isExternal$iv = declaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPECTED_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkActualDeclarationHasExpected(FirMemberDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, boolean checkActual) {
        block18: {
            block16: {
                block17: {
                    symbol = declaration.getSymbol();
                    v0 = ExpectActualAttributesKt.getExpectForActual(symbol);
                    if (v0 == null) {
                        return;
                    }
                    compatibilityToMembersMap = v0;
                    this.checkAmbiguousExpects(symbol, compatibilityToMembersMap, symbol, context, reporter);
                    source = declaration.getSource();
                    $this$isActual$iv = declaration;
                    $i$f$isActual = false;
                    if (!$this$isActual$iv.getStatus().isActual()) {
                        if (this.allStrongIncompatibilities(compatibilityToMembersMap)) {
                            return;
                        }
                        if (compatibilityToMembersMap.containsKey(ExpectActualCompatibility.Compatible.INSTANCE)) {
                            if (checkActual) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_MISSING(), (DiagnosticContext)context, null, 8, null);
                            }
                            return;
                        }
                    }
                    singleIncompatibility = (ExpectActualCompatibility)CollectionsKt.singleOrNull((Iterable)compatibilityToMembersMap.keySet());
                    if (!(singleIncompatibility instanceof ExpectActualCompatibility.Incompatible.ClassScopes)) break block17;
                    if (!(symbol instanceof FirRegularClassSymbol != false || symbol instanceof FirTypeAliasSymbol != false)) {
                        $i$a$-require-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$1 = false;
                        $i$a$-require-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$1 = "Incompatible.ClassScopes is only possible for a class or a typealias: " + declaration;
                        throw new IllegalArgumentException($i$a$-require-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$1.toString());
                    }
                    $this$filterNot$iv = ((ExpectActualCompatibility.Incompatible.ClassScopes)singleIncompatibility).getUnfulfilled();
                    $i$f$filterNot = false;
                    var12_19 = $this$filterNot$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        p0 = (Pair)element$iv$iv;
                        $i$a$-filterNot-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$nonTrivialUnfulfilled$1 = false;
                        if (FirExpectActualDeclarationChecker.checkActualDeclarationHasExpected$hasSingleActualSuspect(p0)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    nonTrivialUnfulfilled = (List)destination$iv$iv;
                    if (((Collection)nonTrivialUnfulfilled).isEmpty() == false) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS(), symbol, (Object)nonTrivialUnfulfilled, (DiagnosticContext)context, null, 32, null);
                    }
                    break block18;
                }
                if (compatibilityToMembersMap.containsKey(ExpectActualCompatibility.Compatible.INSTANCE)) break block18;
                if (!(declaration instanceof FirFunction)) ** GOTO lbl-1000
                $this$any$iv = compatibilityToMembersMap.keySet();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (ExpectActualCompatibility)element$iv;
                        $i$a$-any-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$2 = false;
                        if (!(it instanceof ExpectActualCompatibility.Incompatible.ActualFunctionWithDefaultParameters)) continue;
                        v1 = true;
                        break block16;
                    }
                    v1 = false;
                }
            }
            if (v1) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getACTUAL_FUNCTION_WITH_DEFAULT_ARGUMENTS(), (DiagnosticContext)context, null, 8, null);
            } else if (this.requireActualModifier(declaration.getSymbol(), context.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_WITHOUT_EXPECT(), symbol, compatibilityToMembersMap, (DiagnosticContext)context, null, 32, null);
            }
        }
        if ((v2 = ExpectActualAttributesKt.getSingleCompatibleExpectForActualOrNull(symbol)) == null) {
            v2 = ExpectActualAttributesKt.getSingleExpectForActualOrNull(symbol);
        }
        if ((expectedSingleCandidate = v2) != null) {
            this.checkOptInAnnotation(declaration, expectedSingleCandidate, context, reporter);
            this.checkAnnotationsMatch(expectedSingleCandidate, symbol, context, reporter);
        }
    }

    static /* synthetic */ void checkActualDeclarationHasExpected$default(FirExpectActualDeclarationChecker firExpectActualDeclarationChecker, FirMemberDeclaration firMemberDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        firExpectActualDeclarationChecker.checkActualDeclarationHasExpected(firMemberDeclaration, checkerContext, diagnosticReporter, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAmbiguousExpects(FirBasedSymbol<?> actualDeclaration, Map<ExpectActualCompatibility<FirBasedSymbol<?>>, ? extends List<? extends FirBasedSymbol<?>>> compatibility, FirBasedSymbol<?> symbol2, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$sortedBy$iv;
        Sequence sequence2 = SequencesKt.map((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(compatibility), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.1.INSTANCE), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.2.INSTANCE)), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.3.INSTANCE);
        boolean $i$f$sortedBy = false;
        List filesWithAtLeastWeaklyCompatibleExpects2 = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FirModuleData it = (FirModuleData)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName().asString());
                it = (FirModuleData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName().asString())));
            }
        }));
        if (filesWithAtLeastWeaklyCompatibleExpects2.size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)actualDeclaration.getSource(), FirErrors.INSTANCE.getAMBIGUOUS_EXPECTS(), symbol2, (Object)filesWithAtLeastWeaklyCompatibleExpects2, (DiagnosticContext)context2, null, 32, null);
        }
    }

    private final void checkAnnotationsMatch(FirBasedSymbol<?> expectSymbol, FirBasedSymbol<?> actualSymbol, CheckerContext context2, DiagnosticReporter reporter) {
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            return;
        }
        FirExpectActualMatchingContext matchingContext2 = FirExpectActualMatchingContextFactory.create$default(FirExpectActualMatchingContextKt.getExpectActualMatchingContextFactory(context2.getSession()), context2.getSession(), context2.getScopeSession(), false, 4, null);
        AbstractExpectActualAnnotationMatchChecker.Incompatibility incompatibility = AbstractExpectActualAnnotationMatchChecker.INSTANCE.areAnnotationsCompatible(expectSymbol, (DeclarationSymbolMarker)actualSymbol, matchingContext2);
        if (incompatibility == null) {
            return;
        }
        AbstractExpectActualAnnotationMatchChecker.Incompatibility incompatibility2 = incompatibility;
        SourceElementMarker sourceElementMarker = incompatibility2.getActualAnnotationTargetElement();
        Intrinsics.checkNotNull((Object)sourceElementMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirSourceElement");
        KtSourceElement actualAnnotationTargetSourceElement = ((FirSourceElement)sourceElementMarker).getElement();
        KtDiagnosticFactory4<FirBasedSymbol<?>, FirBasedSymbol<?>, KtSourceElement, ExpectActualAnnotationsIncompatibilityType<FirAnnotation>> ktDiagnosticFactory4 = FirErrors.INSTANCE.getACTUAL_ANNOTATIONS_NOT_MATCH_EXPECT();
        AbstractKtSourceElement abstractKtSourceElement = KtDiagnosticReportHelpersKt.requireNotNull(actualSymbol.getSource());
        DeclarationSymbolMarker declarationSymbolMarker = incompatibility2.getExpectSymbol();
        Intrinsics.checkNotNull((Object)declarationSymbolMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.FirBasedSymbol<*>");
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)declarationSymbolMarker;
        DeclarationSymbolMarker declarationSymbolMarker2 = incompatibility2.getActualSymbol();
        Intrinsics.checkNotNull((Object)declarationSymbolMarker2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.FirBasedSymbol<*>");
        reporter.report(ktDiagnosticFactory4.on(abstractKtSourceElement, firBasedSymbol, (FirBasedSymbol)declarationSymbolMarker2, actualAnnotationTargetSourceElement, incompatibility2.getType().mapAnnotationType(checkAnnotationsMatch.1.INSTANCE), null), context2);
    }

    public final boolean allStrongIncompatibilities(@NotNull Map<? extends ExpectActualCompatibility<?>, ?> $this$allStrongIncompatibilities) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$allStrongIncompatibilities, (String)"<this>");
            Iterable $this$all$iv = $this$allStrongIncompatibilities.keySet();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ExpectActualCompatibility it = (ExpectActualCompatibility)element$iv;
                    boolean bl2 = false;
                    if (it instanceof ExpectActualCompatibility.Incompatible.StrongIncompatible) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean requireActualModifier(FirBasedSymbol<?> declaration, FirSession session) {
        return !DeclarationUtilsKt.isAnnotationConstructor(declaration, session) && !DeclarationUtilsKt.isPrimaryConstructorOfInlineOrValueClass(declaration, session);
    }

    private final void checkOptInAnnotation(FirMemberDeclaration declaration, FirBasedSymbol<?> expectDeclarationSymbol, CheckerContext context2, DiagnosticReporter reporter) {
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions) && declaration instanceof FirClass && ((FirClass)declaration).getClassKind() == ClassKind.ANNOTATION_CLASS && !FirAnnotationUtilsKt.hasAnnotation(expectDeclarationSymbol, StandardClassIds.Annotations.INSTANCE.getOptionalExpectation(), context2.getSession()) && FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)declaration, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPECT_ACTUAL_OPT_IN_ANNOTATION(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private static final boolean checkExpectPropertyAccessorModifiers$isDefault(FirPropertyAccessor $this$checkExpectPropertyAccessorModifiers_u24isDefault) {
        KtSourceElement ktSourceElement = $this$checkExpectPropertyAccessorModifiers_u24isDefault.getSource();
        return Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DefaultAccessor.INSTANCE);
    }

    private static final boolean checkActualDeclarationHasExpected$hasSingleActualSuspect(Pair<? extends FirBasedSymbol<?>, ? extends Map<ExpectActualCompatibility.Incompatible<FirBasedSymbol<?>>, ? extends Collection<? extends FirBasedSymbol<?>>>> expectedWithIncompatibility) {
        Object object;
        FirBasedSymbol actualMember;
        FirBasedSymbol expectedMember = (FirBasedSymbol)expectedWithIncompatibility.component1();
        Map incompatibility = (Map)expectedWithIncompatibility.component2();
        Collection collection = (Collection)CollectionsKt.singleOrNull((Iterable)incompatibility.values());
        FirBasedSymbol firBasedSymbol = actualMember = collection != null ? (FirBasedSymbol)CollectionsKt.singleOrNull((Iterable)collection) : null;
        return actualMember != null && !INSTANCE.allStrongIncompatibilities(incompatibility) && Intrinsics.areEqual((object = ExpectActualAttributesKt.getExpectForActual(actualMember.getFir())) != null && (object = object.values()) != null && (object = (List)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) != null ? (FirBasedSymbol)CollectionsKt.singleOrNull((List)object) : null, (Object)expectedMember);
    }
}

