/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FastStackAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackInterpreter;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackValue;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000 *2\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003R\u00020\u00000\u0001:\u0002*+B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u0016\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020\u0013J\u000e\u0010 \u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0013J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0013J\u0016\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020\u0013J\u001c\u0010#\u001a\u00060\u0003R\u00020\u00002\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0016H\u0014J\b\u0010&\u001a\u00020\u001dH\u0002J\u0018\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0016H\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR6\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010j\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u001a\u001a*\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001b0\u0010j\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001b`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FastStackAnalyzer;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackValue;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$FixStackFrame;", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "skipBreakContinueGotoEdges", "", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "loopEntryPointMarkers", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lorg/jetbrains/kotlin/utils/SmartList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/HashMap;", "<set-?>", "", "maxExtraStackSize", "getMaxExtraStackSize", "()I", "spilledStacks", "", "beforeAnalyze", "", "getActualStack", "location", "getActualStackSize", "getExpectedStackSize", "getStackToSpill", "newFrame", "nLocals", "nStack", "recordLoopEntryPointMarkers", "visitControlFlowEdge", "insnNode", "successor", "Companion", "FixStackFrame", "backend"})
@SourceDebugExtension(value={"SMAP\nFixStackAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,207:1\n372#2,7:208\n*S KotlinDebug\n*F\n+ 1 FixStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer\n*L\n83#1:208,7\n*E\n"})
public final class FixStackAnalyzer
extends FastStackAnalyzer<FixStackValue, FixStackFrame> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FixStackContext context;
    private final boolean skipBreakContinueGotoEdges;
    @NotNull
    private final HashMap<LabelNode, SmartList<AbstractInsnNode>> loopEntryPointMarkers;
    private int maxExtraStackSize;
    @NotNull
    private final HashMap<AbstractInsnNode, List<FixStackValue>> spilledStacks;
    public static final int DEAD_CODE_STACK_SIZE = -1;

    public FixStackAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull FixStackContext context2, boolean skipBreakContinueGotoEdges) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(owner, method, new FixStackInterpreter());
        this.context = context2;
        this.skipBreakContinueGotoEdges = skipBreakContinueGotoEdges;
        this.loopEntryPointMarkers = new HashMap();
        this.spilledStacks = new HashMap();
    }

    public /* synthetic */ FixStackAnalyzer(String string2, MethodNode methodNode, FixStackContext fixStackContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(string2, methodNode, fixStackContext, bl);
    }

    @NotNull
    public final FixStackContext getContext() {
        return this.context;
    }

    public final int getMaxExtraStackSize() {
        return this.maxExtraStackSize;
    }

    @Nullable
    public final List<FixStackValue> getStackToSpill(@NotNull AbstractInsnNode location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.spilledStacks.get(location);
    }

    @Nullable
    public final List<FixStackValue> getActualStack(@NotNull AbstractInsnNode location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        FixStackFrame fixStackFrame = (FixStackFrame)((Object)this.getFrame(location));
        return fixStackFrame != null ? fixStackFrame.getStackContent() : null;
    }

    public final int getActualStackSize(@NotNull AbstractInsnNode location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        FixStackFrame fixStackFrame = (FixStackFrame)((Object)this.getFrame(location));
        return fixStackFrame != null ? fixStackFrame.getStackSizeWithExtra() : -1;
    }

    public final int getExpectedStackSize(@NotNull AbstractInsnNode location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        SmartList smartList = (SmartList)((Map)this.loopEntryPointMarkers).get(location);
        List expectedStackSizeNodes = smartList != null ? (List)smartList : CollectionsKt.listOf((Object)location);
        for (AbstractInsnNode node : expectedStackSizeNodes) {
            FixStackFrame fixStackFrame = (FixStackFrame)((Object)this.getFrame(node));
            if (fixStackFrame == null) continue;
            FixStackFrame frame = fixStackFrame;
            return frame.getStackSizeWithExtra();
        }
        return -1;
    }

    @Override
    protected void beforeAnalyze() {
        this.recordLoopEntryPointMarkers();
    }

    /*
     * WARNING - void declaration
     */
    private final void recordLoopEntryPointMarkers() {
        for (AbstractInsnNode marker : this.context.getFakeAlwaysFalseIfeqMarkers()) {
            Object object;
            LabelNode key$iv;
            void $this$getOrPut$iv;
            AbstractInsnNode next = marker.getNext();
            if (!(next instanceof JumpInsnNode)) continue;
            Map map = this.loopEntryPointMarkers;
            Intrinsics.checkNotNullExpressionValue((Object)((JumpInsnNode)next).label, (String)"label");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                SmartList answer$iv = new SmartList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((SmartList)object).add(marker);
        }
    }

    @Override
    protected boolean visitControlFlowEdge(@NotNull AbstractInsnNode insnNode, int successor) {
        Intrinsics.checkNotNullParameter((Object)insnNode, (String)"insnNode");
        if (!this.skipBreakContinueGotoEdges) {
            return true;
        }
        return !(insnNode instanceof JumpInsnNode) || !this.context.getBreakContinueGotoNodes().contains(insnNode);
    }

    @Override
    @NotNull
    protected FixStackFrame newFrame(int nLocals, int nStack) {
        return new FixStackFrame(nLocals, nStack);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$Companion;", "", "()V", "DEAD_CODE_STACK_SIZE", "", "backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001H\u0016J&\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0002H\u0016J\u0014\u0010!\u001a\u00020\r2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#J\u0010\u0010$\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$FixStackFrame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackValue;", "nLocals", "", "nStack", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;II)V", "extraStack", "Lcom/intellij/util/containers/Stack;", "stackSizeWithExtra", "getStackSizeWithExtra", "()I", "clearStack", "", "execute", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "executeAfterInlineCallMarker", "executeBeforeInlineCallMarker", "executeRestoreStackInTryCatch", "executeSaveStackBeforeTry", "getStackContent", "", "init", "src", "merge", "", "frame", "pop", "push", "value", "pushAll", "values", "", "saveStackAndClear", "setStack", "i", "backend"})
    @SourceDebugExtension(value={"SMAP\nFixStackAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$FixStackFrame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1855#2,2:208\n*S KotlinDebug\n*F\n+ 1 FixStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$FixStackFrame\n*L\n148#1:208,2\n*E\n"})
    public final class FixStackFrame
    extends Frame<FixStackValue> {
        @NotNull
        private final Stack<FixStackValue> extraStack;

        public FixStackFrame(int nLocals, int nStack) {
            super(nLocals, nStack);
            this.extraStack = new Stack();
        }

        @NotNull
        public Frame<FixStackValue> init(@NotNull Frame<? extends FixStackValue> src) {
            Intrinsics.checkNotNullParameter(src, (String)"src");
            this.extraStack.clear();
            this.extraStack.addAll((Collection)((FixStackFrame)src).extraStack);
            Frame frame = super.init(src);
            Intrinsics.checkNotNullExpressionValue((Object)frame, (String)"init(...)");
            return frame;
        }

        public void clearStack() {
            this.extraStack.clear();
            super.clearStack();
        }

        public void execute(@NotNull AbstractInsnNode insn, @NotNull Interpreter<FixStackValue> interpreter2) {
            Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
            Intrinsics.checkNotNullParameter(interpreter2, (String)"interpreter");
            if (PseudoInsn.SAVE_STACK_BEFORE_TRY.isa(insn)) {
                this.executeSaveStackBeforeTry(insn);
            } else if (PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.isa(insn)) {
                this.executeRestoreStackInTryCatch(insn);
            } else if (InlineCodegenUtilsKt.isBeforeInlineMarker(insn)) {
                this.executeBeforeInlineCallMarker(insn);
            } else if (InlineCodegenUtilsKt.isAfterInlineMarker(insn)) {
                this.executeAfterInlineCallMarker(insn);
            } else if (insn.getOpcode() == 177) {
                return;
            }
            super.execute(insn, interpreter2);
        }

        public final int getStackSizeWithExtra() {
            return super.getStackSize() + this.extraStack.size();
        }

        @NotNull
        public final List<FixStackValue> getStackContent() {
            ArrayList<Value> savedStack = new ArrayList<Value>();
            int n = super.getStackSize();
            for (int i = 0; i < n; ++i) {
                savedStack.add(super.getStack(i));
            }
            savedStack.addAll((Collection)this.extraStack);
            return savedStack;
        }

        public void push(@NotNull FixStackValue value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            if (super.getStackSize() < this.getMaxStackSize()) {
                super.push((Value)value2);
            } else {
                this.extraStack.add((Object)value2);
                FixStackAnalyzer.this.maxExtraStackSize = Math.max(FixStackAnalyzer.this.getMaxExtraStackSize(), this.extraStack.size());
            }
        }

        public final void pushAll(@NotNull Collection<? extends FixStackValue> values2) {
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            Iterable $this$forEach$iv = values2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FixStackValue it = (FixStackValue)((Object)element$iv);
                boolean bl = false;
                this.push(it);
            }
        }

        @NotNull
        public FixStackValue pop() {
            FixStackValue fixStackValue;
            if (!((Collection)this.extraStack).isEmpty()) {
                Object object = this.extraStack.pop();
                Intrinsics.checkNotNull((Object)object);
                fixStackValue = (FixStackValue)((Object)object);
            } else {
                Value value2 = super.pop();
                Intrinsics.checkNotNull((Object)value2);
                fixStackValue = (FixStackValue)value2;
            }
            return fixStackValue;
        }

        public void setStack(int i, @NotNull FixStackValue value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            if (i < super.getMaxStackSize()) {
                super.setStack(i, (Value)value2);
            } else {
                this.extraStack.set(i - this.getMaxStackSize(), (Object)value2);
            }
        }

        public boolean merge(@NotNull Frame<? extends FixStackValue> frame, @NotNull Interpreter<FixStackValue> interpreter2) {
            Intrinsics.checkNotNullParameter(frame, (String)"frame");
            Intrinsics.checkNotNullParameter(interpreter2, (String)"interpreter");
            throw new UnsupportedOperationException("Stack normalization should not merge frames");
        }

        private final void executeBeforeInlineCallMarker(AbstractInsnNode insn) {
            this.saveStackAndClear(insn);
        }

        private final void saveStackAndClear(AbstractInsnNode insn) {
            List<FixStackValue> savedValues = this.getStackContent();
            ((Map)FixStackAnalyzer.this.spilledStacks).put(insn, savedValues);
            this.clearStack();
        }

        private final void executeAfterInlineCallMarker(AbstractInsnNode insn) {
            AbstractInsnNode beforeInlineMarker = FixStackAnalyzer.this.getContext().getOpeningInlineMethodMarker().get(insn);
            if (this.getStackSize() > 0) {
                List savedValues;
                FixStackValue returnValue = this.pop();
                this.clearStack();
                List list2 = savedValues = (List)((Map)FixStackAnalyzer.this.spilledStacks).get(beforeInlineMarker);
                Intrinsics.checkNotNull((Object)list2);
                this.pushAll(list2);
                this.push(returnValue);
            } else {
                List savedValues;
                List list3 = savedValues = (List)((Map)FixStackAnalyzer.this.spilledStacks).get(beforeInlineMarker);
                Intrinsics.checkNotNull((Object)list3);
                this.pushAll(list3);
            }
        }

        private final void executeRestoreStackInTryCatch(AbstractInsnNode insn) {
            AbstractInsnNode saveNode = FixStackAnalyzer.this.getContext().getSaveStackMarkerForRestoreMarker().get(insn);
            Map map = FixStackAnalyzer.this.spilledStacks;
            AbstractInsnNode abstractInsnNode = saveNode;
            Intrinsics.checkNotNull((Object)abstractInsnNode);
            AbstractInsnNode abstractInsnNode2 = abstractInsnNode;
            FixStackAnalyzer fixStackAnalyzer = FixStackAnalyzer.this;
            Object v = map.get(abstractInsnNode2);
            if (v == null) {
                boolean bl = false;
                throw new AssertionError((Object)(fixStackAnalyzer.indexOf(insn) + ": Restore stack is unavailable for " + fixStackAnalyzer.indexOf(saveNode)));
            }
            List savedValues = (List)v;
            this.pushAll(savedValues);
        }

        private final void executeSaveStackBeforeTry(AbstractInsnNode insn) {
            this.saveStackAndClear(insn);
        }
    }
}

