/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.contracts.description.LogicOperationKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirExpressionRef;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.builder.CharacterWithDiagnostic;
import org.jetbrains.kotlin.fir.builder.Context;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirLegacyRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.builder.FirLegacyRawContractDescriptionBuilder;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousObjectBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyAccessorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirReceiverParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckedSafeCallSubject;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirLazyExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBinaryLogicExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCheckedSafeCallSubjectBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComparisonExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComponentCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirElvisExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirPropertyAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSafeCallExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWrappedDelegateExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.builder.FirDelegateFieldReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirImplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirTypeProjectionWithVarianceBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitTypeRefImplWithoutSource;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u009a\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0005\u001a\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u001a.\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%\u001a\u0018\u0010&\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010 2\u0006\u0010(\u001a\u00020)\u001a\u0010\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-\u001a\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u000200H\u0000\u001a\f\u00101\u001a\u00020\u0001*\u0004\u0018\u000102\u001a\n\u00103\u001a\u000204*\u00020 \u001a\u0016\u00105\u001a\u00020\u0001*\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010\u001cH\u0002\u001a\n\u00106\u001a\u000204*\u000207\u001a0\u00108\u001a\u000209*\u00020\u000f2\b\u0010:\u001a\u0004\u0018\u00010 2\b\u0010;\u001a\u0004\u0018\u00010 2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020#H\u0002\u001a\u001a\u0010>\u001a\u00020?*\u00020\u001e2\u0006\u0010@\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020 \u001a\u001e\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u0011*\b\u0012\u0004\u0012\u00020B0\u00112\u0006\u0010C\u001a\u000202\u001aR\u0010D\u001a\u00020E\"\u0004\b\u0000\u0010\u0016*\u00020F2\b\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020J2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010K\u001a\u00020\u00012\n\b\u0002\u0010L\u001a\u0004\u0018\u00010M\u001a.\u0010N\u001a\u00020O*\u00020\u000f2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020Q2\b\u0010;\u001a\u0004\u0018\u00010 2\b\u0010:\u001a\u0004\u0018\u00010 \u001a.\u0010R\u001a\u000209*\u00020\u000f2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010S\u001a\u00020\u00012\b\u0010;\u001a\u0004\u0018\u00010 2\b\u0010:\u001a\u0004\u0018\u00010 \u001a$\u0010T\u001a\u00020U*\u00020\u000f2\u0006\u0010V\u001a\u00020\u000f2\u0006\u0010W\u001a\u00020\u00012\b\u0010;\u001a\u0004\u0018\u00010 \u001a\u001c\u0010X\u001a\u00020Y*\u00020\u000f2\u0006\u0010V\u001a\u00020\u000f2\b\u0010;\u001a\u0004\u0018\u00010 \u001a\u001e\u0010Z\u001a\u00020E\"\u0004\b\u0000\u0010\u0016*\u00020[2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018\u001a\u001b\u0010\\\u001a\u00020\u0001*\u00020]\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\n\u0010^\u001a\u00020\u0001*\u00020-\u001a\n\u0010_\u001a\u00020\u001a*\u00020\u001c\u001a\n\u0010`\u001a\u00020\u000f*\u00020\u000f\u001a\f\u0010a\u001a\u0004\u0018\u00010#*\u00020Q\u001a\u001c\u0010b\u001a\u00020c*\u00020)2\b\u0010d\u001a\u0004\u0018\u00010 2\u0006\u0010e\u001a\u00020\u0005\u001a\n\u0010f\u001a\u00020g*\u00020Q\u001a\f\u0010h\u001a\u0004\u0018\u00010g*\u00020Q\u001a\n\u0010i\u001a\u00020j*\u000209\u001a\f\u0010k\u001a\u0004\u0018\u00010#*\u00020Q\u001a\u0016\u0010l\u001a\u00020 *\u00020 2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018\u001a\n\u0010m\u001a\u00020n*\u00020o\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001f\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00f2\u0001\u0004\n\u000209\u00a8\u0006p"}, d2={"isUnderscore", "", "", "(Ljava/lang/CharSequence;)Z", "ownerRegularClassTypeParametersCount", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;", "getOwnerRegularClassTypeParametersCount", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;)Ljava/lang/Integer;", "ownerRegularOrAnonymousObjectSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getOwnerRegularOrAnonymousObjectSymbol", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "buildBalancedOrExpressionTree", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "conditions", "", "lower", "upper", "currentDispatchReceiverType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "T", "context", "Lorg/jetbrains/kotlin/fir/builder/Context;", "escapedStringToCharacter", "Lorg/jetbrains/kotlin/fir/builder/CharacterWithDiagnostic;", "text", "", "generateAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "qualifiedSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "calleeReferenceSource", "name", "Lorg/jetbrains/kotlin/name/Name;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "generateResolvedAccessExpression", "source", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "processLegacyContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "translateEscape", "c", "", "appliesToPrimaryConstructorParameter", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "asReceiverParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirReceiverParameter;", "checkReceiver", "convertToReceiverParameter", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "createConventionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "operationReferenceSource", "baseSource", "argument", "conventionName", "createSafeCall", "Lorg/jetbrains/kotlin/fir/expressions/FirSafeCallExpression;", "receiver", "filterUseSiteTarget", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "target", "generateAccessorsByDelegate", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;", "delegateBuilder", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirWrappedDelegateExpressionBuilder;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "isExtension", "lazyDelegateExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLazyExpression;", "generateComparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "operatorToken", "Lcom/intellij/psi/tree/IElementType;", "generateContainsOperation", "inverted", "generateLazyLogicalOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "other", "isAnd", "generateNotNullOrOther", "Lorg/jetbrains/kotlin/fir/expressions/FirElvisExpression;", "initContainingClassAttr", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "isContractBlockFirCheck", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "isContractPresentFirCheck", "parseCharacter", "pullUpSafeCallIfNecessary", "toBinaryName", "toComponentCall", "Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;", "entrySource", "index", "toFirOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "toFirOperationOrNull", "toLegacyRawContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirLegacyRawContractDescription;", "toUnaryName", "withForcedKindFrom", "wrapIntoArray", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "raw-fir.common"})
@SourceDebugExtension(value={"SMAP\nConversionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversionUtils.kt\norg/jetbrains/kotlin/fir/builder/ConversionUtilsKt\n+ 2 FirElvisExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirElvisExpressionBuilderKt\n+ 3 FirBinaryLogicExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirBinaryLogicExpressionBuilderKt\n+ 4 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 5 FirSimpleNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirSimpleNamedReferenceBuilderKt\n+ 6 FirComparisonExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirComparisonExpressionBuilderKt\n+ 7 FirPropertyAccessExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirPropertyAccessExpressionBuilderKt\n+ 8 FirResolvedNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirResolvedNamedReferenceBuilderKt\n+ 9 FirComponentCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirComponentCallBuilderKt\n+ 10 FirPropertyAccessorBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirPropertyAccessorBuilderKt\n+ 11 FirReturnExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirReturnExpressionBuilderKt\n+ 12 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 13 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 14 FirLegacyRawContractDescriptionBuilder.kt\norg/jetbrains/kotlin/fir/contracts/builder/FirLegacyRawContractDescriptionBuilderKt\n+ 15 FirCheckedSafeCallSubjectBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCheckedSafeCallSubjectBuilderKt\n+ 16 FirSafeCallExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSafeCallExpressionBuilderKt\n+ 17 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 18 FirAnnotationCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationCallBuilderKt\n+ 19 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 20 FirReceiverParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirReceiverParameterBuilderKt\n+ 21 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 22 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 23 FirThisReceiverExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirThisReceiverExpressionBuilderKt\n+ 24 FirImplicitThisReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirImplicitThisReferenceBuilderKt\n+ 25 FirDelegateFieldReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirDelegateFieldReferenceBuilderKt\n+ 26 FirCallableReferenceAccessBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCallableReferenceAccessBuilderKt\n+ 27 FirTypeProjectionWithVarianceBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirTypeProjectionWithVarianceBuilderKt\n*L\n1#1,721:1\n55#2,4:722\n54#3,4:726\n75#4,4:730\n75#4,4:742\n75#4,4:770\n75#4,4:786\n75#4,4:806\n41#5,4:734\n41#5,4:746\n41#5,4:754\n41#5,4:774\n41#5,4:790\n41#5,4:810\n59#6,4:738\n67#7,4:750\n67#7,4:758\n67#7,4:818\n67#7,4:897\n42#8,4:762\n42#8,4:822\n42#8,4:909\n74#9,4:766\n103#10,4:778\n103#10,4:794\n61#11,4:782\n61#11,4:802\n100#12,4:798\n33#13,4:814\n39#14,4:826\n50#15,4:830\n56#16,4:834\n1603#17,9:838\n1855#17:847\n1856#17:862\n1612#17:863\n819#17:868\n847#17,2:869\n1620#17,2:913\n1622#17:923\n86#18,13:848\n1#19:861\n44#20,4:864\n44#20,4:871\n1064#21,2:875\n49#22,4:877\n49#22,4:919\n84#23,4:881\n84#23,4:889\n42#24,4:885\n42#24,4:893\n40#25,4:901\n69#26,4:905\n42#27,4:915\n*S KotlinDebug\n*F\n+ 1 ConversionUtils.kt\norg/jetbrains/kotlin/fir/builder/ConversionUtilsKt\n*L\n189#1:722,4\n199#1:726,4\n216#1:730,4\n265#1:742,4\n430#1:770,4\n462#1:786,4\n519#1:806,4\n218#1:734,4\n267#1:746,4\n285#1:754,4\n432#1:774,4\n465#1:790,4\n522#1:810,4\n252#1:738,4\n283#1:750,4\n298#1:758,4\n529#1:818,4\n377#1:897,4\n300#1:762,4\n530#1:822,4\n390#1:909,4\n311#1:766,4\n449#1:778,4\n491#1:794,4\n461#1:782,4\n518#1:802,4\n501#1:798,4\n526#1:814,4\n564#1:826,4\n600#1:830,4\n609#1:834,4\n634#1:838,9\n634#1:847\n634#1:862\n634#1:863\n648#1:868\n648#1:869,2\n418#1:913,2\n418#1:923\n636#1:848,13\n634#1:861\n644#1:864,4\n656#1:871,4\n670#1:875,2\n715#1:877,4\n422#1:919,4\n361#1:881,4\n367#1:889,4\n363#1:885,4\n369#1:893,4\n379#1:901,4\n388#1:905,4\n419#1:915,4\n*E\n"})
public final class ConversionUtilsKt {
    @NotNull
    public static final CharacterWithDiagnostic parseCharacter(@NotNull String $this$parseCharacter) {
        Intrinsics.checkNotNullParameter((Object)$this$parseCharacter, (String)"<this>");
        if ($this$parseCharacter.length() < 2 || $this$parseCharacter.charAt(0) != '\'' || $this$parseCharacter.charAt($this$parseCharacter.length() - 1) != '\'') {
            return new CharacterWithDiagnostic(DiagnosticKind.IncorrectCharacterLiteral);
        }
        String string2 = $this$parseCharacter.substring(1, $this$parseCharacter.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String text = string2;
        if (((CharSequence)text).length() == 0) {
            return new CharacterWithDiagnostic(DiagnosticKind.EmptyCharacterLiteral);
        }
        return text.charAt(0) != '\\' ? (text.length() == 1 ? new CharacterWithDiagnostic(text.charAt(0)) : new CharacterWithDiagnostic(DiagnosticKind.TooManyCharactersInCharacterLiteral)) : ConversionUtilsKt.escapedStringToCharacter(text);
    }

    @NotNull
    public static final CharacterWithDiagnostic escapedStringToCharacter(@NotNull String text) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        boolean bl2 = bl = ((CharSequence)text).length() > 0 && text.charAt(0) == '\\';
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Only escaped sequences must be passed to this routine: " + text;
            throw new AssertionError((Object)string2);
        }
        String string3 = text.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String escape = string3;
        switch (escape.length()) {
            case 0: {
                return new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
            }
            case 1: {
                return ConversionUtilsKt.translateEscape(escape.charAt(0));
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                String string4 = escape.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                Integer intValue = StringsKt.toIntOrNull((String)string4, (int)16);
                if (intValue == null) break;
                return new CharacterWithDiagnostic((char)intValue.intValue());
            }
        }
        return new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
    }

    @NotNull
    public static final CharacterWithDiagnostic translateEscape(char c) {
        char c2 = c;
        return c2 == 't' ? new CharacterWithDiagnostic('\t') : (c2 == 'b' ? new CharacterWithDiagnostic('\b') : (c2 == 'n' ? new CharacterWithDiagnostic('\n') : (c2 == 'r' ? new CharacterWithDiagnostic('\r') : (c2 == '\'' ? new CharacterWithDiagnostic('\'') : (c2 == '\"' ? new CharacterWithDiagnostic('\"') : (c2 == '\\' ? new CharacterWithDiagnostic('\\') : (c2 == '$' ? new CharacterWithDiagnostic('$') : new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape))))))));
    }

    @Nullable
    public static final Name toBinaryName(@NotNull IElementType $this$toBinaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toBinaryName, (String)"<this>");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.BINARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(immutableBiMap, (String)"BINARY_OPERATION_NAMES");
        return (Name)((Map)immutableBiMap).get($this$toBinaryName);
    }

    @Nullable
    public static final Name toUnaryName(@NotNull IElementType $this$toUnaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toUnaryName, (String)"<this>");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.UNARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(immutableBiMap, (String)"UNARY_OPERATION_NAMES");
        return (Name)((Map)immutableBiMap).get($this$toUnaryName);
    }

    @NotNull
    public static final FirOperation toFirOperation(@NotNull IElementType $this$toFirOperation) {
        Intrinsics.checkNotNullParameter((Object)$this$toFirOperation, (String)"<this>");
        FirOperation firOperation = ConversionUtilsKt.toFirOperationOrNull($this$toFirOperation);
        if (firOperation == null) {
            throw new IllegalStateException(("Cannot convert element type to FIR operation: " + $this$toFirOperation).toString());
        }
        return firOperation;
    }

    @Nullable
    public static final FirOperation toFirOperationOrNull(@NotNull IElementType $this$toFirOperationOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$toFirOperationOrNull, (String)"<this>");
        IElementType iElementType = $this$toFirOperationOrNull;
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT)) ? FirOperation.LT : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT)) ? FirOperation.GT : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ)) ? FirOperation.LT_EQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ)) ? FirOperation.GT_EQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ)) ? FirOperation.EQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ)) ? FirOperation.NOT_EQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQEQ)) ? FirOperation.IDENTITY : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQEQEQ)) ? FirOperation.NOT_IDENTITY : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQ)) ? FirOperation.ASSIGN : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUSEQ)) ? FirOperation.PLUS_ASSIGN : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUSEQ)) ? FirOperation.MINUS_ASSIGN : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MULTEQ)) ? FirOperation.TIMES_ASSIGN : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.DIVEQ)) ? FirOperation.DIV_ASSIGN : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PERCEQ)) ? FirOperation.REM_ASSIGN : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.AS_KEYWORD)) ? FirOperation.AS : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.AS_SAFE)) ? FirOperation.SAFE_AS : null)))))))))))))));
    }

    @NotNull
    public static final FirElvisExpression generateNotNullOrOther(@NotNull FirExpression $this$generateNotNullOrOther, @NotNull FirExpression other, @Nullable KtSourceElement baseSource) {
        FirElvisExpressionBuilder firElvisExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$generateNotNullOrOther, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$buildElvisExpression = false;
        FirElvisExpressionBuilder $this$generateNotNullOrOther_u24lambda_u241 = firElvisExpressionBuilder = new FirElvisExpressionBuilder();
        boolean bl = false;
        $this$generateNotNullOrOther_u24lambda_u241.setSource(baseSource);
        $this$generateNotNullOrOther_u24lambda_u241.setLhs($this$generateNotNullOrOther);
        $this$generateNotNullOrOther_u24lambda_u241.setRhs(other);
        return firElvisExpressionBuilder.build();
    }

    @NotNull
    public static final FirBinaryLogicExpression generateLazyLogicalOperation(@NotNull FirExpression $this$generateLazyLogicalOperation, @NotNull FirExpression other, boolean isAnd, @Nullable KtSourceElement baseSource) {
        FirBinaryLogicExpressionBuilder firBinaryLogicExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$generateLazyLogicalOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$buildBinaryLogicExpression = false;
        FirBinaryLogicExpressionBuilder $this$generateLazyLogicalOperation_u24lambda_u242 = firBinaryLogicExpressionBuilder = new FirBinaryLogicExpressionBuilder();
        boolean bl = false;
        $this$generateLazyLogicalOperation_u24lambda_u242.setSource(baseSource);
        $this$generateLazyLogicalOperation_u24lambda_u242.setLeftOperand($this$generateLazyLogicalOperation);
        $this$generateLazyLogicalOperation_u24lambda_u242.setRightOperand(other);
        $this$generateLazyLogicalOperation_u24lambda_u242.setKind(isAnd ? LogicOperationKind.AND : LogicOperationKind.OR);
        return firBinaryLogicExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirFunctionCall generateContainsOperation(@NotNull FirExpression $this$generateContainsOperation, @NotNull FirExpression argument2, boolean inverted, @Nullable KtSourceElement baseSource, @Nullable KtSourceElement operationReferenceSource) {
        void $this$generateContainsOperation_u24lambda_u244_u24lambda_u243;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$generateContainsOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        FirFunctionCall containsCall = ConversionUtilsKt.createConventionCall($this$generateContainsOperation, operationReferenceSource, baseSource, argument2, OperatorNameConventions.CONTAINS);
        if (!inverted) {
            return containsCall;
        }
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$generateContainsOperation_u24lambda_u244 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = baseSource;
        $this$generateContainsOperation_u24lambda_u244.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.DesugaredInvertedContains.INSTANCE, 0, 0, 6, null) : null);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$generateContainsOperation_u24lambda_u244;
        boolean bl2 = false;
        KtSourceElement ktSourceElement2 = operationReferenceSource;
        $this$generateContainsOperation_u24lambda_u244_u24lambda_u243.setSource(ktSourceElement2 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement2, KtFakeSourceElementKind.DesugaredInvertedContains.INSTANCE, 0, 0, 6, null) : null);
        $this$generateContainsOperation_u24lambda_u244_u24lambda_u243.setName(OperatorNameConventions.NOT);
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$generateContainsOperation_u24lambda_u244.setExplicitReceiver(containsCall);
        $this$generateContainsOperation_u24lambda_u244.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    @NotNull
    public static final FirComparisonExpression generateComparisonExpression(@NotNull FirExpression $this$generateComparisonExpression, @NotNull FirExpression argument2, @NotNull IElementType operatorToken, @Nullable KtSourceElement baseSource, @Nullable KtSourceElement operationReferenceSource) {
        FirComparisonExpressionBuilder firComparisonExpressionBuilder;
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter((Object)$this$generateComparisonExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorToken, (String)"operatorToken");
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"COMPARISON_OPERATIONS");
        if (!CollectionsKt.contains((Iterable)((Iterable)immutableSet), (Object)operatorToken)) {
            boolean $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = false;
            String $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = operatorToken + " is not in " + OperatorConventions.COMPARISON_OPERATIONS;
            throw new IllegalArgumentException($i$a$-require-ConversionUtilsKt$generateComparisonExpression$22.toString());
        }
        KtSourceElement ktSourceElement = baseSource;
        FirFunctionCall compareToCall = ConversionUtilsKt.createConventionCall($this$generateComparisonExpression, operationReferenceSource, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.GeneratedComparisonExpression.INSTANCE, 0, 0, 6, null) : null, argument2, OperatorNameConventions.COMPARE_TO);
        IElementType iElementType = operatorToken;
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT))) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT))) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ))) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ))) {
            firOperation = FirOperation.GT_EQ;
        } else {
            throw new IllegalStateException(("Unknown " + operatorToken).toString());
        }
        FirOperation firOperation2 = firOperation;
        boolean $i$f$buildComparisonExpression = false;
        FirComparisonExpressionBuilder $this$generateComparisonExpression_u24lambda_u246 = firComparisonExpressionBuilder = new FirComparisonExpressionBuilder();
        boolean bl = false;
        $this$generateComparisonExpression_u24lambda_u246.setSource(baseSource);
        $this$generateComparisonExpression_u24lambda_u246.setOperation(firOperation2);
        $this$generateComparisonExpression_u24lambda_u246.setCompareToCall(compareToCall);
        return firComparisonExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirFunctionCall createConventionCall(FirExpression $this$createConventionCall, KtSourceElement operationReferenceSource, KtSourceElement baseSource, FirExpression argument2, Name conventionName) {
        void $this$createConventionCall_u24lambda_u248_u24lambda_u247;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$createConventionCall_u24lambda_u248 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        $this$createConventionCall_u24lambda_u248.setSource(baseSource);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$createConventionCall_u24lambda_u248;
        boolean bl2 = false;
        $this$createConventionCall_u24lambda_u248_u24lambda_u247.setSource(operationReferenceSource);
        $this$createConventionCall_u24lambda_u248_u24lambda_u247.setName(conventionName);
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$createConventionCall_u24lambda_u248.setExplicitReceiver($this$createConventionCall);
        $this$createConventionCall_u24lambda_u248.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(argument2));
        $this$createConventionCall_u24lambda_u248.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateAccessExpression(@Nullable KtSourceElement qualifiedSource, @Nullable KtSourceElement calleeReferenceSource, @NotNull Name name2, @Nullable ConeDiagnostic diagnostic) {
        void $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249;
        KtSourceElement ktSourceElement;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateAccessExpression_u24lambda_u2410 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateAccessExpression_u24lambda_u2410.setSource(qualifiedSource);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessExpression_u24lambda_u2410;
        boolean bl2 = false;
        if (Intrinsics.areEqual((Object)calleeReferenceSource, (Object)qualifiedSource)) {
            KtSourceElement ktSourceElement2 = calleeReferenceSource;
            ktSourceElement = ktSourceElement2 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement2, KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE, 0, 0, 6, null) : null;
        } else {
            ktSourceElement = calleeReferenceSource;
        }
        $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249.setSource(ktSourceElement);
        $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249.setName(name2);
        firPropertyAccessExpressionBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        if (diagnostic != null) {
            $this$generateAccessExpression_u24lambda_u2410.getNonFatalDiagnostics().add(diagnostic);
        }
        return firPropertyAccessExpressionBuilder.build();
    }

    public static /* synthetic */ FirQualifiedAccessExpression generateAccessExpression$default(KtSourceElement ktSourceElement, KtSourceElement ktSourceElement2, Name name2, ConeDiagnostic coneDiagnostic, int n, Object object) {
        if ((n & 8) != 0) {
            coneDiagnostic = null;
        }
        return ConversionUtilsKt.generateAccessExpression(ktSourceElement, ktSourceElement2, name2, coneDiagnostic);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateResolvedAccessExpression(@Nullable KtSourceElement source, @NotNull FirVariable variable2) {
        void $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateResolvedAccessExpression_u24lambda_u2412 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateResolvedAccessExpression_u24lambda_u2412.setSource(source);
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateResolvedAccessExpression_u24lambda_u2412;
        boolean bl2 = false;
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setSource(source);
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setName(variable2.getName());
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setResolvedSymbol((FirBasedSymbol)variable2.getSymbol());
        firPropertyAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firPropertyAccessExpressionBuilder.build();
    }

    @NotNull
    public static final FirComponentCall toComponentCall(@NotNull FirVariable $this$toComponentCall, @Nullable KtSourceElement entrySource, int index2) {
        FirComponentCallBuilder firComponentCallBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toComponentCall, (String)"<this>");
        boolean $i$f$buildComponentCall = false;
        FirComponentCallBuilder $this$toComponentCall_u24lambda_u2413 = firComponentCallBuilder = new FirComponentCallBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = entrySource;
        KtSourceElement componentCallSource = ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.DesugaredComponentFunctionCall.INSTANCE, 0, 0, 6, null) : null;
        $this$toComponentCall_u24lambda_u2413.setSource(componentCallSource);
        $this$toComponentCall_u24lambda_u2413.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(componentCallSource, $this$toComponentCall));
        $this$toComponentCall_u24lambda_u2413.setComponentIndex(index2 + 1);
        return firComponentCallBuilder.build();
    }

    @Nullable
    public static final FirClassSymbol<? extends FirClass> getOwnerRegularOrAnonymousObjectSymbol(@NotNull FirClassBuilder $this$ownerRegularOrAnonymousObjectSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$ownerRegularOrAnonymousObjectSymbol, (String)"<this>");
        FirClassBuilder firClassBuilder = $this$ownerRegularOrAnonymousObjectSymbol;
        return firClassBuilder instanceof FirAnonymousObjectBuilder ? (FirClassSymbol)((FirAnonymousObjectBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol() : (firClassBuilder instanceof FirRegularClassBuilder ? (FirClassSymbol)((FirRegularClassBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol() : null);
    }

    @Nullable
    public static final Integer getOwnerRegularClassTypeParametersCount(@NotNull FirClassBuilder $this$ownerRegularClassTypeParametersCount) {
        Intrinsics.checkNotNullParameter((Object)$this$ownerRegularClassTypeParametersCount, (String)"<this>");
        return $this$ownerRegularClassTypeParametersCount instanceof FirRegularClassBuilder ? Integer.valueOf($this$ownerRegularClassTypeParametersCount.getTypeParameters().size()) : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> void generateAccessorsByDelegate(@NotNull FirPropertyBuilder $this$generateAccessorsByDelegate, @Nullable FirWrappedDelegateExpressionBuilder delegateBuilder, @NotNull FirModuleData moduleData, @Nullable FirClassSymbol<?> ownerRegularOrAnonymousObjectSymbol, @NotNull Context<T> context2, boolean isExtension, @Nullable FirLazyExpression lazyDelegateExpression2) {
        Object object;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Object $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429;
        FirFunctionTarget returnTarget;
        List<FirAnnotation> annotations2;
        FirDeclarationStatusImpl $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426;
        void var22_35;
        Object object2;
        Object $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        FirPropertyBuilder firPropertyBuilder;
        FirExpression firExpression2;
        FirDelegateFieldSymbol firDelegateFieldSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$generateAccessorsByDelegate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        if (delegateBuilder == null) {
            return;
        }
        FirDelegateFieldSymbol it = firDelegateFieldSymbol = new FirDelegateFieldSymbol($this$generateAccessorsByDelegate.getSymbol().getCallableId());
        boolean bl = false;
        $this$generateAccessorsByDelegate.setDelegateFieldSymbol(it);
        FirDelegateFieldSymbol delegateFieldSymbol = firDelegateFieldSymbol;
        boolean isMember = ownerRegularOrAnonymousObjectSymbol != null;
        KtSourceElement ktSourceElement = delegateBuilder.getSource();
        KtSourceElement fakeSource = ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null) : null;
        boolean isVar = $this$generateAccessorsByDelegate.isVar();
        FirPropertyBuilder firPropertyBuilder2 = $this$generateAccessorsByDelegate;
        FirLazyExpression firLazyExpression = lazyDelegateExpression2;
        if (firLazyExpression != null) {
            firExpression2 = firLazyExpression;
        } else {
            FirFunctionCallBuilder firFunctionCallBuilder2;
            FirPropertyBuilder firPropertyBuilder3 = $this$generateAccessorsByDelegate;
            firPropertyBuilder = firPropertyBuilder2;
            boolean bl2 = false;
            boolean $i$f$buildFunctionCall = false;
            FirFunctionCallBuilder firFunctionCallBuilder3 = firFunctionCallBuilder2 = new FirFunctionCallBuilder();
            firAnnotationContainerBuilder = delegateBuilder;
            boolean bl3 = false;
            ((FirFunctionCallBuilder)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427).setExplicitReceiver(delegateBuilder.getExpression());
            boolean $i$f$buildSimpleNamedReference = false;
            object2 = new FirSimpleNamedReferenceBuilder();
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = object2;
            var22_35 = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427;
            boolean bl4 = false;
            ((FirSimpleNamedReferenceBuilder)((Object)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426)).setSource(fakeSource);
            ((FirSimpleNamedReferenceBuilder)((Object)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426)).setName(OperatorNameConventions.PROVIDE_DELEGATE);
            var22_35.setCalleeReference(((FirSimpleNamedReferenceBuilder)object2).build());
            ((FirFunctionCallBuilder)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427).setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, context2, true), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
            ((FirFunctionCallBuilder)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427).setOrigin(FirFunctionCallOrigin.Operator);
            ((FirFunctionCallBuilder)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427).setSource(fakeSource);
            ((FirWrappedDelegateExpressionBuilder)firAnnotationContainerBuilder).setDelegateProvider(firFunctionCallBuilder2.build());
            firPropertyBuilder2 = firPropertyBuilder;
            firExpression2 = delegateBuilder.build();
        }
        firPropertyBuilder2.setDelegate(firExpression2);
        if ($this$generateAccessorsByDelegate.getGetter() == null || $this$generateAccessorsByDelegate.getGetter() instanceof FirDefaultPropertyAccessor) {
            void it2;
            void $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
            void $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431;
            void $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432;
            FirFunctionCallBuilder firFunctionCallBuilder4;
            void $this$generateAccessorsByDelegate_u24lambda_u2433;
            FirPropertyAccessor firPropertyAccessor = $this$generateAccessorsByDelegate.getGetter();
            annotations2 = firPropertyAccessor != null ? firPropertyAccessor.getAnnotations() : null;
            returnTarget = new FirFunctionTarget(null, false);
            FirPropertyAccessor firPropertyAccessor2 = $this$generateAccessorsByDelegate.getGetter();
            FirDeclarationStatus getterStatus = firPropertyAccessor2 != null ? firPropertyAccessor2.getStatus() : null;
            Object object3 = $this$generateAccessorsByDelegate.getGetter();
            if (object3 == null || (object3 = ((FirPropertyAccessor)object3).getSource()) == null || (object3 = KtSourceElementKt.fakeElement$default((KtSourceElement)object3, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null)) == null) {
                object3 = fakeSource;
            }
            Object getterElement = object3;
            boolean $i$f$buildPropertyAccessor22 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427 = new FirPropertyAccessorBuilder();
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427;
            firPropertyBuilder = $this$generateAccessorsByDelegate;
            boolean bl5 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2433.setSource((KtSourceElement)getterElement);
            $this$generateAccessorsByDelegate_u24lambda_u2433.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2433.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2433.setReturnTypeRef(FirImplicitTypeRefImplWithoutSource.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2433.setGetter(true);
            Object object4 = getterStatus;
            if (object4 == null || (object4 = object4.getVisibility()) == null) {
                object4 = Visibilities.Unknown.INSTANCE;
            }
            FirDeclarationStatusImpl $i$f$buildSimpleNamedReference = new FirDeclarationStatusImpl((Visibility)object4, Modality.FINAL);
            object2 = $i$f$buildSimpleNamedReference;
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426 = $this$generateAccessorsByDelegate_u24lambda_u2433;
            boolean $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$2$22 = false;
            FirDeclarationStatus firDeclarationStatus = getterStatus;
            ((FirDeclarationStatusImpl)$this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429).setInline(firDeclarationStatus != null ? firDeclarationStatus.isInline() : ((FirDeclarationStatusImpl)$this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429).isInline());
            ((FirPropertyAccessorBuilder)((Object)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426)).setStatus($i$f$buildSimpleNamedReference);
            $this$generateAccessorsByDelegate_u24lambda_u2433.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildReturnExpression = false;
            Object $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$2$22 = $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429 = new FirReturnExpressionBuilder();
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426 = $this$generateAccessorsByDelegate_u24lambda_u2433;
            boolean bl6 = false;
            boolean $i$f$buildFunctionCall = false;
            FirFunctionCallBuilder firFunctionCallBuilder5 = firFunctionCallBuilder4 = new FirFunctionCallBuilder();
            firFunctionCallBuilder = $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432;
            boolean bl7 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, context2));
            boolean $i$f$buildSimpleNamedReference2 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            object = $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431;
            boolean bl8 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430.setName(OperatorNameConventions.GET_VALUE);
            ((FirFunctionCallBuilder)object).setCalleeReference(firSimpleNamedReferenceBuilder.build());
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, context2, false, 32, null), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setOrigin(FirFunctionCallOrigin.Operator);
            ((FirReturnExpressionBuilder)((Object)firFunctionCallBuilder)).setResult(firFunctionCallBuilder4.build());
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432.setTarget(returnTarget);
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432.setSource(fakeSource);
            FirStatement firStatement = ((FirReturnExpressionBuilder)$this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429).build();
            ((FirPropertyAccessorBuilder)((Object)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426)).setBody(new FirSingleExpressionBlock(firStatement));
            if (annotations2 != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2433.getAnnotations().addAll((Collection<FirAnnotation>)annotations2);
            }
            $this$generateAccessorsByDelegate_u24lambda_u2433.setPropertySymbol($this$generateAccessorsByDelegate.getSymbol());
            FirPropertyAccessor $i$f$buildPropertyAccessor22 = ((FirPropertyAccessorBuilder)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427).build();
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427 = $i$f$buildPropertyAccessor22;
            boolean bl9 = false;
            returnTarget.bind((FirTargetElement)it2);
            ConversionUtilsKt.initContainingClassAttr((FirCallableDeclaration)it2, context2);
            firPropertyBuilder.setGetter($i$f$buildPropertyAccessor22);
        }
        if (isVar && ($this$generateAccessorsByDelegate.getSetter() == null || $this$generateAccessorsByDelegate.getSetter() instanceof FirDefaultPropertyAccessor)) {
            void it3;
            void $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439_u24lambda_u2438;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
            FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
            void $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440;
            Object $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2437;
            void $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441;
            void $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442;
            void $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2435;
            void $this$generateAccessorsByDelegate_u24lambda_u2443;
            FirPropertyAccessor firPropertyAccessor = $this$generateAccessorsByDelegate.getSetter();
            annotations2 = firPropertyAccessor != null ? firPropertyAccessor.getAnnotations() : null;
            returnTarget = new FirFunctionTarget(null, false);
            Object object5 = $this$generateAccessorsByDelegate.getSetter();
            List<FirAnnotation> parameterAnnotations = object5 != null && (object5 = ((FirPropertyAccessor)object5).getValueParameters()) != null && (object5 = (FirValueParameter)CollectionsKt.firstOrNull((List)object5)) != null ? ((FirValueParameter)object5).getAnnotations() : null;
            FirPropertyAccessor firPropertyAccessor3 = $this$generateAccessorsByDelegate.getSetter();
            FirDeclarationStatus setterStatus = firPropertyAccessor3 != null ? firPropertyAccessor3.getStatus() : null;
            Object object6 = $this$generateAccessorsByDelegate.getSetter();
            if (object6 == null || (object6 = ((FirPropertyAccessor)object6).getSource()) == null || (object6 = KtSourceElementKt.fakeElement$default((KtSourceElement)object6, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null)) == null) {
                object6 = fakeSource;
            }
            Object setterElement = object6;
            boolean $i$f$buildPropertyAccessor = false;
            Object bl9 = new FirPropertyAccessorBuilder();
            FirPropertyAccessorBuilder bl5 = bl9;
            firPropertyBuilder = $this$generateAccessorsByDelegate;
            boolean bl10 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2443.setSource((KtSourceElement)setterElement);
            $this$generateAccessorsByDelegate_u24lambda_u2443.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2443.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2443.setReturnTypeRef(moduleData.getSession().getBuiltinTypes().getUnitType());
            $this$generateAccessorsByDelegate_u24lambda_u2443.setGetter(false);
            Object object7 = setterStatus;
            if (object7 == null || (object7 = object7.getVisibility()) == null) {
                object7 = Visibilities.Unknown.INSTANCE;
            }
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429 = new FirDeclarationStatusImpl((Visibility)object7, Modality.FINAL);
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426 = $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429;
            var22_35 = $this$generateAccessorsByDelegate_u24lambda_u2443;
            boolean bl11 = false;
            FirDeclarationStatus firDeclarationStatus = setterStatus;
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2435.setInline(firDeclarationStatus != null ? firDeclarationStatus.isInline() : $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2435.isInline());
            var22_35.setStatus((FirDeclarationStatus)$this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429);
            $this$generateAccessorsByDelegate_u24lambda_u2443.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildValueParameter = false;
            FirAnnotationContainerBuilder firAnnotationContainerBuilder2 = new FirValueParameterBuilder();
            FirValueParameterBuilder $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436 = firAnnotationContainerBuilder2;
            boolean bl12 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436.setContainingFunctionSymbol($this$generateAccessorsByDelegate_u24lambda_u2443.getSymbol());
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436.setReturnTypeRef(FirImplicitTypeRefImplWithoutSource.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436.setName(SpecialNames.IMPLICIT_SET_PARAMETER);
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436.setSymbol(new FirValueParameterSymbol($this$generateAccessorsByDelegate.getName()));
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436.setCrossinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436.setNoinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436.setVararg(false);
            if (parameterAnnotations != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436.getAnnotations().addAll((Collection<FirAnnotation>)parameterAnnotations);
            }
            FirValueParameter parameter2 = ((FirValueParameterBuilder)firAnnotationContainerBuilder2).build();
            ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2443.getValueParameters()).add(parameter2);
            boolean $i$f$buildReturnExpression = false;
            firAnnotationContainerBuilder2 = new FirReturnExpressionBuilder();
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2436 = firAnnotationContainerBuilder2;
            var22_35 = $this$generateAccessorsByDelegate_u24lambda_u2443;
            boolean bl13 = false;
            boolean $i$f$buildFunctionCall = false;
            FirFunctionCallBuilder bl7 = firFunctionCallBuilder = new FirFunctionCallBuilder();
            void var31_49 = $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442;
            boolean bl14 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, context2));
            boolean $i$f$buildSimpleNamedReference = false;
            object = new FirSimpleNamedReferenceBuilder();
            FirSimpleNamedReferenceBuilder bl8 = object;
            void var36_59 = $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441;
            boolean bl15 = false;
            ((FirSimpleNamedReferenceBuilder)$this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2437).setSource(fakeSource);
            ((FirSimpleNamedReferenceBuilder)$this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2437).setName(OperatorNameConventions.SET_VALUE);
            var36_59.setCalleeReference(((FirSimpleNamedReferenceBuilder)object).build());
            boolean $i$f$buildArgumentList = false;
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2437 = object = new FirArgumentListBuilder();
            var36_59 = $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441;
            boolean bl16 = false;
            ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440.getArguments()).add(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, context2, false, 32, null));
            ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440.getArguments()).add(ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate));
            Collection collection = $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440.getArguments();
            boolean $i$f$buildPropertyAccessExpression = false;
            FirPropertyAccessExpressionBuilder $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
            boolean bl17 = false;
            boolean $i$f$buildResolvedNamedReference = false;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
            FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439;
            boolean bl18 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439_u24lambda_u2438.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439_u24lambda_u2438.setName(SpecialNames.IMPLICIT_SET_PARAMETER);
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439_u24lambda_u2438.setResolvedSymbol(parameter2.getSymbol());
            firPropertyAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
            FirPropertyAccessExpression firPropertyAccessExpression = firPropertyAccessExpressionBuilder.build();
            collection.add(firPropertyAccessExpression);
            var36_59.setArgumentList(((FirArgumentListBuilder)object).build());
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441.setOrigin(FirFunctionCallOrigin.Operator);
            var31_49.setResult(firFunctionCallBuilder.build());
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442.setTarget(returnTarget);
            $this$generateAccessorsByDelegate_u24lambda_u2443_u24lambda_u2442.setSource(fakeSource);
            FirStatement firStatement = ((FirReturnExpressionBuilder)firAnnotationContainerBuilder2).build();
            var22_35.setBody(new FirSingleExpressionBlock(firStatement));
            if (annotations2 != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2443.getAnnotations().addAll((Collection<FirAnnotation>)annotations2);
            }
            $this$generateAccessorsByDelegate_u24lambda_u2443.setPropertySymbol($this$generateAccessorsByDelegate.getSymbol());
            FirPropertyAccessor firPropertyAccessor4 = ((FirPropertyAccessorBuilder)bl9).build();
            bl9 = firPropertyAccessor4;
            boolean bl19 = false;
            returnTarget.bind((FirTargetElement)it3);
            ConversionUtilsKt.initContainingClassAttr((FirCallableDeclaration)it3, context2);
            firPropertyBuilder.setSetter(firPropertyAccessor4);
        }
    }

    public static /* synthetic */ void generateAccessorsByDelegate$default(FirPropertyBuilder firPropertyBuilder, FirWrappedDelegateExpressionBuilder firWrappedDelegateExpressionBuilder, FirModuleData firModuleData, FirClassSymbol firClassSymbol, Context context2, boolean bl, FirLazyExpression firLazyExpression, int n, Object object) {
        if ((n & 0x20) != 0) {
            firLazyExpression = null;
        }
        ConversionUtilsKt.generateAccessorsByDelegate(firPropertyBuilder, firWrappedDelegateExpressionBuilder, firModuleData, firClassSymbol, context2, bl, firLazyExpression);
    }

    @Nullable
    public static final FirContractDescription processLegacyContractDescription(@NotNull FirBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (ConversionUtilsKt.isContractPresentFirCheck(block)) {
            FirFunctionCall contractCall2 = (FirFunctionCall)FirExpressionUtilKt.replaceFirstStatement(block, processLegacyContractDescription.contractCall.1.INSTANCE);
            return ConversionUtilsKt.toLegacyRawContractDescription(contractCall2);
        }
        return null;
    }

    @NotNull
    public static final FirLegacyRawContractDescription toLegacyRawContractDescription(@NotNull FirFunctionCall $this$toLegacyRawContractDescription) {
        FirLegacyRawContractDescriptionBuilder firLegacyRawContractDescriptionBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toLegacyRawContractDescription, (String)"<this>");
        boolean $i$f$buildLegacyRawContractDescription = false;
        FirLegacyRawContractDescriptionBuilder $this$toLegacyRawContractDescription_u24lambda_u2445 = firLegacyRawContractDescriptionBuilder = new FirLegacyRawContractDescriptionBuilder();
        boolean bl = false;
        $this$toLegacyRawContractDescription_u24lambda_u2445.setSource($this$toLegacyRawContractDescription.getSource());
        $this$toLegacyRawContractDescription_u24lambda_u2445.setContractCall($this$toLegacyRawContractDescription);
        return firLegacyRawContractDescriptionBuilder.build();
    }

    public static final boolean isContractPresentFirCheck(@NotNull FirBlock $this$isContractPresentFirCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$isContractPresentFirCheck, (String)"<this>");
        FirStatement firStatement = (FirStatement)CollectionsKt.firstOrNull($this$isContractPresentFirCheck.getStatements());
        if (firStatement == null) {
            return false;
        }
        FirStatement firstStatement = firStatement;
        return ConversionUtilsKt.isContractBlockFirCheck(firstStatement);
    }

    public static final boolean isContractBlockFirCheck(@NotNull FirStatement $this$isContractBlockFirCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$isContractBlockFirCheck, (String)"<this>");
        FirFunctionCall firFunctionCall = $this$isContractBlockFirCheck instanceof FirFunctionCall ? (FirFunctionCall)$this$isContractBlockFirCheck : null;
        if (firFunctionCall == null) {
            return false;
        }
        FirFunctionCall contractCall2 = firFunctionCall;
        if (!Intrinsics.areEqual((Object)contractCall2.getCalleeReference().getName().asString(), (Object)"contract")) {
            return false;
        }
        FirExpression firExpression2 = contractCall2.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression == null) {
            return true;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        if (!ConversionUtilsKt.checkReceiver(contractCall2, "contracts")) {
            return false;
        }
        if (!ConversionUtilsKt.checkReceiver(receiver, "kotlin")) {
            return false;
        }
        FirExpression firExpression3 = receiver.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = firExpression3 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression3 : null;
        if (firQualifiedAccessExpression2 == null) {
            return false;
        }
        FirQualifiedAccessExpression receiverOfReceiver = firQualifiedAccessExpression2;
        return receiverOfReceiver.getExplicitReceiver() == null;
    }

    private static final boolean checkReceiver(FirExpression $this$checkReceiver, String name2) {
        if (!($this$checkReceiver instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        FirExpression firExpression2 = ((FirQualifiedAccessExpression)$this$checkReceiver).getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        FirReference firReference = receiver.getCalleeReference();
        Object object = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
        if (object == null || (object = ((FirNamedReference)object).getName()) == null || (object = ((Name)object).asString()) == null) {
            return false;
        }
        Object receiverName = object;
        return Intrinsics.areEqual((Object)receiverName, (Object)name2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirSafeCallExpression createSafeCall(@NotNull FirQualifiedAccessExpression $this$createSafeCall, @NotNull FirExpression receiver, @NotNull KtSourceElement source) {
        void $this$createSafeCall_u24lambda_u2450_u24lambda_u2449;
        FirExpressionRef<FirExpression> $this$createSafeCall_u24lambda_u2448_u24lambda_u2447;
        FirExpressionRef<FirExpression> firExpressionRef;
        Intrinsics.checkNotNullParameter((Object)$this$createSafeCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean $i$f$buildCheckedSafeCallSubject = false;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder = new FirCheckedSafeCallSubjectBuilder();
        FirCheckedSafeCallSubjectBuilder $this$createSafeCall_u24lambda_u2448 = firAnnotationContainerBuilder;
        boolean bl = false;
        FirExpressionRef<FirExpression> firExpressionRef2 = firExpressionRef = new FirExpressionRef<FirExpression>();
        FirAnnotationContainerBuilder firAnnotationContainerBuilder2 = $this$createSafeCall_u24lambda_u2448;
        boolean bl2 = false;
        $this$createSafeCall_u24lambda_u2448_u24lambda_u2447.bind(receiver);
        ((FirCheckedSafeCallSubjectBuilder)firAnnotationContainerBuilder2).setOriginalReceiverRef(firExpressionRef);
        KtSourceElement ktSourceElement = receiver.getSource();
        $this$createSafeCall_u24lambda_u2448.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.CheckedSafeCallSubject.INSTANCE, 0, 0, 6, null) : null);
        FirCheckedSafeCallSubject checkedSafeCallSubject = ((FirCheckedSafeCallSubjectBuilder)firAnnotationContainerBuilder).build();
        $this$createSafeCall.replaceExplicitReceiver(checkedSafeCallSubject);
        boolean $i$f$buildSafeCallExpression = false;
        FirAnnotationContainerBuilder $this$createSafeCall_u24lambda_u2450 = firAnnotationContainerBuilder = new FirSafeCallExpressionBuilder();
        boolean bl3 = false;
        ((FirSafeCallExpressionBuilder)$this$createSafeCall_u24lambda_u2450).setReceiver(receiver);
        $this$createSafeCall_u24lambda_u2448_u24lambda_u2447 = firExpressionRef = new FirExpressionRef();
        firAnnotationContainerBuilder2 = $this$createSafeCall_u24lambda_u2450;
        boolean bl4 = false;
        $this$createSafeCall_u24lambda_u2450_u24lambda_u2449.bind((FirExpression)checkedSafeCallSubject);
        ((FirSafeCallExpressionBuilder)firAnnotationContainerBuilder2).setCheckedSubjectRef(firExpressionRef);
        ((FirSafeCallExpressionBuilder)$this$createSafeCall_u24lambda_u2450).setSelector($this$createSafeCall);
        ((FirSafeCallExpressionBuilder)$this$createSafeCall_u24lambda_u2450).setSource(source);
        return ((FirSafeCallExpressionBuilder)firAnnotationContainerBuilder).build();
    }

    @NotNull
    public static final FirExpression pullUpSafeCallIfNecessary(@NotNull FirExpression $this$pullUpSafeCallIfNecessary) {
        Intrinsics.checkNotNullParameter((Object)$this$pullUpSafeCallIfNecessary, (String)"<this>");
        if (!($this$pullUpSafeCallIfNecessary instanceof FirQualifiedAccessExpression)) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirExpression firExpression2 = ((FirQualifiedAccessExpression)$this$pullUpSafeCallIfNecessary).getExplicitReceiver();
        FirSafeCallExpression firSafeCallExpression = firExpression2 instanceof FirSafeCallExpression ? (FirSafeCallExpression)firExpression2 : null;
        if (firSafeCallExpression == null) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirSafeCallExpression safeCall = firSafeCallExpression;
        FirStatement firStatement = safeCall.getSelector();
        FirExpression firExpression3 = firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
        if (firExpression3 == null) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirExpression safeCallSelector = firExpression3;
        ((FirQualifiedAccessExpression)$this$pullUpSafeCallIfNecessary).replaceExplicitReceiver(safeCallSelector);
        safeCall.replaceSelector($this$pullUpSafeCallIfNecessary);
        return safeCall;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnnotationCall> filterUseSiteTarget(@NotNull List<? extends FirAnnotationCall> $this$filterUseSiteTarget, @NotNull AnnotationUseSiteTarget target) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterUseSiteTarget, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        Iterable $this$mapNotNull$iv = $this$filterUseSiteTarget;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirAnnotationCall firAnnotationCall;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
            boolean bl2 = false;
            if (it.getUseSiteTarget() != target) {
                firAnnotationCall = null;
            } else {
                FirAnnotationCallBuilder firAnnotationCallBuilder;
                boolean $i$f$buildAnnotationCallCopy = false;
                FirAnnotationCallBuilder copyBuilder$iv = new FirAnnotationCallBuilder();
                copyBuilder$iv.setSource(it.getSource());
                copyBuilder$iv.setUseSiteTarget(it.getUseSiteTarget());
                copyBuilder$iv.setAnnotationTypeRef(it.getAnnotationTypeRef());
                copyBuilder$iv.getTypeArguments().addAll((Collection<FirTypeProjection>)it.getTypeArguments());
                copyBuilder$iv.setArgumentList(it.getArgumentList());
                copyBuilder$iv.setCalleeReference(it.getCalleeReference());
                copyBuilder$iv.setArgumentMapping(it.getArgumentMapping());
                copyBuilder$iv.setAnnotationResolvePhase(it.getAnnotationResolvePhase());
                FirAnnotationCallBuilder $this$filterUseSiteTarget_u24lambda_u2452_u24lambda_u2451 = firAnnotationCallBuilder = copyBuilder$iv;
                boolean bl3 = false;
                KtSourceElement ktSourceElement = it.getSource();
                $this$filterUseSiteTarget_u24lambda_u2452_u24lambda_u2451.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.FromUseSiteTarget.INSTANCE, 0, 0, 6, null) : null);
                firAnnotationCall = firAnnotationCallBuilder.build();
            }
            if (firAnnotationCall == null) continue;
            FirAnnotationCall it$iv$iv = firAnnotationCall;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirReceiverParameter convertToReceiverParameter(@NotNull FirTypeRef $this$convertToReceiverParameter) {
        void $this$filterNotTo$iv$iv;
        FirReceiverParameterBuilder firReceiverParameterBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$convertToReceiverParameter, (String)"<this>");
        FirTypeRef typeRef = $this$convertToReceiverParameter;
        boolean $i$f$buildReceiverParameter = false;
        FirReceiverParameterBuilder $this$convertToReceiverParameter_u24lambda_u2454 = firReceiverParameterBuilder = new FirReceiverParameterBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = typeRef.getSource();
        $this$convertToReceiverParameter_u24lambda_u2454.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.ReceiverFromType.INSTANCE, 0, 0, 6, null) : null);
        Collection collection = $this$convertToReceiverParameter_u24lambda_u2454.getAnnotations();
        List<FirAnnotation> list2 = typeRef.getAnnotations();
        Intrinsics.checkNotNull(list2, (String)"null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.kotlin.fir.expressions.FirAnnotationCall>");
        CollectionsKt.addAll((Collection)collection, (Iterable)ConversionUtilsKt.filterUseSiteTarget(list2, AnnotationUseSiteTarget.RECEIVER));
        Iterable $this$filterNot$iv = typeRef.getAnnotations();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FirAnnotation it = (FirAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (it.getUseSiteTarget() == AnnotationUseSiteTarget.RECEIVER) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredTypeRefAnnotations = (List)destination$iv$iv;
        if (filteredTypeRefAnnotations.size() != typeRef.getAnnotations().size()) {
            typeRef.replaceAnnotations(filteredTypeRefAnnotations);
        }
        $this$convertToReceiverParameter_u24lambda_u2454.setTypeRef(typeRef);
        return firReceiverParameterBuilder.build();
    }

    @NotNull
    public static final FirReceiverParameter asReceiverParameter(@NotNull KtSourceElement $this$asReceiverParameter) {
        FirReceiverParameterBuilder firReceiverParameterBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$asReceiverParameter, (String)"<this>");
        boolean $i$f$buildReceiverParameter = false;
        FirReceiverParameterBuilder $this$asReceiverParameter_u24lambda_u2455 = firReceiverParameterBuilder = new FirReceiverParameterBuilder();
        boolean bl = false;
        $this$asReceiverParameter_u24lambda_u2455.setSource(KtSourceElementKt.fakeElement$default($this$asReceiverParameter, KtFakeSourceElementKind.ReceiverFromType.INSTANCE, 0, 0, 6, null));
        $this$asReceiverParameter_u24lambda_u2455.setTypeRef(FirImplicitTypeRefImplWithoutSource.INSTANCE);
        return firReceiverParameterBuilder.build();
    }

    public static final <T> void initContainingClassAttr(@NotNull FirCallableDeclaration $this$initContainingClassAttr, @NotNull Context<T> context2) {
        Intrinsics.checkNotNullParameter((Object)$this$initContainingClassAttr, (String)"<this>");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Object object = ConversionUtilsKt.currentDispatchReceiverType(context2);
        if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            return;
        }
        ClassMembersKt.setContainingClassForStaticMemberAttr($this$initContainingClassAttr, (ConeClassLikeLookupTag)object);
    }

    @Nullable
    public static final <T> ConeClassLikeType currentDispatchReceiverType(@NotNull Context<T> context2) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        return (ConeClassLikeType)CollectionsKt.lastOrNull(context2.getDispatchReceiverTypesStack());
    }

    public static final boolean isUnderscore(@NotNull CharSequence $this$isUnderscore) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$isUnderscore, (String)"<this>");
            CharSequence $this$all$iv = $this$isUnderscore;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (it == '_') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public static final FirExpression buildBalancedOrExpressionTree(@NotNull List<? extends FirExpression> conditions2, int lower2, int upper) {
        Intrinsics.checkNotNullParameter(conditions2, (String)"conditions");
        int size = upper - lower2 + 1;
        int middle = size / 2 + lower2;
        if (lower2 == upper) {
            return conditions2.get(middle);
        }
        FirExpression leftNode = ConversionUtilsKt.buildBalancedOrExpressionTree(conditions2, lower2, middle - 1);
        FirExpression rightNode = ConversionUtilsKt.buildBalancedOrExpressionTree(conditions2, middle, upper);
        KtSourceElement ktSourceElement = leftNode.getSource();
        if (ktSourceElement == null) {
            ktSourceElement = rightNode.getSource();
        }
        return ConversionUtilsKt.generateLazyLogicalOperation(leftNode, rightNode, false, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.WhenCondition.INSTANCE, 0, 0, 6, null) : null);
    }

    public static /* synthetic */ FirExpression buildBalancedOrExpressionTree$default(List list2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = CollectionsKt.getLastIndex((List)list2);
        }
        return ConversionUtilsKt.buildBalancedOrExpressionTree(list2, n, n2);
    }

    public static final boolean appliesToPrimaryConstructorParameter(@Nullable AnnotationUseSiteTarget $this$appliesToPrimaryConstructorParameter) {
        return $this$appliesToPrimaryConstructorParameter == null || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.RECEIVER || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.FILE;
    }

    @NotNull
    public static final KtSourceElement withForcedKindFrom(@NotNull KtSourceElement $this$withForcedKindFrom, @NotNull Context<?> context2) {
        Intrinsics.checkNotNullParameter((Object)$this$withForcedKindFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        KtSourceElementKind forcedKind = context2.getForcedElementSourceKind();
        return Intrinsics.areEqual((Object)forcedKind, (Object)$this$withForcedKindFrom.getKind()) ? $this$withForcedKindFrom : (forcedKind instanceof KtFakeSourceElementKind ? KtSourceElementKt.fakeElement$default($this$withForcedKindFrom, (KtFakeSourceElementKind)forcedKind, 0, 0, 6, null) : KtSourceElementKt.realElement($this$withForcedKindFrom));
    }

    @NotNull
    public static final FirResolvedTypeRef wrapIntoArray(@NotNull FirErrorTypeRef $this$wrapIntoArray) {
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$wrapIntoArray, (String)"<this>");
        FirErrorTypeRef typeRef = $this$wrapIntoArray;
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder $this$wrapIntoArray_u24lambda_u2457 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        boolean bl = false;
        $this$wrapIntoArray_u24lambda_u2457.setSource(typeRef.getSource());
        ConeKotlinTypeProjectionOut[] coneKotlinTypeProjectionOutArray = new ConeKotlinTypeProjectionOut[]{new ConeKotlinTypeProjectionOut(FirTypeUtilsKt.getConeType(typeRef))};
        $this$wrapIntoArray_u24lambda_u2457.setType(TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getArray(), coneKotlinTypeProjectionOutArray, false, null, 6, null));
        $this$wrapIntoArray_u24lambda_u2457.setDelegatedTypeRef(UtilsKt.copyWithNewSourceKind((FirTypeRef)typeRef, KtFakeSourceElementKind.ArrayTypeFromVarargParameter.INSTANCE));
        return firResolvedTypeRefBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> FirExpression generateAccessorsByDelegate$thisRef(boolean $isExtension, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, KtSourceElement fakeSource, FirPropertyBuilder $this_generateAccessorsByDelegate, Context<T> $context, boolean forDispatchReceiver) {
        FirExpression firExpression2;
        if ($isExtension && !forDispatchReceiver) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416_u24lambda_u2415;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder2 = firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416;
            boolean bl2 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416_u24lambda_u2415.setBoundSymbol($this_generateAccessorsByDelegate.getSymbol());
            firThisReceiverExpressionBuilder2.setCalleeReference(firImplicitThisReferenceBuilder.build());
            firExpression2 = firThisReceiverExpressionBuilder.build();
        } else if ($ownerRegularOrAnonymousObjectSymbol != null) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2417;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            FirImplicitThisReferenceBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416_u24lambda_u2415 = firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder3 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418;
            boolean bl3 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2417.setBoundSymbol((FirBasedSymbol)$ownerRegularOrAnonymousObjectSymbol);
            firThisReceiverExpressionBuilder3.setCalleeReference(firImplicitThisReferenceBuilder.build());
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418.setConeTypeOrNull((ConeKotlinType)CollectionsKt.last($context.getDispatchReceiverTypesStack()));
            firExpression2 = firThisReceiverExpressionBuilder.build();
        } else {
            firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Null.INSTANCE, null, null, false, 8, null);
        }
        return firExpression2;
    }

    static /* synthetic */ FirExpression generateAccessorsByDelegate$thisRef$default(boolean bl, FirClassSymbol firClassSymbol, KtSourceElement ktSourceElement, FirPropertyBuilder firPropertyBuilder, Context context2, boolean bl2, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        return ConversionUtilsKt.generateAccessorsByDelegate$thisRef(bl, firClassSymbol, ktSourceElement, firPropertyBuilder, context2, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> FirPropertyAccessExpression generateAccessorsByDelegate$delegateAccess(KtSourceElement fakeSource, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, FirDelegateFieldSymbol delegateFieldSymbol, boolean $isExtension, FirPropertyBuilder $this_generateAccessorsByDelegate, Context<T> $context) {
        void $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420_u24lambda_u2419;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420.setSource(fakeSource);
        boolean $i$f$buildDelegateFieldReference = false;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder2 = firDelegateFieldReferenceBuilder = new FirDelegateFieldReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420;
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420_u24lambda_u2419.setResolvedSymbol(delegateFieldSymbol);
        firPropertyAccessExpressionBuilder2.setCalleeReference(firDelegateFieldReferenceBuilder.build());
        if ($ownerRegularOrAnonymousObjectSymbol != null) {
            $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420.setDispatchReceiver(ConversionUtilsKt.generateAccessorsByDelegate$thisRef($isExtension, $ownerRegularOrAnonymousObjectSymbol, fakeSource, $this_generateAccessorsByDelegate, $context, true));
        }
        return firPropertyAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirCallableReferenceAccess generateAccessorsByDelegate$propertyRef(KtSourceElement fakeSource, boolean isMember, boolean $isExtension, boolean isVar, FirPropertyBuilder $this_generateAccessorsByDelegate) {
        void $this$mapTo$iv;
        ConeKotlinType coneKotlinType;
        Object $i$f$buildResolvedNamedReference2;
        void $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder;
        boolean $i$f$buildCallableReferenceAccess = false;
        FirCallableReferenceAccessBuilder $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425 = firCallableReferenceAccessBuilder = new FirCallableReferenceAccessBuilder();
        boolean bl = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425.setSource(fakeSource);
        boolean $i$f$buildResolvedNamedReference2 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        Object object = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425;
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421.setSource(fakeSource);
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421.setName($this_generateAccessorsByDelegate.getName());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421.setResolvedSymbol($this_generateAccessorsByDelegate.getSymbol());
        ((FirCallableReferenceAccessBuilder)object).setCalleeReference(firResolvedNamedReferenceBuilder.build());
        if (!isMember && !$isExtension) {
            ConeClassLikeType coneClassLikeType;
            if (isVar) {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKMutableProperty0(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            } else {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKProperty0(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            }
            coneKotlinType = coneClassLikeType;
        } else if (isMember && $isExtension) {
            ConeClassLikeType coneClassLikeType;
            if (isVar) {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKMutableProperty2(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            } else {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKProperty2(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            }
            coneKotlinType = coneClassLikeType;
        } else {
            ConeClassLikeType coneClassLikeType;
            if (isVar) {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKMutableProperty1(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            } else {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKProperty1(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            }
            coneKotlinType = coneClassLikeType;
        }
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425.setConeTypeOrNull(coneKotlinType);
        $i$f$buildResolvedNamedReference2 = $this_generateAccessorsByDelegate.getTypeParameters();
        Collection destination$iv = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425.getTypeArguments();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            void $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder;
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv;
            object = destination$iv;
            boolean bl3 = false;
            boolean $i$f$buildTypeProjectionWithVariance = false;
            FirTypeProjectionWithVarianceBuilder $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423 = firTypeProjectionWithVarianceBuilder = new FirTypeProjectionWithVarianceBuilder();
            boolean bl4 = false;
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423.setVariance(Variance.INVARIANT);
            boolean $i$f$buildResolvedTypeRef = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder2 = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423;
            boolean bl5 = false;
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.setType(new ConeTypeParameterTypeImpl(it.getSymbol().toLookupTag(), false, null, 4, null));
            firTypeProjectionWithVarianceBuilder2.setTypeRef(firResolvedTypeRefBuilder.build());
            object.add(firTypeProjectionWithVarianceBuilder.build());
        }
        return firCallableReferenceAccessBuilder.build();
    }
}

