/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUpperBoundViolatedHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.OriginalProjectionTypeAttribute;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B+\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB!\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u000b\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0014\u0010\u0014\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0006H\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FE10LikeConeSubstitutor;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "typeParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "typeArguments", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirSession;)V", "substitution", "", "(Ljava/util/Map;Lorg/jetbrains/kotlin/fir/FirSession;)V", "substituteArgument", "projection", "index", "", "substituteType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "withProjection", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUpperBoundViolatedHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUpperBoundViolatedHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FE10LikeConeSubstitutor\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,263:1\n26#2:264\n*S KotlinDebug\n*F\n+ 1 FirUpperBoundViolatedHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FE10LikeConeSubstitutor\n*L\n95#1:264\n*E\n"})
public final class FE10LikeConeSubstitutor
extends AbstractConeSubstitutor {
    @NotNull
    private final Map<FirTypeParameterSymbol, ConeTypeProjection> substitution;

    public FE10LikeConeSubstitutor(@NotNull Map<FirTypeParameterSymbol, ? extends ConeTypeProjection> substitution, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter(substitution, (String)"substitution");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        super(TypeComponentsKt.getTypeContext(useSiteSession));
        this.substitution = substitution;
    }

    public FE10LikeConeSubstitutor(@NotNull List<FirTypeParameterSymbol> typeParameters2, @NotNull List<? extends ConeTypeProjection> typeArguments, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter(typeParameters2, (String)"typeParameters");
        Intrinsics.checkNotNullParameter(typeArguments, (String)"typeArguments");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        this(MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)typeParameters2, (Iterable)typeArguments)), useSiteSession);
    }

    @Override
    @Nullable
    public ConeKotlinType substituteType(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof ConeTypeParameterType)) {
            return null;
        }
        ConeTypeProjection coneTypeProjection = this.substitution.get(((ConeTypeParameterType)type2).getLookupTag().getSymbol());
        if (coneTypeProjection == null) {
            return null;
        }
        ConeTypeProjection projection = coneTypeProjection;
        if (ConeTypeProjectionKt.isStarProjection(projection)) {
            boolean $i$f$emptyArray = false;
            return this.withProjection(TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getAny(), new ConeTypeProjection[0], true, null, 4, null), projection);
        }
        ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(projection);
        Intrinsics.checkNotNull((Object)coneKotlinType);
        ConeKotlinType coneKotlinType2 = this.updateNullabilityIfNeeded(coneKotlinType, type2);
        if (coneKotlinType2 == null || (coneKotlinType2 = LookupTagUtilsKt.withCombinedAttributesFrom(coneKotlinType2, type2)) == null) {
            return null;
        }
        ConeKotlinType result2 = coneKotlinType2;
        return this.withProjection(result2, projection);
    }

    private final ConeKotlinType withProjection(ConeKotlinType $this$withProjection, ConeTypeProjection projection) {
        if (projection.getKind() == ProjectionKind.INVARIANT) {
            return $this$withProjection;
        }
        return TypeUtilsKt.withAttributes($this$withProjection, ConeAttributes.Companion.create(CollectionsKt.listOf((Object)new OriginalProjectionTypeAttribute(projection))));
    }

    @Override
    @Nullable
    public ConeTypeProjection substituteArgument(@NotNull ConeTypeProjection projection, int index2) {
        Object projectionFromType;
        ProjectionKind projectionKindFromType;
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        ConeTypeProjection coneTypeProjection = super.substituteArgument(projection, index2);
        if (coneTypeProjection == null) {
            return null;
        }
        ConeTypeProjection substitutedProjection = coneTypeProjection;
        if (ConeTypeProjectionKt.isStarProjection(substitutedProjection)) {
            return null;
        }
        ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(substitutedProjection);
        Intrinsics.checkNotNull((Object)coneKotlinType);
        ConeKotlinType type2 = coneKotlinType;
        Object object = FirUpperBoundViolatedHelpersKt.access$getOriginalProjection(type2.getAttributes());
        if (object == null || (object = ((OriginalProjectionTypeAttribute)object).getData()) == null) {
            object = type2;
        }
        if ((projectionKindFromType = ((ConeTypeProjection)(projectionFromType = object)).getKind()) == ProjectionKind.STAR) {
            return ConeStarProjection.INSTANCE;
        }
        if (projectionKindFromType == ProjectionKind.INVARIANT || projectionKindFromType == projection.getKind()) {
            return substitutedProjection;
        }
        if (projection.getKind() == ProjectionKind.INVARIANT) {
            return this.wrapProjection((ConeTypeProjection)projectionFromType, type2);
        }
        return ConeStarProjection.INSTANCE;
    }
}

