/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactory;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.caches.FirLazyValue;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.deserialization.ClassDeserializationKt;
import org.jetbrains.kotlin.fir.deserialization.FirBuiltinAnnotationDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.deserialization.FirMemberDeserializer;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.resolve.providers.impl.BinaryVersionAndPackageFragment;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirBuiltinSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirBuiltinSyntheticFunctionInterfaceProvider;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J*\u0010\u001e\u001a\u00020\u001f2\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0!2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0017J&\u0010&\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020'0!2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0017J&\u0010(\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020'0!2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0004J&\u0010)\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020*0!2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0017J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;)V", "allPackageFragments", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider$BuiltInsPackageFragment;", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "getModuleData", "()Lorg/jetbrains/kotlin/fir/FirModuleData;", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "syntheticFunctionInterfaceProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSyntheticFunctionInterfaceProvider;", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackage", "fqName", "getTopLevelCallableSymbolsTo", "", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelFunctionSymbolsToByPackageFragments", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "loadBuiltIns", "BuiltInsPackageFragment", "fir-deserialization"})
@SourceDebugExtension(value={"SMAP\nFirBuiltinSymbolProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirBuiltinSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,228:1\n1477#2:229\n1502#2,3:230\n1505#2,3:240\n1549#2:243\n1620#2,3:244\n1446#2,5:247\n1446#2,5:252\n372#3,7:233\n*S KotlinDebug\n*F\n+ 1 FirBuiltinSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider\n*L\n62#1:229\n62#1:230,3\n62#1:240,3\n69#1:243\n69#1:244,3\n110#1:247,5\n121#1:252,5\n62#1:233,7\n*E\n"})
public class FirBuiltinSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final FirModuleData moduleData;
    @NotNull
    private final FirKotlinScopeProvider kotlinScopeProvider;
    @NotNull
    private final FirBuiltinSyntheticFunctionInterfaceProvider syntheticFunctionInterfaceProvider;
    @NotNull
    private final Map<FqName, List<BuiltInsPackageFragment>> allPackageFragments;
    @NotNull
    private final FirSymbolNamesProvider symbolNamesProvider;

    /*
     * WARNING - void declaration
     */
    public FirBuiltinSymbolProvider(@NotNull FirSession session, @NotNull FirModuleData moduleData, @NotNull FirKotlinScopeProvider kotlinScopeProvider) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider, (String)"kotlinScopeProvider");
        super(session);
        this.moduleData = moduleData;
        this.kotlinScopeProvider = kotlinScopeProvider;
        this.syntheticFunctionInterfaceProvider = new FirBuiltinSyntheticFunctionInterfaceProvider(session, this.moduleData, this.kotlinScopeProvider);
        Iterable iterable = this.loadBuiltIns();
        FirBuiltinSymbolProvider firBuiltinSymbolProvider = this;
        boolean $i$f$groupBy = false;
        void var6_7 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            BuiltInsPackageFragment it = (BuiltInsPackageFragment)element$iv$iv;
            boolean bl = false;
            FqName key$iv$iv = it.getFqName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        firBuiltinSymbolProvider.allPackageFragments = destination$iv$iv;
        this.symbolNamesProvider = new FirSymbolNamesProvider(this){
            final /* synthetic */ FirBuiltinSymbolProvider this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Set<String> getPackageNamesWithTopLevelCallables() {
                void var2_2;
                void $this$mapTo$iv;
                Iterable iterable = FirBuiltinSymbolProvider.access$getAllPackageFragments$p(this.this$0).keySet();
                Collection destination$iv = new LinkedHashSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    FqName fqName2 = (FqName)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.asString());
                }
                return (Set)var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Set<String> getTopLevelClassifierNamesInPackage(@NotNull FqName packageFqName) {
                Set set;
                Set set2;
                Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
                List list2 = (List)FirBuiltinSymbolProvider.access$getAllPackageFragments$p(this.this$0).get(packageFqName);
                if (list2 != null) {
                    void var3_3;
                    void $this$flatMapTo$iv;
                    Iterable iterable = list2;
                    Collection destination$iv = new LinkedHashSet<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv : $this$flatMapTo$iv) {
                        void $this$mapTo$iv$iv;
                        BuiltInsPackageFragment fragment = (BuiltInsPackageFragment)element$iv;
                        boolean bl = false;
                        Iterable $this$map$iv = fragment.getClassDataFinder().getAllClassIds();
                        boolean $i$f$map = false;
                        Iterable iterable2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            ClassId classId = (ClassId)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(it.getShortClassName().asString());
                        }
                        Iterable list$iv = (List)destination$iv$iv;
                        CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                    }
                    set2 = (Set)var3_3;
                } else {
                    set2 = set = null;
                }
                if (set2 == null) {
                    set = SetsKt.emptySet();
                }
                return set;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Set<Name> getTopLevelCallableNamesInPackage(@NotNull FqName packageFqName) {
                Set set;
                Set set2;
                Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
                List list2 = (List)FirBuiltinSymbolProvider.access$getAllPackageFragments$p(this.this$0).get(packageFqName);
                if (list2 != null) {
                    void var3_3;
                    void $this$flatMapTo$iv;
                    Iterable iterable = list2;
                    Collection destination$iv = new LinkedHashSet<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv : $this$flatMapTo$iv) {
                        BuiltInsPackageFragment it = (BuiltInsPackageFragment)element$iv;
                        boolean bl = false;
                        Iterable list$iv = it.getTopLevelCallableNames();
                        CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                    }
                    set2 = (Set)var3_3;
                } else {
                    set2 = set = null;
                }
                if (set2 == null) {
                    set = SetsKt.emptySet();
                }
                return set;
            }

            public boolean getMayHaveSyntheticFunctionTypes() {
                return true;
            }

            public boolean mayHaveSyntheticFunctionType(@NotNull ClassId classId) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                return FirBuiltinSymbolProvider.access$getSyntheticFunctionInterfaceProvider$p(this.this$0).getSymbolNamesProvider().mayHaveSyntheticFunctionType(classId);
            }
        };
    }

    @NotNull
    public final FirModuleData getModuleData() {
        return this.moduleData;
    }

    @NotNull
    public final FirKotlinScopeProvider getKotlinScopeProvider() {
        return this.kotlinScopeProvider;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BuiltInsPackageFragment> loadBuiltIns() {
        void $this$mapTo$iv$iv;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Function1 streamProvider2 = (Function1)new Function1<String, InputStream>(classLoader){
            final /* synthetic */ ClassLoader $classLoader;
            {
                this.$classLoader = $classLoader;
                super(1);
            }

            public final InputStream invoke(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Object object = this.$classLoader;
                if (object == null || (object = ((ClassLoader)object).getResourceAsStream(path)) == null) {
                    object = ClassLoader.getSystemResourceAsStream(path);
                }
                return object;
            }
        };
        Set<FqName> packageFqNames = StandardClassIds.INSTANCE.getBuiltInsPackages();
        Iterable $this$map$iv = packageFqNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            InputStream inputStream;
            void fqName2;
            FqName fqName3 = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String resourcePath = BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath((FqName)fqName2);
            InputStream inputStream2 = inputStream = (InputStream)streamProvider2.invoke((Object)resourcePath);
            if (inputStream2 == null) {
                throw new IllegalStateException("Resource not found in classpath: " + resourcePath);
            }
            Intrinsics.checkNotNull((Object)inputStream2);
            InputStream inputStream3 = inputStream;
            collection.add(new BuiltInsPackageFragment(inputStream3, (FqName)fqName2, this.moduleData, this.kotlinScopeProvider));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        if (this.allPackageFragments.containsKey(fqName2)) {
            return fqName2;
        }
        return null;
    }

    @Nullable
    public FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        List<BuiltInsPackageFragment> list2;
        block5: {
            block4: {
                Object object;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                    list2 = this.allPackageFragments.get(classId.getPackageFqName());
                    if (list2 == null) break block4;
                    for (BuiltInsPackageFragment it : (Iterable)list2) {
                        boolean bl = false;
                        FirRegularClassSymbol firRegularClassSymbol = it.getClassLikeSymbolByClassId(classId);
                        if (firRegularClassSymbol == null) continue;
                        object = firRegularClassSymbol;
                        break block3;
                    }
                    object = list2 = null;
                }
                if (object != null) break block5;
            }
            list2 = this.syntheticFunctionInterfaceProvider.getClassLikeSymbolByClassId(classId);
        }
        return list2;
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.symbolNamesProvider;
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        block1: {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            List<BuiltInsPackageFragment> list2 = this.allPackageFragments.get(packageFqName);
            if (list2 == null) break block1;
            Iterable $this$flatMapTo$iv = list2;
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                BuiltInsPackageFragment it = (BuiltInsPackageFragment)element$iv;
                boolean bl = false;
                Iterable list$iv = it.getTopLevelCallableSymbols(name2);
                CollectionsKt.addAll((Collection)destination, (Iterable)list$iv);
            }
            List cfr_ignored_0 = (List)((Collection)destination);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.getTopLevelFunctionSymbolsToByPackageFragments(destination, packageFqName, name2);
    }

    protected final void getTopLevelFunctionSymbolsToByPackageFragments(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        block1: {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            List<BuiltInsPackageFragment> list2 = this.allPackageFragments.get(packageFqName);
            if (list2 == null) break block1;
            Iterable $this$flatMapTo$iv = list2;
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                BuiltInsPackageFragment it = (BuiltInsPackageFragment)element$iv;
                boolean bl = false;
                Iterable list$iv = it.getTopLevelFunctionSymbols(name2);
                CollectionsKt.addAll((Collection)destination, (Iterable)list$iv);
            }
            List cfr_ignored_0 = (List)((Collection)destination);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
    }

    public static final /* synthetic */ Map access$getAllPackageFragments$p(FirBuiltinSymbolProvider $this) {
        return $this.allPackageFragments;
    }

    public static final /* synthetic */ FirBuiltinSyntheticFunctionInterfaceProvider access$getSyntheticFunctionInterfaceProvider$p(FirBuiltinSymbolProvider $this) {
        return $this.syntheticFunctionInterfaceProvider;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u00103\u001a\u0004\u0018\u00010\u00102\u0006\u00104\u001a\u00020\u000f2\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u00106\u001a\u0004\u0018\u00010\u00102\u0006\u00104\u001a\u00020\u000fJ\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001908J\u0018\u00109\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030:0\u001a2\u0006\u0010;\u001a\u00020\u0019J\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010;\u001a\u00020\u0019R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u0018\u001a\u001c\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001a0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider$BuiltInsPackageFragment;", "", "stream", "Ljava/io/InputStream;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "(Ljava/io/InputStream;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;)V", "binaryVersionAndPackageFragment", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/BinaryVersionAndPackageFragment;", "classCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "classDataFinder", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoBasedClassDataFinder;", "getClassDataFinder", "()Lorg/jetbrains/kotlin/serialization/deserialization/ProtoBasedClassDataFinder;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "functionCache", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "", "functionsNameCache", "Lorg/jetbrains/kotlin/fir/caches/FirLazyValue;", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "memberDeserializer", "Lorg/jetbrains/kotlin/fir/deserialization/FirMemberDeserializer;", "getMemberDeserializer", "()Lorg/jetbrains/kotlin/fir/deserialization/FirMemberDeserializer;", "memberDeserializer$delegate", "Lkotlin/Lazy;", "getModuleData", "()Lorg/jetbrains/kotlin/fir/FirModuleData;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "packageProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "getPackageProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "version", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "findAndDeserializeClass", "classId", "parentContext", "getClassLikeSymbolByClassId", "getTopLevelCallableNames", "", "getTopLevelCallableSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "name", "getTopLevelFunctionSymbols", "fir-deserialization"})
    @SourceDebugExtension(value={"SMAP\nFirBuiltinSymbolProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirBuiltinSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider$BuiltInsPackageFragment\n+ 2 FirCachesFactory.kt\norg/jetbrains/kotlin/fir/caches/FirCachesFactoryKt\n+ 3 FirCacheWithPostCompute.kt\norg/jetbrains/kotlin/fir/caches/FirCacheWithPostComputeKt\n*L\n1#1,228:1\n69#2,3:229\n17#3:232\n*S KotlinDebug\n*F\n+ 1 FirBuiltinSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider$BuiltInsPackageFragment\n*L\n169#1:229,3\n200#1:232\n*E\n"})
    private static final class BuiltInsPackageFragment {
        @NotNull
        private final FqName fqName;
        @NotNull
        private final FirModuleData moduleData;
        @NotNull
        private final FirKotlinScopeProvider kotlinScopeProvider;
        @NotNull
        private final BinaryVersionAndPackageFragment binaryVersionAndPackageFragment;
        @NotNull
        private final NameResolverImpl nameResolver;
        @NotNull
        private final ProtoBasedClassDataFinder classDataFinder;
        @NotNull
        private final Lazy memberDeserializer$delegate;
        @NotNull
        private final FirCache<ClassId, FirRegularClassSymbol, FirDeserializationContext> classCache;
        @NotNull
        private final FirCache functionCache;
        @NotNull
        private final FirLazyValue<List<Name>> functionsNameCache;

        public BuiltInsPackageFragment(@NotNull InputStream stream, @NotNull FqName fqName2, @NotNull FirModuleData moduleData, @NotNull FirKotlinScopeProvider kotlinScopeProvider) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
            Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider, (String)"kotlinScopeProvider");
            this.fqName = fqName2;
            this.moduleData = moduleData;
            this.kotlinScopeProvider = kotlinScopeProvider;
            this.binaryVersionAndPackageFragment = BinaryVersionAndPackageFragment.Companion.createFromStream(stream);
            ProtoBuf.StringTable stringTable2 = this.getPackageProto().getStrings();
            Intrinsics.checkNotNullExpressionValue((Object)stringTable2, (String)"getStrings(...)");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = this.getPackageProto().getQualifiedNames();
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"getQualifiedNames(...)");
            this.nameResolver = new NameResolverImpl(stringTable2, qualifiedNameTable);
            this.classDataFinder = new ProtoBasedClassDataFinder(this.getPackageProto(), this.nameResolver, this.getVersion(), (Function1<? super ClassId, ? extends SourceElement>)((Function1)classDataFinder.1.INSTANCE));
            this.memberDeserializer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FirMemberDeserializer>(this){
                final /* synthetic */ BuiltInsPackageFragment this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final FirMemberDeserializer invoke() {
                    FqName fqName2 = this.this$0.getFqName();
                    ProtoBuf.Package package_ = this.this$0.getPackageProto().getPackage();
                    Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"getPackage(...)");
                    return FirDeserializationContext.Companion.createForPackage(fqName2, package_, BuiltInsPackageFragment.access$getNameResolver$p(this.this$0), this.this$0.getModuleData(), new FirBuiltinAnnotationDeserializer(this.this$0.getModuleData().getSession()), new FirConstDeserializer(this.this$0.getModuleData().getSession(), BuiltInSerializerProtocol.INSTANCE), null).getMemberDeserializer();
                }
            }));
            this.classCache = FirCachesFactoryKt.getFirCachesFactory(this.moduleData.getSession()).createCacheWithPostCompute(classCache.1.INSTANCE, (Function3)new Function3<ClassId, FirRegularClassSymbol, FirDeserializationContext, Unit>(this){
                final /* synthetic */ BuiltInsPackageFragment this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                public final void invoke(@NotNull ClassId classId, @NotNull FirRegularClassSymbol symbol2, @Nullable FirDeserializationContext parentContext) {
                    Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                    Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                    ClassData classData = this.this$0.getClassDataFinder().findClassData(classId);
                    Intrinsics.checkNotNull((Object)classData);
                    ClassData classData2 = classData;
                    ProtoBuf.Class classProto = classData2.getClassProto();
                    ClassDeserializationKt.deserializeClassToSymbol(classId, classProto, symbol2, BuiltInsPackageFragment.access$getNameResolver$p(this.this$0), this.this$0.getModuleData().getSession(), this.this$0.getModuleData(), null, this.this$0.getKotlinScopeProvider(), BuiltInSerializerProtocol.INSTANCE, parentContext, null, FirDeclarationOrigin.BuiltIns.INSTANCE, (Function2<? super ClassId, ? super FirDeserializationContext, FirRegularClassSymbol>)((Function2)new Function2<ClassId, FirDeserializationContext, FirRegularClassSymbol>((Object)this.this$0){

                        @Nullable
                        public final FirRegularClassSymbol invoke(@NotNull ClassId p0, @Nullable FirDeserializationContext p1) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return BuiltInsPackageFragment.access$findAndDeserializeClass((BuiltInsPackageFragment)this.receiver, p0, p1);
                        }

                        @NotNull
                        public final String getSignature() {
                            return "findAndDeserializeClass(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;";
                        }

                        @NotNull
                        public final String getName() {
                            return "findAndDeserializeClass";
                        }

                        @NotNull
                        public final KDeclarationContainer getOwner() {
                            return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(BuiltInsPackageFragment.class);
                        }
                    }));
                }
            });
            FirCachesFactory $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(this.moduleData.getSession());
            boolean $i$f$createCache = false;
            this.functionCache = $this$createCache$iv.createCache((Function2)new Function2(this){
                final /* synthetic */ BuiltInsPackageFragment this$0;
                {
                    this.this$0 = builtInsPackageFragment;
                    super(2);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final Object invoke(@NotNull Object key, @Nullable Void void_) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    ProtoBuf.Function it;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Name name2 = (Name)key;
                    boolean bl = false;
                    List<ProtoBuf.Function> list2 = this.this$0.getPackageProto().getPackage().getFunctionList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getFunctionList(...)");
                    Iterable $this$filter$iv = list2;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (ProtoBuf.Function)element$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)NameResolverUtilKt.getName(BuiltInsPackageFragment.access$getNameResolver$p(this.this$0), it.getName()), (Object)name2)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (ProtoBuf.Function)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        FirMemberDeserializer firMemberDeserializer = BuiltInsPackageFragment.access$getMemberDeserializer(this.this$0);
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(FirMemberDeserializer.loadFunction$default(firMemberDeserializer, it, null, null, null, 14, null).getSymbol());
                    }
                    return (List)destination$iv$iv;
                }
            });
            this.functionsNameCache = FirCachesFactoryKt.getFirCachesFactory(this.moduleData.getSession()).createLazyValue((Function0)new Function0<List<? extends Name>>(this){
                final /* synthetic */ BuiltInsPackageFragment this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<Name> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List<ProtoBuf.Function> list2 = this.this$0.getPackageProto().getPackage().getFunctionList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getFunctionList(...)");
                    Iterable iterable = list2;
                    BuiltInsPackageFragment builtInsPackageFragment = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ProtoBuf.Function function2 = (ProtoBuf.Function)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(NameResolverUtilKt.getName(BuiltInsPackageFragment.access$getNameResolver$p(builtInsPackageFragment), it.getName()));
                    }
                    return (List)destination$iv$iv;
                }
            });
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        @NotNull
        public final FirModuleData getModuleData() {
            return this.moduleData;
        }

        @NotNull
        public final FirKotlinScopeProvider getKotlinScopeProvider() {
            return this.kotlinScopeProvider;
        }

        @NotNull
        public final BuiltInsBinaryVersion getVersion() {
            return this.binaryVersionAndPackageFragment.getVersion();
        }

        @NotNull
        public final ProtoBuf.PackageFragment getPackageProto() {
            return this.binaryVersionAndPackageFragment.getPackageFragment();
        }

        @NotNull
        public final ProtoBasedClassDataFinder getClassDataFinder() {
            return this.classDataFinder;
        }

        private final FirMemberDeserializer getMemberDeserializer() {
            Lazy lazy = this.memberDeserializer$delegate;
            return (FirMemberDeserializer)lazy.getValue();
        }

        @Nullable
        public final FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            return BuiltInsPackageFragment.findAndDeserializeClass$default(this, classId, null, 2, null);
        }

        private final FirRegularClassSymbol findAndDeserializeClass(ClassId classId, FirDeserializationContext parentContext) {
            boolean classIdExists = this.classDataFinder.getAllClassIds().contains(classId);
            if (!classIdExists) {
                return null;
            }
            return this.classCache.getValue(classId, parentContext);
        }

        static /* synthetic */ FirRegularClassSymbol findAndDeserializeClass$default(BuiltInsPackageFragment builtInsPackageFragment, ClassId classId, FirDeserializationContext firDeserializationContext, int n, Object object) {
            if ((n & 2) != 0) {
                firDeserializationContext = null;
            }
            return builtInsPackageFragment.findAndDeserializeClass(classId, firDeserializationContext);
        }

        @NotNull
        public final List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull Name name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return this.getTopLevelFunctionSymbols(name2);
        }

        @NotNull
        public final Collection<Name> getTopLevelCallableNames() {
            return this.functionsNameCache.getValue();
        }

        @NotNull
        public final List<FirNamedFunctionSymbol> getTopLevelFunctionSymbols(@NotNull Name name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            FirCache $this$getValue$iv = this.functionCache;
            boolean $i$f$getValue = false;
            return (List)$this$getValue$iv.getValue(name2, null);
        }

        public static final /* synthetic */ NameResolverImpl access$getNameResolver$p(BuiltInsPackageFragment $this) {
            return $this.nameResolver;
        }

        public static final /* synthetic */ FirMemberDeserializer access$getMemberDeserializer(BuiltInsPackageFragment $this) {
            return $this.getMemberDeserializer();
        }

        public static final /* synthetic */ FirRegularClassSymbol access$findAndDeserializeClass(BuiltInsPackageFragment $this, ClassId classId, FirDeserializationContext parentContext) {
            return $this.findAndDeserializeClass(classId, parentContext);
        }
    }
}

