/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.actualizer.FakeOverrideRebuilder;
import org.jetbrains.kotlin.backend.common.actualizer.RemapFakeOverridesVisitor;
import org.jetbrains.kotlin.backend.common.actualizer.RemoveFakeOverridesVisitor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyDeclarationBase;
import org.jetbrains.kotlin.ir.overrides.IrFakeOverrideBuilder;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J@\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u001c2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u000fH\u0002J\u000e\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$J\"\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0&*\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J,\u0010'\u001a\u00020\u0018*\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00122\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010!\u001a\u00020\u000fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/FakeOverrideRebuilder;", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/ir/overrides/IrFakeOverrideBuilder;", "(Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/overrides/IrFakeOverrideBuilder;)V", "getFakeOverrideBuilder", "()Lorg/jetbrains/kotlin/ir/overrides/IrFakeOverrideBuilder;", "fakeOverrideMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lkotlin/collections/HashMap;", "processedClasses", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lkotlin/collections/HashSet;", "removedFakeOverrides", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "collectOverriddenDeclarations", "", "member", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableDeclaration;", "result", "", "visited", "stopAtReal", "", "rebuildClassFakeOverrides", "irClass", "rebuildFakeOverrides", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getOverriddenDeclarations", "", "processDeclaration", "declaration", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nFakeOverrideRebuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeOverrideRebuilder.kt\norg/jetbrains/kotlin/backend/common/actualizer/FakeOverrideRebuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n1#2:245\n1620#3,3:246\n*S KotlinDebug\n*F\n+ 1 FakeOverrideRebuilder.kt\norg/jetbrains/kotlin/backend/common/actualizer/FakeOverrideRebuilder\n*L\n136#1:246,3\n*E\n"})
public final class FakeOverrideRebuilder {
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final IrFakeOverrideBuilder fakeOverrideBuilder;
    @NotNull
    private final Map<IrClassSymbol, List<IrSymbol>> removedFakeOverrides;
    @NotNull
    private final HashSet<IrClass> processedClasses;
    @NotNull
    private final HashMap<IrSymbol, IrSymbol> fakeOverrideMap;

    public FakeOverrideRebuilder(@NotNull SymbolTable symbolTable, @NotNull IrFakeOverrideBuilder fakeOverrideBuilder) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)fakeOverrideBuilder, (String)"fakeOverrideBuilder");
        this.symbolTable = symbolTable;
        this.fakeOverrideBuilder = fakeOverrideBuilder;
        this.removedFakeOverrides = new LinkedHashMap();
        this.processedClasses = new HashSet();
        this.fakeOverrideMap = new HashMap();
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final IrFakeOverrideBuilder getFakeOverrideBuilder() {
        return this.fakeOverrideBuilder;
    }

    public final void rebuildFakeOverrides(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        IrVisitorsKt.acceptVoid(irModule, new RemoveFakeOverridesVisitor(this.removedFakeOverrides, this.symbolTable));
        for (IrClassSymbol clazz : this.removedFakeOverrides.keySet()) {
            this.rebuildClassFakeOverrides((IrClass)clazz.getOwner());
        }
        IrVisitorsKt.acceptVoid(irModule, new RemapFakeOverridesVisitor((Map<IrSymbol, ? extends IrSymbol>)this.fakeOverrideMap));
    }

    private final void collectOverriddenDeclarations(IrOverridableDeclaration<?> member2, Set<IrOverridableDeclaration<?>> result2, Set<IrOverridableDeclaration<?>> visited2, boolean stopAtReal) {
        if (!visited2.add(member2)) {
            return;
        }
        if (IrFakeOverrideUtilsKt.isReal(member2)) {
            result2.add(member2);
            if (stopAtReal) {
                return;
            }
        } else if (!(!((Collection)member2.getOverriddenSymbols()).isEmpty())) {
            boolean $i$a$-require-FakeOverrideRebuilder$collectOverriddenDeclarations$22 = false;
            String $i$a$-require-FakeOverrideRebuilder$collectOverriddenDeclarations$22 = "No overridden symbols found for (fake override) " + RenderIrElementKt.render$default(member2, null, 1, null);
            throw new IllegalArgumentException($i$a$-require-FakeOverrideRebuilder$collectOverriddenDeclarations$22.toString());
        }
        for (IrSymbol overridden : member2.getOverriddenSymbols()) {
            IrSymbolOwner irSymbolOwner = overridden.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration<*>");
            this.collectOverriddenDeclarations((IrOverridableDeclaration)irSymbolOwner, result2, visited2, stopAtReal);
        }
    }

    private final Set<IrOverridableDeclaration<?>> getOverriddenDeclarations(IrOverridableDeclaration<?> $this$getOverriddenDeclarations, boolean stopAtReal) {
        Set set;
        Set result2 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        this.collectOverriddenDeclarations($this$getOverriddenDeclarations, result2, new HashSet(), stopAtReal);
        return set;
    }

    private final void processDeclaration(Map<IrSymbol, IrSymbol> $this$processDeclaration, IrOverridableDeclaration<?> declaration, IrClass irClass2) {
        for (IrOverridableDeclaration<?> overridden : this.getOverriddenDeclarations(declaration, false)) {
            IrSymbol previousSymbol = $this$processDeclaration.put((IrSymbol)overridden.getSymbol(), (IrSymbol)declaration.getSymbol());
            if (previousSymbol == null) continue;
            IrSymbolOwner irSymbolOwner = previousSymbol.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            IrDeclaration previous = (IrDeclaration)irSymbolOwner;
            throw new IllegalStateException(("Multiple overrides in class " + IrUtilsKt.getFqNameWhenAvailable(irClass2) + " for " + RenderIrElementKt.render$default(overridden, null, 1, null) + ":\n  previous: " + RenderIrElementKt.render$default(previous, null, 1, null) + "\n            declared in " + IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass(previous)) + "\n       new: " + RenderIrElementKt.render$default(declaration, null, 1, null) + "\n            declared in " + IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass(declaration))).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void rebuildClassFakeOverrides(IrClass irClass2) {
        if (irClass2 instanceof IrLazyDeclarationBase) {
            return;
        }
        if (!this.processedClasses.add(irClass2)) {
            return;
        }
        List<IrSymbol> list2 = this.removedFakeOverrides.get(irClass2.getSymbol());
        if (list2 == null) {
            return;
        }
        List<IrSymbol> oldList = list2;
        for (IrType c : irClass2.getSuperTypes()) {
            IrClass it;
            if (IrTypesKt.getClass(c) == null) continue;
            boolean bl = false;
            this.rebuildClassFakeOverrides(it);
        }
        this.fakeOverrideBuilder.buildFakeOverridesForClass(irClass2, false);
        Map overriddenMap = new LinkedHashMap();
        for (IrDeclaration declaration : irClass2.getDeclarations()) {
            IrSimpleFunction it;
            IrDeclaration irDeclaration2 = declaration;
            if (irDeclaration2 instanceof IrSimpleFunction) {
                this.processDeclaration(overriddenMap, (IrOverridableDeclaration)declaration, irClass2);
                continue;
            }
            if (!(irDeclaration2 instanceof IrProperty)) continue;
            this.processDeclaration(overriddenMap, (IrOverridableDeclaration)declaration, irClass2);
            if (((IrProperty)declaration).getGetter() != null) {
                boolean bl = false;
                this.processDeclaration(overriddenMap, it, irClass2);
            }
            if (((IrProperty)declaration).getSetter() == null) continue;
            boolean bl = false;
            this.processDeclaration(overriddenMap, it, irClass2);
        }
        block6: for (IrSymbol old : oldList) {
            void $this$mapTo$iv;
            Set overridden = new LinkedHashSet();
            IrSymbolOwner irSymbolOwner = old.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration<*>");
            this.collectOverriddenDeclarations((IrOverridableDeclaration)irSymbolOwner, overridden, new HashSet(), true);
            Iterable bl = overridden;
            Collection destination$iv = CollectionsKt.newHashSetWithExpectedSize(1);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                IrOverridableDeclaration irOverridableDeclaration = (IrOverridableDeclaration)item$iv;
                Collection collection = destination$iv;
                boolean bl2 = false;
                IrSymbol irSymbol2 = (IrSymbol)overriddenMap.get(it.getSymbol());
                if (irSymbol2 == null) {
                    throw new IllegalStateException(("No new fake override recorded for declaration in class " + IrUtilsKt.getFqNameWhenAvailable(irClass2) + ": " + RenderIrElementKt.render$default((IrElement)it, null, 1, null)).toString());
                }
                collection.add(irSymbol2);
            }
            HashSet newSymbols = (HashSet)destination$iv;
            switch (newSymbols.size()) {
                case 0: {
                    throw new IllegalStateException(("No overridden found for declaration in class " + IrUtilsKt.getFqNameWhenAvailable(irClass2) + ": " + RenderIrElementKt.render$default(old.getOwner(), null, 1, null)).toString());
                }
                case 1: {
                    ((Map)this.fakeOverrideMap).put(old, kotlin.collections.CollectionsKt.single((Iterable)newSymbols));
                    continue block6;
                }
            }
            throw new IllegalStateException(("Multiple overridden found for declaration in class " + IrUtilsKt.getFqNameWhenAvailable(irClass2) + ": " + RenderIrElementKt.render$default(old.getOwner(), null, 1, null) + '\n' + kotlin.collections.CollectionsKt.joinToString$default((Iterable)newSymbols, (CharSequence)"\n", null, null, (int)0, null, (Function1)rebuildClassFakeOverrides.4.INSTANCE, (int)30, null)).toString());
        }
    }
}

