/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u0006*\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "forEachClassLikeType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "action", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1#2:69\n1855#3,2:70\n1855#3,2:72\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker\n*L\n51#1:70,2\n62#1:72,2\n*E\n"})
public final class FirMissingDependencyClassChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirMissingDependencyClassChecker INSTANCE = new FirMissingDependencyClassChecker();

    private FirMissingDependencyClassChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ConeDiagnostic diagnostic;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirNamedReference calleeReference = expression2.getCalleeReference();
        if (FirReferenceUtilsKt.isError(calleeReference) && (!((diagnostic = ((FirDiagnosticHolder)((Object)calleeReference)).getDiagnostic()) instanceof ConeInapplicableCandidateError) || ((ConeInapplicableCandidateError)diagnostic).getApplicability() != CandidateApplicability.UNSAFE_CALL)) {
            return;
        }
        FirMissingDependencyClassChecker.check$consider(reporter, expression2, context2, FirTypeUtilsKt.getResolvedType(expression2));
        Object object = expression2.getExtensionReceiver();
        if (object != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null) {
            Object p0 = object;
            boolean bl = false;
            FirMissingDependencyClassChecker.check$consider(reporter, expression2, context2, (ConeKotlinType)p0);
        }
        Iterable $this$forEach$iv = expression2.getArgumentList().getArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirExpression it = (FirExpression)element$iv;
            boolean bl = false;
            FirMissingDependencyClassChecker.check$consider(reporter, expression2, context2, FirTypeUtilsKt.getResolvedType(it));
        }
    }

    private final void forEachClassLikeType(ConeKotlinType $this$forEachClassLikeType, Function1<? super ConeClassLikeType, Unit> action) {
        ConeKotlinType coneKotlinType = $this$forEachClassLikeType;
        if (coneKotlinType instanceof ConeFlexibleType) {
            this.forEachClassLikeType(((ConeFlexibleType)$this$forEachClassLikeType).getLowerBound(), action);
            this.forEachClassLikeType(((ConeFlexibleType)$this$forEachClassLikeType).getUpperBound(), action);
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.forEachClassLikeType(((ConeDefinitelyNotNullType)$this$forEachClassLikeType).getOriginal(), action);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            Iterable $this$forEach$iv = ((ConeIntersectionType)$this$forEachClassLikeType).getIntersectedTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                INSTANCE.forEachClassLikeType(it, action);
            }
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            action.invoke((Object)$this$forEachClassLikeType);
        }
    }

    private static final void check$consider(DiagnosticReporter $reporter, FirFunctionCall $expression, CheckerContext $context, ConeKotlinType type2) {
        Ref.BooleanRef hasError2 = new Ref.BooleanRef();
        Ref.BooleanRef hasMissingClass = new Ref.BooleanRef();
        INSTANCE.forEachClassLikeType(type2, (Function1<? super ConeClassLikeType, Unit>)((Function1)new Function1<ConeClassLikeType, Unit>(hasError2, hasMissingClass, $context){
            final /* synthetic */ Ref.BooleanRef $hasError;
            final /* synthetic */ Ref.BooleanRef $hasMissingClass;
            final /* synthetic */ CheckerContext $context;
            {
                this.$hasError = $hasError;
                this.$hasMissingClass = $hasMissingClass;
                this.$context = $context;
                super(1);
            }

            public final void invoke(@NotNull ConeClassLikeType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof ConeErrorType) {
                    this.$hasError.element = true;
                } else {
                    this.$hasMissingClass.element = this.$hasMissingClass.element || LookupTagUtilsKt.toSymbol(it.getLookupTag(), this.$context.getSession()) == null;
                }
            }
        }));
        if (hasMissingClass.element && !hasError2.element) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)$expression.getSource(), FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS(), (Object)type2, (DiagnosticContext)$context, null, 16, null);
        }
    }
}

