/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmPackageNameAnnotationsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationChecker;", "()V", "jvmPackageNameClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmPackageNameAnnotationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmPackageNameAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmPackageNameAnnotationsChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n22#2,4:45\n1747#3,3:49\n*S KotlinDebug\n*F\n+ 1 FirJvmPackageNameAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmPackageNameAnnotationsChecker\n*L\n28#1:45,4\n39#1:49,3\n*E\n"})
public final class FirJvmPackageNameAnnotationsChecker
extends FirExpressionChecker<FirAnnotation> {
    @NotNull
    public static final FirJvmPackageNameAnnotationsChecker INSTANCE = new FirJvmPackageNameAnnotationsChecker();
    @NotNull
    private static final ClassId jvmPackageNameClassId = ClassId.Companion.topLevel(new FqName("kotlin.jvm.JvmPackageName"));

    private FirJvmPackageNameAnnotationsChecker() {
    }

    @Override
    public void check(@NotNull FirAnnotation expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        block12: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirTypeRef $this$coneTypeSafe$iv = expression2.getAnnotationTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
                return;
            }
            Object lookupTag2 = object;
            if (!Intrinsics.areEqual((Object)((ConeClassLikeLookupTag)lookupTag2).getClassId(), (Object)jvmPackageNameClassId)) {
                return;
            }
            String string2 = FirAnnotationUtilsKt.getStringArgument(expression2, StandardNames.NAME);
            if (string2 == null) {
                return;
            }
            String nameValue = string2;
            if (((CharSequence)nameValue).length() == 0) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getJVM_PACKAGE_NAME_CANNOT_BE_EMPTY(), (DiagnosticContext)context2, null, 8, null);
            } else if (!FqNamesUtilKt.isValidJavaFqName(nameValue)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getJVM_PACKAGE_NAME_MUST_BE_VALID_NAME(), (DiagnosticContext)context2, null, 8, null);
            }
            FirFile firFile = context2.getContainingFile();
            if (firFile == null) {
                return;
            }
            FirFile file2 = firFile;
            Iterable $this$any$iv = file2.getDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof FirClass)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getJVM_PACKAGE_NAME_NOT_SUPPORTED_IN_FILES_WITH_CLASSES(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

