/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasExpandsToArrayOfNothingsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "containsMalformedArgument", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isMalformed", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTypeAliasExpandsToArrayOfNothingsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeAliasExpandsToArrayOfNothingsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasExpandsToArrayOfNothingsChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,36:1\n12474#2,2:37\n*S KotlinDebug\n*F\n+ 1 FirTypeAliasExpandsToArrayOfNothingsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasExpandsToArrayOfNothingsChecker\n*L\n34#1:37,2\n*E\n"})
public final class FirTypeAliasExpandsToArrayOfNothingsChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirTypeAliasExpandsToArrayOfNothingsChecker INSTANCE = new FirTypeAliasExpandsToArrayOfNothingsChecker();

    private FirTypeAliasExpandsToArrayOfNothingsChecker() {
    }

    @Override
    public void check(@NotNull FirTypeAlias declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ConeClassLikeType coneClassLikeType = FirDeclarationUtilKt.getExpandedConeType(declaration);
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        if (this.isMalformed(type2, context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getExpandedTypeRef().getSource(), FirErrors.INSTANCE.getTYPEALIAS_EXPANDS_TO_ARRAY_OF_NOTHINGS(), (Object)type2, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean isMalformed(ConeKotlinType $this$isMalformed, CheckerContext context2) {
        ConeTypeProjection coneTypeProjection;
        return Intrinsics.areEqual((Object)FirHelpersKt.fullyExpandedClassId($this$isMalformed, context2.getSession()), (Object)StandardClassIds.INSTANCE.getArray()) && Intrinsics.areEqual((coneTypeProjection = (ConeTypeProjection)ArraysKt.singleOrNull((Object[])$this$isMalformed.getTypeArguments())) != null && (coneTypeProjection = ConeTypeProjectionKt.getType(coneTypeProjection)) != null ? FirHelpersKt.fullyExpandedClassId((ConeKotlinType)coneTypeProjection, context2.getSession()) : null, (Object)StandardClassIds.INSTANCE.getNothing()) || this.containsMalformedArgument($this$isMalformed, context2);
    }

    private final boolean containsMalformedArgument(ConeKotlinType $this$containsMalformedArgument, CheckerContext context2) {
        boolean bl;
        block1: {
            ConeTypeProjection[] $this$any$iv = $this$containsMalformedArgument.getTypeArguments();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                ConeTypeProjection element$iv;
                ConeTypeProjection it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(it);
                boolean bl3 = coneKotlinType != null ? INSTANCE.isMalformed(coneKotlinType, context2) : false;
                if (!bl3) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }
}

