/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.AnnotationsPosition;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponent;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRetentionAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u001c\u0010\u001b\u001a\u00020\u00062\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmAnnotationsPlatformSpecificSupportComponent;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotationsPlatformSpecificSupportComponent;", "()V", "deprecationAnnotationsWithOverridesPropagation", "", "Lorg/jetbrains/kotlin/name/ClassId;", "", "getDeprecationAnnotationsWithOverridesPropagation", "()Ljava/util/Map;", "requiredAnnotations", "", "getRequiredAnnotations", "()Ljava/util/Set;", "requiredAnnotationsWithArguments", "getRequiredAnnotationsWithArguments", "volatileAnnotations", "getVolatileAnnotations", "extractBackingFieldAnnotationsFromProperty", "Lorg/jetbrains/kotlin/fir/declarations/AnnotationsPosition;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "propertyAnnotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "backingFieldAnnotations", "symbolContainsRepeatableAnnotation", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmAnnotationsPlatformSpecificSupportComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmAnnotationsPlatformSpecificSupportComponent.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmAnnotationsPlatformSpecificSupportComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n3190#2,10:78\n*S KotlinDebug\n*F\n+ 1 FirJvmAnnotationsPlatformSpecificSupportComponent.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmAnnotationsPlatformSpecificSupportComponent\n*L\n66#1:78,10\n*E\n"})
public final class FirJvmAnnotationsPlatformSpecificSupportComponent
extends FirAnnotationsPlatformSpecificSupportComponent {
    @NotNull
    public static final FirJvmAnnotationsPlatformSpecificSupportComponent INSTANCE = new FirJvmAnnotationsPlatformSpecificSupportComponent();
    @NotNull
    private static final Set<ClassId> requiredAnnotationsWithArguments;
    @NotNull
    private static final Set<ClassId> requiredAnnotations;
    @NotNull
    private static final Set<ClassId> volatileAnnotations;
    @NotNull
    private static final Map<ClassId, Boolean> deprecationAnnotationsWithOverridesPropagation;

    private FirJvmAnnotationsPlatformSpecificSupportComponent() {
    }

    @Override
    @NotNull
    public Set<ClassId> getRequiredAnnotationsWithArguments() {
        return requiredAnnotationsWithArguments;
    }

    @Override
    @NotNull
    public Set<ClassId> getRequiredAnnotations() {
        return requiredAnnotations;
    }

    @Override
    @NotNull
    public Set<ClassId> getVolatileAnnotations() {
        return volatileAnnotations;
    }

    @Override
    @NotNull
    public Map<ClassId, Boolean> getDeprecationAnnotationsWithOverridesPropagation() {
        return deprecationAnnotationsWithOverridesPropagation;
    }

    @Override
    public boolean symbolContainsRepeatableAnnotation(@NotNull FirClassLikeSymbol<?> symbol2, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)symbol2, StandardClassIds.Annotations.INSTANCE.getRepeatable(), session) != null) {
            return true;
        }
        if (FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)symbol2, JvmStandardClassIds.Annotations.Java.INSTANCE.getRepeatable(), session) != null || FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)symbol2, JvmStandardClassIds.Annotations.INSTANCE.getJvmRepeatable(), session) != null) {
            return FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.RepeatableAnnotations) || FirRetentionAnnotationHelpersKt.getAnnotationRetention(symbol2, session) == AnnotationRetention.SOURCE && symbol2.getOrigin() instanceof FirDeclarationOrigin.Java;
        }
        return false;
    }

    @Override
    @Nullable
    public AnnotationsPosition extractBackingFieldAnnotationsFromProperty(@NotNull FirProperty property, @NotNull FirSession session, @NotNull List<? extends FirAnnotation> propertyAnnotations, @NotNull List<? extends FirAnnotation> backingFieldAnnotations2) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(propertyAnnotations, (String)"propertyAnnotations");
        Intrinsics.checkNotNullParameter(backingFieldAnnotations2, (String)"backingFieldAnnotations");
        if (propertyAnnotations.isEmpty() || property.getBackingField() == null) {
            return null;
        }
        Iterable $this$partition$iv = propertyAnnotations;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FirAnnotation it = (FirAnnotation)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)FirAnnotationUtilsKt.toAnnotationClassIdSafe(it, session), (Object)JvmStandardClassIds.Annotations.Java.INSTANCE.getDeprecated())) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List newBackingFieldAnnotations = (List)pair.component1();
        List newPropertyAnnotations = (List)pair.component2();
        if (newBackingFieldAnnotations.isEmpty()) {
            return null;
        }
        List list2 = CollectionsKt.plus((Collection)backingFieldAnnotations2, (Iterable)newBackingFieldAnnotations);
        return new AnnotationsPosition(list2, newPropertyAnnotations);
    }

    static {
        Object[] objectArray = new ClassId[]{StandardClassIds.Annotations.INSTANCE.getDeprecated(), StandardClassIds.Annotations.INSTANCE.getTarget(), JvmStandardClassIds.Annotations.Java.INSTANCE.getTarget()};
        requiredAnnotationsWithArguments = SetsKt.setOf((Object[])objectArray);
        objectArray = new ClassId[]{JvmStandardClassIds.Annotations.Java.INSTANCE.getDeprecated(), StandardClassIds.Annotations.INSTANCE.getDeprecatedSinceKotlin(), StandardClassIds.Annotations.INSTANCE.getSinceKotlin(), StandardClassIds.Annotations.INSTANCE.getWasExperimental(), JvmStandardClassIds.Annotations.INSTANCE.getJvmRecord()};
        requiredAnnotations = SetsKt.plus(INSTANCE.getRequiredAnnotationsWithArguments(), (Iterable)SetsKt.setOf((Object[])objectArray));
        objectArray = new ClassId[]{StandardClassIds.Annotations.INSTANCE.getVolatile(), JvmStandardClassIds.Annotations.INSTANCE.getJvmVolatile()};
        volatileAnnotations = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)StandardClassIds.Annotations.INSTANCE.getDeprecated(), (Object)true), TuplesKt.to((Object)JvmStandardClassIds.Annotations.Java.INSTANCE.getDeprecated(), (Object)false), TuplesKt.to((Object)StandardClassIds.Annotations.INSTANCE.getSinceKotlin(), (Object)true)};
        deprecationAnnotationsWithOverridesPropagation = MapsKt.mapOf((Pair[])objectArray);
    }
}

