/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsModuleCheckUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00100\u000f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsModuleQualifiedAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkReifiedTypeParameters", "expr", "extractModuleCalleeSymbols", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/AbstractKtSourceElement;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsModuleQualifiedAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsModuleQualifiedAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsModuleQualifiedAccessChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,61:1\n187#2,9:62\n*S KotlinDebug\n*F\n+ 1 FirJsModuleQualifiedAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsModuleQualifiedAccessChecker\n*L\n52#1:62,9\n*E\n"})
public final class FirJsModuleQualifiedAccessChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJsModuleQualifiedAccessChecker INSTANCE = new FirJsModuleQualifiedAccessChecker();

    private FirJsModuleQualifiedAccessChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkReifiedTypeParameters(expression2, context2, reporter);
        List<Pair<FirBasedSymbol<?>, AbstractKtSourceElement>> calleeSymbols = this.extractModuleCalleeSymbols(expression2);
        for (Pair<FirBasedSymbol<?>, AbstractKtSourceElement> pair : calleeSymbols) {
            FirBasedSymbol calleeSymbol = (FirBasedSymbol)pair.component1();
            AbstractKtSourceElement source = (AbstractKtSourceElement)pair.component2();
            AbstractKtSourceElement abstractKtSourceElement = source;
            if (abstractKtSourceElement == null) {
                abstractKtSourceElement = expression2.getSource();
            }
            FirJsModuleCheckUtilsKt.checkJsModuleUsage(calleeSymbol, context2, reporter, abstractKtSourceElement);
        }
    }

    private final List<Pair<FirBasedSymbol<?>, AbstractKtSourceElement>> extractModuleCalleeSymbols(FirQualifiedAccessExpression expression2) {
        List list2;
        FirBasedSymbol calleeSymbol = FirReferenceUtilsKt.toResolvedBaseSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (calleeSymbol != null && FirHelpersKt.getContainingClassSymbol(calleeSymbol, calleeSymbol.getModuleData().getSession()) == null) {
            return CollectionsKt.listOf((Object)TuplesKt.to((Object)calleeSymbol, (Object)expression2.getCalleeReference().getSource()));
        }
        FirExpression receiver = expression2.getDispatchReceiver();
        if (receiver == null) {
            FirBasedSymbol firBasedSymbol = calleeSymbol;
            list2 = CollectionsKt.listOfNotNull(firBasedSymbol != null ? TuplesKt.to((Object)firBasedSymbol, (Object)expression2.getCalleeReference().getSource()) : null);
        } else if (receiver instanceof FirResolvedQualifier) {
            FirClassLikeSymbol<?> classSymbol = ((FirResolvedQualifier)receiver).getSymbol();
            if (expression2 instanceof FirCallableReferenceAccess) {
                Object[] objectArray = new Pair[2];
                FirClassLikeSymbol<?> firClassLikeSymbol = classSymbol;
                objectArray[0] = firClassLikeSymbol != null ? TuplesKt.to(firClassLikeSymbol, (Object)((FirResolvedQualifier)receiver).getSource()) : null;
                FirBasedSymbol firBasedSymbol = calleeSymbol;
                objectArray[1] = firBasedSymbol != null ? TuplesKt.to((Object)firBasedSymbol, (Object)((FirCallableReferenceAccess)expression2).getCalleeReference().getSource()) : null;
                list2 = CollectionsKt.listOfNotNull((Object[])objectArray);
            } else {
                FirClassLikeSymbol<?> firClassLikeSymbol = classSymbol;
                list2 = CollectionsKt.listOfNotNull(firClassLikeSymbol != null ? TuplesKt.to(firClassLikeSymbol, (Object)expression2.getCalleeReference().getSource()) : null);
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReifiedTypeParameters(FirQualifiedAccessExpression expr, CheckerContext context2, DiagnosticReporter reporter) {
        block3: {
            FirFunctionCall firFunctionCall = expr instanceof FirFunctionCall ? (FirFunctionCall)expr : null;
            if (firFunctionCall == null) break block3;
            FirFunctionCall $this$forAllReifiedTypeParameters$iv = firFunctionCall;
            boolean $i$f$forAllReifiedTypeParameters = false;
            FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default($this$forAllReifiedTypeParameters$iv.getCalleeReference(), false, 1, null);
            if (firNamedFunctionSymbol != null) {
                FirNamedFunctionSymbol functionSymbol$iv = firNamedFunctionSymbol;
                for (Pair pair : CollectionsKt.zip((Iterable)functionSymbol$iv.getTypeParameterSymbols(), (Iterable)$this$forAllReifiedTypeParameters$iv.getTypeArguments())) {
                    FirRegularClassSymbol typeArgumentClass;
                    void typeArgument;
                    ConeKotlinType type$iv;
                    FirTypeParameterSymbol typeParameterSymbol$iv = (FirTypeParameterSymbol)pair.component1();
                    FirTypeProjection typeArgument$iv = (FirTypeProjection)pair.component2();
                    if (!typeParameterSymbol$iv.isReified() || !(typeArgument$iv instanceof FirTypeProjectionWithVariance) || FirTypeUtilsKt.getConeTypeOrNull(((FirTypeProjectionWithVariance)typeArgument$iv).getTypeRef()) == null) continue;
                    FirTypeProjectionWithVariance firTypeProjectionWithVariance = (FirTypeProjectionWithVariance)typeArgument$iv;
                    ConeKotlinType type2 = type$iv;
                    boolean bl = false;
                    if (TypeUtilsKt.toRegularClassSymbol(type2, context2.getSession()) == null) continue;
                    KtSourceElement ktSourceElement = typeArgument.getSource();
                    if (ktSourceElement == null && (ktSourceElement = ((FirFunctionCall)expr).getCalleeReference().getSource()) == null) {
                        ktSourceElement = expr.getSource();
                    }
                    KtSourceElement source = ktSourceElement;
                    FirJsModuleCheckUtilsKt.checkJsModuleUsage(typeArgumentClass, context2, reporter, source);
                }
            }
        }
    }
}

