/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Implication;
import org.jetbrains.kotlin.fir.resolve.dfa.LogicSystem;
import org.jetbrains.kotlin.fir.resolve.dfa.LogicSystemKt;
import org.jetbrains.kotlin.fir.resolve.dfa.ModelKt;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.Operation;
import org.jetbrains.kotlin.fir.resolve.dfa.OperationStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Statement;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.VariableStorageImpl;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeIntersector;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0017J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u001cj\u0002`\u001dJ\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fJ\u0018\u0010\u001e\u001a\u00020\u00172\b\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\u0017JF\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u001cj\u0002`\u001d2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u001cj\u0002`\u001d2\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u001cj\u0002`\u001dJB\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u001cj\u0002`\u001d2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110(0\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J.\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u001cj\u0002`\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020*2\u0006\u0010+\u001a\u00020,J&\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u001cj\u0002`\u001d2\u0006\u0010\u000e\u001a\u00020-2\u0006\u0010\u0018\u001a\u00020*J\u001e\u0010.\u001a\u00020,2\u0006\u0010 \u001a\u00020-2\u0006\u0010!\u001a\u00020-2\u0006\u0010/\u001a\u00020\u0014J\u001c\u00100\u001a\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020-0\u001f2\u0006\u00102\u001a\u00020,J\u0016\u00103\u001a\u0004\u0018\u00010\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fJF\u00104\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u001cj\u0002`\u001d2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u001cj\u0002`\u001d2\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u001cj\u0002`\u001dJ\u001e\u00105\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u00142\u0006\u00106\u001a\u000207J6\u00108\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020'2\u0016\b\u0002\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110<J\u001a\u0010=\u001a\u00020\r*\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020-0\u001fH\u0002J\"\u0010>\u001a\u00020\r*\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020-0\u001f2\u0006\u0010?\u001a\u00020-H\u0002J*\u0010@\u001a\u00020\r*\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020-0\u001f2\u0006\u0010?\u001a\u00020-2\u0006\u00102\u001a\u00020,H\u0002J\f\u0010A\u001a\u00020,*\u00020BH\u0014J\u001a\u0010C\u001a\u00020\r*\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020-0\u001fH\u0002J\u0015\u0010D\u001a\u00020\r*\u00020E2\u0006\u0010F\u001a\u00020\u0017H\u0082\u0002J\u001e\u0010G\u001a\u00020\r*\u00020\u000f2\u0006\u0010/\u001a\u00020\u00142\b\u0010H\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem;", "", "context", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "(Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;)V", "anyType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "nullableNothingType", "variableStorage", "Lorg/jetbrains/kotlin/fir/resolve/dfa/VariableStorageImpl;", "getVariableStorage", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/VariableStorageImpl;", "addImplication", "", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;", "implication", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Implication;", "addLocalVariableAlias", "alias", "Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "underlyingVariable", "addTypeStatement", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;", "statement", "addTypeStatements", "", "statements", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatements;", "and", "", "a", "b", "andForTypeStatements", "left", "right", "approveOperationStatement", "logicStatements", "Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "Lkotlinx/collections/immutable/PersistentList;", "approvedStatement", "Lorg/jetbrains/kotlin/fir/resolve/dfa/OperationStatement;", "removeApprovedOrImpossible", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;", "isSameValueIn", "variable", "joinFlow", "flows", "union", "or", "orForTypeStatements", "recordNewAssignment", "index", "", "translateVariableFromConditionInStatements", "originalVariable", "newVariable", "transform", "Lkotlin/Function1;", "copyCommonAliases", "copyNonConflictingAliases", "commonFlow", "copyStatements", "isAcceptableForSmartcast", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "mergeAssignments", "plusAssign", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableTypeStatement;", "other", "replaceVariable", "replacement", "semantics"})
@SourceDebugExtension(value={"SMAP\nLogicSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogicSystem.kt\norg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,395:1\n2661#2,7:396\n1603#2,9:404\n1855#2:413\n1856#2:415\n1612#2:416\n1611#2:417\n1855#2:418\n1856#2:420\n1612#2:421\n1726#2,3:422\n1446#2,5:425\n1855#2:430\n1620#2,3:431\n1611#2:434\n1855#2:435\n1856#2:437\n1612#2:438\n1520#2,3:439\n1523#2,3:449\n1620#2,3:452\n1856#2:455\n1285#2,4:457\n1726#2,3:468\n1747#2,3:471\n1549#2:474\n1620#2,3:475\n1#3:403\n1#3:414\n1#3:419\n1#3:436\n372#4,7:442\n372#4,7:461\n230#5:456\n*S KotlinDebug\n*F\n+ 1 LogicSystem.kt\norg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem\n*L\n31#1:396,7\n60#1:404,9\n60#1:413\n60#1:415\n60#1:416\n84#1:417\n84#1:418\n84#1:420\n84#1:421\n129#1:422,3\n157#1:425,5\n157#1:430\n162#1:431,3\n165#1:434\n165#1:435\n165#1:437\n165#1:438\n169#1:439,3\n169#1:449,3\n178#1:452,3\n157#1:455\n221#1:457,4\n319#1:468,3\n320#1:471,3\n321#1:474\n321#1:475,3\n60#1:414\n84#1:419\n165#1:436\n169#1:442,7\n245#1:461,7\n219#1:456\n*E\n"})
public abstract class LogicSystem {
    @NotNull
    private final ConeInferenceContext context;
    @NotNull
    private final ConeClassLikeType nullableNothingType;
    @NotNull
    private final ConeClassLikeType anyType;

    public LogicSystem(@NotNull ConeInferenceContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.nullableNothingType = this.context.getSession().getBuiltinTypes().getNullableNothingType().getType();
        this.anyType = this.context.getSession().getBuiltinTypes().getAnyType().getType();
    }

    @NotNull
    public abstract VariableStorageImpl getVariableStorage();

    protected boolean isAcceptableForSmartcast(@NotNull ConeKotlinType $this$isAcceptableForSmartcast) {
        Intrinsics.checkNotNullParameter((Object)$this$isAcceptableForSmartcast, (String)"<this>");
        return !ConeBuiltinTypeUtilsKt.isNullableNothing($this$isAcceptableForSmartcast);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MutableFlow joinFlow(@NotNull Collection<PersistentFlow> flows, boolean union) {
        Intrinsics.checkNotNullParameter(flows, (String)"flows");
        switch (flows.size()) {
            case 0: {
                return new MutableFlow();
            }
            case 1: {
                return ((PersistentFlow)CollectionsKt.first((Iterable)flows)).fork();
            }
        }
        Iterable $this$reduce$iv = flows;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            PersistentFlow persistentFlow = (PersistentFlow)iterator$iv.next();
            PersistentFlow a = (PersistentFlow)accumulator$iv;
            boolean bl = false;
            if (a.lowestCommonAncestor((PersistentFlow)b) != null) continue;
            throw new IllegalStateException(("no common ancestor in " + a + ", " + b).toString());
        }
        PersistentFlow commonFlow = (PersistentFlow)accumulator$iv;
        MutableFlow result2 = commonFlow.fork();
        this.mergeAssignments(result2, flows);
        if (union) {
            this.copyNonConflictingAliases(result2, flows, commonFlow);
        } else {
            this.copyCommonAliases(result2, flows);
        }
        this.copyStatements(result2, flows, commonFlow, union);
        return result2;
    }

    public final void addLocalVariableAlias(@NotNull MutableFlow flow, @NotNull RealVariable alias, @NotNull RealVariable underlyingVariable) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)underlyingVariable, (String)"underlyingVariable");
        if (Intrinsics.areEqual((Object)underlyingVariable, (Object)alias)) {
            return;
        }
        ((Map)flow.getDirectAliasMap$semantics()).put(alias, underlyingVariable);
        Map map = (Map)flow.getBackwardsAliasMap$semantics();
        PersistentSet persistentSet = (PersistentSet)flow.getBackwardsAliasMap$semantics().get((Object)underlyingVariable);
        if (persistentSet == null || (persistentSet = persistentSet.add((Object)alias)) == null) {
            Object[] objectArray = new RealVariable[]{alias};
            persistentSet = ExtensionsKt.persistentSetOf((Object[])objectArray);
        }
        PersistentSet persistentSet2 = persistentSet;
        map.put(underlyingVariable, persistentSet2);
    }

    @Nullable
    public final TypeStatement addTypeStatement(@NotNull MutableFlow flow, @NotNull TypeStatement statement2) {
        PersistentTypeStatement persistentTypeStatement;
        PersistentSet newExactType;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        if (statement2.getExactType().isEmpty()) {
            return null;
        }
        RealVariable variable2 = statement2.getVariable();
        PersistentTypeStatement persistentTypeStatement2 = (PersistentTypeStatement)flow.getApprovedTypeStatements$semantics().get((Object)variable2);
        Object oldExactType = persistentTypeStatement2 != null ? persistentTypeStatement2.getExactType() : null;
        PersistentSet persistentSet = oldExactType;
        if (persistentSet == null || (persistentSet = persistentSet.addAll((Collection)statement2.getExactType())) == null) {
            persistentSet = ExtensionsKt.toPersistentSet((Iterable)statement2.getExactType());
        }
        if ((newExactType = persistentSet) == oldExactType) {
            return null;
        }
        PersistentTypeStatement it = persistentTypeStatement = new PersistentTypeStatement(variable2, (PersistentSet<? extends ConeKotlinType>)newExactType);
        boolean bl = false;
        ((Map)flow.getApprovedTypeStatements$semantics()).put(variable2, it);
        return persistentTypeStatement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TypeStatement> addTypeStatements(@NotNull MutableFlow flow, @NotNull Map<RealVariable, ? extends TypeStatement> statements2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter(statements2, (String)"statements");
        Iterable $this$mapNotNull$iv = statements2.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeStatement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            TypeStatement it = (TypeStatement)element$iv$iv;
            boolean bl2 = false;
            if (this.addTypeStatement(flow, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void addImplication(@NotNull MutableFlow flow, @NotNull Implication implication) {
        block5: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
                Intrinsics.checkNotNullParameter((Object)implication, (String)"implication");
                Statement effect = implication.getEffect();
                if (Intrinsics.areEqual((Object)effect, (Object)implication.getCondition())) {
                    return;
                }
                if (!(effect instanceof TypeStatement)) break block5;
                if (((TypeStatement)effect).isEmpty()) break block6;
                PersistentSet<ConeKotlinType> persistentSet = (PersistentSet<ConeKotlinType>)flow.getApprovedTypeStatements$semantics().get((Object)((TypeStatement)effect).getVariable());
                boolean bl = persistentSet != null && (persistentSet = persistentSet.getExactType()) != null ? persistentSet.containsAll((Collection)((TypeStatement)effect).getExactType()) : false;
                if (!bl) break block5;
            }
            return;
        }
        DataFlowVariable variable2 = implication.getCondition().getVariable();
        Map map = (Map)flow.getLogicStatements$semantics();
        PersistentList persistentList = (PersistentList)flow.getLogicStatements$semantics().get((Object)variable2);
        if (persistentList == null || (persistentList = persistentList.add((Object)implication)) == null) {
            Object[] objectArray = new Implication[]{implication};
            persistentList = ExtensionsKt.persistentListOf((Object[])objectArray);
        }
        PersistentList persistentList2 = persistentList;
        map.put(variable2, persistentList2);
    }

    /*
     * WARNING - void declaration
     */
    public final void translateVariableFromConditionInStatements(@NotNull MutableFlow flow, @NotNull DataFlowVariable originalVariable, @NotNull DataFlowVariable newVariable, @NotNull Function1<? super Implication, Implication> transform2) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)originalVariable, (String)"originalVariable");
        Intrinsics.checkNotNullParameter((Object)newVariable, (String)"newVariable");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        PersistentList statements2 = ModelKt.isSynthetic(originalVariable) ? (PersistentList)flow.getLogicStatements$semantics().remove((Object)originalVariable) : (PersistentList)flow.getLogicStatements$semantics().get((Object)originalVariable);
        Collection collection = (Collection)statements2;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        PersistentList persistentList = (PersistentList)flow.getLogicStatements$semantics().get((Object)newVariable);
        if (persistentList == null) {
            persistentList = ExtensionsKt.persistentListOf();
        }
        PersistentList existing = persistentList;
        Map map = (Map)flow.getLogicStatements$semantics();
        Iterable iterable = (Iterable)statements2;
        Collection destination$iv = (Collection)existing.builder();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Implication it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Implication it = (Implication)element$iv;
            boolean bl2 = false;
            if ((Implication)transform2.invoke((Object)ModelKt.implies(new OperationStatement(newVariable, it.getCondition().getOperation()), it.getEffect())) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        iterable = ((PersistentList.Builder)destination$iv).build();
        map.put(newVariable, iterable);
    }

    public static /* synthetic */ void translateVariableFromConditionInStatements$default(LogicSystem logicSystem2, MutableFlow mutableFlow, DataFlowVariable dataFlowVariable, DataFlowVariable dataFlowVariable2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: translateVariableFromConditionInStatements");
        }
        if ((n & 8) != 0) {
            function1 = translateVariableFromConditionInStatements.1.INSTANCE;
        }
        logicSystem2.translateVariableFromConditionInStatements(mutableFlow, dataFlowVariable, dataFlowVariable2, (Function1<? super Implication, Implication>)function1);
    }

    @NotNull
    public final Map<RealVariable, TypeStatement> approveOperationStatement(@NotNull PersistentFlow flow, @NotNull OperationStatement statement2) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        return this.approveOperationStatement((Map)flow.getLogicStatements$semantics(), statement2, false);
    }

    @NotNull
    public final Map<RealVariable, TypeStatement> approveOperationStatement(@NotNull MutableFlow flow, @NotNull OperationStatement statement2, boolean removeApprovedOrImpossible) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        return this.approveOperationStatement((Map)flow.getLogicStatements$semantics(), statement2, removeApprovedOrImpossible);
    }

    public final void recordNewAssignment(@NotNull MutableFlow flow, @NotNull RealVariable variable2, int index2) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        this.replaceVariable(flow, variable2, null);
        Integer n = index2;
        ((Map)flow.getAssignmentIndex$semantics()).put(variable2, n);
    }

    public final boolean isSameValueIn(@NotNull PersistentFlow a, @NotNull PersistentFlow b, @NotNull RealVariable variable2) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        return Intrinsics.areEqual((Object)a.getAssignmentIndex$semantics().get((Object)variable2), (Object)b.getAssignmentIndex$semantics().get((Object)variable2));
    }

    private final void mergeAssignments(MutableFlow $this$mergeAssignments, Collection<PersistentFlow> flows) {
        Map reassignedVariables = new LinkedHashMap();
        for (PersistentFlow entry : flows) {
            for (Map.Entry entry2 : ((Map)entry.getAssignmentIndex$semantics()).entrySet()) {
                RealVariable variable2 = (RealVariable)entry2.getKey();
                int index2 = ((Number)entry2.getValue()).intValue();
                Integer n = (Integer)$this$mergeAssignments.getAssignmentIndex$semantics().get((Object)variable2);
                int n2 = index2;
                if (n != null && n == n2) continue;
                Map map = reassignedVariables;
                Integer n3 = (Integer)reassignedVariables.get(variable2);
                int n4 = n3 != null ? n3 : 0;
                Integer n5 = Math.max(index2, n4);
                map.put(variable2, n5);
            }
        }
        for (Map.Entry entry : reassignedVariables.entrySet()) {
            RealVariable variable3 = (RealVariable)entry.getKey();
            int index3 = ((Number)entry.getValue()).intValue();
            this.recordNewAssignment($this$mergeAssignments, variable3, index3);
        }
    }

    private final void copyCommonAliases(MutableFlow $this$copyCommonAliases, Collection<PersistentFlow> flows) {
        for (Map.Entry entry : ((Map)((PersistentFlow)CollectionsKt.first((Iterable)flows)).getDirectAliasMap$semantics()).entrySet()) {
            boolean bl;
            RealVariable to;
            RealVariable from2;
            block4: {
                from2 = (RealVariable)entry.getKey();
                to = (RealVariable)entry.getValue();
                if (Intrinsics.areEqual((Object)$this$copyCommonAliases.getDirectAliasMap$semantics().get((Object)from2), (Object)to)) continue;
                Iterable $this$all$iv = flows;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PersistentFlow it = (PersistentFlow)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.unwrapVariable(from2), (Object)to)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            this.addLocalVariableAlias($this$copyCommonAliases, from2, to);
        }
    }

    private final void copyNonConflictingAliases(MutableFlow $this$copyNonConflictingAliases, Collection<PersistentFlow> flows, PersistentFlow commonFlow) {
        Map candidates2 = new LinkedHashMap();
        for (PersistentFlow entry : flows) {
            for (Map.Entry entry2 : ((Map)entry.getDirectAliasMap$semantics()).entrySet()) {
                RealVariable from2 = (RealVariable)entry2.getKey();
                RealVariable to = (RealVariable)entry2.getValue();
                Map map = candidates2;
                if (Intrinsics.areEqual((Object)commonFlow.getAssignmentIndex$semantics().get((Object)from2), (Object)entry.getAssignmentIndex$semantics().get((Object)from2))) continue;
                RealVariable realVariable2 = candidates2.containsKey(from2) && !Intrinsics.areEqual(candidates2.get(from2), (Object)to) ? null : to;
                map.put(from2, realVariable2);
            }
        }
        for (Map.Entry entry : candidates2.entrySet()) {
            RealVariable from3 = (RealVariable)entry.getKey();
            RealVariable to = (RealVariable)entry.getValue();
            RealVariable realVariable3 = to;
            if (realVariable3 == null) continue;
            this.addLocalVariableAlias($this$copyNonConflictingAliases, from3, realVariable3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void copyStatements(MutableFlow $this$copyStatements, Collection<PersistentFlow> flows, PersistentFlow commonFlow, boolean union) {
        void $this$forEach$iv;
        void destination$iv;
        Iterable $this$flatMapTo$iv;
        Iterable iterable = flows;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            PersistentFlow it = (PersistentFlow)element$iv;
            boolean bl2 = false;
            Iterable list$iv = it.getKnownVariables();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = (Iterable)destination$iv;
        boolean $i$f$forEach = false;
        block1: for (Object element$iv : $this$forEach$iv) {
            TypeStatement statement2;
            TypeStatement typeStatement;
            Iterator it;
            Iterable iterable2;
            Iterable destination$iv2;
            Iterable $this$mapTo$iv;
            Object object;
            RealVariable variable2 = (RealVariable)element$iv;
            boolean bl = false;
            if (((Map)$this$copyStatements.getDirectAliasMap$semantics()).containsKey(variable2)) continue;
            if (!union) {
                Iterable bl2 = flows;
                Collection collection2 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    PersistentFlow persistentFlow = (PersistentFlow)item$iv;
                    iterable2 = destination$iv2;
                    boolean bl3 = false;
                    TypeStatement typeStatement2 = ((PersistentFlow)((Object)it)).getTypeStatement(variable2);
                    if (typeStatement2 == null) continue block1;
                    iterable2.add(typeStatement2);
                }
                typeStatement = ((LogicSystem)object).or((Collection<? extends TypeStatement>)destination$iv2);
            } else if (Intrinsics.areEqual((Object)$this$copyStatements.getAssignmentIndex$semantics().get((Object)variable2), (Object)commonFlow.getAssignmentIndex$semantics().get((Object)variable2))) {
                void $this$mapNotNullTo$iv;
                $this$mapTo$iv = flows;
                destination$iv2 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach2 = false;
                it = $this$forEach$iv$iv.iterator();
                while (it.hasNext()) {
                    TypeStatement it$iv;
                    Object element$iv$iv;
                    Object element$iv2 = element$iv$iv = it.next();
                    boolean bl4 = false;
                    PersistentFlow it2 = (PersistentFlow)element$iv2;
                    boolean bl5 = false;
                    if (it2.getTypeStatement(variable2) == null) continue;
                    boolean bl6 = false;
                    destination$iv2.add(it$iv);
                }
                typeStatement = ((LogicSystem)object).and((Collection<? extends TypeStatement>)destination$iv2);
            } else {
                void $this$mapTo$iv2;
                Collection destination$iv3;
                Iterable $this$groupByTo$iv;
                destination$iv2 = flows;
                Map $i$f$mapNotNullTo = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv3 : $this$groupByTo$iv) {
                    Object object2;
                    PersistentFlow it3 = (PersistentFlow)element$iv3;
                    boolean bl7 = false;
                    Integer n = (Integer)it3.getAssignmentIndex$semantics().get((Object)variable2);
                    Integer key$iv = n != null ? n : -1;
                    void $this$getOrPut$iv$iv = destination$iv3;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
                    if (value$iv$iv == null) {
                        boolean bl8 = false;
                        List answer$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                        object2 = answer$iv$iv;
                    } else {
                        object2 = value$iv$iv;
                    }
                    List list$iv = (List)object2;
                    it3 = (PersistentFlow)element$iv3;
                    object = list$iv;
                    boolean bl9 = false;
                    object.add(it3.getTypeStatement(variable2));
                }
                void byAssignment = destination$iv3;
                Integer n = (Integer)commonFlow.getAssignmentIndex$semantics().get((Object)variable2);
                byAssignment.remove(n != null ? n : -1);
                $this$groupByTo$iv = byAssignment.values();
                destination$iv3 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv2) {
                    List it4 = (List)item$iv;
                    iterable2 = destination$iv3;
                    boolean bl10 = false;
                    TypeStatement typeStatement3 = this.and(CollectionsKt.filterNotNull((Iterable)it4));
                    if (typeStatement3 == null) continue block1;
                    iterable2.add(typeStatement3);
                }
                typeStatement = ((LogicSystem)object).or(destination$iv3);
            }
            TypeStatement typeStatement4 = statement2 = typeStatement;
            boolean bl11 = typeStatement4 != null ? typeStatement4.isNotEmpty() : false;
            if (!bl11) continue;
            ((Map)$this$copyStatements.getApprovedTypeStatements$semantics()).put(variable2, LogicSystemKt.access$toPersistent(statement2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceVariable(MutableFlow $this$replaceVariable, RealVariable variable2, RealVariable replacement) {
        RealVariable original = (RealVariable)$this$replaceVariable.getDirectAliasMap$semantics().remove((Object)variable2);
        if (original != null) {
            PersistentSet siblings2;
            if (AbstractTypeChecker.RUN_SLOW_ASSERTIONS) {
                boolean bl;
                boolean bl2 = bl = !((Map)$this$replaceVariable.getBackwardsAliasMap$semantics()).containsKey(variable2);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                boolean bl3 = bl = !((Map)$this$replaceVariable.getLogicStatements$semantics()).containsKey(variable2);
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                boolean bl4 = bl = !((Map)$this$replaceVariable.getApprovedTypeStatements$semantics()).containsKey(variable2);
                if (_Assertions.ENABLED && !bl) {
                    String string4 = "Assertion failed";
                    throw new AssertionError((Object)string4);
                }
            }
            if ((siblings2 = (PersistentSet)MapsKt.getValue((Map)((Map)$this$replaceVariable.getBackwardsAliasMap$semantics()), (Object)original)).size() > 1) {
                ((Map)$this$replaceVariable.getBackwardsAliasMap$semantics()).put(original, siblings2.remove((Object)variable2));
            } else {
                $this$replaceVariable.getBackwardsAliasMap$semantics().remove((Object)original);
            }
            if (replacement != null) {
                this.addLocalVariableAlias($this$replaceVariable, replacement, original);
            }
        } else {
            Object object;
            MutableFlow mutableFlow;
            RealVariable realVariable2;
            PersistentSet aliases = (PersistentSet)$this$replaceVariable.getBackwardsAliasMap$semantics().remove((Object)variable2);
            RealVariable realVariable3 = replacement;
            if (realVariable3 == null) {
                PersistentSet persistentSet = aliases;
                realVariable3 = persistentSet != null ? (RealVariable)CollectionsKt.first((Iterable)((Iterable)persistentSet)) : null;
            }
            RealVariable replacementOrNext = realVariable3;
            for (RealVariable dependent : variable2.getDependentVariables()) {
                RealVariable realVariable4;
                LogicSystem logicSystem2 = this;
                MutableFlow mutableFlow2 = $this$replaceVariable;
                RealVariable realVariable5 = dependent;
                if (replacementOrNext != null) {
                    void it;
                    realVariable2 = realVariable5;
                    mutableFlow = mutableFlow2;
                    object = logicSystem2;
                    boolean bl = false;
                    RealVariable realVariable6 = this.getVariableStorage().copyRealVariableWithRemapping(dependent, variable2, (RealVariable)it);
                    logicSystem2 = object;
                    mutableFlow2 = mutableFlow;
                    realVariable5 = realVariable2;
                    realVariable4 = realVariable6;
                } else {
                    realVariable4 = null;
                }
                logicSystem2.replaceVariable(mutableFlow2, realVariable5, realVariable4);
            }
            LogicSystemKt.access$replaceVariableInImplications((Map)$this$replaceVariable.getLogicStatements$semantics(), variable2, replacementOrNext);
            LogicSystemKt.access$replaceVariableInStatements((Map)$this$replaceVariable.getApprovedTypeStatements$semantics(), variable2, replacementOrNext);
            if (aliases != null && replacementOrNext != null) {
                ((Map)$this$replaceVariable.getDirectAliasMap$semantics()).remove(replacementOrNext);
                Object $this$minus$iv = aliases;
                boolean $i$f$minus = false;
                PersistentSet withoutSelf = $this$minus$iv.remove((Object)replacementOrNext);
                if (!((Collection)withoutSelf).isEmpty()) {
                    void $this$associateWithTo$iv;
                    $this$minus$iv = (Iterable)withoutSelf;
                    Map destination$iv = (Map)$this$replaceVariable.getDirectAliasMap$semantics();
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv : $this$associateWithTo$iv) {
                        RealVariable realVariable7 = (RealVariable)element$iv;
                        mutableFlow = element$iv;
                        object = destination$iv;
                        boolean bl = false;
                        realVariable2 = replacementOrNext;
                        object.put(mutableFlow, realVariable2);
                    }
                    Map map = (Map)$this$replaceVariable.getBackwardsAliasMap$semantics();
                    PersistentSet persistentSet = (PersistentSet)$this$replaceVariable.getBackwardsAliasMap$semantics().get((Object)replacementOrNext);
                    if (persistentSet == null || (persistentSet = persistentSet.addAll((Collection)withoutSelf)) == null) {
                        persistentSet = withoutSelf;
                    }
                    PersistentSet persistentSet2 = persistentSet;
                    map.put(replacementOrNext, persistentSet2);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<RealVariable, TypeStatement> approveOperationStatement(Map<DataFlowVariable, ? extends PersistentList<Implication>> logicStatements, OperationStatement approvedStatement, boolean removeApprovedOrImpossible) {
        LinkedList<OperationStatement> linkedList;
        Map result2 = new LinkedHashMap();
        LinkedList<OperationStatement> $this$approveOperationStatement_u24lambda_u2414 = linkedList = new LinkedList<OperationStatement>();
        boolean bl = false;
        ((Collection)$this$approveOperationStatement_u24lambda_u2414).add(approvedStatement);
        LinkedList<OperationStatement> queue = linkedList;
        Set approved = new LinkedHashSet();
        while (!((Collection)queue).isEmpty()) {
            PersistentList<Implication> statements2;
            PersistentList stillUnknown2;
            OperationStatement next = (OperationStatement)queue.removeFirst();
            if (!removeApprovedOrImpossible) {
                Intrinsics.checkNotNull((Object)next);
                if (!approved.add(next)) continue;
            }
            Operation operation = next.getOperation();
            DataFlowVariable variable2 = next.getVariable();
            if (ModelKt.isReal(variable2)) {
                Object object;
                void $this$getOrPut$iv;
                ConeClassLikeType impliedType = operation == Operation.EqNull ? this.nullableNothingType : this.anyType;
                Map map = result2;
                DataFlowVariable key$iv = variable2;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    MutableTypeStatement answer$iv = new MutableTypeStatement((RealVariable)variable2, null, 2, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((MutableTypeStatement)object).getExactType().add(impliedType);
            }
            if (logicStatements.get(variable2) == null || Intrinsics.areEqual((Object)(stillUnknown2 = statements2.removeAll((Function1)new Function1<Implication, Boolean>(operation, queue, this, (Map<RealVariable, MutableTypeStatement>)result2, removeApprovedOrImpossible){
                final /* synthetic */ Operation $operation;
                final /* synthetic */ LinkedList<OperationStatement> $queue;
                final /* synthetic */ LogicSystem this$0;
                final /* synthetic */ Map<RealVariable, MutableTypeStatement> $result;
                final /* synthetic */ boolean $removeApprovedOrImpossible;
                {
                    this.$operation = $operation;
                    this.$queue = $queue;
                    this.this$0 = $receiver;
                    this.$result = $result;
                    this.$removeApprovedOrImpossible = $removeApprovedOrImpossible;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke(@NotNull Implication it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Boolean knownValue = it.getCondition().getOperation().valueIfKnown(this.$operation);
                    if (Intrinsics.areEqual((Object)knownValue, (Object)true)) {
                        Statement effect = it.getEffect();
                        if (effect instanceof OperationStatement) {
                            ((Collection)this.$queue).add(effect);
                        } else if (effect instanceof TypeStatement) {
                            Object object;
                            void $this$getOrPut$iv;
                            LogicSystem logicSystem2 = this.this$0;
                            Map<RealVariable, MutableTypeStatement> map = this.$result;
                            RealVariable key$iv = ((TypeStatement)effect).getVariable();
                            boolean $i$f$getOrPut = false;
                            V value$iv = $this$getOrPut$iv.get(key$iv);
                            if (value$iv == null) {
                                LogicSystem logicSystem3 = logicSystem2;
                                boolean bl = false;
                                logicSystem2 = logicSystem3;
                                MutableTypeStatement answer$iv = new MutableTypeStatement(((TypeStatement)effect).getVariable(), null, 2, null);
                                $this$getOrPut$iv.put(key$iv, answer$iv);
                                object = answer$iv;
                            } else {
                                object = value$iv;
                            }
                            LogicSystem.access$plusAssign(logicSystem2, (MutableTypeStatement)object, (TypeStatement)effect);
                        }
                    }
                    return this.$removeApprovedOrImpossible && knownValue != null;
                }
            })), statements2) || !TypeIntrinsics.isMutableMap(logicStatements)) continue;
            if (stillUnknown2.isEmpty()) {
                logicStatements.remove(variable2);
                continue;
            }
            logicStatements.put(variable2, (PersistentList<Implication>)stillUnknown2);
        }
        return result2;
    }

    @NotNull
    public final Map<RealVariable, TypeStatement> orForTypeStatements(@NotNull Map<RealVariable, ? extends TypeStatement> left, @NotNull Map<RealVariable, ? extends TypeStatement> right) {
        Map map;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left.isEmpty()) {
            map = left;
        } else if (right.isEmpty()) {
            map = right;
        } else {
            Map map2;
            Map $this$orForTypeStatements_u24lambda_u2416 = map2 = MapsKt.createMapBuilder();
            boolean bl = false;
            for (Map.Entry<RealVariable, TypeStatement> entry : left.entrySet()) {
                RealVariable variable2 = entry.getKey();
                TypeStatement leftStatement = entry.getValue();
                Object[] objectArray = new TypeStatement[2];
                objectArray[0] = leftStatement;
                if (right.get(variable2) == null) continue;
                objectArray[1] = objectArray[1];
                TypeStatement typeStatement = this.or(CollectionsKt.listOf((Object[])objectArray));
                if (typeStatement == null) continue;
                $this$orForTypeStatements_u24lambda_u2416.put(variable2, typeStatement);
            }
            map = MapsKt.build((Map)map2);
        }
        return map;
    }

    @NotNull
    public final Map<RealVariable, TypeStatement> andForTypeStatements(@NotNull Map<RealVariable, ? extends TypeStatement> left, @NotNull Map<RealVariable, ? extends TypeStatement> right) {
        Map map;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left.isEmpty()) {
            map = right;
        } else if (right.isEmpty()) {
            map = left;
        } else {
            Map map2;
            Map $this$andForTypeStatements_u24lambda_u2417 = map2 = MapsKt.toMutableMap(left);
            boolean bl = false;
            for (Map.Entry<RealVariable, TypeStatement> entry : right.entrySet()) {
                RealVariable variable2 = entry.getKey();
                TypeStatement rightStatement = entry.getValue();
                $this$andForTypeStatements_u24lambda_u2417.put(variable2, this.and((TypeStatement)$this$andForTypeStatements_u24lambda_u2417.get(variable2), rightStatement));
            }
            map = map2;
        }
        return map;
    }

    private final void plusAssign(MutableTypeStatement $this$plusAssign, TypeStatement other) {
        Intrinsics.checkNotNullParameter((Object)$this$plusAssign, (String)"<this>");
        CollectionsKt.addAll((Collection)$this$plusAssign.getExactType(), (Iterable)other.getExactType());
    }

    @NotNull
    public final TypeStatement and(@Nullable TypeStatement a, @NotNull TypeStatement b) {
        TypeStatement typeStatement;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        TypeStatement typeStatement2 = a;
        if (typeStatement2 != null && (typeStatement2 = LogicSystemKt.access$toMutable(typeStatement2)) != null) {
            TypeStatement typeStatement3;
            TypeStatement $this$and_u24lambda_u2418 = typeStatement3 = typeStatement2;
            boolean bl = false;
            this.plusAssign((MutableTypeStatement)$this$and_u24lambda_u2418, b);
            typeStatement = typeStatement3;
        } else {
            typeStatement = b;
        }
        return typeStatement;
    }

    @Nullable
    public final TypeStatement and(@NotNull Collection<? extends TypeStatement> statements2) {
        Intrinsics.checkNotNullParameter(statements2, (String)"statements");
        switch (statements2.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (TypeStatement)CollectionsKt.first((Iterable)statements2);
            }
        }
        Iterator<? extends TypeStatement> iterator2 = statements2.iterator();
        MutableTypeStatement result2 = LogicSystemKt.access$toMutable(iterator2.next());
        while (iterator2.hasNext()) {
            this.plusAssign(result2, iterator2.next());
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TypeStatement or(@NotNull Collection<? extends TypeStatement> statements2) {
        ConeKotlinType coneKotlinType;
        void $this$mapTo$iv$iv;
        boolean bl;
        Object element$iv2;
        RealVariable variable2;
        block19: {
            boolean $this$all$iv2;
            TypeStatement it;
            block18: {
                boolean bl2;
                Intrinsics.checkNotNullParameter(statements2, (String)"statements");
                switch (statements2.size()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return (TypeStatement)CollectionsKt.first((Iterable)statements2);
                    }
                }
                variable2 = ((TypeStatement)CollectionsKt.first((Iterable)statements2)).getVariable();
                Iterable $this$all$iv2 = statements2;
                boolean $i$f$all = false;
                if (((Collection)$this$all$iv2).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv2) {
                        it = (TypeStatement)element$iv2;
                        boolean bl3 = false;
                        if (Intrinsics.areEqual((Object)it.getVariable(), (Object)variable2)) continue;
                        bl2 = false;
                        break block18;
                    }
                    bl2 = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                boolean $i$a$-assert-LogicSystem$or$32 = false;
                String $i$a$-assert-LogicSystem$or$32 = "folding statements for different variables";
                throw new AssertionError((Object)$i$a$-assert-LogicSystem$or$32);
            }
            Iterable $this$any$iv = statements2;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    it = (TypeStatement)element$iv2;
                    boolean bl4 = false;
                    if (!it.isEmpty()) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        Iterable $this$map$iv = statements2;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeStatement typeStatement = (TypeStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(ConeTypeIntersector.INSTANCE.intersectTypes(this.context, CollectionsKt.toList((Iterable)it.getExactType())));
        }
        List intersected = (List)destination$iv$iv;
        ConeKotlinType coneKotlinType2 = TypeUtilsKt.commonSuperTypeOrNull(this.context, intersected);
        if (coneKotlinType2 == null) {
            return null;
        }
        ConeKotlinType unified = coneKotlinType2;
        if (ConeBuiltinTypeUtilsKt.isNullableAny(unified)) {
            return null;
        }
        if (this.isAcceptableForSmartcast(unified)) {
            coneKotlinType = unified;
        } else {
            if (FirTypeUtilsKt.getCanBeNull(unified)) {
                return null;
            }
            coneKotlinType = this.context.anyType();
        }
        ConeKotlinType result2 = coneKotlinType;
        Object[] objectArray = new ConeKotlinType[]{result2};
        return new PersistentTypeStatement(variable2, (PersistentSet<? extends ConeKotlinType>)ExtensionsKt.persistentSetOf((Object[])objectArray));
    }

    public static final /* synthetic */ void access$plusAssign(LogicSystem $this, MutableTypeStatement $receiver, TypeStatement other) {
        $this.plusAssign($receiver, other);
    }
}

