/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u0002H\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u000f*\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmNameChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "findJvmNameAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "isRenamableFunction", "", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "isValueClassThatRequiresMangling", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmNameChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmNameChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n40#2:76\n34#2:77\n43#2:80\n288#3,2:78\n*S KotlinDebug\n*F\n+ 1 FirJvmNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmNameChecker\n*L\n50#1:76\n51#1:77\n72#1:80\n60#1:78,2\n*E\n"})
public final class FirJvmNameChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmNameChecker INSTANCE = new FirJvmNameChecker();

    private FirJvmNameChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block9: {
            FirAnnotation jvmName2;
            block10: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                    FirAnnotation firAnnotation = this.findJvmNameAnnotation(declaration);
                    if (firAnnotation == null) {
                        return;
                    }
                    jvmName2 = firAnnotation;
                    FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName(jvmName2, StandardNames.NAME);
                    if (firExpression2 == null) {
                        return;
                    }
                    FirExpression name2 = firExpression2;
                    if (!Intrinsics.areEqual((Object)FirTypeUtilsKt.getResolvedType(name2), (Object)context2.getSession().getBuiltinTypes().getStringType().getType())) {
                        return;
                    }
                    FirConstExpression firConstExpression = name2 instanceof FirConstExpression ? (FirConstExpression)name2 : null;
                    Object t = firConstExpression != null ? firConstExpression.getValue() : null;
                    String string2 = t instanceof String ? (String)t : null;
                    if (string2 == null) {
                        return;
                    }
                    String value2 = string2;
                    if (!Name.isValidIdentifier(value2)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmName2.getSource(), FirJvmErrors.INSTANCE.getILLEGAL_JVM_NAME(), (DiagnosticContext)context2, null, 8, null);
                    }
                    if (!(declaration instanceof FirFunction) || this.isRenamableFunction(context2, (FirFunction)declaration)) break block8;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmName2.getSource(), FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_NAME(), (DiagnosticContext)context2, null, 8, null);
                    break block9;
                }
                if (!(declaration instanceof FirCallableDeclaration)) break block9;
                FirRegularClass containingClass = ResolveUtilsKt.getContainingClass((FirCallableDeclaration)declaration, context2.getSession());
                FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$isOverride = false;
                if ($this$isOverride$iv.getStatus().isOverride()) break block10;
                FirMemberDeclaration $this$isOverridable$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$isOverridable = false;
                if ($this$isOverridable$iv.getStatus().getModality() != Modality.FINAL && !Intrinsics.areEqual((Object)$this$isOverridable$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) break block10;
                FirRegularClass firRegularClass = containingClass;
                boolean bl = firRegularClass != null ? this.isValueClassThatRequiresMangling(firRegularClass) : false;
                if (!bl) break block9;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmName2.getSource(), FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_NAME(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final FirAnnotation findJvmNameAnnotation(FirDeclaration $this$findJvmNameAnnotation) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findJvmNameAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirAnnotation it = (FirAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef())), (Object)StandardClassIds.Annotations.INSTANCE.getJvmName())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean isRenamableFunction(CheckerContext $this$isRenamableFunction, FirFunction function2) {
        FirClassLikeSymbol<?> containingClass = FirHelpersKt.getContainingClassSymbol(function2, $this$isRenamableFunction.getSession());
        return containingClass != null || !function2.getSymbol().getCallableId().isLocal();
    }

    private final boolean isValueClassThatRequiresMangling(FirRegularClass $this$isValueClassThatRequiresMangling) {
        FirMemberDeclaration $this$isInline$iv = $this$isValueClassThatRequiresMangling;
        boolean $i$f$isInline = false;
        return $this$isInline$iv.getStatus().isInline() && !Intrinsics.areEqual((Object)$this$isValueClassThatRequiresMangling.getName(), (Object)StandardClassIds.INSTANCE.getResult().getShortClassName());
    }
}

