/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMultipleDefaultsInheritedFromSupertypesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkFunction", "function", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMultipleDefaultsInheritedFromSupertypesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMultipleDefaultsInheritedFromSupertypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMultipleDefaultsInheritedFromSupertypesChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n95#2,3:62\n1774#3,4:65\n*S KotlinDebug\n*F\n+ 1 FirMultipleDefaultsInheritedFromSupertypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMultipleDefaultsInheritedFromSupertypesChecker\n*L\n38#1:62,3\n43#1:65,4\n*E\n"})
public final class FirMultipleDefaultsInheritedFromSupertypesChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirMultipleDefaultsInheritedFromSupertypesChecker INSTANCE = new FirMultipleDefaultsInheritedFromSupertypesChecker();

    private FirMultipleDefaultsInheritedFromSupertypesChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirContainingNamesAwareScopeKt.processAllFunctions(FirHelpersKt.unsubstitutedScope(declaration, context2), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(declaration, context2, reporter){
            final /* synthetic */ FirRegularClass $declaration;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$declaration = $declaration;
                this.$context = $context;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FirMultipleDefaultsInheritedFromSupertypesChecker.access$checkFunction(FirMultipleDefaultsInheritedFromSupertypesChecker.INSTANCE, this.$declaration, it, this.$context, this.$reporter);
            }
        }));
    }

    private final void checkFunction(FirRegularClass declaration, FirNamedFunctionSymbol function2, CheckerContext context2, DiagnosticReporter reporter) {
        Collection<FirCallableSymbol<?>> collection;
        if (function2 instanceof FirIntersectionOverrideFunctionSymbol) {
            Collection<FirCallableSymbol<?>> $this$castAll$iv = ((FirIntersectionOverrideFunctionSymbol)function2).getIntersections();
            boolean $i$f$castAll = false;
            Iterator<FirCallableSymbol<?>> iterator2 = $this$castAll$iv.iterator();
            while (iterator2.hasNext()) {
                FirCallableSymbol<?> element$iv;
                FirCallableSymbol<?> firCallableSymbol = element$iv = iterator2.next();
                if (firCallableSymbol == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol<*>");
                }
                FirFunctionSymbol cfr_ignored_0 = (FirFunctionSymbol)firCallableSymbol;
            }
            collection = $this$castAll$iv;
        } else {
            collection = (Collection<FirCallableSymbol<?>>)FirHelpersKt.directOverriddenFunctions(function2, context2);
        }
        Collection<FirCallableSymbol<?>> overriddenFunctions2 = collection;
        Iterator<FirValueParameterSymbol> iterator3 = function2.getValueParameterSymbols().iterator();
        int n = 0;
        while (iterator3.hasNext()) {
            int n2;
            int index2 = n++;
            FirValueParameterSymbol parameter2 = iterator3.next();
            Iterable $this$count$iv = overriddenFunctions2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    FirFunctionSymbol it = (FirFunctionSymbol)element$iv;
                    boolean bl = false;
                    if (!it.getValueParameterSymbols().get(index2).getHasDefaultValue() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int basesWithDefaultValues = n2;
            if (basesWithDefaultValues <= 1) continue;
            if (ClassMembersKt.isSubstitutionOrIntersectionOverride(function2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getMULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES_WHEN_NO_EXPLICIT_OVERRIDE(), (Object)parameter2, (DiagnosticContext)context2, null, 16, null);
                continue;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter2.getSource(), FirErrors.INSTANCE.getMULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES(), (Object)parameter2, (DiagnosticContext)context2, null, 16, null);
        }
    }

    public static final /* synthetic */ void access$checkFunction(FirMultipleDefaultsInheritedFromSupertypesChecker $this, FirRegularClass declaration, FirNamedFunctionSymbol function2, CheckerContext context2, DiagnosticReporter reporter) {
        $this.checkFunction(declaration, function2, context2, reporter);
    }
}

