/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0006H\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\bH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\bH\u0002J$\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0002J$\u0010\u001b\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsExportDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "validateDeclarationOnConsumableName", "declarationDescriptor", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getIdentifier", "Lcom/intellij/psi/PsiElement;", "getJsNameArgument", "getKotlinOrJsName", "", "isExportable", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "currentlyProcessed", "", "isExportableReturn", "js.frontend"})
public final class JsExportDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final JsExportDeclarationChecker INSTANCE = new JsExportDeclarationChecker();

    private JsExportDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        boolean hasJsName;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        BindingTrace trace = context2.getTrace();
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        if (!AnnotationsUtils.isExportedObject(descriptor2, bindingContext2)) {
            return;
        }
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return;
        }
        boolean bl = hasJsName = AnnotationsUtils.getJsNameAnnotation(descriptor2) != null;
        if (((MemberDescriptor)descriptor2).isExpect()) {
            JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration, "expect");
        }
        this.validateDeclarationOnConsumableName(declaration, descriptor2, trace);
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof FunctionDescriptor) {
            for (TypeParameterDescriptor typeParameter2 : ((FunctionDescriptor)descriptor2).getTypeParameters()) {
                Intrinsics.checkNotNull((Object)typeParameter2);
                JsExportDeclarationChecker.check$checkTypeParameter(bindingContext2, trace, typeParameter2);
            }
            if (InlineOnlyKt.isInlineWithReified((MemberDescriptor)descriptor2)) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration, "inline function with reified type parameters");
                return;
            }
            if (((FunctionDescriptor)descriptor2).isSuspend()) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration, "suspend function");
                return;
            }
            if (descriptor2 instanceof ConstructorDescriptor && !((ConstructorDescriptor)descriptor2).isPrimary() && !hasJsName) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration, "secondary constructor without @JsName");
            }
            if (!(descriptor2 instanceof PropertyAccessorDescriptor)) {
                for (ValueParameterDescriptor parameter2 : ((FunctionDescriptor)descriptor2).getValueParameters()) {
                    Intrinsics.checkNotNull((Object)parameter2);
                    JsExportDeclarationChecker.check$checkValueParameter(bindingContext2, trace, parameter2);
                }
                KotlinType kotlinType = ((FunctionDescriptor)descriptor2).getReturnType();
                if (kotlinType != null) {
                    KotlinType returnType2 = kotlinType;
                    boolean bl2 = false;
                    if (!JsExportDeclarationChecker.isExportableReturn$default(INSTANCE, returnType2, bindingContext2, null, 2, null)) {
                        trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration, "return", returnType2));
                    }
                }
            }
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            if (declaration instanceof KtParameter) {
                return;
            }
            if (DescriptorUtilsKt.isExtensionProperty(descriptor2)) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration, "extension property");
                return;
            }
            KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (!JsExportDeclarationChecker.isExportable$default(this, kotlinType, bindingContext2, null, 2, null)) {
                trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration, "property", ((PropertyDescriptor)descriptor2).getType()));
            }
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            String wrongDeclaration;
            for (TypeParameterDescriptor typeParameter3 : ((ClassDescriptor)descriptor2).getDeclaredTypeParameters()) {
                Intrinsics.checkNotNull((Object)typeParameter3);
                JsExportDeclarationChecker.check$checkTypeParameter(bindingContext2, trace, typeParameter3);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((ClassDescriptor)descriptor2).getKind().ordinal()]) {
                case 1: {
                    String string2 = "annotation class";
                    break;
                }
                case 2: {
                    String string2;
                    if (DescriptorUtilsKt.isInsideInterface(descriptor2)) {
                        string2 = "nested class inside exported interface";
                        break;
                    }
                    if (InlineClassesUtilsKt.isInlineClass(descriptor2)) {
                        string2 = (((ClassDescriptor)descriptor2).isInline() ? "inline " : "") + (((ClassDescriptor)descriptor2).isValue() ? "value " : "") + "class";
                        break;
                    }
                    string2 = null;
                    break;
                }
                default: {
                    String string2 = DescriptorUtilsKt.isInsideInterface(descriptor2) ? (((ClassDescriptor)descriptor2).isCompanionObject() ? "companion object" : "nested/inner declaration") + " inside exported interface" : (wrongDeclaration = null);
                }
            }
            if (wrongDeclaration != null) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration, wrongDeclaration);
                return;
            }
            if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                return;
            }
        }
    }

    private final boolean isExportableReturn(KotlinType $this$isExportableReturn, BindingContext bindingContext, Set<KotlinType> currentlyProcessed) {
        return TypeUtilsKt.isUnit($this$isExportableReturn) || this.isExportable($this$isExportableReturn, bindingContext, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportableReturn$default(JsExportDeclarationChecker jsExportDeclarationChecker, KotlinType kotlinType, BindingContext bindingContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return jsExportDeclarationChecker.isExportableReturn(kotlinType, bindingContext, set);
    }

    private final boolean isExportable(KotlinType $this$isExportable, BindingContext bindingContext, Set<KotlinType> currentlyProcessed) {
        boolean isPrimitiveExportableType;
        if (!currentlyProcessed.add($this$isExportable)) {
            return true;
        }
        currentlyProcessed.add($this$isExportable);
        if (FunctionTypesKt.isFunctionType($this$isExportable)) {
            int n = CollectionsKt.getLastIndex($this$isExportable.getArguments());
            for (int i = 0; i < n; ++i) {
                KotlinType kotlinType = $this$isExportable.getArguments().get(i).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                if (this.isExportable(kotlinType, bindingContext, currentlyProcessed)) continue;
                currentlyProcessed.remove($this$isExportable);
                return false;
            }
            currentlyProcessed.remove($this$isExportable);
            KotlinType kotlinType = ((TypeProjection)CollectionsKt.last($this$isExportable.getArguments())).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            return this.isExportableReturn(kotlinType, bindingContext, currentlyProcessed);
        }
        for (TypeProjection argument2 : $this$isExportable.getArguments()) {
            KotlinType kotlinType = argument2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (this.isExportable(kotlinType, bindingContext, currentlyProcessed)) continue;
            currentlyProcessed.remove($this$isExportable);
            return false;
        }
        currentlyProcessed.remove($this$isExportable);
        KotlinType nonNullable = TypeUtilsKt.makeNotNullable($this$isExportable);
        boolean bl = isPrimitiveExportableType = TypeUtilsKt.isAnyOrNullableAny(nonNullable) || TypeUtilsKt.isTypeParameter(nonNullable) || DynamicTypesKt.isDynamic(nonNullable) || TypeUtilsKt.isBoolean(nonNullable) || KotlinBuiltIns.isThrowableOrNullableThrowable(nonNullable) || KotlinBuiltIns.isString(nonNullable) || TypeUtilsKt.isPrimitiveNumberOrNullableType(nonNullable) && !TypeUtilsKt.isLong(nonNullable) || TypeUtilsKt.isNothingOrNullableNothing(nonNullable) || KotlinBuiltIns.isArray($this$isExportable) || KotlinBuiltIns.isPrimitiveArray($this$isExportable);
        if (isPrimitiveExportableType) {
            return true;
        }
        ClassifierDescriptor descriptor2 = $this$isExportable.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return false;
        }
        if (KotlinBuiltIns.isEnum($this$isExportable)) {
            return true;
        }
        return DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)((Object)descriptor2)) || AnnotationsUtils.isExportedObject(descriptor2, bindingContext);
    }

    static /* synthetic */ boolean isExportable$default(JsExportDeclarationChecker jsExportDeclarationChecker, KotlinType kotlinType, BindingContext bindingContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return jsExportDeclarationChecker.isExportable(kotlinType, bindingContext, set);
    }

    private final void validateDeclarationOnConsumableName(KtDeclaration declaration, DeclarationDescriptor declarationDescriptor, BindingTrace trace) {
        if (!DescriptorUtilKt.isTopLevelInPackage(declarationDescriptor) || declarationDescriptor.getName().isSpecial()) {
            return;
        }
        String name2 = this.getKotlinOrJsName(declarationDescriptor);
        if (IdentifierPolicyKt.getSPECIAL_KEYWORDS().contains(name2) || !IdentifierPolicyKt.getRESERVED_KEYWORDS().contains(name2) && Intrinsics.areEqual((Object)NameSuggestion.Companion.sanitizeName(name2), (Object)name2)) {
            return;
        }
        PsiElement psiElement = this.getJsNameArgument(declarationDescriptor);
        if (psiElement == null) {
            psiElement = this.getIdentifier(declaration);
        }
        PsiElement reportTarget = psiElement;
        trace.report(ErrorsJs.NON_CONSUMABLE_EXPORTED_IDENTIFIER.on(reportTarget, name2));
    }

    private final String getKotlinOrJsName(DeclarationDescriptor $this$getKotlinOrJsName) {
        String string2 = AnnotationsUtils.getJsName($this$getKotlinOrJsName);
        if (string2 == null) {
            String string3 = $this$getKotlinOrJsName.getName().getIdentifier();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdentifier(...)");
        }
        return string2;
    }

    private final PsiElement getIdentifier(KtDeclaration $this$getIdentifier) {
        Intrinsics.checkNotNull((Object)$this$getIdentifier, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
        PsiElement psiElement = ((KtNamedDeclaration)$this$getIdentifier).getNameIdentifier();
        Intrinsics.checkNotNull((Object)psiElement);
        return psiElement;
    }

    private final PsiElement getJsNameArgument(DeclarationDescriptor $this$getJsNameArgument) {
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getJsNameAnnotation($this$getJsNameArgument);
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor jsNameAnnotation = annotationDescriptor;
        PsiElement psiElement = PsiSourceElementKt.getPsi(jsNameAnnotation.getSource());
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
        Object object = ((KtAnnotationEntry)psiElement).getValueArgumentList();
        return (PsiElement)(object != null && (object = ((KtValueArgumentList)object).getArguments()) != null ? (KtValueArgument)CollectionsKt.first((List)object) : null);
    }

    private static final void check$checkTypeParameter(BindingContext bindingContext, BindingTrace trace, TypeParameterDescriptor descriptor2) {
        for (KotlinType upperBound : descriptor2.getUpperBounds()) {
            PsiElement typeParameterDeclaration;
            Intrinsics.checkNotNull((Object)upperBound);
            if (JsExportDeclarationChecker.isExportable$default(INSTANCE, upperBound, bindingContext, null, 2, null)) continue;
            Intrinsics.checkNotNull((Object)DescriptorToSourceUtils.descriptorToDeclaration(descriptor2));
            trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(typeParameterDeclaration, "upper bound", upperBound));
        }
    }

    private static final void check$checkValueParameter(BindingContext bindingContext, BindingTrace trace, ValueParameterDescriptor descriptor2) {
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        if (!JsExportDeclarationChecker.isExportable$default(INSTANCE, kotlinType, bindingContext, null, 2, null)) {
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement valueParameterDeclaration2 = psiElement;
            trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(valueParameterDeclaration2, "parameter", descriptor2.getType()));
        }
    }

    private static final void check$reportWrongExportedDeclaration(BindingTrace trace, KtDeclaration $declaration, String kind) {
        trace.report(ErrorsJs.WRONG_EXPORTED_DECLARATION.on((KtExpression)((PsiElement)$declaration), kind));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

