/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterChecker;
import org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterCheckerData;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterKCallableNamePreprocessor;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001d\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010!J\u001d\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010$J!\u0010%\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020)2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001d\u0010*\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020+2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010,J\u001d\u0010-\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020.2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010/J\u001d\u00100\u001a\u00020\u00072\u0006\u0010\b\u001a\u0002012\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u00102J\u001d\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u0002052\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u00106J\u001d\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u00109J\u001d\u0010:\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020;2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010<J\u001d\u0010=\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020>2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010?J\u001d\u0010@\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020A2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010BJ\u001d\u0010C\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020D2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010EJ\u001d\u0010F\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020G2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010HJ\u001d\u0010I\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020J2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010KJ\u001d\u0010L\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020M2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010NJ\u001d\u0010O\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020P2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010QJ\u001d\u0010R\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020S2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010TJ\u001d\u0010U\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020V2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010WJ\u001d\u0010X\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020Y2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010ZJ\u001d\u0010[\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\\2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010]J\u001d\u0010^\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020_2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010`J\u001d\u0010a\u001a\u00020\u00072\u0006\u0010b\u001a\u00020c2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010dJ\u001e\u0010e\u001a\u00020\u00072\f\u0010f\u001a\b\u0012\u0004\u0012\u00020h0g2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001d\u0010i\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020j2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010kJ\u001d\u0010l\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020m2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010nJ\u001d\u0010o\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020p2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010qJ\u001d\u0010r\u001a\u00020\u00072\u0006\u0010s\u001a\u00020t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010uJ\u001d\u0010v\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020w2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010xJ\u0018\u0010y\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020)2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001d\u0010z\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020{2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010|J\u001e\u0010}\u001a\u00020\u00072\u0006\u0010~\u001a\u00020\u007f2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0003\u0010\u0080\u0001J \u0010\u0081\u0001\u001a\u00020\u00072\u0007\u0010\b\u001a\u00030\u0082\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0003\u0010\u0083\u0001J \u0010\u0084\u0001\u001a\u00020\u00072\u0007\u00104\u001a\u00030\u0085\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0003\u0010\u0086\u0001J \u0010\u0087\u0001\u001a\u00020\u0007*\u00020\u00052\u0010\b\u0004\u0010\u0088\u0001\u001a\t\u0012\u0004\u0012\u00020\u00070\u0089\u0001H\u0082\bJ\u0014\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020h0g*\u00030\u008b\u0001H\u0002J\r\u0010\u008c\u0001\u001a\u00020\u0007*\u00020\u001dH\u0002J\u0011\u0010\u008d\u0001\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030&H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008e\u0001"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCommonChecker;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;", "()V", "visitedStack", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitBlock", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "data", "Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;", "(Lorg/jetbrains/kotlin/ir/expressions/IrBlock;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "(Lorg/jetbrains/kotlin/ir/expressions/IrBody;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitBodyIfNeeded", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitBranch", "branch", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "(Lorg/jetbrains/kotlin/ir/expressions/IrBranch;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "(Lorg/jetbrains/kotlin/ir/expressions/IrBreak;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitClassReference", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "(Lorg/jetbrains/kotlin/ir/expressions/IrComposite;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "(Lorg/jetbrains/kotlin/ir/expressions/IrConst;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "(Lorg/jetbrains/kotlin/ir/expressions/IrContinue;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "(Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitElement", "element", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitExpressionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitGetEnumValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "(Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "(Lorg/jetbrains/kotlin/ir/expressions/IrGetField;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "(Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "(Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitInstanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "(Lorg/jetbrains/kotlin/ir/expressions/IrReturn;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "(Lorg/jetbrains/kotlin/ir/expressions/IrSetField;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "(Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitSpreadElement", "spread", "Lorg/jetbrains/kotlin/ir/expressions/IrSpreadElement;", "(Lorg/jetbrains/kotlin/ir/expressions/IrSpreadElement;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitStatements", "statements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "(Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitSyntheticBody", "Lorg/jetbrains/kotlin/ir/expressions/IrSyntheticBody;", "(Lorg/jetbrains/kotlin/ir/expressions/IrSyntheticBody;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "(Lorg/jetbrains/kotlin/ir/expressions/IrThrow;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "(Lorg/jetbrains/kotlin/ir/expressions/IrTry;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitValueArguments", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "(Lorg/jetbrains/kotlin/ir/expressions/IrVararg;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitVariable", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "(Lorg/jetbrains/kotlin/ir/expressions/IrWhen;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "(Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCheckerData;)Ljava/lang/Boolean;", "asVisited", "block", "Lkotlin/Function0;", "getInnerDeclarations", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "isGetterToConstVal", "isNaN", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrInterpreterCommonChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreterCommonChecker.kt\norg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCommonChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,330:1\n26#1,4:348\n26#1,4:388\n26#1,2:392\n28#1,2:416\n26#1,4:469\n26#1,4:476\n26#1,4:480\n1726#2,3:331\n800#2,11:334\n1726#2,3:345\n1549#2:352\n1620#2,3:353\n2624#2,3:356\n1747#2,3:359\n1726#2,2:362\n800#2,11:364\n618#2,12:375\n1728#2:387\n800#2,11:394\n661#2,11:405\n800#2,11:418\n618#2,12:429\n800#2,11:441\n800#2,11:452\n766#2:463\n857#2,2:464\n1726#2,3:466\n1726#2,3:473\n1726#2,3:484\n1#3:487\n*S KotlinDebug\n*F\n+ 1 IrInterpreterCommonChecker.kt\norg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterCommonChecker\n*L\n53#1:348,4\n161#1:388,4\n183#1:392,2\n183#1:416,2\n256#1:469,4\n283#1:476,4\n289#1:480,4\n39#1:331,3\n48#1:334,11\n48#1:345,3\n84#1:352\n84#1:353,3\n85#1:356,3\n129#1:359,3\n137#1:362,2\n141#1:364,11\n142#1:375,12\n137#1:387\n198#1:394,11\n198#1:405,11\n210#1:418,11\n210#1:429,12\n229#1:441,11\n230#1:452,11\n230#1:463\n230#1:464,2\n232#1:466,3\n275#1:473,3\n299#1:484,3\n*E\n"})
public final class IrInterpreterCommonChecker
implements IrInterpreterChecker {
    @NotNull
    private final List<IrElement> visitedStack = new ArrayList();

    private final boolean asVisited(IrElement $this$asVisited, Function0<Boolean> block) {
        boolean $i$f$asVisited = false;
        ((Collection)this.visitedStack).add($this$asVisited);
        boolean result2 = (Boolean)block.invoke();
        this.visitedStack.remove(CollectionsKt.getLastIndex(this.visitedStack));
        return result2;
    }

    @Override
    @NotNull
    public Boolean visitElement(@NotNull IrElement element, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return false;
    }

    private final List<IrStatement> getInnerDeclarations(IrDeclarationParent $this$getInnerDeclarations) {
        Object object = $this$getInnerDeclarations instanceof IrDeclarationContainer ? (IrDeclarationContainer)$this$getInnerDeclarations : null;
        if (object == null || (object = object.getDeclarations()) == null) {
            IrStatementContainer irStatementContainer = $this$getInnerDeclarations instanceof IrStatementContainer ? (IrStatementContainer)((Object)$this$getInnerDeclarations) : null;
            object = irStatementContainer != null ? irStatementContainer.getStatements() : CollectionsKt.emptyList();
        }
        return object;
    }

    private final boolean visitStatements(List<? extends IrStatement> statements2, IrInterpreterCheckerData data2) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = statements2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IrStatement it = (IrStatement)element$iv;
                    boolean bl2 = false;
                    if (((Boolean)it.accept(this, data2)).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean visitConstructor(IrFunctionAccessExpression expression2, IrInterpreterCheckerData data2) {
        IrAnonymousInitializer it;
        void $this$all$iv;
        void $this$filterIsInstanceTo$iv$iv;
        IrFunction constructor2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        if (!data2.getMode().canEvaluateFunction(constructor2)) {
            return false;
        }
        if (!this.visitValueArguments(expression2, data2)) {
            return false;
        }
        if (!this.visitBodyIfNeeded(constructor2, data2)) return false;
        Iterable $this$filterIsInstance$iv = IrUtilsKt.getParentAsClass(constructor2).getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        object = $this$all$iv.iterator();
        do {
            if (!object.hasNext()) return true;
            Object element$iv = object.next();
            it = (IrAnonymousInitializer)element$iv;
            boolean bl = false;
        } while (((Boolean)it.accept(this, data2)).booleanValue());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean visitBodyIfNeeded(IrFunction irFunction2, IrInterpreterCheckerData data2) {
        void this_$iv;
        if (!data2.getMode().mustCheckBodyOf(irFunction2)) {
            return true;
        }
        IrInterpreterCommonChecker irInterpreterCommonChecker = this;
        IrElement $this$asVisited$iv = irFunction2;
        boolean $i$f$asVisited = false;
        ((Collection)this_$iv.visitedStack).add($this$asVisited$iv);
        boolean bl = false;
        IrBody irBody = irFunction2.getBody();
        boolean result$iv = irBody != null ? (Boolean)irBody.accept(this, data2) : true;
        this_$iv.visitedStack.remove(CollectionsKt.getLastIndex(this_$iv.visitedStack));
        return result$iv;
    }

    private final boolean isGetterToConstVal(IrCall $this$isGetterToConstVal) {
        Object object = ((IrSimpleFunction)$this$isGetterToConstVal.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        return object != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isConst() : false;
    }

    @Override
    @NotNull
    public Boolean visitCall(@NotNull IrCall expression2, @NotNull IrInterpreterCheckerData data2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        IrSimpleFunction owner = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (!data2.getInterpreterConfiguration().getInlineConstVal() && this.isGetterToConstVal(expression2) && !Intrinsics.areEqual((Object)data2.getIrFile(), (Object)IrUtilsKt.getFileOrNull(owner))) {
            bl = false;
        } else if (UtilsKt.isAccessToNotNullableObject(expression2.getDispatchReceiver()) && this.isGetterToConstVal(expression2)) {
            bl = this.visitBodyIfNeeded(owner, data2);
        } else if (!data2.getMode().canEvaluateExpression(expression2) || !data2.getMode().canEvaluateFunction(owner)) {
            bl = false;
        } else if (IrInterpreterKCallableNamePreprocessor.Companion.isKCallableNameCall(expression2, data2.getIrBuiltIns()) || IrInterpreterKCallableNamePreprocessor.Companion.isEnumName(expression2)) {
            bl = true;
        } else {
            IrExpression irExpression = expression2.getDispatchReceiver();
            boolean dispatchReceiverComputable = irExpression != null ? (Boolean)irExpression.accept(this, data2) : true;
            IrExpression irExpression2 = expression2.getExtensionReceiver();
            boolean extensionReceiverComputable = irExpression2 != null ? (Boolean)irExpression2.accept(this, data2) : true;
            bl = dispatchReceiverComputable && extensionReceiverComputable && this.visitValueArguments(expression2, data2) && this.visitBodyIfNeeded(owner, data2);
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitVariable(@NotNull IrVariable declaration, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        IrExpression irExpression = declaration.getInitializer();
        return irExpression != null ? (Boolean)irExpression.accept(this, data2) : true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean visitValueArguments(IrFunctionAccessExpression expression2, IrInterpreterCheckerData data2) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)expression2.getValueArgumentsCount());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(expression2.getValueArgument((int)it));
            }
            Iterable $this$none$iv = (List)destination$iv$iv;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    IrExpression it = (IrExpression)element$iv;
                    boolean bl3 = false;
                    IrExpression irExpression = it;
                    boolean bl4 = irExpression != null ? !((Boolean)irExpression.accept(this, data2)).booleanValue() : false;
                    if (!bl4) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitBody(@NotNull IrBody body2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitStatements(IrUtilsKt.getStatements(body2), data2);
    }

    @Override
    @NotNull
    public Boolean visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return (Boolean)body2.getExpression().accept(this, data2);
    }

    @Override
    @NotNull
    public Boolean visitBlock(@NotNull IrBlock expression2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!data2.getMode().canEvaluateBlock(expression2)) {
            return false;
        }
        if (expression2 instanceof IrReturnableBlock) {
            IrInlinedFunctionBlock inlinedBlock;
            Object object = CollectionsKt.singleOrNull(expression2.getStatements());
            IrInlinedFunctionBlock irInlinedFunctionBlock = inlinedBlock = object instanceof IrInlinedFunctionBlock ? (IrInlinedFunctionBlock)object : null;
            if (inlinedBlock != null) {
                return (Boolean)inlinedBlock.getInlineCall().accept(this, data2);
            }
        }
        return this.visitStatements(expression2.getStatements(), data2);
    }

    @Override
    @NotNull
    public Boolean visitComposite(@NotNull IrComposite expression2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!data2.getMode().canEvaluateComposite(expression2)) {
            return false;
        }
        return this.visitStatements(expression2.getStatements(), data2);
    }

    @Override
    @NotNull
    public Boolean visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return body2.getKind() == IrSyntheticBodyKind.ENUM_VALUES || body2.getKind() == IrSyntheticBodyKind.ENUM_VALUEOF;
    }

    private final boolean isNaN(IrConst<?> $this$isNaN) {
        return Intrinsics.areEqual($this$isNaN.getKind(), (Object)IrConstKind.Double.INSTANCE) && Double.isNaN(((Number)IrConstKind.Double.INSTANCE.valueOf($this$isNaN)).doubleValue()) || Intrinsics.areEqual($this$isNaN.getKind(), (Object)IrConstKind.Float.INSTANCE) && Float.isNaN(((Number)IrConstKind.Float.INSTANCE.valueOf($this$isNaN)).floatValue());
    }

    @Override
    @NotNull
    public Boolean visitConst(@NotNull IrConst<?> expression2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return true;
    }

    @Override
    @NotNull
    public Boolean visitVararg(@NotNull IrVararg expression2, @NotNull IrInterpreterCheckerData data2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Iterable $this$any$iv = expression2.getElements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl2 = false;
                    if (!((Boolean)it.accept(this, data2)).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)spread, (String)"spread");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return (Boolean)spread.getExpression().accept(this, data2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Boolean visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrInterpreterCheckerData data2) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Iterable $this$all$iv = expression2.getArguments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    IrExpression arg = (IrExpression)element$iv;
                    boolean bl3 = false;
                    if (arg instanceof IrGetObjectValue) {
                        void $this$single$iv;
                        void $this$filterIsInstanceTo$iv$iv;
                        Iterable $this$filterIsInstance$iv;
                        Iterable iterable = ((IrClass)((IrGetObjectValue)arg).getSymbol().getOwner()).getDeclarations();
                        boolean $i$f$filterIsInstance = false;
                        void var11_11 = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterIsInstance$iv = (List)destination$iv$iv;
                        boolean $i$f$single = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (Object element$iv2 : $this$single$iv) {
                            IrSimpleFunction it = (IrSimpleFunction)element$iv2;
                            boolean bl4 = false;
                            if (!(Intrinsics.areEqual((Object)it.getName().asString(), (Object)"toString") && it.getValueParameters().isEmpty() && it.getExtensionReceiverParameter() == null)) continue;
                            if (found$iv) {
                                throw new IllegalArgumentException("Collection contains more than one matching element.");
                            }
                            single$iv = element$iv2;
                            found$iv = true;
                        }
                        if (!found$iv) {
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        IrSimpleFunction toString2 = single$iv;
                        bl2 = data2.getMode().canEvaluateFunction(toString2) && this.visitBodyIfNeeded(toString2, data2);
                    } else {
                        bl2 = (Boolean)arg.accept(this, data2);
                    }
                    if (bl2) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return data2.getMode().canEvaluateExpression(expression2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Boolean visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull IrInterpreterCheckerData data2) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!data2.getMode().canEvaluateEnumValue(expression2)) {
            return false;
        }
        if (this.visitedStack.contains(expression2)) {
            return true;
        }
        IrInterpreterCommonChecker irInterpreterCommonChecker = this;
        IrElement $this$asVisited$iv = expression2;
        boolean $i$f$asVisited = false;
        ((Collection)this_$iv.visitedStack).add($this$asVisited$iv);
        boolean bl = false;
        IrExpressionBody irExpressionBody = ((IrEnumEntry)expression2.getSymbol().getOwner()).getInitializerExpression();
        boolean result$iv = irExpressionBody != null ? ((Boolean)irExpressionBody.accept(this, data2)).booleanValue() : false;
        this_$iv.visitedStack.remove(CollectionsKt.getLastIndex(this_$iv.visitedStack));
        return result$iv;
    }

    @Override
    @NotNull
    public Boolean visitGetValue(@NotNull IrGetValue expression2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitedStack.contains(expression2.getSymbol().getOwner().getParent());
    }

    @Override
    @NotNull
    public Boolean visitSetValue(@NotNull IrSetValue expression2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return (Boolean)expression2.getValue().accept(this, data2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @NotNull
    public Boolean visitGetField(@NotNull IrGetField expression, @NotNull IrInterpreterCheckerData data) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                        owner = (IrField)expression.getSymbol().getOwner();
                        v0 = owner.getCorrespondingPropertySymbol();
                        property = v0 != null ? (IrProperty)v0.getOwner() : null;
                        fqName = UtilsKt.getFqName(owner);
                        var6_6 = this;
                        $this$asVisited$iv = owner;
                        $i$f$asVisited = false;
                        ((Collection)this_$iv.visitedStack).add($this$asVisited$iv);
                        $i$a$-asVisited-IrInterpreterCommonChecker$visitGetField$1 = false;
                        if (!Intrinsics.areEqual((Object)fqName, (Object)"java.lang.Boolean.FALSE") && !Intrinsics.areEqual((Object)fqName, (Object)"java.lang.Boolean.TRUE")) break block10;
                        v1 = true;
                        break block11;
                    }
                    if (!IrInterpreterCommonChecker.access$visitGetField$isJavaStaticWithPrimitiveOrString(owner)) break block12;
                    v2 = owner.getInitializer();
                    v1 = v2 != null ? ((Boolean)v2.accept(this, data)).booleanValue() : false;
                    break block11;
                }
                if (expression.getReceiver() != null) break block13;
                v3 = property;
                v4 = v3 != null ? v3.isConst() : false;
                if (!v4) ** GOTO lbl-1000
                v5 = owner.getInitializer();
                v6 = v5 != null ? ((Boolean)v5.accept(this, data)).booleanValue() : false;
                if (v6) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                break block11;
            }
            if (!Intrinsics.areEqual((Object)owner.getOrigin(), (Object)IrDeclarationOrigin.PROPERTY_BACKING_FIELD.INSTANCE)) ** GOTO lbl-1000
            v7 = property;
            v8 = v7 != null ? v7.isConst() : false;
            if (v8) {
                v9 = expression.getReceiver();
                receiverComputable = (v9 != null ? (Boolean)v9.accept(this, data) : true) != false || UtilsKt.isAccessToNotNullableObject(expression.getReceiver()) != false;
                v10 = owner.getInitializer();
                v11 = initializerComputable = v10 != null ? (Boolean)v10.accept(this, data) : false;
                v1 = receiverComputable && initializerComputable;
            } else lbl-1000:
            // 2 sources

            {
                block9: {
                    declarations = IrInterpreterCommonChecker.access$getInnerDeclarations(this, owner.getParent());
                    $this$filterIsInstance$iv = declarations;
                    $i$f$filterIsInstance = false;
                    var14_16 = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof IrProperty)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$singleOrNull$iv = (List)destination$iv$iv;
                    $i$f$singleOrNull = false;
                    single$iv = null;
                    found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        it = (IrProperty)element$iv;
                        $i$a$-singleOrNull-IrInterpreterCommonChecker$visitGetField$1$getter$1 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)property)) continue;
                        if (found$iv) {
                            v12 = null;
                            break block9;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v12 = found$iv == false ? null : single$iv;
                }
                if ((v13 /* !! */  = (IrProperty)v12) == null || (v13 /* !! */  = v13 /* !! */ .getGetter()) == null) {
                    v1 = false;
                } else {
                    getter /* !! */  = v13 /* !! */ ;
                    v1 = IrInterpreterCommonChecker.access$getVisitedStack$p(this).contains(getter /* !! */ );
                }
            }
        }
        result$iv = v1;
        this_$iv.visitedStack.remove(CollectionsKt.getLastIndex(this_$iv.visitedStack));
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Boolean visitSetField(@NotNull IrSetField expression2, @NotNull IrInterpreterCheckerData data2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (UtilsKt.accessesTopLevelOrObjectField(expression2)) {
            return false;
        }
        IrPropertySymbol irPropertySymbol = ((IrField)expression2.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        IrProperty property = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
        List<IrStatement> declarations2 = this.getInnerDeclarations(((IrField)expression2.getSymbol().getOwner()).getParent());
        Iterable $this$filterIsInstance$iv = declarations2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$single$iv = (List)destination$iv$iv;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrProperty it = (IrProperty)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)property)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        IrSimpleFunction irSimpleFunction = ((IrProperty)single$iv).getSetter();
        if (irSimpleFunction == null) {
            return false;
        }
        IrSimpleFunction setter2 = irSimpleFunction;
        return this.visitedStack.contains(setter2) && (Boolean)expression2.getValue().accept(this, data2) != false;
    }

    @Override
    @NotNull
    public Boolean visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitConstructor(expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (IrTypePredicatesKt.isAny(((IrConstructor)expression2.getSymbol().getOwner()).getReturnType())) {
            return true;
        }
        return this.visitConstructor(expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitConstructor(expression2, data2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Boolean visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull IrInterpreterCheckerData data2) {
        boolean bl;
        boolean bl2;
        boolean $i$f$all;
        Iterable $this$all$iv;
        List classProperties;
        block13: {
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            IrClass irClass2 = (IrClass)expression2.getClassSymbol().getOwner();
            Iterable $this$filterIsInstance$iv = irClass2.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection collection = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object t : $this$filterIsInstanceTo$iv$iv) {
                if (!(t instanceof IrProperty)) continue;
                collection.add(t);
            }
            classProperties = (List)collection;
            Iterable $this$filterIsInstance$iv2 = irClass2.getDeclarations();
            boolean $i$f$filterIsInstance2 = false;
            Iterable iterable2 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv : iterable2) {
                if (!(element$iv$iv instanceof IrAnonymousInitializer)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv2 = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            void var8_11 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : var8_11) {
                IrAnonymousInitializer it = (IrAnonymousInitializer)element$iv$iv;
                boolean bl3 = false;
                if (!(!it.isStatic())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List anonymousInitializer = (List)destination$iv$iv;
            $this$all$iv = anonymousInitializer;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IrAnonymousInitializer init2 = (IrAnonymousInitializer)element$iv;
                    boolean bl4 = false;
                    if (((Boolean)init2.getBody().accept(this, data2)).booleanValue()) continue;
                    bl2 = false;
                    break block13;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            boolean bl5;
            block14: {
                $this$all$iv = classProperties;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl5 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean bl6;
                        IrProperty it = (IrProperty)element$iv;
                        boolean bl7 = false;
                        IrElementBase irElementBase = it.getBackingField();
                        IrExpression propertyInitializer = irElementBase != null && (irElementBase = ((IrField)irElementBase).getInitializer()) != null ? ((IrExpressionBody)irElementBase).getExpression() : null;
                        IrGetValue irGetValue = propertyInitializer instanceof IrGetValue ? (IrGetValue)propertyInitializer : null;
                        if (Intrinsics.areEqual((Object)(irGetValue != null ? irGetValue.getOrigin() : null), (Object)IrStatementOrigin.INITIALIZE_PROPERTY_FROM_PARAMETER.INSTANCE)) {
                            bl6 = true;
                        } else {
                            IrExpression irExpression = propertyInitializer;
                            bl6 = !(irExpression != null ? !((Boolean)irExpression.accept(this, data2)).booleanValue() : false);
                        }
                        if (bl6) continue;
                        bl5 = false;
                        break block14;
                    }
                    bl5 = true;
                }
            }
            if (bl5) {
                bl = true;
                return bl;
            }
        }
        bl = false;
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrInterpreterCheckerData data2) {
        boolean extensionReceiverComputable;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!data2.getMode().canEvaluateCallableReference(expression2)) {
            return false;
        }
        IrFunction owner = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrExpression irExpression = expression2.getDispatchReceiver();
        boolean dispatchReceiverComputable = irExpression != null ? (Boolean)irExpression.accept(this, data2) : true;
        IrExpression irExpression2 = expression2.getExtensionReceiver();
        boolean bl = extensionReceiverComputable = irExpression2 != null ? (Boolean)irExpression2.accept(this, data2) : true;
        if (!data2.getMode().canEvaluateFunction(owner)) {
            return false;
        }
        boolean bodyComputable = this.visitBodyIfNeeded(owner, data2);
        return dispatchReceiverComputable && extensionReceiverComputable && bodyComputable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Boolean visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull IrInterpreterCheckerData data2) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!data2.getMode().canEvaluateFunctionExpression(expression2)) {
            return false;
        }
        IrBody irBody = expression2.getFunction().getBody();
        if (irBody == null) {
            return false;
        }
        IrBody body2 = irBody;
        IrInterpreterCommonChecker irInterpreterCommonChecker = this;
        IrElement $this$asVisited$iv = expression2.getFunction();
        boolean $i$f$asVisited = false;
        ((Collection)this_$iv.visitedStack).add($this$asVisited$iv);
        boolean bl = false;
        boolean result$iv = (Boolean)body2.accept(this, data2);
        this_$iv.visitedStack.remove(CollectionsKt.getLastIndex(this_$iv.visitedStack));
        return result$iv;
    }

    @Override
    @NotNull
    public Boolean visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrInterpreterCheckerData data2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                IrSymbolOwner operand;
                IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(expression2.getTypeOperand());
                IrSymbolOwner irSymbolOwner = operand = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
                if (operand instanceof IrTypeParameter && !this.visitedStack.contains(((IrTypeParameter)operand).getParent())) {
                    return false;
                }
                bl = (Boolean)expression2.getArgument().accept(this, data2);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitWhen(@NotNull IrWhen expression2, @NotNull IrInterpreterCheckerData data2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            if (!data2.getMode().canEvaluateExpression(expression2)) {
                return false;
            }
            Iterable $this$all$iv = expression2.getBranches();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IrBranch it = (IrBranch)element$iv;
                    boolean bl2 = false;
                    if (((Boolean)it.accept(this, data2)).booleanValue()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitBranch(@NotNull IrBranch branch, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return (Boolean)branch.getCondition().accept(this, data2) != false && (Boolean)branch.getResult().accept(this, data2) != false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public Boolean visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull IrInterpreterCheckerData data) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        var3_3 = this;
        $this$asVisited$iv = loop;
        $i$f$asVisited = false;
        ((Collection)this_$iv.visitedStack).add($this$asVisited$iv);
        $i$a$-asVisited-IrInterpreterCommonChecker$visitWhileLoop$1 = false;
        if (!((Boolean)loop.getCondition().accept(this, data)).booleanValue()) ** GOTO lbl-1000
        v0 = loop.getBody();
        if (v0 != null ? (Boolean)v0.accept(this, data) : true) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        result$iv = v1;
        this_$iv.visitedStack.remove(CollectionsKt.getLastIndex(this_$iv.visitedStack));
        return result$iv;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public Boolean visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull IrInterpreterCheckerData data) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        var3_3 = this;
        $this$asVisited$iv = loop;
        $i$f$asVisited = false;
        ((Collection)this_$iv.visitedStack).add($this$asVisited$iv);
        $i$a$-asVisited-IrInterpreterCommonChecker$visitDoWhileLoop$1 = false;
        if (!((Boolean)loop.getCondition().accept(this, data)).booleanValue()) ** GOTO lbl-1000
        v0 = loop.getBody();
        if (v0 != null ? (Boolean)v0.accept(this, data) : true) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        result$iv = v1;
        this_$iv.visitedStack.remove(CollectionsKt.getLastIndex(this_$iv.visitedStack));
        return result$iv;
    }

    @Override
    @NotNull
    public Boolean visitTry(@NotNull IrTry aTry, @NotNull IrInterpreterCheckerData data2) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            if (!data2.getMode().canEvaluateExpression(aTry)) {
                return false;
            }
            if (!((Boolean)aTry.getTryResult().accept(this, data2)).booleanValue()) {
                return false;
            }
            if (aTry.getFinallyExpression() != null) {
                IrExpression irExpression = aTry.getFinallyExpression();
                boolean bl2 = irExpression != null ? !((Boolean)irExpression.accept(this, data2)).booleanValue() : false;
                if (bl2) {
                    return false;
                }
            }
            Iterable $this$all$iv = aTry.getCatches();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IrCatch it = (IrCatch)element$iv;
                    boolean bl3 = false;
                    if (((Boolean)it.getResult().accept(this, data2)).booleanValue()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitBreak(@NotNull IrBreak jump, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitedStack.contains(jump.getLoop());
    }

    @Override
    @NotNull
    public Boolean visitContinue(@NotNull IrContinue jump, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitedStack.contains(jump.getLoop());
    }

    @Override
    @NotNull
    public Boolean visitReturn(@NotNull IrReturn expression2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!this.visitedStack.contains(expression2.getReturnTargetSymbol().getOwner())) {
            return false;
        }
        return (Boolean)expression2.getValue().accept(this, data2);
    }

    @Override
    @NotNull
    public Boolean visitThrow(@NotNull IrThrow expression2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!data2.getMode().canEvaluateExpression(expression2)) {
            return false;
        }
        return (Boolean)expression2.getValue().accept(this, data2);
    }

    @Override
    @NotNull
    public Boolean visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrInterpreterCheckerData data2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!data2.getMode().canEvaluateCallableReference(expression2)) {
            return false;
        }
        IrExpression irExpression = expression2.getDispatchReceiver();
        boolean dispatchReceiverComputable = irExpression != null ? (Boolean)irExpression.accept(this, data2) : true;
        IrExpression irExpression2 = expression2.getExtensionReceiver();
        boolean extensionReceiverComputable = irExpression2 != null ? (Boolean)irExpression2.accept(this, data2) : true;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
        if (irSimpleFunctionSymbol != null) {
            IrSimpleFunctionSymbol it = irSimpleFunctionSymbol;
            boolean bl2 = false;
            bl = data2.getMode().canEvaluateFunction(it.getOwner());
        } else {
            bl = true;
        }
        boolean getterIsComputable = bl;
        return dispatchReceiverComputable && extensionReceiverComputable && getterIsComputable;
    }

    @Override
    @NotNull
    public Boolean visitClassReference(@NotNull IrClassReference expression2, @NotNull IrInterpreterCheckerData data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return data2.getMode().canEvaluateClassReference(expression2);
    }

    @Override
    @NotNull
    public Boolean visitConstructor(@NotNull IrConstructor declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitBlockBody(@NotNull IrBlockBody body2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    @NotNull
    public Boolean visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    @NotNull
    public Boolean visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitCatch(@NotNull IrCatch aCatch, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    @NotNull
    public Boolean visitClass(@NotNull IrClass declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitClass(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitConstantArray(@NotNull IrConstantArray expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitConstantObject(@NotNull IrConstantObject expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitConstantValue(@NotNull IrConstantValue expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitElseBranch(@NotNull IrElseBranch branch, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public Boolean visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitExpression(@NotNull IrExpression expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitField(@NotNull IrField declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitFile(@NotNull IrFile declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitFunction(@NotNull IrFunction declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitFunction(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitGetClass(@NotNull IrGetClass expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitLoop(@NotNull IrLoop loop2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    @NotNull
    public Boolean visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitProperty(@NotNull IrProperty declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitScript(@NotNull IrScript declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public Boolean visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public Boolean visitValueParameter(@NotNull IrValueParameter declaration, @NotNull IrInterpreterCheckerData data2) {
        return IrInterpreterChecker.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    private static final boolean visitGetField$isJavaStaticWithPrimitiveOrString(IrField owner) {
        return Intrinsics.areEqual((Object)owner.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) && owner.isStatic() && owner.isFinal() && (IrTypePredicatesKt.isPrimitiveType$default(owner.getType(), false, 1, null) || IrTypePredicatesKt.isStringClassType(owner.getType()));
    }

    public static final /* synthetic */ boolean access$visitGetField$isJavaStaticWithPrimitiveOrString(IrField owner) {
        return IrInterpreterCommonChecker.visitGetField$isJavaStaticWithPrimitiveOrString(owner);
    }

    public static final /* synthetic */ List access$getInnerDeclarations(IrInterpreterCommonChecker $this, IrDeclarationParent $receiver) {
        return $this.getInnerDeclarations($receiver);
    }

    public static final /* synthetic */ List access$getVisitedStack$p(IrInterpreterCommonChecker $this) {
        return $this.visitedStack;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

