/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDeclarationDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0004R\u001b\u0010\u0006\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/ir/descriptors/IrBasedDeclarationDescriptor;", "T", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "owner", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "getAnnotations", "()Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "annotations$delegate", "Lkotlin/Lazy;", "getOwner", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "equals", "", "other", "", "getContainingDeclaration", "hashCode", "", "toString", "", "toAnnotationDescriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "toConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "Lorg/jetbrains/kotlin/ir/IrElement;", "toIrBasedKotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrBasedDescriptors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrBasedDescriptors.kt\norg/jetbrains/kotlin/ir/descriptors/IrBasedDeclarationDescriptor\n+ 2 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1272:1\n16#2:1273\n16#2:1286\n1620#3,3:1274\n766#3:1277\n857#3,2:1278\n1179#3,2:1280\n1253#3,4:1282\n1620#3,3:1287\n*S KotlinDebug\n*F\n+ 1 IrBasedDescriptors.kt\norg/jetbrains/kotlin/ir/descriptors/IrBasedDeclarationDescriptor\n*L\n68#1:1273\n91#1:1286\n68#1:1274,3\n69#1:1277\n69#1:1278,2\n70#1:1280,2\n70#1:1282,4\n91#1:1287,3\n*E\n"})
public abstract class IrBasedDeclarationDescriptor<T extends IrDeclaration>
implements DeclarationDescriptor {
    @NotNull
    private final T owner;
    @NotNull
    private final Lazy annotations$delegate;

    public IrBasedDeclarationDescriptor(@NotNull T owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        this.owner = owner;
        this.annotations$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Annotations>(this){
            final /* synthetic */ IrBasedDeclarationDescriptor<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Annotations invoke() {
                void $this$mapTo$iv$iv;
                void $this$memoryOptimizedMap$iv;
                Object object = this.this$0.getOwner();
                Object object2 = object instanceof IrAnnotationContainer ? (IrAnnotationContainer)object : null;
                if (object2 == null || (object2 = object2.getAnnotations()) == null) {
                    return Annotations.Companion.getEMPTY();
                }
                Object ownerAnnotations = object2;
                Collection collection = (Collection)ownerAnnotations;
                object = this.this$0;
                Annotations.Companion companion = Annotations.Companion;
                boolean $i$f$memoryOptimizedMap = false;
                Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$memoryOptimizedMap$iv.size());
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrConstructorCall irConstructorCall2 = (IrConstructorCall)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(IrBasedDeclarationDescriptor.access$toAnnotationDescriptor(object, (IrConstructorCall)it));
                }
                return companion.create(org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv));
            }
        }));
    }

    @NotNull
    public final T getOwner() {
        return this.owner;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Lazy lazy = this.annotations$delegate;
        return (Annotations)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final AnnotationDescriptor toAnnotationDescriptor(IrConstructorCall $this$toAnnotationDescriptor) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Pair it;
        void $this$mapTo$iv$iv;
        Iterable $this$memoryOptimizedMap$iv;
        IrClass annotationClass2 = IrUtilsKt.getParentAsClass($this$toAnnotationDescriptor.getSymbol().getOwner());
        if (Intrinsics.areEqual((Object)annotationClass2.getSymbol().getDescriptor(), (Object)ErrorUtils.INSTANCE.getErrorClass())) {
            return new AnnotationDescriptorImpl(IrTypesKt.toKotlinType($this$toAnnotationDescriptor.getType()), MapsKt.emptyMap(), $this$toAnnotationDescriptor.getSource());
        }
        boolean bl = IrUtilsKt.isAnnotationClass(annotationClass2);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-IrBasedDeclarationDescriptor$toAnnotationDescriptor$22 = false;
            String $i$a$-assert-IrBasedDeclarationDescriptor$toAnnotationDescriptor$22 = "Expected call to constructor of annotation class but was: " + DumpIrTreeKt.dump$default($this$toAnnotationDescriptor, null, 1, null);
            throw new AssertionError((Object)$i$a$-assert-IrBasedDeclarationDescriptor$toAnnotationDescriptor$22);
        }
        Collection collection = ((IrConstructor)$this$toAnnotationDescriptor.getSymbol().getOwner()).getValueParameters();
        KotlinType kotlinType = this.toIrBasedKotlinType(IrUtilsKt.getDefaultType(annotationClass2));
        boolean $i$f$memoryOptimizedMap = false;
        Iterable iterable = $this$memoryOptimizedMap$iv;
        Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(TuplesKt.to((Object)it.getName(), (Object)$this$toAnnotationDescriptor.getValueArgument(it.getIndex())));
        }
        $this$memoryOptimizedMap$iv = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl3 = false;
            if (!(it.getSecond() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Pair it2 = (Pair)element$iv$iv;
            boolean bl4 = false;
            Object object = it2.getFirst();
            Object object2 = it2.getSecond();
            Intrinsics.checkNotNull((Object)object2);
            Pair pair = TuplesKt.to((Object)object, this.toConstantValue((IrElement)object2));
            map.put(pair.getFirst(), pair.getSecond());
        }
        SourceElement sourceElement = $this$toAnnotationDescriptor.getSource();
        Map map = destination$iv$iv2;
        KotlinType kotlinType2 = kotlinType;
        return new AnnotationDescriptorImpl(kotlinType2, map, sourceElement);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ConstantValue<?> toConstantValue(IrElement $this$toConstantValue) {
        ConstantValue constantValue;
        IrElement irElement = $this$toConstantValue;
        if (irElement instanceof IrConst) {
            IrConstKind irConstKind = ((IrConst)$this$toConstantValue).getKind();
            if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Null.INSTANCE)) {
                constantValue = new NullValue();
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Boolean.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Boolean");
                constantValue = new BooleanValue((Boolean)t);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Char.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Char");
                constantValue = new CharValue(((Character)t).charValue());
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Byte.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Byte");
                constantValue = new ByteValue((Byte)t);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Short.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Short");
                constantValue = new ShortValue((Short)t);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Int.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Int");
                constantValue = new IntValue((Integer)t);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Long.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Long");
                constantValue = new LongValue((Long)t);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.String.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.String");
                constantValue = new StringValue((String)t);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Float.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Float");
                constantValue = new FloatValue(((Float)t).floatValue());
                return constantValue;
            } else {
                if (!Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Double.INSTANCE)) throw new NoWhenBranchMatchedException();
                Object t = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Double");
                constantValue = new DoubleValue((Double)t);
            }
            return constantValue;
        } else if (irElement instanceof IrVararg) {
            void $this$mapTo$iv$iv;
            Collection $this$memoryOptimizedMap$iv = ((IrVararg)$this$toConstantValue).getElements();
            boolean $i$f$memoryOptimizedMap = false;
            Iterable iterable = $this$memoryOptimizedMap$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (it instanceof IrSpreadElement) {
                    throw new IllegalStateException((it + " is not expected").toString());
                }
                collection.add(this.toConstantValue((IrElement)it));
            }
            List elements = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
            constantValue = new ArrayValue(elements, (Function1<? super ModuleDescriptor, ? extends KotlinType>)((Function1)toConstantValue.1.INSTANCE));
            return constantValue;
        } else if (irElement instanceof IrGetEnumValue) {
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)IrBasedDescriptorsKt.toIrBasedDescriptor(IrUtilsKt.getParentAsClass((IrDeclaration)((IrGetEnumValue)$this$toConstantValue).getSymbol().getOwner())));
            Intrinsics.checkNotNull((Object)classId);
            constantValue = new EnumValue(classId, ((IrEnumEntry)((IrGetEnumValue)$this$toConstantValue).getSymbol().getOwner()).getName());
            return constantValue;
        } else if (irElement instanceof IrClassReference) {
            IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(((IrClassReference)$this$toConstantValue).getClassType()).getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)IrBasedDescriptorsKt.toIrBasedDescriptor((IrClass)irSymbolOwner));
            Intrinsics.checkNotNull((Object)classId);
            constantValue = new KClassValue(classId, 0);
            return constantValue;
        } else {
            if (!(irElement instanceof IrConstructorCall)) throw new IllegalStateException(($this$toConstantValue + " is not expected: " + DumpIrTreeKt.dump$default($this$toConstantValue, null, 1, null)).toString());
            constantValue = new AnnotationValue(this.toAnnotationDescriptor((IrConstructorCall)$this$toConstantValue));
        }
        return constantValue;
    }

    @NotNull
    protected final KotlinType toIrBasedKotlinType(@NotNull IrType $this$toIrBasedKotlinType) {
        Intrinsics.checkNotNullParameter((Object)$this$toIrBasedKotlinType, (String)"<this>");
        return IrBasedDescriptorsKt.toIrBasedKotlinType($this$toIrBasedKotlinType, AdditionalIrUtilsKt.getModule(this.owner).getBuiltIns());
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return IrBasedDescriptorsKt.access$getContainingDeclaration(this.owner);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof IrBasedDeclarationDescriptor && Intrinsics.areEqual(this.owner, ((IrBasedDeclarationDescriptor)other).owner);
    }

    public int hashCode() {
        return this.owner.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + RenderIrElementKt.render$default((IrElement)this.owner, null, 1, null);
    }

    public static final /* synthetic */ AnnotationDescriptor access$toAnnotationDescriptor(IrBasedDeclarationDescriptor $this, IrConstructorCall $receiver) {
        return $this.toAnnotationDescriptor($receiver);
    }
}

