/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverterKt;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\f\u001a\u00020\u0005H\u0086\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\u000e\u001a\u00020\u0005J\u001f\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002H\u0086\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ComplementarySourceFilesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "dumpValue", "value", "get", "sourceFile", "remove", "file", "set", "", "complementaryFiles", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nComplementarySourceFilesMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComplementarySourceFilesMap.kt\norg/jetbrains/kotlin/incremental/storage/ComplementarySourceFilesMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
public final class ComplementarySourceFilesMap
extends BasicStringMap<Collection<? extends String>> {
    public ComplementarySourceFilesMap(@NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(storageFile, (KeyDescriptor<String>)((KeyDescriptor)PathStringDescriptor.INSTANCE), (DataExternalizer)StringCollectionExternalizer.INSTANCE, icContext);
    }

    public final void set(@NotNull File sourceFile, @NotNull Collection<? extends File> complementaryFiles) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter(complementaryFiles, (String)"complementaryFiles");
        this.getStorage().set((String)this.getPathConverter().toPath(sourceFile), FileToPathConverterKt.toPaths(this.getPathConverter(), complementaryFiles));
    }

    @NotNull
    public final Collection<File> get(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Collection collection = (Collection)this.getStorage().get((String)this.getPathConverter().toPath(sourceFile));
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection paths = collection;
        return FileToPathConverterKt.toFiles(this.getPathConverter(), paths);
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Collection<String> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return IncrementalJvmCacheKt.dumpCollection(value2);
    }

    @NotNull
    public final Collection<File> remove(@NotNull File file2) {
        Collection<File> collection;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Collection<File> it = collection = this.get(file2);
        boolean bl = false;
        this.getStorage().remove((String)this.getPathConverter().toPath(file2));
        return collection;
    }
}

