/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.HiddenCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ$\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\f\u0010\u0012\u001a\u00020\u000f*\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CheckDeprecatedSinceKotlin;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isHiddenForThisCallSite", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "isSuperCall", "Lorg/jetbrains/kotlin/fir/FirElement;", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckDeprecatedSinceKotlin\n+ 2 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckerSinkKt\n*L\n1#1,760:1\n28#2,2:761\n22#2,9:763\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckDeprecatedSinceKotlin\n*L\n692#1:761,2\n692#1:763,9\n*E\n"})
public final class CheckDeprecatedSinceKotlin
extends ResolutionStage {
    @NotNull
    public static final CheckDeprecatedSinceKotlin INSTANCE = new CheckDeprecatedSinceKotlin();

    private CheckDeprecatedSinceKotlin() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        DeprecationInfo deprecation;
        FirBasedSymbol<?> firBasedSymbol = candidate2.getSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return Unit.INSTANCE;
        }
        FirCallableSymbol symbol2 = firCallableSymbol;
        DeprecationInfo deprecationInfo = deprecation = DeprecationUtilsKt.getDeprecation(symbol2, context2.getSession(), callInfo.getCallSite());
        if ((deprecationInfo != null ? deprecationInfo.getDeprecationLevel() : null) == DeprecationLevelValue.HIDDEN || this.isHiddenForThisCallSite(symbol2, callInfo, candidate2)) {
            void $this$yieldDiagnostic$iv;
            firBasedSymbol = sink;
            ResolutionDiagnostic diagnostic$iv = HiddenCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final boolean isHiddenForThisCallSite(FirCallableSymbol<?> symbol2, CallInfo callInfo, Candidate candidate2) {
        if (this.isSuperCall(callInfo.getCallSite())) {
            return false;
        }
        if (((FirCallableDeclaration)symbol2.getFir()).getDispatchReceiverType() == null || !(symbol2 instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)DeprecationUtilsKt.isHiddenEverywhereBesideSuperCalls((FirCallableDeclaration)((FirNamedFunctionSymbol)symbol2).getFir()), (Object)true)) {
            return true;
        }
        FirScope firScope = candidate2.getOriginScope();
        FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
        if (firTypeScope == null) {
            return false;
        }
        FirTypeScope scope2 = firTypeScope;
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions(scope2, (FirNamedFunctionSymbol)symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(result2){
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol it) {
                ProcessorAction processorAction;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)DeprecationUtilsKt.isHiddenEverywhereBesideSuperCalls((FirCallableDeclaration)it.getFir()), (Object)true)) {
                    this.$result.element = true;
                    processorAction = ProcessorAction.STOP;
                } else {
                    processorAction = ProcessorAction.NEXT;
                }
                return processorAction;
            }
        }));
        return result2.element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSuperCall(FirElement $this$isSuperCall) {
        if (!($this$isSuperCall instanceof FirQualifiedAccessExpression)) return false;
        FirExpression firExpression2 = ((FirQualifiedAccessExpression)$this$isSuperCall).getExplicitReceiver();
        if (!((firExpression2 != null ? FirExpressionUtilKt.getCalleeReference(firExpression2) : null) instanceof FirSuperReference)) return false;
        return true;
    }
}

