/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.ControlFlowInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwareControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.extended.UnusedChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.NormalPath;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "()V", "isLoopIterator", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "analyze", "", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "CfaVisitor", "ValueWritesWithoutReading", "VariableStatus", "VariableStatusInfo", "checkers"})
public final class UnusedChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final UnusedChecker INSTANCE = new UnusedChecker();

    private UnusedChecker() {
    }

    @Override
    public void analyze(@NotNull PropertyInitializationInfoData data2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Map<CFGNode<?>, PersistentMap<EdgeLabel, VariableStatusInfo>> ownData = new ValueWritesWithoutReading(context2.getSession(), data2.getProperties()).getData(data2.getGraph());
        data2.getGraph().traverse(new CfaVisitor(ownData, reporter, context2));
    }

    private final boolean isLoopIterator(FirPropertySymbol $this$isLoopIterator) {
        Object object = ((FirProperty)$this$isLoopIterator.getFir()).getInitializer();
        return Intrinsics.areEqual((Object)(object != null && (object = ((FirExpression)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012&\u0010\u0002\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001aH\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR1\u0010\u0002\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$CfaVisitor;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/PathAwareVariableStatusInfo;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getData", "()Ljava/util/Map;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "visitNode", "", "node", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nUnusedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$CfaVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1603#2,9:311\n1855#2:320\n1856#2:322\n1612#2:323\n2730#2,7:324\n1#3:321\n*S KotlinDebug\n*F\n+ 1 UnusedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$CfaVisitor\n*L\n69#1:311,9\n69#1:320\n69#1:322\n69#1:323\n69#1:324,7\n69#1:321\n*E\n"})
    public static final class CfaVisitor
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Map<CFGNode<?>, PersistentMap<EdgeLabel, VariableStatusInfo>> data;
        @NotNull
        private final DiagnosticReporter reporter;
        @NotNull
        private final CheckerContext context;

        public CfaVisitor(@NotNull Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, VariableStatusInfo>> data2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.data = data2;
            this.reporter = reporter;
            this.context = context2;
        }

        @NotNull
        public final Map<CFGNode<?>, PersistentMap<EdgeLabel, VariableStatusInfo>> getData() {
            return this.data;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Object object = FirExpressionUtilKt.getCalleeReference(node.getFir());
            if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
                return;
            }
            Object variableSymbol = object;
            PersistentMap<EdgeLabel, VariableStatusInfo> persistentMap = this.data.get(node);
            if (persistentMap == null) {
                return;
            }
            PersistentMap<EdgeLabel, VariableStatusInfo> dataPerNode = persistentMap;
            for (VariableStatusInfo dataPerLabel : (ImmutableCollection)dataPerNode.values()) {
                VariableStatus data2;
                if ((VariableStatus)((Object)dataPerLabel.get(variableSymbol)) == null || data2 != VariableStatus.ONLY_WRITTEN_NEVER_READ) continue;
                KtSourceElement source = node.getFir().getLValue().getSource();
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getASSIGNED_VALUE_IS_NEVER_READ(), (DiagnosticContext)this.context, null, 8, null);
                break;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
            Object v1;
            void $this$reduceOrNull$iv;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirPropertySymbol variableSymbol = node.getFir().getSymbol();
            if (node.getFir().getSource() == null) {
                return;
            }
            if (INSTANCE.isLoopIterator(variableSymbol)) {
                return;
            }
            if (Intrinsics.areEqual((Object)variableSymbol.getName(), (Object)SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) {
                return;
            }
            PersistentMap<EdgeLabel, VariableStatusInfo> persistentMap = this.data.get(node);
            if (persistentMap == null) {
                return;
            }
            PersistentMap<EdgeLabel, VariableStatusInfo> dataPerNode = persistentMap;
            Iterable $this$mapNotNull$iv = dataPerNode.values();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                VariableStatus it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                VariableStatusInfo it = (VariableStatusInfo)element$iv$iv;
                boolean bl2 = false;
                if ((VariableStatus)((Object)it.get((Object)variableSymbol)) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$reduceOrNull = false;
            Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void it;
                    VariableStatus $i$f$mapNotNullTo2 = (VariableStatus)((Object)iterator$iv.next());
                    VariableStatus acc = (VariableStatus)((Object)accumulator$iv);
                    boolean bl = false;
                    accumulator$iv = acc.merge((VariableStatus)it);
                }
                v1 = accumulator$iv;
            }
            VariableStatus data2 = v1;
            if (data2 != null) {
                KtSourceElement variableSource;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(variableSymbol, FirResolvePhase.BODY_RESOLVE);
                FirProperty variable2 = (FirProperty)variableSymbol.getFir();
                KtSourceElement ktSourceElement = variableSource = variable2.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
                    return;
                }
                if (data2 == VariableStatus.UNUSED) {
                    FirExpression firExpression2 = node.getFir().getInitializer();
                    FirFunctionCall firFunctionCall = firExpression2 instanceof FirFunctionCall ? (FirFunctionCall)firExpression2 : null;
                    if (!(firFunctionCall != null ? FirHelpersKt.isIterator(firFunctionCall) : false) && !Intrinsics.areEqual((Object)ClassMembersKt.isCatchParameter(node.getFir()), (Object)true)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)variableSource, FirErrors.INSTANCE.getUNUSED_VARIABLE(), (DiagnosticContext)this.context, null, 8, null);
                    }
                } else if (data2.isRedundantInit()) {
                    FirExpression firExpression3 = variable2.getInitializer();
                    KtSourceElement source = firExpression3 != null ? firExpression3.getSource() : null;
                    KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVARIABLE_INITIALIZER_IS_REDUNDANT(), (DiagnosticContext)this.context, null, 8, null);
                } else if (data2 == VariableStatus.ONLY_WRITTEN_NEVER_READ) {
                    KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)variableSource, FirErrors.INSTANCE.getVARIABLE_NEVER_READ(), (DiagnosticContext)this.context, null, 8, null);
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00010B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ.\u0010\u000f\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f0\u00102\u0006\u0010\u0012\u001a\u00020\u0013Ja\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0017\"\u00020\u00072\u0016\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019H\u0002\u00a2\u0006\u0002\u0010\u001bJ8\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J8\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0006\u0010!\u001a\u00020\"2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\fH\u0016J<\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u00112\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\fH\u0016J8\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0006\u0010!\u001a\u00020&2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\fH\u0016JI\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0\u0017\"\u00020)H\u0002\u00a2\u0006\u0002\u0010*J8\u0010+\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0006\u0010!\u001a\u00020,2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\fH\u0016J8\u0010-\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0006\u0010!\u001a\u00020.2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\fH\u0016J8\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f*\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002R$\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$ValueWritesWithoutReading;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/Set;)V", "emptyInfo", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/PathAwareVariableStatusInfo;", "getEmptyInfo", "()Lkotlinx/collections/immutable/PersistentMap;", "getData", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "update", "pathAwareInfo", "symbols", "", "updater", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatus;", "(Lkotlinx/collections/immutable/PersistentMap;[Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;Lkotlin/jvm/functions/Function1;)Lkotlinx/collections/immutable/PersistentMap;", "visitAnnotation", "dataForNode", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "visitFunctionCallNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallNode;", "data", "visitNode", "visitQualifiedAccessNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "visitQualifiedAccesses", "qualifiedAccesses", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "(Lkotlinx/collections/immutable/PersistentMap;[Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Lkotlinx/collections/immutable/PersistentMap;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "withAnnotationsFrom", "Companion", "checkers"})
    @SourceDebugExtension(value={"SMAP\nUnusedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$ValueWritesWithoutReading\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,310:1\n1789#2,3:311\n1603#2,9:314\n1855#2:323\n1856#2:325\n1612#2:326\n1#3:324\n1#3:339\n1#3:344\n37#4,2:327\n37#4,2:342\n11383#5,9:329\n13309#5:338\n13310#5:340\n11392#5:341\n52#6:345\n*S KotlinDebug\n*F\n+ 1 UnusedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$ValueWritesWithoutReading\n*L\n166#1:311,3\n248#1:314,9\n248#1:323\n248#1:325\n248#1:326\n248#1:324\n263#1:339\n248#1:327,2\n263#1:342,2\n263#1:329,9\n263#1:338\n263#1:340\n263#1:341\n292#1:345\n*E\n"})
    private static final class ValueWritesWithoutReading
    extends PathAwareControlFlowGraphVisitor<VariableStatusInfo> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final FirSession session;
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private static final PersistentMap<EdgeLabel, VariableStatusInfo> EMPTY_INFO;

        public ValueWritesWithoutReading(@NotNull FirSession session, @NotNull Set<? extends FirPropertySymbol> localProperties) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter(localProperties, (String)"localProperties");
            this.session = session;
            this.localProperties = localProperties;
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, VariableStatusInfo> getEmptyInfo() {
            return EMPTY_INFO;
        }

        @NotNull
        public final Map<CFGNode<?>, PersistentMap<EdgeLabel, VariableStatusInfo>> getData(@NotNull ControlFlowGraph graph) {
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            return CfgTraverserKt.collectDataForNode(graph, TraverseDirection.Backward, this);
        }

        /*
         * WARNING - void declaration
         */
        private final PersistentMap<EdgeLabel, VariableStatusInfo> withAnnotationsFrom(PersistentMap<EdgeLabel, VariableStatusInfo> $this$withAnnotationsFrom, CFGNode<?> node) {
            PersistentMap<EdgeLabel, VariableStatusInfo> persistentMap;
            block4: {
                block3: {
                    Object obj = node.getFir();
                    persistentMap = obj instanceof FirAnnotationContainer ? (PersistentMap<EdgeLabel, VariableStatusInfo>)obj : null;
                    if (persistentMap == null || (persistentMap = persistentMap.getAnnotations()) == null) break block3;
                    Iterable $this$fold$iv = (Iterable)persistentMap;
                    boolean $i$f$fold = false;
                    PersistentMap<EdgeLabel, VariableStatusInfo> accumulator$iv = $this$withAnnotationsFrom;
                    for (Object element$iv : $this$fold$iv) {
                        void p1;
                        FirAnnotation firAnnotation = (FirAnnotation)element$iv;
                        PersistentMap<EdgeLabel, VariableStatusInfo> p0 = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = this.visitAnnotation(p0, (FirAnnotation)p1);
                    }
                    persistentMap = accumulator$iv;
                    if (persistentMap != null) break block4;
                }
                persistentMap = $this$withAnnotationsFrom;
            }
            return persistentMap;
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, VariableStatusInfo> visitNode(@NotNull CFGNode<?> node, @NotNull PersistentMap<EdgeLabel, VariableStatusInfo> data2) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            return this.withAnnotationsFrom(super.visitNode(node, data2), node);
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, VariableStatusInfo> visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull PersistentMap<EdgeLabel, VariableStatusInfo> data2) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            PersistentMap<EdgeLabel, VariableStatusInfo> dataForNode = this.visitNode((CFGNode<?>)node, data2);
            KtSourceElement ktSourceElement = node.getFir().getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
                return dataForNode;
            }
            FirPropertySymbol symbol2 = node.getFir().getSymbol();
            FirPropertySymbol[] firPropertySymbolArray = new FirPropertySymbol[]{symbol2};
            return this.update(dataForNode, firPropertySymbolArray, (Function1<? super VariableStatus, ? extends VariableStatus>)((Function1)new Function1<VariableStatus, VariableStatus>(node){
                final /* synthetic */ VariableDeclarationNode $node;
                {
                    this.$node = $node;
                    super(1);
                }

                @Nullable
                public final VariableStatus invoke(@Nullable VariableStatus prev) {
                    VariableStatus variableStatus;
                    VariableStatus variableStatus2 = prev;
                    switch (variableStatus2 == null ? -1 : visitVariableDeclarationNode.WhenMappings.$EnumSwitchMapping$0[variableStatus2.ordinal()]) {
                        case -1: {
                            variableStatus = VariableStatus.UNUSED;
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (this.$node.getFir().getInitializer() != null && prev.isRead()) {
                                prev.setRedundantInit(true);
                                variableStatus = prev;
                                break;
                            }
                            if (this.$node.getFir().getInitializer() != null) {
                                variableStatus = VariableStatus.ONLY_WRITTEN_NEVER_READ;
                                break;
                            }
                            variableStatus = null;
                            break;
                        }
                        case 3: {
                            variableStatus = VariableStatus.READ;
                            break;
                        }
                        default: {
                            variableStatus = null;
                        }
                    }
                    return variableStatus;
                }
            }));
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, VariableStatusInfo> visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull PersistentMap<EdgeLabel, VariableStatusInfo> data2) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            PersistentMap<EdgeLabel, VariableStatusInfo> dataForNode = this.visitNode((CFGNode<?>)node, data2);
            Object object = FirExpressionUtilKt.getCalleeReference(node.getFir());
            if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
                return dataForNode;
            }
            Object symbol2 = object;
            FirPropertySymbol[] firPropertySymbolArray = new FirPropertySymbol[]{symbol2};
            return this.update(dataForNode, firPropertySymbolArray, (Function1<? super VariableStatus, ? extends VariableStatus>)((Function1)new Function1<VariableStatus, VariableStatus>(this, (FirPropertySymbol)symbol2){
                final /* synthetic */ ValueWritesWithoutReading this$0;
                final /* synthetic */ FirPropertySymbol $symbol;
                {
                    this.this$0 = $receiver;
                    this.$symbol = $symbol;
                    super(1);
                }

                @Nullable
                public final VariableStatus invoke(@Nullable VariableStatus prev) {
                    VariableStatus toPut;
                    VariableStatus variableStatus;
                    if (!ValueWritesWithoutReading.access$getLocalProperties$p(this.this$0).contains(this.$symbol)) {
                        variableStatus = null;
                    } else if (prev == VariableStatus.READ) {
                        variableStatus = VariableStatus.WRITTEN_AFTER_READ;
                    } else if (prev == VariableStatus.WRITTEN_AFTER_READ) {
                        variableStatus = VariableStatus.ONLY_WRITTEN_NEVER_READ;
                    } else {
                        VariableStatus variableStatus2 = prev;
                        if (variableStatus2 == null) {
                            variableStatus2 = VariableStatus.UNUSED;
                        }
                        variableStatus = VariableStatus.ONLY_WRITTEN_NEVER_READ.merge(variableStatus2);
                    }
                    if ((toPut = variableStatus) == null) {
                        return null;
                    }
                    VariableStatus variableStatus3 = prev;
                    toPut.setRead(variableStatus3 != null ? variableStatus3.isRead() : false);
                    return toPut;
                }
            }));
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, VariableStatusInfo> visitQualifiedAccessNode(@NotNull QualifiedAccessNode node, @NotNull PersistentMap<EdgeLabel, VariableStatusInfo> data2) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            PersistentMap<EdgeLabel, VariableStatusInfo> dataForNode = this.visitNode((CFGNode<?>)node, data2);
            FirQualifiedAccessExpression[] firQualifiedAccessExpressionArray = new FirQualifiedAccessExpression[]{node.getFir()};
            return this.visitQualifiedAccesses(dataForNode, firQualifiedAccessExpressionArray);
        }

        /*
         * WARNING - void declaration
         */
        private final PersistentMap<EdgeLabel, VariableStatusInfo> visitAnnotation(PersistentMap<EdgeLabel, VariableStatusInfo> dataForNode, FirAnnotation annotation2) {
            PersistentMap<EdgeLabel, VariableStatusInfo> persistentMap;
            if (annotation2 instanceof FirAnnotationCall) {
                void $this$toTypedArray$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = ((FirAnnotationCall)annotation2).getArgumentList().getArguments();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FirQualifiedAccessExpression it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    FirExpression it = (FirExpression)element$iv$iv;
                    boolean bl2 = false;
                    if ((it instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)it : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                FirQualifiedAccessExpression[] qualifiedAccesses = thisCollection$iv.toArray(new FirQualifiedAccessExpression[0]);
                persistentMap = this.visitQualifiedAccesses(dataForNode, Arrays.copyOf(qualifiedAccesses, qualifiedAccesses.length));
            } else {
                persistentMap = dataForNode;
            }
            return persistentMap;
        }

        /*
         * WARNING - void declaration
         */
        private final PersistentMap<EdgeLabel, VariableStatusInfo> visitQualifiedAccesses(PersistentMap<EdgeLabel, VariableStatusInfo> dataForNode, FirQualifiedAccessExpression ... qualifiedAccesses) {
            void $this$toTypedArray$iv;
            void $this$mapNotNullTo$iv$iv;
            Object $this$mapNotNull$iv = qualifiedAccesses;
            boolean $i$f$mapNotNull = false;
            FirQualifiedAccessExpression[] firQualifiedAccessExpressionArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                FirPropertySymbol it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (ValueWritesWithoutReading.visitQualifiedAccesses$retrieveSymbol(this, (FirQualifiedAccessExpression)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            FirPropertySymbol[] symbols = thisCollection$iv.toArray(new FirPropertySymbol[0]);
            VariableStatus status2 = VariableStatus.READ;
            status2.setRead(true);
            return this.update(dataForNode, Arrays.copyOf(symbols, symbols.length), (Function1<? super VariableStatus, ? extends VariableStatus>)((Function1)new Function1<VariableStatus, VariableStatus>(status2){
                final /* synthetic */ VariableStatus $status;
                {
                    this.$status = $status;
                    super(1);
                }

                @Nullable
                public final VariableStatus invoke(@Nullable VariableStatus it) {
                    return this.$status;
                }
            }));
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, VariableStatusInfo> visitFunctionCallNode(@NotNull FunctionCallNode node, @NotNull PersistentMap<EdgeLabel, VariableStatusInfo> data2) {
            FirPropertySymbol symbol2;
            FirPropertySymbol firPropertySymbol;
            FirPropertySymbol[] firPropertySymbolArray;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            PersistentMap<EdgeLabel, VariableStatusInfo> dataForNode = this.visitNode((CFGNode<?>)node, data2);
            FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(node.getFir().getCalleeReference());
            if (firResolvedNamedReference == null) {
                return dataForNode;
            }
            FirResolvedNamedReference reference2 = firResolvedNamedReference;
            FirBasedSymbol<?> firBasedSymbol = reference2.getResolvedSymbol();
            FirFunctionSymbol firFunctionSymbol = firBasedSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firBasedSymbol : null;
            if (firFunctionSymbol == null) {
                return dataForNode;
            }
            FirFunctionSymbol functionSymbol = firFunctionSymbol;
            if (Intrinsics.areEqual((Object)functionSymbol.getCallableId().getCallableName().getIdentifier(), (Object)"invoke")) {
                Object v2;
                block6: {
                    firPropertySymbolArray = (FirPropertySymbol[])this.localProperties;
                    for (Object t : firPropertySymbolArray) {
                        FirPropertySymbol it = (FirPropertySymbol)t;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getName(), (Object)reference2.getName()) && FunctionalTypeUtilsKt.isBasicFunctionType(FirTypeUtilsKt.getConeType(it.getResolvedReturnTypeRef()), this.session))) continue;
                        v2 = t;
                        break block6;
                    }
                    v2 = null;
                }
                firPropertySymbol = v2;
            } else {
                firPropertySymbol = null;
            }
            if ((symbol2 = firPropertySymbol) == null) {
                return dataForNode;
            }
            VariableStatus status2 = VariableStatus.READ;
            status2.setRead(true);
            firPropertySymbolArray = new FirPropertySymbol[]{symbol2};
            return this.update(dataForNode, firPropertySymbolArray, (Function1<? super VariableStatus, ? extends VariableStatus>)((Function1)new Function1<VariableStatus, VariableStatus>(status2){
                final /* synthetic */ VariableStatus $status;
                {
                    this.$status = $status;
                    super(1);
                }

                @Nullable
                public final VariableStatus invoke(@Nullable VariableStatus it) {
                    return this.$status;
                }
            }));
        }

        private final PersistentMap<EdgeLabel, VariableStatusInfo> update(PersistentMap<EdgeLabel, VariableStatusInfo> pathAwareInfo, FirPropertySymbol[] symbols, Function1<? super VariableStatus, ? extends VariableStatus> updater) {
            PersistentMap<EdgeLabel, VariableStatusInfo> $this$mutate$iv = pathAwareInfo;
            boolean $i$f$mutate = false;
            PersistentMap.Builder builder2 = $this$mutate$iv.builder();
            Map it = (Map)builder2;
            boolean bl = false;
            for (Map.Entry entry : ((Map)pathAwareInfo).entrySet()) {
                EdgeLabel label = (EdgeLabel)entry.getKey();
                VariableStatusInfo dataPerLabel = (VariableStatusInfo)entry.getValue();
                for (FirPropertySymbol symbol2 : symbols) {
                    VariableStatus v;
                    if ((VariableStatus)((Object)updater.invoke(dataPerLabel.get((Object)symbol2))) == null) continue;
                    it.put(label, dataPerLabel.put(symbol2, (Object)v));
                }
            }
            return builder2.build();
        }

        private static final FirPropertySymbol visitQualifiedAccesses$retrieveSymbol(ValueWritesWithoutReading this$0, FirQualifiedAccessExpression qualifiedAccess) {
            FirPropertySymbol firPropertySymbol;
            FirPropertySymbol firPropertySymbol2 = FirReferenceUtilsKt.toResolvedPropertySymbol$default(qualifiedAccess.getCalleeReference(), false, 1, null);
            if (firPropertySymbol2 != null) {
                FirPropertySymbol firPropertySymbol3;
                FirPropertySymbol it = firPropertySymbol3 = firPropertySymbol2;
                boolean bl = false;
                firPropertySymbol = this$0.localProperties.contains(it) ? firPropertySymbol3 : null;
            } else {
                firPropertySymbol = null;
            }
            return firPropertySymbol;
        }

        public static final /* synthetic */ Set access$getLocalProperties$p(ValueWritesWithoutReading $this) {
            return $this.localProperties;
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)NormalPath.INSTANCE, (Object)VariableStatusInfo.Companion.getEMPTY())};
            EMPTY_INFO = ExtensionsKt.persistentMapOf((Pair[])pairArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$ValueWritesWithoutReading$Companion;", "", "()V", "EMPTY_INFO", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/PathAwareVariableStatusInfo;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatus;", "", "priority", "", "(Ljava/lang/String;II)V", "isRead", "", "()Z", "setRead", "(Z)V", "isRedundantInit", "setRedundantInit", "merge", "variableUseState", "READ", "WRITTEN_AFTER_READ", "ONLY_WRITTEN_NEVER_READ", "UNUSED", "checkers"})
    public static final class VariableStatus
    extends Enum<VariableStatus> {
        private final int priority;
        private boolean isRead;
        private boolean isRedundantInit;
        public static final /* enum */ VariableStatus READ = new VariableStatus(3);
        public static final /* enum */ VariableStatus WRITTEN_AFTER_READ = new VariableStatus(2);
        public static final /* enum */ VariableStatus ONLY_WRITTEN_NEVER_READ = new VariableStatus(1);
        public static final /* enum */ VariableStatus UNUSED = new VariableStatus(0);
        private static final /* synthetic */ VariableStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private VariableStatus(int priority) {
            this.priority = priority;
        }

        public final boolean isRead() {
            return this.isRead;
        }

        public final void setRead(boolean bl) {
            this.isRead = bl;
        }

        public final boolean isRedundantInit() {
            return this.isRedundantInit;
        }

        public final void setRedundantInit(boolean bl) {
            this.isRedundantInit = bl;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final VariableStatus merge(@Nullable VariableStatus variableUseState) {
            it = var3_3 = (base = variableUseState == null || this.priority > variableUseState.priority ? this : variableUseState);
            $i$a$-also-UnusedChecker$VariableStatus$merge$1 = false;
            if (this.isRead) ** GOTO lbl-1000
            v0 = variableUseState;
            v1 = v0 != null ? v0.isRead : false;
            if (v1) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = it.isRead = false;
            }
            if (!this.isRedundantInit) ** GOTO lbl-1000
            v3 = variableUseState;
            v4 = v3 != null ? v3.isRedundantInit : false;
            if (v4) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            it.isRedundantInit = v5;
            return var3_3;
        }

        public static VariableStatus[] values() {
            return (VariableStatus[])$VALUES.clone();
        }

        public static VariableStatus valueOf(String value2) {
            return Enum.valueOf(VariableStatus.class, value2);
        }

        @NotNull
        public static EnumEntries<VariableStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = variableStatusArray = new VariableStatus[]{VariableStatus.READ, VariableStatus.WRITTEN_AFTER_READ, VariableStatus.ONLY_WRITTEN_NEVER_READ, VariableStatus.UNUSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u000e2\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000eB\u001b\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0016J\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0016R,\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0004\u0012\u00020\u00000\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatus;", "map", "Lkotlinx/collections/immutable/PersistentMap;", "(Lkotlinx/collections/immutable/PersistentMap;)V", "constructor", "Lkotlin/Function1;", "getConstructor", "()Lkotlin/jvm/functions/Function1;", "merge", "other", "plus", "Companion", "checkers"})
    public static final class VariableStatusInfo
    extends ControlFlowInfo<VariableStatusInfo, FirPropertySymbol, VariableStatus> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Function1<PersistentMap<FirPropertySymbol, ? extends VariableStatus>, VariableStatusInfo> constructor;
        @NotNull
        private static final VariableStatusInfo EMPTY = new VariableStatusInfo(null, 1, null);

        public VariableStatusInfo(@NotNull PersistentMap<FirPropertySymbol, ? extends VariableStatus> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
            this.constructor = constructor.1.INSTANCE;
        }

        public /* synthetic */ VariableStatusInfo(PersistentMap persistentMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                persistentMap = ExtensionsKt.persistentMapOf((Pair[])new Pair[0]);
            }
            this((PersistentMap<FirPropertySymbol, ? extends VariableStatus>)persistentMap);
        }

        @Override
        @NotNull
        protected Function1<PersistentMap<FirPropertySymbol, ? extends VariableStatus>, VariableStatusInfo> getConstructor() {
            return this.constructor;
        }

        @Override
        @NotNull
        public VariableStatusInfo merge(@NotNull VariableStatusInfo other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            VariableStatusInfo result2 = this;
            for (FirPropertySymbol symbol2 : CollectionsKt.union((Iterable)this.keySet(), (Iterable)other.keySet())) {
                VariableStatus variableStatus;
                VariableStatus kind1;
                VariableStatus variableStatus2 = (VariableStatus)((Object)this.get((Object)symbol2));
                if (variableStatus2 == null) {
                    variableStatus2 = kind1 = VariableStatus.UNUSED;
                }
                if ((variableStatus = (VariableStatus)((Object)other.get((Object)symbol2))) == null) {
                    variableStatus = VariableStatus.UNUSED;
                }
                VariableStatus kind2 = variableStatus;
                VariableStatus variableStatus3 = kind1.merge(kind2);
                result2 = (VariableStatusInfo)result2.put(symbol2, (Object)variableStatus3);
            }
            return result2;
        }

        @Override
        @NotNull
        public VariableStatusInfo plus(@NotNull VariableStatusInfo other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.merge(other);
        }

        public VariableStatusInfo() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "getEMPTY", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final VariableStatusInfo getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

