/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirArrayLiteralChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isInsideAnnotationCall", "", "isInsideAnnotationClass", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnsupportedArrayLiteralChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnsupportedArrayLiteralChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,93:1\n45#2:94\n45#2:95\n45#2:102\n1747#3,2:96\n1549#3:98\n1620#3,3:99\n1747#3,3:103\n1749#3:106\n67#4:107\n*S KotlinDebug\n*F\n+ 1 FirUnsupportedArrayLiteralChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker\n*L\n40#1:94\n44#1:95\n60#1:102\n48#1:96,2\n51#1:98\n51#1:99,3\n60#1:103,3\n48#1:106\n76#1:107\n*E\n"})
public final class FirUnsupportedArrayLiteralChecker
extends FirExpressionChecker<FirArrayLiteral> {
    @NotNull
    public static final FirUnsupportedArrayLiteralChecker INSTANCE = new FirUnsupportedArrayLiteralChecker();

    private FirUnsupportedArrayLiteralChecker() {
    }

    @Override
    public void check(@NotNull FirArrayLiteral expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(this.isInsideAnnotationCall(expression2, context2) || !(!((Collection)context2.getCallsOrAssignments()).isEmpty()) && this.isInsideAnnotationClass(context2))) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Collection literals outside of annotations", (DiagnosticContext)context2, null, 16, null);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideAnnotationCall(FirArrayLiteral expression2, CheckerContext context2) {
        boolean bl;
        List<FirExpression> list2;
        boolean $i$f$getArguments;
        FirCall $this$arguments$iv;
        FirStatement firStatement = (FirStatement)CollectionsKt.lastOrNull(context2.getCallsOrAssignments());
        if (firStatement == null) return false;
        FirStatement it = firStatement;
        boolean bl2 = false;
        FirStatement firStatement2 = it;
        if (firStatement2 instanceof FirFunctionCall) {
            FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getResolvedType((FirExpression)it), context2.getSession());
            if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) != ClassKind.ANNOTATION_CLASS) return false;
            $this$arguments$iv = (FirCall)it;
            $i$f$getArguments = false;
            list2 = $this$arguments$iv.getArgumentList().getArguments();
        } else {
            if (!(firStatement2 instanceof FirAnnotationCall)) return false;
            $this$arguments$iv = (FirCall)it;
            $i$f$getArguments = false;
            list2 = $this$arguments$iv.getArgumentList().getArguments();
        }
        List<FirExpression> arguments2 = list2;
        Iterable $this$any$iv = arguments2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            List list3;
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            FirExpression argument2 = (FirExpression)element$iv;
            boolean bl3 = false;
            if (argument2 instanceof FirVarargArgumentsExpression) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((FirVarargArgumentsExpression)argument2).getArguments();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void arg;
                    FirExpression firExpression2 = (FirExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(FirExpressionUtilKt.unwrapArgument((FirExpression)arg));
                }
                list3 = (List)destination$iv$iv;
            } else {
                list3 = CollectionsKt.listOf((Object)FirExpressionUtilKt.unwrapArgument(argument2));
            }
            List unwrappedArguments = list3;
            for (FirExpression unwrapped : unwrappedArguments) {
                boolean bl5;
                if (Intrinsics.areEqual((Object)unwrapped, (Object)expression2)) return true;
                if (unwrapped instanceof FirErrorExpression) {
                    if (Intrinsics.areEqual((Object)((FirErrorExpression)unwrapped).getExpression(), (Object)expression2)) return true;
                }
                if (!(unwrapped instanceof FirArrayLiteral)) continue;
                FirCall $this$arguments$iv2 = (FirCall)((Object)unwrapped);
                boolean $i$f$getArguments2 = false;
                Iterable $this$any$iv2 = $this$arguments$iv2.getArgumentList().getArguments();
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv2) {
                        FirExpression arrayLiteralElement = (FirExpression)element$iv2;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)FirExpressionUtilKt.unwrapArgument(arrayLiteralElement), (Object)expression2)) continue;
                        return true;
                    }
                    bl5 = false;
                }
                if (!bl5) continue;
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean isInsideAnnotationClass(CheckerContext context2) {
        for (FirDeclaration declaration : CollectionsKt.asReversed(context2.getContainingDeclarations())) {
            if (declaration instanceof FirRegularClass) {
                FirRegularClass $this$isCompanion$iv = (FirRegularClass)declaration;
                boolean $i$f$isCompanion = false;
                if ($this$isCompanion$iv.getStatus().isCompanion()) continue;
                if (((FirRegularClass)declaration).getClassKind() != ClassKind.ANNOTATION_CLASS) break;
                return true;
            }
            if (declaration instanceof FirValueParameter || declaration instanceof FirPrimaryConstructor) continue;
        }
        return false;
    }
}

