/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtDiagnosticReporterWithImplicitIrBasedContext;
import org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualAnnotationMatchingChecker;
import org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualAnnotationMatchingChecker$getContainingTopLevelClass$;
import org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMatchingContext;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.mpp.DeclarationSymbolMarker;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualAnnotationMatchChecker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000O\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\r\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualAnnotationMatchingChecker;", "", "matchedExpectToActual", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "classActualizationInfo", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "typeSystemContext", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/KtDiagnosticReporterWithImplicitIrBasedContext;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Lorg/jetbrains/kotlin/KtDiagnosticReporterWithImplicitIrBasedContext;)V", "context", "org/jetbrains/kotlin/backend/common/actualizer/IrExpectActualAnnotationMatchingChecker$context$1", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualAnnotationMatchingChecker$context$1;", "isFakeOverride", "", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)Z", "check", "", "getContainingActualClassIfFakeOverride", "actualSymbol", "getContainingTopLevelClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "symbol", "getTypealiasSymbolIfActualizedViaTypealias", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeAliasSymbol;", "expectSymbol", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrExpectActualAnnotationMatchingChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrExpectActualAnnotationMatchingChecker.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualAnnotationMatchingChecker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,82:1\n473#2:83\n*S KotlinDebug\n*F\n+ 1 IrExpectActualAnnotationMatchingChecker.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualAnnotationMatchingChecker\n*L\n80#1:83\n*E\n"})
public final class IrExpectActualAnnotationMatchingChecker {
    @NotNull
    private final Map<IrSymbol, IrSymbol> matchedExpectToActual;
    @NotNull
    private final ClassActualizationInfo classActualizationInfo;
    @NotNull
    private final KtDiagnosticReporterWithImplicitIrBasedContext diagnosticsReporter;
    @NotNull
    private final context.1 context;

    public IrExpectActualAnnotationMatchingChecker(@NotNull Map<IrSymbol, ? extends IrSymbol> matchedExpectToActual, @NotNull ClassActualizationInfo classActualizationInfo, @NotNull IrTypeSystemContext typeSystemContext2, @NotNull KtDiagnosticReporterWithImplicitIrBasedContext diagnosticsReporter) {
        Intrinsics.checkNotNullParameter(matchedExpectToActual, (String)"matchedExpectToActual");
        Intrinsics.checkNotNullParameter((Object)classActualizationInfo, (String)"classActualizationInfo");
        Intrinsics.checkNotNullParameter((Object)typeSystemContext2, (String)"typeSystemContext");
        Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
        this.matchedExpectToActual = matchedExpectToActual;
        this.classActualizationInfo = classActualizationInfo;
        this.diagnosticsReporter = diagnosticsReporter;
        Map<ClassId, IrClassSymbol> map = this.classActualizationInfo.getActualClasses();
        this.context = new IrExpectActualMatchingContext(typeSystemContext2, map){

            public void onMatchedClasses(@NotNull IrClassSymbol expectClassSymbol, @NotNull IrClassSymbol actualClassSymbol) {
                Intrinsics.checkNotNullParameter((Object)expectClassSymbol, (String)"expectClassSymbol");
                Intrinsics.checkNotNullParameter((Object)actualClassSymbol, (String)"actualClassSymbol");
                throw new IllegalStateException("Must not be called".toString());
            }

            public void onMatchedCallables(@NotNull IrSymbol expectSymbol, @NotNull IrSymbol actualSymbol) {
                Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
                Intrinsics.checkNotNullParameter((Object)actualSymbol, (String)"actualSymbol");
                throw new IllegalStateException("Must not be called".toString());
            }
        };
    }

    public final void check() {
        for (Map.Entry<IrSymbol, IrSymbol> entry : this.matchedExpectToActual.entrySet()) {
            AbstractExpectActualAnnotationMatchChecker.Incompatibility incompatibility;
            IrSymbol irSymbol2;
            IrSymbol expectSymbol = entry.getKey();
            IrSymbol actualSymbol = entry.getValue();
            if (expectSymbol instanceof IrTypeParameterSymbol || this.isFakeOverride(expectSymbol) || AbstractExpectActualAnnotationMatchChecker.INSTANCE.areAnnotationsCompatible(expectSymbol, (DeclarationSymbolMarker)actualSymbol, this.context) == null) continue;
            IrTypeAliasSymbol irTypeAliasSymbol = this.getTypealiasSymbolIfActualizedViaTypealias(expectSymbol);
            if (irTypeAliasSymbol != null) {
                irSymbol2 = irTypeAliasSymbol;
            } else {
                irSymbol2 = this.getContainingActualClassIfFakeOverride(actualSymbol);
                if (irSymbol2 == null) {
                    irSymbol2 = actualSymbol;
                }
            }
            IrSymbol reportOn = irSymbol2;
            DeclarationSymbolMarker declarationSymbolMarker = incompatibility.getExpectSymbol();
            Intrinsics.checkNotNull((Object)declarationSymbolMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrSymbol");
            IrSymbol irSymbol3 = (IrSymbol)declarationSymbolMarker;
            DeclarationSymbolMarker declarationSymbolMarker2 = incompatibility.getActualSymbol();
            Intrinsics.checkNotNull((Object)declarationSymbolMarker2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrSymbol");
            IrActualizerUtilsKt.reportActualAnnotationsNotMatchExpect(this.diagnosticsReporter, irSymbol3, (IrSymbol)declarationSymbolMarker2, incompatibility.getType().mapAnnotationType(check.1.INSTANCE), reportOn);
        }
    }

    private final boolean isFakeOverride(IrSymbol $this$isFakeOverride) {
        IrSymbolOwner irSymbolOwner = $this$isFakeOverride.getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        return IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)irSymbolOwner);
    }

    private final IrTypeAliasSymbol getTypealiasSymbolIfActualizedViaTypealias(IrSymbol expectSymbol) {
        IrClass irClass2 = this.getContainingTopLevelClass(expectSymbol);
        if (irClass2 == null) {
            return null;
        }
        IrClass topLevelExpectClass = irClass2;
        ClassId classId = AdditionalIrUtilsKt.getClassIdOrFail(topLevelExpectClass);
        return this.classActualizationInfo.getActualTypeAliases().get(classId);
    }

    private final IrSymbol getContainingActualClassIfFakeOverride(IrSymbol actualSymbol) {
        if (!this.isFakeOverride(actualSymbol)) {
            return null;
        }
        IrClass irClass2 = this.getContainingTopLevelClass(actualSymbol);
        return irClass2 != null ? irClass2.getSymbol() : null;
    }

    private final IrClass getContainingTopLevelClass(IrSymbol symbol2) {
        Sequence parentsWithSelf2;
        IrSymbolOwner irSymbolOwner = symbol2.getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        IrDeclaration declaration = (IrDeclaration)irSymbolOwner;
        Object[] objectArray = new IrDeclaration[]{declaration};
        Sequence $this$filterIsInstance$iv = parentsWithSelf2 = SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])objectArray), LocalDeclarationsLoweringKt.getParents(declaration));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getContainingTopLevelClass$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return (IrClass)SequencesKt.lastOrNull((Sequence)sequence2);
    }
}

