/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.ConversionTypeOrigin;
import org.jetbrains.kotlin.fir.backend.Fir2IrAnnotationsFromPluginRegistrar;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import org.jetbrains.kotlin.fir.backend.Fir2IrCommonMemberStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConfiguration;
import org.jetbrains.kotlin.fir.backend.Fir2IrConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.Fir2IrLocalClassStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.IrBuiltInsOverFir;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DelegatedMemberGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrClassifiersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyDeclarationsGenerator;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.lazy.Fir2IrLazyClass;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.signaturer.FirBasedSignatureComposer;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrTypeParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J5\u0010~\u001a\u00020\u001d2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\n\b\u0002\u0010\u0081\u0001\u001a\u00030\u0082\u00012\n\b\u0002\u0010\u0083\u0001\u001a\u00030\u0084\u00012\f\b\u0002\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u0001J\u001a\u0010\u0087\u0001\u001a\u00020\u001d2\u0007\u0010\u0088\u0001\u001a\u00020&2\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001J(\u0010\u008b\u0001\u001a\u00020\u001d2\u0007\u0010\u008c\u0001\u001a\u00020\u001c2\b\u0010\u008d\u0001\u001a\u00030\u0086\u00012\f\b\u0002\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u0001J\u001a\u0010\u0090\u0001\u001a\u00020q2\u0007\u0010\u0091\u0001\u001a\u00020p2\b\u0010\u008d\u0001\u001a\u00030\u0086\u0001J2\u0010\u0092\u0001\u001a\u00020x2\u0007\u0010\u0093\u0001\u001a\u00020w2\b\u0010\u0094\u0001\u001a\u00030\u0095\u00012\b\u0010\u0096\u0001\u001a\u00030\u0097\u00012\n\b\u0002\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0002J\u0012\u0010\u009a\u0001\u001a\u00020\u001d2\u0007\u0010\u009b\u0001\u001a\u00020VH\u0002J\u0013\u0010\u009c\u0001\u001a\u00030\u009d\u00012\u0007\u0010\u009e\u0001\u001a\u00020wH\u0002J\u0013\u0010\u009f\u0001\u001a\u0004\u0018\u00010\u001d2\b\u0010\u00a0\u0001\u001a\u00030\u00a1\u0001J\u0012\u0010\u00a2\u0001\u001a\u0004\u0018\u00010\u001d2\u0007\u0010\u009b\u0001\u001a\u00020VJ\u0012\u0010\u00a3\u0001\u001a\u0004\u0018\u00010\u001d2\u0007\u0010\u0088\u0001\u001a\u00020&J\u001a\u0010\u00a4\u0001\u001a\u0004\u0018\u0001092\u0007\u0010\u00a5\u0001\u001a\u000208H\u0000\u00a2\u0006\u0003\b\u00a6\u0001J&\u0010\u00a7\u0001\u001a\u0004\u0018\u00010x2\u0007\u0010\u0093\u0001\u001a\u00020w2\n\b\u0002\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0000\u00a2\u0006\u0003\b\u00a8\u0001J\u0015\u0010\u00a9\u0001\u001a\u0004\u0018\u00010\u001d2\b\u0010\u00a0\u0001\u001a\u00030\u00a1\u0001H\u0002J\u001a\u0010\u00aa\u0001\u001a\u0004\u0018\u00010q2\u0007\u0010\u00ab\u0001\u001a\u00020pH\u0000\u00a2\u0006\u0003\b\u00ac\u0001J\u001f\u0010\u00ad\u0001\u001a\b\u0012\u0004\u0012\u00020D0C2\u0007\u0010\u00ae\u0001\u001a\u00020\u001d2\u0007\u0010\u009b\u0001\u001a\u00020VJ%\u0010\u00af\u0001\u001a\u00020\u001d2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\t\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u001dJ\u0016\u0010\u00b0\u0001\u001a\u00030\u00b1\u00012\f\u0010\u00b2\u0001\u001a\u0007\u0012\u0002\b\u00030\u00b3\u0001J'\u0010\u00b4\u0001\u001a\u0002092\u0007\u0010\u00a5\u0001\u001a\u0002082\u0007\u0010\u0085\u0001\u001a\u00020\u001d2\f\b\u0002\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u0001J8\u0010\u00b5\u0001\u001a\u00020x2\u0007\u0010\u0093\u0001\u001a\u00020w2\b\u0010\u0094\u0001\u001a\u00030\u0095\u00012\b\u0010\u0096\u0001\u001a\u00030\u0097\u00012\n\b\u0002\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0000\u00a2\u0006\u0003\b\u00b6\u0001J\u001c\u0010\u00b7\u0001\u001a\u00030\u009d\u00012\b\u0010\u00b8\u0001\u001a\u00030\u00b9\u00012\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001J\b\u0010\u00ba\u0001\u001a\u00030\u00bb\u0001J$\u0010\u00bc\u0001\u001a\u00030\u00bb\u00012\b\u0010\u00bd\u0001\u001a\u00030\u00be\u00012\b\u0010\u00bf\u0001\u001a\u00030\u0097\u0001H\u0000\u00a2\u0006\u0003\b\u00c0\u0001J\b\u0010\u00c1\u0001\u001a\u00030\u00bb\u0001J\u001a\u0010\u00c2\u0001\u001a\u00030\u00bb\u00012\u0007\u0010\u00a5\u0001\u001a\u0002082\u0007\u0010\u00c3\u0001\u001a\u00020\u001dJ\u001b\u0010\u00c4\u0001\u001a\u00030\u00c5\u0001*\u00030\u00c6\u00012\n\b\u0002\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0002R\u0012\u0010\u0006\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u00020\"X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u00020(X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0012\u0010+\u001a\u00020,X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0012\u0010/\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0012\u00103\u001a\u000204X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u001a\u00107\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u0002090\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010:\u001a\u00020;X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0012\u0010>\u001a\u00020?X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR \u0010B\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0C0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010E\u001a\u00020FX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0012\u0010I\u001a\u00020JX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u0018\u0010M\u001a\b\u0012\u0004\u0012\u00020N0CX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR\u0012\u0010Q\u001a\u00020RX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u001a\u0010U\u001a\u000e\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020XX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010Y\u001a\u00020ZX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\R\u000e\u0010]\u001a\u00020^X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010_\u001a\u00020`X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\ba\u0010bR\u0012\u0010c\u001a\u00020dX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\be\u0010fR\u0012\u0010g\u001a\u00020hX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bi\u0010jR\u0012\u0010k\u001a\u00020lX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bm\u0010nR\u001a\u0010o\u001a\u000e\u0012\u0004\u0012\u00020p\u0012\u0004\u0012\u00020q0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010r\u001a\u00020sX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bt\u0010uR\u001a\u0010v\u001a\u000e\u0012\u0004\u0012\u00020w\u0012\u0004\u0012\u00020x0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010y\u001a\u000e\u0012\u0004\u0012\u00020w\u0012\u0004\u0012\u00020x0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010z\u001a\u00020{X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b|\u0010}\u00a8\u0006\u00c7\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "components", "commonMemberStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrCommonMemberStorage;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/backend/Fir2IrCommonMemberStorage;)V", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "annotationsFromPluginRegistrar", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrAnnotationsFromPluginRegistrar;", "getAnnotationsFromPluginRegistrar", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrAnnotationsFromPluginRegistrar;", "builtIns", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "callablesGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "getCallablesGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "classCache", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "classifierStorage", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "classifiersGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "getClassifiersGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "codeFragmentCache", "Lorg/jetbrains/kotlin/fir/declarations/FirCodeFragment;", "configuration", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "getConfiguration", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "converter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "getConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "delegatedMemberGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "getDelegatedMemberGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "enumEntryCache", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "extensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "getExtensions", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "getFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "fieldsForContextReceivers", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "irBuiltIns", "Lorg/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "irProviders", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "getIrProviders", "()Ljava/util/List;", "lazyDeclarationsGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "getLazyDeclarationsGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "localClassesCreatedOnTheFly", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "localStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrLocalClassStorage;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "processMembersOfClassesOnTheFlyImmediately", "", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeAliasCache", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "typeParameterCache", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "typeParameterCacheForSetter", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "createAndCacheAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "name", "Lorg/jetbrains/kotlin/name/Name;", "irParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "createAndCacheCodeFragmentClass", "codeFragment", "containingFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "createAndCacheIrClass", "regularClass", "parent", "predefinedOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "createAndCacheIrTypeAlias", "typeAlias", "createAndCacheIrTypeParameter", "typeParameter", "index", "", "ownerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "typeOrigin", "Lorg/jetbrains/kotlin/fir/backend/ConversionTypeOrigin;", "createAndCacheLocalIrClassOnTheFly", "klass", "createIrTypeParameterForNonCachedDeclaration", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "firTypeParameter", "findIrClass", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "getCachedIrClass", "getCachedIrCodeFragment", "getCachedIrEnumEntry", "enumEntry", "getCachedIrEnumEntry$fir2ir", "getCachedIrTypeParameter", "getCachedIrTypeParameter$fir2ir", "getCachedLocalClass", "getCachedTypeAlias", "firTypeAlias", "getCachedTypeAlias$fir2ir", "getFieldsWithContextReceiversForClass", "irClass", "getIrAnonymousObjectForEnumEntry", "getIrClassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "firClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getIrEnumEntry", "getIrTypeParameter", "getIrTypeParameter$fir2ir", "getIrTypeParameterSymbol", "firTypeParameterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "preCacheBuiltinClasses", "", "preCacheTypeParameters", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "irOwnerSymbol", "preCacheTypeParameters$fir2ir", "processMembersOfClassesCreatedOnTheFly", "putEnumEntryClassInScope", "correspondingClass", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrClassifierStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrClassifierStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,380:1\n1#2:381\n21#3:382\n21#3:383\n21#3:384\n372#4,3:385\n375#4,4:392\n1549#5:388\n1620#5,3:389\n*S KotlinDebug\n*F\n+ 1 Fir2IrClassifierStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage\n*L\n185#1:382\n194#1:383\n222#1:384\n245#1:385,3\n245#1:392,4\n246#1:388\n246#1:389,3\n*E\n"})
public final class Fir2IrClassifierStorage
implements Fir2IrComponents {
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final Map<FirRegularClass, IrClass> classCache;
    @NotNull
    private final Map<FirTypeAlias, IrTypeAlias> typeAliasCache;
    @NotNull
    private final Map<FirTypeParameter, IrTypeParameter> typeParameterCache;
    @NotNull
    private final Map<FirTypeParameter, IrTypeParameter> typeParameterCacheForSetter;
    @NotNull
    private final Map<FirEnumEntry, IrEnumEntry> enumEntryCache;
    @NotNull
    private final Map<FirCodeFragment, IrClass> codeFragmentCache;
    @NotNull
    private final Map<IrClass, List<IrField>> fieldsForContextReceivers;
    @NotNull
    private final Fir2IrLocalClassStorage localStorage;
    @NotNull
    private final Map<FirClass, IrClass> localClassesCreatedOnTheFly;
    private boolean processMembersOfClassesOnTheFlyImmediately;

    public Fir2IrClassifierStorage(@NotNull Fir2IrComponents components2, @NotNull Fir2IrCommonMemberStorage commonMemberStorage) {
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        Intrinsics.checkNotNullParameter((Object)commonMemberStorage, (String)"commonMemberStorage");
        this.components = components2;
        this.classCache = commonMemberStorage.getClassCache();
        this.typeAliasCache = new LinkedHashMap();
        this.typeParameterCache = commonMemberStorage.getTypeParameterCache();
        this.typeParameterCacheForSetter = new LinkedHashMap();
        this.enumEntryCache = commonMemberStorage.getEnumEntryCache();
        this.codeFragmentCache = new LinkedHashMap();
        this.fieldsForContextReceivers = new LinkedHashMap();
        this.localStorage = new Fir2IrLocalClassStorage(commonMemberStorage.getLocalClassCache());
        this.localClassesCreatedOnTheFly = new LinkedHashMap();
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.components.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public Fir2IrAnnotationsFromPluginRegistrar getAnnotationsFromPluginRegistrar() {
        return this.components.getAnnotationsFromPluginRegistrar();
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.components.getBuiltIns();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.components.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrCallableDeclarationsGenerator getCallablesGenerator() {
        return this.components.getCallablesGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrClassifiersGenerator getClassifiersGenerator() {
        return this.components.getClassifiersGenerator();
    }

    @Override
    @NotNull
    public Fir2IrConfiguration getConfiguration() {
        return this.components.getConfiguration();
    }

    @Override
    @NotNull
    public Fir2IrConverter getConverter() {
        return this.components.getConverter();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public DelegatedMemberGenerator getDelegatedMemberGenerator() {
        return this.components.getDelegatedMemberGenerator();
    }

    @Override
    @NotNull
    public Fir2IrExtensions getExtensions() {
        return this.components.getExtensions();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.components.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public IrBuiltInsOverFir getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.components.getIrFactory();
    }

    @Override
    @NotNull
    public List<IrProvider> getIrProviders() {
        return this.components.getIrProviders();
    }

    @Override
    @NotNull
    public Fir2IrLazyDeclarationsGenerator getLazyDeclarationsGenerator() {
        return this.components.getLazyDeclarationsGenerator();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.components.getLock();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public FirBasedSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.components.getVisibilityConverter();
    }

    private final IrType toIrType(FirTypeRef $this$toIrType, ConversionTypeOrigin typeOrigin) {
        Fir2IrTypeConverter $this$toIrType_u24lambda_u240 = this.getTypeConverter();
        boolean bl = false;
        return $this$toIrType_u24lambda_u240.toIrType($this$toIrType, typeOrigin);
    }

    static /* synthetic */ IrType toIrType$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirTypeRef firTypeRef, ConversionTypeOrigin conversionTypeOrigin, int n, Object object) {
        if ((n & 1) != 0) {
            conversionTypeOrigin = ConversionTypeOrigin.DEFAULT;
        }
        return fir2IrClassifierStorage.toIrType(firTypeRef, conversionTypeOrigin);
    }

    public final void preCacheBuiltinClasses() {
        FirRegularClass firClass;
        for (Map.Entry<ClassId, IrClassSymbol> entry : this.getTypeConverter().getClassIdToSymbolMap$fir2ir().entrySet()) {
            ClassId classId = entry.getKey();
            IrClassSymbol irBuiltinSymbol = entry.getValue();
            FirClassifierSymbol<?> firClassifierSymbol = FirSymbolProviderKt.toSymbol(classId, this.getSession());
            if ((FirRegularClass)(firClassifierSymbol != null ? firClassifierSymbol.getFir() : null) == null) continue;
            IrClass irClass2 = (IrClass)irBuiltinSymbol.getOwner();
            this.classCache.put(firClass, irClass2);
            this.getClassifiersGenerator().processClassHeader(firClass, irClass2);
            this.getDeclarationStorage().preCacheBuiltinClassMembers$fir2ir(firClass, irClass2);
        }
        for (Map.Entry<ClassId, Object> entry : StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().entrySet()) {
            ClassId primitiveClassId = entry.getKey();
            ClassId primitiveArrayId = (ClassId)entry.getValue();
            FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(TypeConstructionUtilsKt.toLookupTag(primitiveArrayId), this.getSession());
            if ((FirRegularClass)(firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null) == null) continue;
            IrType irType = this.getTypeConverter().getClassIdToTypeMap$fir2ir().get(primitiveClassId);
            IrClassSymbol irClassSymbol = this.getIrBuiltIns().getPrimitiveArrayForType().get(irType);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClass irClass3 = (IrClass)irClassSymbol.getOwner();
            this.classCache.put(firClass, irClass3);
            this.getClassifiersGenerator().processClassHeader(firClass, irClass3);
            this.getDeclarationStorage().preCacheBuiltinClassMembers$fir2ir(firClass, irClass3);
        }
    }

    public final void preCacheTypeParameters$fir2ir(@NotNull FirTypeParameterRefsOwner owner, @NotNull IrSymbol irOwnerSymbol) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)irOwnerSymbol, (String)"irOwnerSymbol");
        Iterator<FirTypeParameterRef> iterator2 = owner.getTypeParameters().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            FirTypeParameterRef typeParameter2 = iterator2.next();
            FirTypeParameter original = (FirTypeParameter)typeParameter2.getSymbol().getFir();
            IrTypeParameter irTypeParameter2 = Fir2IrClassifierStorage.getCachedIrTypeParameter$fir2ir$default(this, original, null, 2, null);
            if (irTypeParameter2 == null) {
                irTypeParameter2 = Fir2IrClassifierStorage.createAndCacheIrTypeParameter$default(this, original, index2, irOwnerSymbol, null, 8, null);
            }
            if (!(owner instanceof FirProperty) || !((FirProperty)owner).isVar()) continue;
            ConversionTypeOrigin context2 = ConversionTypeOrigin.SETTER;
            IrTypeParameter irTypeParameter3 = this.getCachedIrTypeParameter$fir2ir(original, context2);
            if (irTypeParameter3 != null) continue;
            irTypeParameter3 = this.createAndCacheIrTypeParameter(original, index2, irOwnerSymbol, context2);
        }
    }

    @NotNull
    public final IrTypeParameter getIrTypeParameter$fir2ir(@NotNull FirTypeParameter typeParameter2, int index2, @NotNull IrSymbol ownerSymbol, @NotNull ConversionTypeOrigin typeOrigin) {
        Intrinsics.checkNotNullParameter((Object)typeParameter2, (String)"typeParameter");
        Intrinsics.checkNotNullParameter((Object)ownerSymbol, (String)"ownerSymbol");
        Intrinsics.checkNotNullParameter((Object)((Object)typeOrigin), (String)"typeOrigin");
        IrTypeParameter irTypeParameter2 = this.getCachedIrTypeParameter$fir2ir(typeParameter2, typeOrigin);
        if (irTypeParameter2 != null) {
            IrTypeParameter it = irTypeParameter2;
            boolean bl = false;
            return it;
        }
        IrTypeParameter irTypeParameter3 = this.createAndCacheIrTypeParameter(typeParameter2, index2, ownerSymbol, typeOrigin);
        this.getClassifiersGenerator().initializeTypeParameterBounds(typeParameter2, irTypeParameter3);
        return irTypeParameter3;
    }

    public static /* synthetic */ IrTypeParameter getIrTypeParameter$fir2ir$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirTypeParameter firTypeParameter, int n, IrSymbol irSymbol2, ConversionTypeOrigin conversionTypeOrigin, int n2, Object object) {
        if ((n2 & 8) != 0) {
            conversionTypeOrigin = ConversionTypeOrigin.DEFAULT;
        }
        return fir2IrClassifierStorage.getIrTypeParameter$fir2ir(firTypeParameter, n, irSymbol2, conversionTypeOrigin);
    }

    private final IrTypeParameter createAndCacheIrTypeParameter(FirTypeParameter typeParameter2, int index2, IrSymbol ownerSymbol, ConversionTypeOrigin typeOrigin) {
        IrTypeParameter irTypeParameter2 = this.getClassifiersGenerator().createIrTypeParameterWithoutBounds(typeParameter2, index2, ownerSymbol);
        if (typeOrigin.getForSetter()) {
            this.typeParameterCacheForSetter.put(typeParameter2, irTypeParameter2);
        } else {
            this.typeParameterCache.put(typeParameter2, irTypeParameter2);
        }
        return irTypeParameter2;
    }

    static /* synthetic */ IrTypeParameter createAndCacheIrTypeParameter$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirTypeParameter firTypeParameter, int n, IrSymbol irSymbol2, ConversionTypeOrigin conversionTypeOrigin, int n2, Object object) {
        if ((n2 & 8) != 0) {
            conversionTypeOrigin = ConversionTypeOrigin.DEFAULT;
        }
        return fir2IrClassifierStorage.createAndCacheIrTypeParameter(firTypeParameter, n, irSymbol2, conversionTypeOrigin);
    }

    @Nullable
    public final IrTypeParameter getCachedIrTypeParameter$fir2ir(@NotNull FirTypeParameter typeParameter2, @NotNull ConversionTypeOrigin typeOrigin) {
        Intrinsics.checkNotNullParameter((Object)typeParameter2, (String)"typeParameter");
        Intrinsics.checkNotNullParameter((Object)((Object)typeOrigin), (String)"typeOrigin");
        return typeOrigin.getForSetter() ? this.typeParameterCacheForSetter.get(typeParameter2) : this.typeParameterCache.get(typeParameter2);
    }

    public static /* synthetic */ IrTypeParameter getCachedIrTypeParameter$fir2ir$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirTypeParameter firTypeParameter, ConversionTypeOrigin conversionTypeOrigin, int n, Object object) {
        if ((n & 2) != 0) {
            conversionTypeOrigin = ConversionTypeOrigin.DEFAULT;
        }
        return fir2IrClassifierStorage.getCachedIrTypeParameter$fir2ir(firTypeParameter, conversionTypeOrigin);
    }

    @NotNull
    public final IrTypeParameterSymbol getIrTypeParameterSymbol(@NotNull FirTypeParameterSymbol firTypeParameterSymbol, @NotNull ConversionTypeOrigin typeOrigin) {
        Object cachedSymbol;
        Intrinsics.checkNotNullParameter((Object)firTypeParameterSymbol, (String)"firTypeParameterSymbol");
        Intrinsics.checkNotNullParameter((Object)((Object)typeOrigin), (String)"typeOrigin");
        FirTypeParameter firTypeParameter = (FirTypeParameter)firTypeParameterSymbol.getFir();
        Object object = this.getCachedIrTypeParameter$fir2ir(firTypeParameter, typeOrigin);
        if (object == null || (object = ((IrTypeParameter)object).getSymbol()) == null) {
            IrTypeParameter irTypeParameter2 = this.typeParameterCache.get(firTypeParameter);
            object = irTypeParameter2 != null ? irTypeParameter2.getSymbol() : null;
        }
        if ((cachedSymbol = object) != null) {
            return cachedSymbol;
        }
        if (this.components.getConfiguration().getAllowNonCachedDeclarations()) {
            return this.createIrTypeParameterForNonCachedDeclaration(firTypeParameter);
        }
        throw new IllegalStateException(("Cannot find cached type parameter by FIR symbol: " + firTypeParameterSymbol.getName() + " of the owner: " + firTypeParameter.getContainingDeclarationSymbol()).toString());
    }

    private final IrTypeParameterSymbol createIrTypeParameterForNonCachedDeclaration(FirTypeParameter firTypeParameter) {
        IrTypeParameter irTypeParameter2;
        int n;
        FirBasedSymbol<?> firTypeParameterOwnerSymbol = firTypeParameter.getContainingDeclarationSymbol();
        Object obj = firTypeParameterOwnerSymbol.getFir();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner");
        FirTypeParameterRefsOwner firTypeParameterOwner = (FirTypeParameterRefsOwner)obj;
        int it = n = firTypeParameterOwner.getTypeParameters().indexOf(firTypeParameter);
        boolean bl = false;
        if (!(it >= 0)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        int index2 = n;
        boolean isSetter = firTypeParameterOwner instanceof FirPropertyAccessor && ((FirPropertyAccessor)firTypeParameterOwner).isSetter();
        ConversionTypeOrigin conversionTypeOrigin = isSetter ? ConversionTypeOrigin.SETTER : ConversionTypeOrigin.DEFAULT;
        IrTypeParameter it2 = irTypeParameter2 = this.createAndCacheIrTypeParameter(firTypeParameter, index2, new IrTypeParameterSymbolImpl(null, 1, null), conversionTypeOrigin);
        boolean bl2 = false;
        this.getClassifiersGenerator().initializeTypeParameterBounds(firTypeParameter, it2);
        return irTypeParameter2.getSymbol();
    }

    @NotNull
    public final IrClass createAndCacheIrClass(@NotNull FirRegularClass regularClass, @NotNull IrDeclarationParent parent2, @Nullable IrDeclarationOrigin predefinedOrigin) {
        IrClass irClass2;
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrClass it = irClass2 = this.getClassifiersGenerator().createIrClass(regularClass, parent2, predefinedOrigin);
        boolean bl = false;
        FirMemberDeclaration $this$visibility$iv = regularClass;
        boolean $i$f$getVisibility = false;
        if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) {
            this.localStorage.set(regularClass, it);
        } else {
            this.classCache.put(regularClass, it);
        }
        return irClass2;
    }

    public static /* synthetic */ IrClass createAndCacheIrClass$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirRegularClass firRegularClass, IrDeclarationParent irDeclarationParent, IrDeclarationOrigin irDeclarationOrigin, int n, Object object) {
        if ((n & 4) != 0) {
            irDeclarationOrigin = null;
        }
        return fir2IrClassifierStorage.createAndCacheIrClass(firRegularClass, irDeclarationParent, irDeclarationOrigin);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final IrClass getCachedIrClass(@NotNull FirClass klass) {
        IrClass irClass2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                if (klass instanceof FirAnonymousObject) break block2;
                if (!(klass instanceof FirRegularClass)) break block3;
                FirMemberDeclaration $this$visibility$iv = klass;
                boolean $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) break block3;
            }
            irClass2 = this.localStorage.get(klass);
            return irClass2;
        }
        irClass2 = this.classCache.get(klass);
        return irClass2;
    }

    @Nullable
    public final IrClass findIrClass(@NotNull ConeClassLikeLookupTag lookupTag2) {
        FirClassLikeSymbol<?> firSymbol;
        Intrinsics.checkNotNullParameter((Object)lookupTag2, (String)"lookupTag");
        return lookupTag2.getClassId().isLocal() ? this.getCachedLocalClass(lookupTag2) : ((firSymbol = LookupTagUtilsKt.toSymbol(lookupTag2, this.getSession())) instanceof FirClassSymbol ? (IrClass)this.getIrClassSymbol((FirClassSymbol)firSymbol).getOwner() : null);
    }

    private final IrClass getCachedLocalClass(ConeClassLikeLookupTag lookupTag2) {
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(lookupTag2, this.getSession());
        Intrinsics.checkNotNull(firClassLikeSymbol);
        Object e = firClassLikeSymbol.getFir();
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirClass");
        return this.localStorage.get((FirClass)e);
    }

    @NotNull
    public final IrClassSymbol getIrClassSymbol(@NotNull FirClassSymbol<?> firClassSymbol) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        Object it;
        ClassId parentId;
        FirClass firClass;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(firClassSymbol, (String)"firClassSymbol");
                firClass = (FirClass)firClassSymbol.getFir();
                IrClass irClass2 = this.getClassifierStorage().getCachedIrClass(firClass);
                if (irClass2 != null) {
                    IrClass it2 = irClass2;
                    boolean bl = false;
                    return it2.getSymbol();
                }
                if (firClass instanceof FirAnonymousObject) break block7;
                if (!(firClass instanceof FirRegularClass)) break block8;
                FirMemberDeclaration $this$visibility$iv = firClass;
                boolean $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) break block8;
            }
            return this.createAndCacheLocalIrClassOnTheFly(firClass).getSymbol();
        }
        Intrinsics.checkNotNull((Object)firClass, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
        FirRegularClass cfr_ignored_0 = (FirRegularClass)firClass;
        ClassId classId = firClassSymbol.getClassId();
        ClassId classId2 = parentId = classId.getOuterClassId();
        if (classId2 != null) {
            it = classId2;
            boolean bl = false;
            firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(this.getSession()).getClassLikeSymbolByClassId((ClassId)it);
        } else {
            firClassLikeSymbol = null;
        }
        FirClassLikeSymbol<?> parentClass = firClassLikeSymbol;
        Fir2IrDeclarationStorage fir2IrDeclarationStorage = this.getDeclarationStorage();
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getPackageFqName(...)");
        FirClassLikeSymbol<?> firClassLikeSymbol2 = parentClass;
        IrDeclarationParent irDeclarationParent = fir2IrDeclarationStorage.findIrParent$fir2ir(fqName2, firClassLikeSymbol2 != null ? firClassLikeSymbol2.toLookupTag() : null, (FirBasedSymbol)firClassSymbol, firClass.getOrigin());
        Intrinsics.checkNotNull((Object)irDeclarationParent);
        IrDeclarationParent irParent2 = irDeclarationParent;
        it = this.getClassifierStorage().getCachedIrClass(firClass);
        if (it != null) {
            Object it3 = it;
            boolean bl = false;
            return ((IrClass)it3).getSymbol();
        }
        IrClass irClass3 = this.getLazyDeclarationsGenerator().createIrLazyClass((FirRegularClass)firClass, irParent2);
        this.classCache.put((FirRegularClass)firClass, irClass3);
        Intrinsics.checkNotNull((Object)irClass3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.lazy.Fir2IrLazyClass");
        ((Fir2IrLazyClass)irClass3).prepareTypeParameters();
        return irClass3.getSymbol();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IrField> getFieldsWithContextReceiversForClass(@NotNull IrClass irClass2, @NotNull FirClass klass) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!(klass instanceof FirRegularClass) || ((FirRegularClass)klass).getContextReceivers().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Map<IrClass, List<IrField>> $this$getOrPut$iv = this.fieldsForContextReceivers;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(irClass2);
        if (value$iv == null) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)((FirRegularClass)klass).getContextReceivers());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrField irField;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                int index2 = indexedValue.component1();
                FirContextReceiver contextReceiver2 = (FirContextReceiver)indexedValue.component2();
                IrFactory irFactory = this.components.getIrFactory();
                IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.FIELD_FOR_CLASS_CONTEXT_RECEIVER.INSTANCE;
                Name name2 = Name.identifier("contextReceiverField" + index2);
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
                IrField it = irField = irFactory.createField(-1, -1, irDeclarationOrigin, name2, descriptorVisibility, new IrFieldSymbolImpl(null, 1, null), Fir2IrClassifierStorage.toIrType$default(this, contextReceiver2.getTypeRef(), null, 1, null), true, false, false);
                boolean bl3 = false;
                it.setParent(irClass2);
                collection.add(irField);
            }
            List answer$iv = (List)destination$iv$iv;
            $this$getOrPut$iv.put(irClass2, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        return list2;
    }

    private final IrClass createAndCacheLocalIrClassOnTheFly(FirClass klass) {
        Fir2IrClassifiersGenerator.LocalIrClassInfo localIrClassInfo = this.getClassifiersGenerator().createLocalIrClassOnTheFly(klass, this.processMembersOfClassesOnTheFlyImmediately);
        IrClass irClass2 = localIrClassInfo.component1();
        FirClass firClassOrLocalParent = localIrClassInfo.component2();
        IrClass irClassOrLocalParent = localIrClassInfo.component3();
        if (!this.processMembersOfClassesOnTheFlyImmediately) {
            this.localClassesCreatedOnTheFly.put(firClassOrLocalParent, irClassOrLocalParent);
        }
        return irClass2;
    }

    public final void processMembersOfClassesCreatedOnTheFly() {
        this.processMembersOfClassesOnTheFlyImmediately = true;
        for (Map.Entry<FirClass, IrClass> entry : this.localClassesCreatedOnTheFly.entrySet()) {
            FirClass klass = entry.getKey();
            IrClass irClass2 = entry.getValue();
            this.getConverter().processClassMembers$fir2ir(klass, irClass2);
            this.getConverter().bindFakeOverridesInClass(irClass2);
        }
        this.localClassesCreatedOnTheFly.clear();
    }

    @NotNull
    public final IrClass createAndCacheAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull Visibility visibility2, @NotNull Name name2, @Nullable IrDeclarationParent irParent2) {
        IrClass irClass2;
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        Intrinsics.checkNotNullParameter((Object)visibility2, (String)"visibility");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        IrClass it = irClass2 = this.getClassifiersGenerator().createAnonymousObject(anonymousObject, visibility2, name2, irParent2);
        boolean bl = false;
        this.localStorage.set(anonymousObject, it);
        return irClass2;
    }

    public static /* synthetic */ IrClass createAndCacheAnonymousObject$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirAnonymousObject firAnonymousObject, Visibility visibility2, Name name2, IrDeclarationParent irDeclarationParent, int n, Object object) {
        if ((n & 2) != 0) {
            visibility2 = Visibilities.Local.INSTANCE;
        }
        if ((n & 4) != 0) {
            name2 = SpecialNames.NO_NAME_PROVIDED;
        }
        if ((n & 8) != 0) {
            irDeclarationParent = null;
        }
        return fir2IrClassifierStorage.createAndCacheAnonymousObject(firAnonymousObject, visibility2, name2, irDeclarationParent);
    }

    @NotNull
    public final IrClass getIrAnonymousObjectForEnumEntry(@NotNull FirAnonymousObject anonymousObject, @NotNull Name name2, @Nullable IrClass irParent2) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        IrClass irClass2 = this.localStorage.get(anonymousObject);
        if (irClass2 != null) {
            IrClass it = irClass2;
            boolean bl = false;
            return it;
        }
        IrClass irAnonymousObject = this.getClassifierStorage().createAndCacheAnonymousObject(anonymousObject, Visibilities.Private.INSTANCE, name2, irParent2);
        this.getClassifiersGenerator().processClassHeader(anonymousObject, irAnonymousObject);
        return irAnonymousObject;
    }

    public final void putEnumEntryClassInScope(@NotNull FirEnumEntry enumEntry, @NotNull IrClass correspondingClass) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkNotNullParameter((Object)correspondingClass, (String)"correspondingClass");
        FirExpression firExpression2 = enumEntry.getInitializer();
        Intrinsics.checkNotNull((Object)firExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression");
        this.localStorage.set(((FirAnonymousObjectExpression)firExpression2).getAnonymousObject(), correspondingClass);
    }

    @Nullable
    public final IrEnumEntry getCachedIrEnumEntry$fir2ir(@NotNull FirEnumEntry enumEntry) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        return this.enumEntryCache.get(enumEntry);
    }

    @NotNull
    public final IrEnumEntry getIrEnumEntry(@NotNull FirEnumEntry enumEntry, @NotNull IrClass irParent2, @Nullable IrDeclarationOrigin predefinedOrigin) {
        IrEnumEntry irEnumEntry;
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkNotNullParameter((Object)irParent2, (String)"irParent");
        IrEnumEntry irEnumEntry2 = this.getCachedIrEnumEntry$fir2ir(enumEntry);
        if (irEnumEntry2 != null) {
            IrEnumEntry it = irEnumEntry2;
            boolean bl = false;
            return it;
        }
        FirProvider firProviderForEntry = FirProviderKt.getFirProvider(enumEntry.getModuleData().getSession());
        FirFile containingFile = firProviderForEntry.getFirCallableContainerFile(enumEntry.getSymbol());
        IrDeclarationOrigin irDeclarationOrigin = predefinedOrigin;
        if (irDeclarationOrigin == null) {
            irDeclarationOrigin = containingFile != null ? (IrDeclarationOrigin)IrDeclarationOrigin.DEFINED.INSTANCE : irParent2.getOrigin();
        }
        IrDeclarationOrigin predefinedOrigin2 = irDeclarationOrigin;
        IrEnumEntry it = irEnumEntry = this.getClassifiersGenerator().createIrEnumEntry(enumEntry, irParent2, predefinedOrigin2);
        boolean bl = false;
        this.enumEntryCache.put(enumEntry, it);
        return irEnumEntry;
    }

    public static /* synthetic */ IrEnumEntry getIrEnumEntry$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirEnumEntry firEnumEntry, IrClass irClass2, IrDeclarationOrigin irDeclarationOrigin, int n, Object object) {
        if ((n & 4) != 0) {
            irDeclarationOrigin = null;
        }
        return fir2IrClassifierStorage.getIrEnumEntry(firEnumEntry, irClass2, irDeclarationOrigin);
    }

    @NotNull
    public final IrTypeAlias createAndCacheIrTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull IrDeclarationParent parent2) {
        IrTypeAlias irTypeAlias;
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrTypeAlias it = irTypeAlias = this.getClassifiersGenerator().createIrTypeAlias(typeAlias, parent2);
        boolean bl = false;
        this.typeAliasCache.put(typeAlias, it);
        return irTypeAlias;
    }

    @Nullable
    public final IrTypeAlias getCachedTypeAlias$fir2ir(@NotNull FirTypeAlias firTypeAlias) {
        Intrinsics.checkNotNullParameter((Object)firTypeAlias, (String)"firTypeAlias");
        return this.typeAliasCache.get(firTypeAlias);
    }

    @Nullable
    public final IrClass getCachedIrCodeFragment(@NotNull FirCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        return this.codeFragmentCache.get(codeFragment);
    }

    @NotNull
    public final IrClass createAndCacheCodeFragmentClass(@NotNull FirCodeFragment codeFragment, @NotNull IrFile containingFile) {
        IrClass irClass2;
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        IrClass it = irClass2 = this.getClassifiersGenerator().createCodeFragmentClass(codeFragment, containingFile);
        boolean bl = false;
        this.codeFragmentCache.put(codeFragment, it);
        return irClass2;
    }
}

